/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.apollo.janus.standalone.sdk.config;

import com.xforceplus.apollo.janus.standalone.sdk.config.LocalCLusterProperties;
import com.xforceplus.apollo.janus.standalone.sdk.utils.SpringConf;
import com.xforceplus.apollo.utils.JacksonUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.CompositePropertySource;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.stereotype.Component;

@Component
public class JanusStandaloneAssit {
    private static final Logger log = LoggerFactory.getLogger(JanusStandaloneAssit.class);
    @Autowired
    private Environment environment;
    private final String eventTypeChannelSendKey = "janus.sdk.eventType-channel-config.send.";
    private final String eventTypeChannelKey = "janus.sdk.eventType-channel-config.receive.";
    private final String sqsEventTypeQueueSendMappingKey = "janus.sdk.sqs-eventType-queue.sendmapping.";
    private final String sqsReceiveQueueAndEventTypesKey = "janus.sdk.sqs-eventType-queue.receiveQueueAndEventTypes.";
    private final String sqsEventTypeAndListenermappingKey = "janus.sdk.sqs-eventType-queue.eventTypeAndListenermapping.";
    public static final Map<String, String> MessageSourceMap = new HashMap<String, String>();

    public JanusStandaloneAssit() {
        log.info("JanusStandaloneAssit ----------------constructor");
    }

    public Map<String, String> findAllProps() {
        try {
            LocalCLusterProperties localCLusterProperties = LocalCLusterProperties.getInstance();
            String standalonePath = this.environment.getProperty("janus.sdk.standalonePath", "");
            SpringConf[] logStorePath = this.environment.getProperty("janus.sdk.log-store-path", "");
            localCLusterProperties.setLogStorePath((String)logStorePath);
            localCLusterProperties.setStandalonePath(standalonePath);
            int processors = Runtime.getRuntime().availableProcessors();
            processors = processors / 2 < 1 ? 1 : processors / 2;
            Integer threadPoolSize = (Integer)this.environment.getProperty("janus.sdk.thread-pool.size", Integer.class, (Object)1);
            threadPoolSize = Math.min(processors, threadPoolSize);
            localCLusterProperties.setThreadPoolSize(threadPoolSize);
            Object threadPoolWaitTime = (Integer)this.environment.getProperty("janus.sdk.thread-pool.wait-time", Integer.class, (Object)10);
            if ((Integer)threadPoolWaitTime < 2 || (Integer)threadPoolWaitTime > 30) {
                threadPoolWaitTime = 10;
            }
            localCLusterProperties.setThreadPoolWaitTime((Integer)threadPoolWaitTime);
            String messageRefuseSizeConfig = this.environment.getProperty("janus.sdk.message.refuse-size", "1M").trim();
            Integer messageRefuseSize = this.convert(messageRefuseSizeConfig);
            localCLusterProperties.setMessageRefuseSize(messageRefuseSize);
            String messageCompressSizeConfig = this.environment.getProperty("janus.sdk.message.compress-size", "1K").trim();
            Integer messageCompressSize = this.convert(messageCompressSizeConfig);
            localCLusterProperties.setMessageCompressSize(messageCompressSize);
            Integer queueSize = (Integer)this.environment.getProperty("janus.sdk.queue-size", Integer.class, (Object)100);
            if (queueSize < 20 || queueSize > 1000) {
                queueSize = 100;
            }
            localCLusterProperties.setQueueSize(queueSize);
            Integer heartBeatInterval = (Integer)this.environment.getProperty("janus.sdk.heart-beat-interval", Integer.class, (Object)60);
            if (heartBeatInterval < 10 || heartBeatInterval > 60) {
                heartBeatInterval = 60;
            }
            localCLusterProperties.setHeartBeatInterval(heartBeatInterval);
            Long fetchMessageInterval = (Long)this.environment.getProperty("janus.sdk.fetch-message-interval", Long.class, (Object)10000L);
            localCLusterProperties.setFetchMessageInterval(fetchMessageInterval);
            Integer qps = (Integer)this.environment.getProperty("janus.sdk.message.qps", Integer.class, (Object)2);
            if (qps < 1 || qps > 20) {
                qps = 1;
            }
            localCLusterProperties.setQps(qps);
            localCLusterProperties.setSqsEnabled((Boolean)this.environment.getProperty("janus.sdk.sqs-enabled", Boolean.class, (Object)false));
            localCLusterProperties.setMessageBusEnabled((Boolean)this.environment.getProperty("janus.sdk.message-bus-enabled", Boolean.class, (Object)false));
            localCLusterProperties.setJanusEnabled((Boolean)this.environment.getProperty("janus.sdk.janus-enabled", Boolean.class, (Object)false));
            localCLusterProperties.setJanusStandaloneEnabled((Boolean)this.environment.getProperty("janus.sdk.janus-standalone-enabled", Boolean.class, (Object)false));
            localCLusterProperties.setJanusUrl((String)this.environment.getProperty("janus.yun.url", String.class, (Object)""));
            localCLusterProperties.setJanusAuthentication((String)this.environment.getProperty("janus.yun.authentication", String.class, (Object)""));
            localCLusterProperties.setJanusPullConfigAction((String)this.environment.getProperty("janus.yun.action.config", String.class, (Object)""));
            if (localCLusterProperties.isSqsEnabled()) {
                MessageSourceMap.put("1", "sqs");
            }
            if (localCLusterProperties.isMessageBusEnabled()) {
                MessageSourceMap.put("2", "messageBus");
            }
            if (localCLusterProperties.isJanusEnabled()) {
                MessageSourceMap.put("3", "janus");
            }
            if (localCLusterProperties.isJanusStandaloneEnabled()) {
                MessageSourceMap.put("4", "standaloneJanus");
            }
        }
        catch (Exception e) {
            log.error("LocalCLusterProperties load failed ,error : {}", (Object)e.getMessage());
        }
        Map<String, LinkedHashMap<String, String>> retlist = this.findAllPropsCollect();
        LinkedHashMap<String, String> allMap = new LinkedHashMap<String, String>();
        for (String ele : retlist.keySet()) {
            SpringConf springConfTemp = null;
            for (SpringConf springConf : SpringConf.values()) {
                if (!ele.startsWith(springConf.getKeyPre())) continue;
                springConfTemp = springConf;
                break;
            }
            if (springConfTemp != null) {
                springConfTemp.getProps().put(ele, retlist.get(ele));
                continue;
            }
            LinkedHashMap<String, String> tempmap = retlist.get(ele);
            allMap.putAll(tempmap);
        }
        for (SpringConf springConf : SpringConf.sortDesc()) {
            for (Map.Entry<String, LinkedHashMap<String, String>> entry : springConf.getProps().entrySet()) {
                LinkedHashMap<String, String> value = entry.getValue();
                allMap.putAll(value);
            }
        }
        HashMap<String, List<String>> eventTypeChannelSends = new HashMap<String, List<String>>();
        HashMap<String, List<String>> eventTypeChannelRevs = new HashMap<String, List<String>>();
        HashMap<String, String> sqsEventTypeQueueSendMapping = new HashMap<String, String>();
        HashMap<String, String> sqsEventTypeAndListenermapping = new HashMap<String, String>();
        HashMap<String, Set<String>> sqsReceiveQueueAndEventTypesMapping = new HashMap<String, Set<String>>();
        for (Map.Entry entry : allMap.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            this.buildEventTypeChannelConfigs(eventTypeChannelSends, key, value, "janus.sdk.eventType-channel-config.send.");
            this.buildEventTypeChannelConfigs(eventTypeChannelRevs, key, value, "janus.sdk.eventType-channel-config.receive.");
            this.buildEventTypeQueueMapping(sqsEventTypeQueueSendMapping, key, value, "janus.sdk.sqs-eventType-queue.sendmapping.");
            this.buildEventTypeAndListenermapping(sqsEventTypeAndListenermapping, key, value, "janus.sdk.sqs-eventType-queue.eventTypeAndListenermapping.");
            this.buildSqsReceiveQueues(sqsReceiveQueueAndEventTypesMapping, key, value, "janus.sdk.sqs-eventType-queue.receiveQueueAndEventTypes.");
        }
        LocalCLusterProperties.getInstance().setEventTypeChannelSends(eventTypeChannelSends);
        LocalCLusterProperties.getInstance().setEventTypeChannelRevs(eventTypeChannelRevs);
        LocalCLusterProperties.getInstance().setSqsEventTypeQueueSendMapping(sqsEventTypeQueueSendMapping);
        LocalCLusterProperties.getInstance().setSqsReceiveQueueAndEventTypesMapping(sqsReceiveQueueAndEventTypesMapping);
        LocalCLusterProperties.getInstance().setSqsEventTypeAndListenermapping(sqsEventTypeAndListenermapping);
        log.info("LocalCLusterProperties: {}", (Object)JacksonUtil.getInstance().toJson((Object)LocalCLusterProperties.getInstance()));
        return allMap;
    }

    private void buildEventTypeQueueMapping(Map<String, String> eventTypeQueueMapping, String key, String value, String eventTypeQueueMappingKey) {
        if (value != null && !value.trim().equals("") && key.startsWith(eventTypeQueueMappingKey) && !key.equals(eventTypeQueueMappingKey)) {
            String eventTypeName = key.replace(eventTypeQueueMappingKey, "");
            String queueName = value.trim();
            eventTypeQueueMapping.put(eventTypeName, queueName);
        }
    }

    private void buildEventTypeAndListenermapping(Map<String, String> sqsEventTypeAndListenermapping, String key, String value, String sqsEventTypeAndListenermappingKey) {
        if (value != null && !value.trim().equals("") && key.startsWith(sqsEventTypeAndListenermappingKey) && !key.equals(sqsEventTypeAndListenermappingKey)) {
            String eventTypeName = key.replace(sqsEventTypeAndListenermappingKey, "");
            String listenerName = value.trim();
            sqsEventTypeAndListenermapping.put(eventTypeName, listenerName);
        }
    }

    private void buildSqsReceiveQueues(Map<String, Set<String>> sqsReceiveQueueAndEventTypesMapping, String key, String value, String sqsReceiveQueueAndEventTypesKey) {
        if (value != null && !value.trim().equals("") && key.startsWith(sqsReceiveQueueAndEventTypesKey) && !key.equals(sqsReceiveQueueAndEventTypesKey)) {
            String queueName = key.replace(sqsReceiveQueueAndEventTypesKey, "");
            HashSet<String> sqsEventTypeNames = new HashSet<String>();
            String[] values = value.split(",");
            if (values != null && values.length > 0) {
                for (String temp : values) {
                    if (temp == null || temp.trim().equals("")) continue;
                    String eventTypeName = temp.trim();
                    if (eventTypeName.equals("all")) {
                        eventTypeName = "*";
                    }
                    sqsEventTypeNames.add(eventTypeName);
                }
            }
            sqsReceiveQueueAndEventTypesMapping.put(queueName, sqsEventTypeNames);
        }
    }

    private void buildEventTypeChannelConfigs(Map<String, List<String>> eventTypeChannels, String key, String value, String eventTypeChannelKey) {
        if (value != null && !value.trim().equals("") && key.startsWith(eventTypeChannelKey) && !key.equals(eventTypeChannelKey)) {
            String eventTypeName = key.replace(eventTypeChannelKey, "");
            HashSet<String> channelSources = new HashSet<String>();
            String[] values = value.split(",");
            if (values != null && values.length > 0) {
                for (String temp : values) {
                    String source;
                    String sourceVal;
                    if (temp == null || (sourceVal = MessageSourceMap.get(source = temp.trim())) == null) continue;
                    channelSources.add(sourceVal);
                }
            }
            if (channelSources.size() > 0) {
                eventTypeChannels.put(eventTypeName, new ArrayList(channelSources));
            }
        }
    }

    private Integer convert(String s) {
        HashMap<String, Integer> unitMap = new HashMap<String, Integer>();
        unitMap.put("k", 1024);
        unitMap.put("K", 1024);
        unitMap.put("m", 0x100000);
        unitMap.put("M", 0x100000);
        Integer sub1 = Integer.valueOf(s.substring(0, s.length() - 1));
        String sub2 = s.substring(s.length() - 1);
        Integer size = sub1 * (Integer)unitMap.get(sub2);
        return size;
    }

    public Map<String, LinkedHashMap<String, String>> findAllPropsCollect() {
        LinkedHashMap<String, LinkedHashMap<String, String>> result = new LinkedHashMap<String, LinkedHashMap<String, String>>();
        for (Map.Entry<String, PropertySource<?>> entry : this.getPropertySources().entrySet()) {
            PropertySource<?> source = entry.getValue();
            String sourceName = entry.getKey();
            if (!(source instanceof EnumerablePropertySource)) continue;
            EnumerablePropertySource enumerable = (EnumerablePropertySource)source;
            LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
            for (String name : enumerable.getPropertyNames()) {
                properties.put(name, String.valueOf(enumerable.getProperty(name)));
            }
            if (properties == null || !MapUtils.isNotEmpty(properties)) continue;
            result.put(sourceName, properties);
        }
        return result;
    }

    private Map<String, PropertySource<?>> getPropertySources() {
        LinkedHashMap map = new LinkedHashMap();
        MutablePropertySources sources = null;
        sources = this.environment != null && this.environment instanceof ConfigurableEnvironment ? ((ConfigurableEnvironment)this.environment).getPropertySources() : new StandardEnvironment().getPropertySources();
        for (PropertySource source : sources) {
            this.extract("", map, source);
        }
        return map;
    }

    private void extract(String root, Map<String, PropertySource<?>> map, PropertySource<?> source) {
        if (source instanceof CompositePropertySource) {
            for (PropertySource nest : ((CompositePropertySource)source).getPropertySources()) {
                this.extract(source.getName() + ":", map, nest);
            }
        } else {
            map.put(root + source.getName(), source);
        }
    }
}

