/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.apollo.janus.standalone.sdk.config;

import com.xforceplus.apollo.janus.standalone.sdk.config.JanusStandaloneAssit;
import com.xforceplus.apollo.janus.standalone.sdk.config.LocalCLusterProperties;
import com.xforceplus.apollo.janus.standalone.sdk.configHandler.PullSqsEventTypeQueueConfigHandler;
import com.xforceplus.apollo.janus.standalone.sdk.message.MessageEventInitListener;
import com.xforceplus.apollo.janus.standalone.sdk.message.MessageSenderUtils;
import com.xforceplus.apollo.janus.standalone.sdk.message.janus.ReceiveAllJanusMessageListener;
import com.xforceplus.apollo.janus.standalone.sdk.message.messageBus.MessageBusInit;
import com.xforceplus.apollo.janus.standalone.sdk.message.standaloneJanus.StandaloneJanusService;
import com.xforceplus.janus.config.core.config.HttpConfig;
import com.xforceplus.xplat.aws.s3.S3Service;
import com.xforceplus.xplat.aws.s3.singleton.S3ClientSingleton;
import com.xforceplus.xplat.aws.sqs.SqsService;
import com.xforceplus.xplat.aws.sqs.singleton.SqsClientSingleton;
import java.util.Map;
import java.util.Properties;
import javax.annotation.PostConstruct;
import net.wicp.tams.common.Conf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.Environment;

@Configuration
@Order(value=-2147483648)
public class JanusStandaloneConfigInit {
    private static final Logger log = LoggerFactory.getLogger(JanusStandaloneConfigInit.class);
    public static String janusStandaloneSdkVersion = "1.3.9-RELEASE";
    public static ApplicationContext context;
    @Autowired
    private JanusStandaloneAssit springBootAssit;
    private String[] addPre = new String[]{"xplat.aws.session.", "common.apiext.thread.pool."};
    private String[] addSingle = new String[0];

    @PostConstruct
    private void init() {
        Map<String, String> allMap = this.springBootAssit.findAllProps();
        if (LocalCLusterProperties.getInstance().isSqsEnabled()) {
            Properties inputpamas = new Properties();
            Properties tpProps = Conf.copyProperties();
            this.addOtherConf(tpProps);
            for (String keystr : allMap.keySet()) {
                boolean needAdd = tpProps.containsKey(keystr);
                if (!needAdd) {
                    for (String addPreEle : this.addPre) {
                        if (!keystr.startsWith(addPreEle)) continue;
                        needAdd = true;
                        break;
                    }
                }
                if (!needAdd) continue;
                inputpamas.put(keystr, allMap.get(keystr));
            }
            log.info("sqs original Properties:{}", (Object)tpProps.toString());
            log.info("sqs cover Properties:{}", (Object)inputpamas.toString());
            Conf.overProp((Properties)inputpamas);
        }
    }

    private void addOtherConf(Properties tpProps) {
        for (String needAddConf : this.addSingle) {
            if (tpProps.containsKey(needAddConf)) continue;
            tpProps.put(needAddConf, "null");
        }
    }

    @Bean
    @ConditionalOnProperty(name={"janus.sdk.sqs-enabled"}, havingValue="true")
    public SqsService newSqs() {
        return SqsClientSingleton.getInst().getSqs();
    }

    @Bean
    @ConditionalOnProperty(name={"janus.sdk.sqs-enabled"}, havingValue="true")
    public S3Service newS3() {
        return S3ClientSingleton.getInst().getS3();
    }

    @Bean
    @ConditionalOnProperty(name={"janus.sdk.janus-enabled"}, havingValue="true")
    public ReceiveAllJanusMessageListener receiveAllJanusMessageListener() {
        return new ReceiveAllJanusMessageListener();
    }

    @Bean
    @ConditionalOnProperty(name={"janus.sdk.message-bus-enabled"}, havingValue="true")
    public MessageBusInit messageBusInit(Environment environment, MessageEventInitListener messageEventInitListener) {
        return new MessageBusInit(environment, messageEventInitListener);
    }

    @Bean
    @ConditionalOnProperty(name={"janus.sdk.janus-standalone-enabled"}, havingValue="true")
    public StandaloneJanusService standaloneJanusService(MessageEventInitListener messageEventInitListener) {
        return new StandaloneJanusService(messageEventInitListener);
    }

    @Bean
    public MessageSenderUtils messageSenderUtils() {
        return new MessageSenderUtils();
    }

    @Bean
    public PullSqsEventTypeQueueConfigHandler pullSdkConfigHandler() {
        return new PullSqsEventTypeQueueConfigHandler();
    }

    @Bean
    public MessageEventInitListener messageEventInitListener(HttpConfig httpConfig) {
        return new MessageEventInitListener(httpConfig);
    }

    @Configuration
    @Order(value=-2147483648)
    protected class InitContext
    implements ApplicationContextAware {
        protected InitContext() {
        }

        public void setApplicationContext(ApplicationContext arg0) throws BeansException {
            context = arg0;
        }
    }
}

