/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.apollo.janus.standalone.sdk.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class LocalCLusterProperties {
    private String standalonePath;
    private int threadPoolSize;
    private int threadPoolWaitTime;
    private int queueSize;
    private int messageRefuseSize;
    private int messageCompressSize;
    private int heartBeatInterval;
    private long fetchMessageInterval;
    private int qps;
    private String logStorePath;
    private boolean sqsEnabled;
    private boolean messageBusEnabled;
    private boolean janusEnabled;
    private boolean janusStandaloneEnabled;
    private Map<String, List<String>> eventTypeChannelSends;
    private Map<String, List<String>> eventTypeChannelRevs;
    private Map<String, Set<String>> eventTypeChannelConfigRevCache = new HashMap<String, Set<String>>();
    private Map<String, String> sqsEventTypeQueueSendMapping;
    private Map<String, Set<String>> sqsReceiveQueueAndEventTypesMapping;
    private Map<String, String> sqsEventTypeAndListenermapping = new HashMap<String, String>();
    private String janusUrl;
    private String janusAuthentication;
    private String janusPullConfigAction;
    private static volatile LocalCLusterProperties localCLusterProperties = new LocalCLusterProperties();

    private LocalCLusterProperties() {
    }

    public boolean isMultiChannelEnabled(String eventType) {
        return this.eventTypeChannelSends != null && this.eventTypeChannelSends.get(eventType) != null && this.eventTypeChannelSends.get(eventType).size() > 1;
    }

    public boolean canSendToSqs(String eventType) {
        if (!this.sqsEnabled) {
            return false;
        }
        if (this.commonPredict(eventType, this.eventTypeChannelSends, "sqs")) {
            return true;
        }
        return this.sqsEventTypeQueueSendMapping != null && this.sqsEventTypeQueueSendMapping.get(eventType) != null;
    }

    private boolean commonPredict(String eventType, Map<String, List<String>> eventTypeChannels, String source) {
        if (eventTypeChannels == null) {
            return false;
        }
        for (Map.Entry<String, List<String>> entry : eventTypeChannels.entrySet()) {
            String key1;
            String key = entry.getKey();
            List<String> sources = entry.getValue();
            boolean keyMatch = false;
            if (key.equals(eventType.trim())) {
                keyMatch = true;
            } else if (key.equals("*")) {
                keyMatch = true;
            } else if (key.endsWith("*") && eventType.startsWith(key1 = key.substring(0, key.length() - 1))) {
                keyMatch = true;
            }
            if (!keyMatch || !CollectionUtils.isNotEmpty(sources) || !sources.contains(source)) continue;
            return true;
        }
        return false;
    }

    public boolean canSendToMessageBus(String eventType) {
        if (!this.messageBusEnabled) {
            return false;
        }
        return this.commonPredict(eventType, this.eventTypeChannelSends, "messageBus");
    }

    public boolean canSendToStandaloneJanus(String eventType) {
        if (!this.janusStandaloneEnabled) {
            return false;
        }
        return this.commonPredict(eventType, this.eventTypeChannelSends, "standaloneJanus");
    }

    public boolean canSendToJanus(String eventType) {
        if (!this.janusEnabled) {
            return false;
        }
        return this.commonPredict(eventType, this.eventTypeChannelSends, "janus");
    }

    public boolean canRevFromSqs(String eventType) {
        if (!this.sqsEnabled) {
            return false;
        }
        return this.commonPredict(eventType, this.eventTypeChannelRevs, "sqs");
    }

    public boolean canRevFromMessageBus(String eventType) {
        if (!this.messageBusEnabled) {
            return false;
        }
        return this.commonPredict(eventType, this.eventTypeChannelRevs, "messageBus");
    }

    public boolean canRevFromStandaloneJanus(String eventType) {
        if (!this.janusStandaloneEnabled) {
            return false;
        }
        return this.commonPredict(eventType, this.eventTypeChannelRevs, "standaloneJanus");
    }

    public boolean canRevFromJanus(String eventType) {
        if (!this.janusEnabled) {
            return false;
        }
        return this.commonPredict(eventType, this.eventTypeChannelRevs, "janus");
    }

    public String getQueueName(String eventTypeName) {
        String queueName = "";
        if (this.sqsEventTypeQueueSendMapping != null) {
            queueName = this.sqsEventTypeQueueSendMapping.get(eventTypeName);
        }
        if (StringUtils.isBlank((CharSequence)queueName)) {
            List<String> candidateEventTypes = new ArrayList<String>(this.sqsEventTypeQueueSendMapping.keySet());
            if (CollectionUtils.isNotEmpty(candidateEventTypes = candidateEventTypes.stream().filter(o -> StringUtils.isNotBlank((CharSequence)o) && o.endsWith("*")).collect(Collectors.toList()))) {
                Collections.sort(candidateEventTypes, (o1, o2) -> {
                    int index2;
                    int index1 = o1.indexOf("*");
                    if (index1 < (index2 = o2.indexOf("*"))) {
                        return 1;
                    }
                    if (index1 > index2) {
                        return -1;
                    }
                    return 0;
                });
                for (String candidateEventType : candidateEventTypes) {
                    String prefixkey = candidateEventType.substring(0, candidateEventType.length() - 1);
                    if (!eventTypeName.startsWith(prefixkey)) continue;
                    queueName = this.sqsEventTypeQueueSendMapping.get(candidateEventType);
                    break;
                }
            }
        }
        return queueName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Set<String> getRevSources(String eventTypeName) {
        Set<String> sources = this.eventTypeChannelConfigRevCache.get(eventTypeName);
        if (sources != null) return sources;
        Class<LocalCLusterProperties> clazz = LocalCLusterProperties.class;
        synchronized (LocalCLusterProperties.class) {
            sources = this.eventTypeChannelConfigRevCache.get(eventTypeName);
            if (sources == null) {
                sources = new HashSet<String>();
                if (localCLusterProperties.canRevFromSqs(eventTypeName)) {
                    sources.add("sqs");
                }
                if (localCLusterProperties.canRevFromMessageBus(eventTypeName)) {
                    sources.add("messageBus");
                }
                if (localCLusterProperties.canRevFromJanus(eventTypeName)) {
                    sources.add("janus");
                }
                if (localCLusterProperties.canRevFromStandaloneJanus(eventTypeName)) {
                    sources.add("standaloneJanus");
                }
                if (sources.size() == 0) {
                    if (localCLusterProperties.isSqsEnabled()) {
                        sources.add("sqs");
                    }
                    if (localCLusterProperties.isMessageBusEnabled()) {
                        sources.add("messageBus");
                    }
                    if (localCLusterProperties.isJanusStandaloneEnabled()) {
                        sources.add("standaloneJanus");
                    }
                    if (localCLusterProperties.isJanusEnabled()) {
                        sources.add("janus");
                    }
                }
            }
            this.eventTypeChannelConfigRevCache.put(eventTypeName, sources);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return sources;
        }
    }

    public static LocalCLusterProperties getInstance() {
        return localCLusterProperties;
    }

    public boolean hasConfig() {
        return this.sqsEnabled || this.messageBusEnabled || this.janusEnabled || this.janusStandaloneEnabled;
    }

    public Set<String> getSqsReceiveQueues() {
        Set<String> sqsReceiveQueues = new HashSet<String>();
        if (this.sqsReceiveQueueAndEventTypesMapping != null) {
            sqsReceiveQueues = this.sqsReceiveQueueAndEventTypesMapping.keySet();
        }
        return sqsReceiveQueues;
    }

    public boolean needReceiveHandle(String queueName, String eventTypeName) {
        if (this.sqsReceiveQueueAndEventTypesMapping == null) {
            return false;
        }
        Set<String> sqsEventTypes = this.sqsReceiveQueueAndEventTypesMapping.get(queueName);
        if (CollectionUtils.isEmpty(sqsEventTypes)) {
            return false;
        }
        for (String sqsEventTypeName : sqsEventTypes) {
            String temp;
            if (sqsEventTypeName.equals("*")) {
                return true;
            }
            if (sqsEventTypeName.equals(eventTypeName)) {
                return true;
            }
            if (!sqsEventTypeName.endsWith("*") || !eventTypeName.startsWith(temp = sqsEventTypeName.substring(0, sqsEventTypeName.length() - 1))) continue;
            return true;
        }
        return false;
    }

    public String getStandalonePath() {
        return this.standalonePath;
    }

    public int getThreadPoolSize() {
        return this.threadPoolSize;
    }

    public int getThreadPoolWaitTime() {
        return this.threadPoolWaitTime;
    }

    public int getQueueSize() {
        return this.queueSize;
    }

    public int getMessageRefuseSize() {
        return this.messageRefuseSize;
    }

    public int getMessageCompressSize() {
        return this.messageCompressSize;
    }

    public int getHeartBeatInterval() {
        return this.heartBeatInterval;
    }

    public long getFetchMessageInterval() {
        return this.fetchMessageInterval;
    }

    public int getQps() {
        return this.qps;
    }

    public String getLogStorePath() {
        return this.logStorePath;
    }

    public boolean isSqsEnabled() {
        return this.sqsEnabled;
    }

    public boolean isMessageBusEnabled() {
        return this.messageBusEnabled;
    }

    public boolean isJanusEnabled() {
        return this.janusEnabled;
    }

    public boolean isJanusStandaloneEnabled() {
        return this.janusStandaloneEnabled;
    }

    public Map<String, List<String>> getEventTypeChannelSends() {
        return this.eventTypeChannelSends;
    }

    public Map<String, List<String>> getEventTypeChannelRevs() {
        return this.eventTypeChannelRevs;
    }

    public Map<String, Set<String>> getEventTypeChannelConfigRevCache() {
        return this.eventTypeChannelConfigRevCache;
    }

    public Map<String, String> getSqsEventTypeQueueSendMapping() {
        return this.sqsEventTypeQueueSendMapping;
    }

    public Map<String, Set<String>> getSqsReceiveQueueAndEventTypesMapping() {
        return this.sqsReceiveQueueAndEventTypesMapping;
    }

    public Map<String, String> getSqsEventTypeAndListenermapping() {
        return this.sqsEventTypeAndListenermapping;
    }

    public String getJanusUrl() {
        return this.janusUrl;
    }

    public String getJanusAuthentication() {
        return this.janusAuthentication;
    }

    public String getJanusPullConfigAction() {
        return this.janusPullConfigAction;
    }

    public void setStandalonePath(String standalonePath) {
        this.standalonePath = standalonePath;
    }

    public void setThreadPoolSize(int threadPoolSize) {
        this.threadPoolSize = threadPoolSize;
    }

    public void setThreadPoolWaitTime(int threadPoolWaitTime) {
        this.threadPoolWaitTime = threadPoolWaitTime;
    }

    public void setQueueSize(int queueSize) {
        this.queueSize = queueSize;
    }

    public void setMessageRefuseSize(int messageRefuseSize) {
        this.messageRefuseSize = messageRefuseSize;
    }

    public void setMessageCompressSize(int messageCompressSize) {
        this.messageCompressSize = messageCompressSize;
    }

    public void setHeartBeatInterval(int heartBeatInterval) {
        this.heartBeatInterval = heartBeatInterval;
    }

    public void setFetchMessageInterval(long fetchMessageInterval) {
        this.fetchMessageInterval = fetchMessageInterval;
    }

    public void setQps(int qps) {
        this.qps = qps;
    }

    public void setLogStorePath(String logStorePath) {
        this.logStorePath = logStorePath;
    }

    public void setSqsEnabled(boolean sqsEnabled) {
        this.sqsEnabled = sqsEnabled;
    }

    public void setMessageBusEnabled(boolean messageBusEnabled) {
        this.messageBusEnabled = messageBusEnabled;
    }

    public void setJanusEnabled(boolean janusEnabled) {
        this.janusEnabled = janusEnabled;
    }

    public void setJanusStandaloneEnabled(boolean janusStandaloneEnabled) {
        this.janusStandaloneEnabled = janusStandaloneEnabled;
    }

    public void setEventTypeChannelSends(Map<String, List<String>> eventTypeChannelSends) {
        this.eventTypeChannelSends = eventTypeChannelSends;
    }

    public void setEventTypeChannelRevs(Map<String, List<String>> eventTypeChannelRevs) {
        this.eventTypeChannelRevs = eventTypeChannelRevs;
    }

    public void setEventTypeChannelConfigRevCache(Map<String, Set<String>> eventTypeChannelConfigRevCache) {
        this.eventTypeChannelConfigRevCache = eventTypeChannelConfigRevCache;
    }

    public void setSqsEventTypeQueueSendMapping(Map<String, String> sqsEventTypeQueueSendMapping) {
        this.sqsEventTypeQueueSendMapping = sqsEventTypeQueueSendMapping;
    }

    public void setSqsReceiveQueueAndEventTypesMapping(Map<String, Set<String>> sqsReceiveQueueAndEventTypesMapping) {
        this.sqsReceiveQueueAndEventTypesMapping = sqsReceiveQueueAndEventTypesMapping;
    }

    public void setSqsEventTypeAndListenermapping(Map<String, String> sqsEventTypeAndListenermapping) {
        this.sqsEventTypeAndListenermapping = sqsEventTypeAndListenermapping;
    }

    public void setJanusUrl(String janusUrl) {
        this.janusUrl = janusUrl;
    }

    public void setJanusAuthentication(String janusAuthentication) {
        this.janusAuthentication = janusAuthentication;
    }

    public void setJanusPullConfigAction(String janusPullConfigAction) {
        this.janusPullConfigAction = janusPullConfigAction;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LocalCLusterProperties)) {
            return false;
        }
        LocalCLusterProperties other = (LocalCLusterProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$standalonePath = this.getStandalonePath();
        String other$standalonePath = other.getStandalonePath();
        if (this$standalonePath == null ? other$standalonePath != null : !this$standalonePath.equals(other$standalonePath)) {
            return false;
        }
        if (this.getThreadPoolSize() != other.getThreadPoolSize()) {
            return false;
        }
        if (this.getThreadPoolWaitTime() != other.getThreadPoolWaitTime()) {
            return false;
        }
        if (this.getQueueSize() != other.getQueueSize()) {
            return false;
        }
        if (this.getMessageRefuseSize() != other.getMessageRefuseSize()) {
            return false;
        }
        if (this.getMessageCompressSize() != other.getMessageCompressSize()) {
            return false;
        }
        if (this.getHeartBeatInterval() != other.getHeartBeatInterval()) {
            return false;
        }
        if (this.getFetchMessageInterval() != other.getFetchMessageInterval()) {
            return false;
        }
        if (this.getQps() != other.getQps()) {
            return false;
        }
        String this$logStorePath = this.getLogStorePath();
        String other$logStorePath = other.getLogStorePath();
        if (this$logStorePath == null ? other$logStorePath != null : !this$logStorePath.equals(other$logStorePath)) {
            return false;
        }
        if (this.isSqsEnabled() != other.isSqsEnabled()) {
            return false;
        }
        if (this.isMessageBusEnabled() != other.isMessageBusEnabled()) {
            return false;
        }
        if (this.isJanusEnabled() != other.isJanusEnabled()) {
            return false;
        }
        if (this.isJanusStandaloneEnabled() != other.isJanusStandaloneEnabled()) {
            return false;
        }
        Map<String, List<String>> this$eventTypeChannelSends = this.getEventTypeChannelSends();
        Map<String, List<String>> other$eventTypeChannelSends = other.getEventTypeChannelSends();
        if (this$eventTypeChannelSends == null ? other$eventTypeChannelSends != null : !((Object)this$eventTypeChannelSends).equals(other$eventTypeChannelSends)) {
            return false;
        }
        Map<String, List<String>> this$eventTypeChannelRevs = this.getEventTypeChannelRevs();
        Map<String, List<String>> other$eventTypeChannelRevs = other.getEventTypeChannelRevs();
        if (this$eventTypeChannelRevs == null ? other$eventTypeChannelRevs != null : !((Object)this$eventTypeChannelRevs).equals(other$eventTypeChannelRevs)) {
            return false;
        }
        Map<String, Set<String>> this$eventTypeChannelConfigRevCache = this.getEventTypeChannelConfigRevCache();
        Map<String, Set<String>> other$eventTypeChannelConfigRevCache = other.getEventTypeChannelConfigRevCache();
        if (this$eventTypeChannelConfigRevCache == null ? other$eventTypeChannelConfigRevCache != null : !((Object)this$eventTypeChannelConfigRevCache).equals(other$eventTypeChannelConfigRevCache)) {
            return false;
        }
        Map<String, String> this$sqsEventTypeQueueSendMapping = this.getSqsEventTypeQueueSendMapping();
        Map<String, String> other$sqsEventTypeQueueSendMapping = other.getSqsEventTypeQueueSendMapping();
        if (this$sqsEventTypeQueueSendMapping == null ? other$sqsEventTypeQueueSendMapping != null : !((Object)this$sqsEventTypeQueueSendMapping).equals(other$sqsEventTypeQueueSendMapping)) {
            return false;
        }
        Map<String, Set<String>> this$sqsReceiveQueueAndEventTypesMapping = this.getSqsReceiveQueueAndEventTypesMapping();
        Map<String, Set<String>> other$sqsReceiveQueueAndEventTypesMapping = other.getSqsReceiveQueueAndEventTypesMapping();
        if (this$sqsReceiveQueueAndEventTypesMapping == null ? other$sqsReceiveQueueAndEventTypesMapping != null : !((Object)this$sqsReceiveQueueAndEventTypesMapping).equals(other$sqsReceiveQueueAndEventTypesMapping)) {
            return false;
        }
        Map<String, String> this$sqsEventTypeAndListenermapping = this.getSqsEventTypeAndListenermapping();
        Map<String, String> other$sqsEventTypeAndListenermapping = other.getSqsEventTypeAndListenermapping();
        if (this$sqsEventTypeAndListenermapping == null ? other$sqsEventTypeAndListenermapping != null : !((Object)this$sqsEventTypeAndListenermapping).equals(other$sqsEventTypeAndListenermapping)) {
            return false;
        }
        String this$janusUrl = this.getJanusUrl();
        String other$janusUrl = other.getJanusUrl();
        if (this$janusUrl == null ? other$janusUrl != null : !this$janusUrl.equals(other$janusUrl)) {
            return false;
        }
        String this$janusAuthentication = this.getJanusAuthentication();
        String other$janusAuthentication = other.getJanusAuthentication();
        if (this$janusAuthentication == null ? other$janusAuthentication != null : !this$janusAuthentication.equals(other$janusAuthentication)) {
            return false;
        }
        String this$janusPullConfigAction = this.getJanusPullConfigAction();
        String other$janusPullConfigAction = other.getJanusPullConfigAction();
        return !(this$janusPullConfigAction == null ? other$janusPullConfigAction != null : !this$janusPullConfigAction.equals(other$janusPullConfigAction));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LocalCLusterProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $standalonePath = this.getStandalonePath();
        result = result * 59 + ($standalonePath == null ? 43 : $standalonePath.hashCode());
        result = result * 59 + this.getThreadPoolSize();
        result = result * 59 + this.getThreadPoolWaitTime();
        result = result * 59 + this.getQueueSize();
        result = result * 59 + this.getMessageRefuseSize();
        result = result * 59 + this.getMessageCompressSize();
        result = result * 59 + this.getHeartBeatInterval();
        long $fetchMessageInterval = this.getFetchMessageInterval();
        result = result * 59 + (int)($fetchMessageInterval >>> 32 ^ $fetchMessageInterval);
        result = result * 59 + this.getQps();
        String $logStorePath = this.getLogStorePath();
        result = result * 59 + ($logStorePath == null ? 43 : $logStorePath.hashCode());
        result = result * 59 + (this.isSqsEnabled() ? 79 : 97);
        result = result * 59 + (this.isMessageBusEnabled() ? 79 : 97);
        result = result * 59 + (this.isJanusEnabled() ? 79 : 97);
        result = result * 59 + (this.isJanusStandaloneEnabled() ? 79 : 97);
        Map<String, List<String>> $eventTypeChannelSends = this.getEventTypeChannelSends();
        result = result * 59 + ($eventTypeChannelSends == null ? 43 : ((Object)$eventTypeChannelSends).hashCode());
        Map<String, List<String>> $eventTypeChannelRevs = this.getEventTypeChannelRevs();
        result = result * 59 + ($eventTypeChannelRevs == null ? 43 : ((Object)$eventTypeChannelRevs).hashCode());
        Map<String, Set<String>> $eventTypeChannelConfigRevCache = this.getEventTypeChannelConfigRevCache();
        result = result * 59 + ($eventTypeChannelConfigRevCache == null ? 43 : ((Object)$eventTypeChannelConfigRevCache).hashCode());
        Map<String, String> $sqsEventTypeQueueSendMapping = this.getSqsEventTypeQueueSendMapping();
        result = result * 59 + ($sqsEventTypeQueueSendMapping == null ? 43 : ((Object)$sqsEventTypeQueueSendMapping).hashCode());
        Map<String, Set<String>> $sqsReceiveQueueAndEventTypesMapping = this.getSqsReceiveQueueAndEventTypesMapping();
        result = result * 59 + ($sqsReceiveQueueAndEventTypesMapping == null ? 43 : ((Object)$sqsReceiveQueueAndEventTypesMapping).hashCode());
        Map<String, String> $sqsEventTypeAndListenermapping = this.getSqsEventTypeAndListenermapping();
        result = result * 59 + ($sqsEventTypeAndListenermapping == null ? 43 : ((Object)$sqsEventTypeAndListenermapping).hashCode());
        String $janusUrl = this.getJanusUrl();
        result = result * 59 + ($janusUrl == null ? 43 : $janusUrl.hashCode());
        String $janusAuthentication = this.getJanusAuthentication();
        result = result * 59 + ($janusAuthentication == null ? 43 : $janusAuthentication.hashCode());
        String $janusPullConfigAction = this.getJanusPullConfigAction();
        result = result * 59 + ($janusPullConfigAction == null ? 43 : $janusPullConfigAction.hashCode());
        return result;
    }

    public String toString() {
        return "LocalCLusterProperties(standalonePath=" + this.getStandalonePath() + ", threadPoolSize=" + this.getThreadPoolSize() + ", threadPoolWaitTime=" + this.getThreadPoolWaitTime() + ", queueSize=" + this.getQueueSize() + ", messageRefuseSize=" + this.getMessageRefuseSize() + ", messageCompressSize=" + this.getMessageCompressSize() + ", heartBeatInterval=" + this.getHeartBeatInterval() + ", fetchMessageInterval=" + this.getFetchMessageInterval() + ", qps=" + this.getQps() + ", logStorePath=" + this.getLogStorePath() + ", sqsEnabled=" + this.isSqsEnabled() + ", messageBusEnabled=" + this.isMessageBusEnabled() + ", janusEnabled=" + this.isJanusEnabled() + ", janusStandaloneEnabled=" + this.isJanusStandaloneEnabled() + ", eventTypeChannelSends=" + this.getEventTypeChannelSends() + ", eventTypeChannelRevs=" + this.getEventTypeChannelRevs() + ", eventTypeChannelConfigRevCache=" + this.getEventTypeChannelConfigRevCache() + ", sqsEventTypeQueueSendMapping=" + this.getSqsEventTypeQueueSendMapping() + ", sqsReceiveQueueAndEventTypesMapping=" + this.getSqsReceiveQueueAndEventTypesMapping() + ", sqsEventTypeAndListenermapping=" + this.getSqsEventTypeAndListenermapping() + ", janusUrl=" + this.getJanusUrl() + ", janusAuthentication=" + this.getJanusAuthentication() + ", janusPullConfigAction=" + this.getJanusPullConfigAction() + ")";
    }
}

