/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.apollo.janus.standalone.sdk.configHandler;

import com.xforceplus.apollo.janus.standalone.sdk.config.JanusStandaloneAssit;
import com.xforceplus.apollo.janus.standalone.sdk.config.LocalCLusterProperties;
import com.xforceplus.apollo.janus.standalone.sdk.message.MessageEventInitListener;
import com.xforceplus.apollo.utils.ErrorUtil;
import com.xforceplus.apollo.utils.JacksonUtil;
import com.xforceplus.janus.config.core.config.ConfigHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;

@Order(value=999)
public class PullSqsEventTypeQueueConfigHandler
implements ConfigHandler {
    private static final Logger log = LoggerFactory.getLogger(PullSqsEventTypeQueueConfigHandler.class);
    private boolean firstIn = true;
    @Autowired
    MessageEventInitListener messageEventInitListener;

    public String getConfigKey() {
        return "sqs-eventType-queue-config";
    }

    public void doHandler(String sqsEventTypeQueueConfig) {
        if (StringUtils.isNotBlank((CharSequence)sqsEventTypeQueueConfig)) {
            log.info("sqs-eventType-queue-config ,{}", (Object)sqsEventTypeQueueConfig);
            boolean sqsEnabled = LocalCLusterProperties.getInstance().isSqsEnabled();
            if (sqsEnabled) {
                this.parseSqsEventTypeQueueConfig(sqsEventTypeQueueConfig);
                if (!this.firstIn) {
                    this.messageEventInitListener.refreshSqsHandler();
                }
            }
        }
        this.firstIn = false;
    }

    private void parseSqsEventTypeQueueConfig(String sqsEventTypeQueueConfig) {
        try {
            Map configMap = (Map)JacksonUtil.getInstance().fromJson(sqsEventTypeQueueConfig, Map.class);
            HashMap<String, String> sqsEventTypeQueueSendMapping = new HashMap<String, String>();
            HashMap<String, Set<String>> sqsReceiveQueueAndEventTypesMapping = new HashMap<String, Set<String>>();
            HashMap<String, String> sqsEventTypeAndListenermapping = new HashMap<String, String>();
            HashMap<String, List<String>> eventTypeChannelSends = new HashMap<String, List<String>>();
            HashMap<String, List<String>> eventTypeChannelRevs = new HashMap<String, List<String>>();
            if (configMap.get("sendmapping") != null || configMap.get("receiveQueueAndEventTypes") != null || configMap.get("eventTypeAndListenermapping") != null || configMap.get("eventTypeChannelConfig") != null) {
                Map temp;
                String eventTypeName;
                if (configMap.get("sendmapping") != null) {
                    Map temp1 = (Map)configMap.get("sendmapping");
                    for (Map.Entry entry : temp1.entrySet()) {
                        eventTypeName = (String)entry.getKey();
                        String queueName = (String)entry.getValue();
                        if (StringUtils.isBlank((CharSequence)eventTypeName) || StringUtils.isBlank((CharSequence)queueName)) continue;
                        sqsEventTypeQueueSendMapping.put(eventTypeName.trim(), queueName.trim());
                    }
                }
                if (configMap.get("receiveQueueAndEventTypes") != null) {
                    Map temp2 = (Map)configMap.get("receiveQueueAndEventTypes");
                    for (Map.Entry entry : temp2.entrySet()) {
                        String queueName = (String)entry.getKey();
                        String eventTypeNames = (String)entry.getValue();
                        if (StringUtils.isBlank((CharSequence)eventTypeNames) || StringUtils.isBlank((CharSequence)queueName)) continue;
                        HashSet<String> sqsEventTypeNames = new HashSet<String>();
                        String[] values = eventTypeNames.split(",");
                        if (values != null && values.length > 0) {
                            for (String temp3 : values) {
                                if (temp3 == null || temp3.trim().equals("")) continue;
                                String eventTypeName2 = temp3.trim();
                                if (eventTypeName2.equalsIgnoreCase("all")) {
                                    eventTypeName2 = "*";
                                }
                                sqsEventTypeNames.add(eventTypeName2);
                            }
                        }
                        sqsReceiveQueueAndEventTypesMapping.put(queueName.trim(), sqsEventTypeNames);
                    }
                }
                if (configMap.get("eventTypeAndListenermapping") != null) {
                    Map temp3 = (Map)configMap.get("eventTypeAndListenermapping");
                    for (Map.Entry entry : temp3.entrySet()) {
                        eventTypeName = (String)entry.getKey();
                        String listenerName = (String)entry.getValue();
                        if (StringUtils.isBlank((CharSequence)eventTypeName) || StringUtils.isBlank((CharSequence)listenerName)) continue;
                        sqsEventTypeAndListenermapping.put(eventTypeName.trim(), listenerName.trim());
                    }
                }
                if (configMap.get("eventTypeChannelConfig") != null && (temp = (Map)configMap.get("eventTypeChannelConfig")) != null) {
                    Map temp2 = (Map)temp.get("send");
                    if (temp2 != null) {
                        for (Map.Entry entry : temp2.entrySet()) {
                            this.buildEventTypeChannelConfigs(eventTypeChannelSends, (String)entry.getKey(), (String)entry.getValue());
                        }
                    }
                    if ((temp2 = (Map)temp.get("receive")) != null) {
                        for (Map.Entry entry : temp2.entrySet()) {
                            this.buildEventTypeChannelConfigs(eventTypeChannelRevs, (String)entry.getKey(), (String)entry.getValue());
                        }
                    }
                }
                LocalCLusterProperties.getInstance().setSqsEventTypeQueueSendMapping(sqsEventTypeQueueSendMapping);
                LocalCLusterProperties.getInstance().setSqsReceiveQueueAndEventTypesMapping(sqsReceiveQueueAndEventTypesMapping);
                LocalCLusterProperties.getInstance().setSqsEventTypeAndListenermapping(sqsEventTypeAndListenermapping);
                LocalCLusterProperties.getInstance().setEventTypeChannelSends(eventTypeChannelSends);
                LocalCLusterProperties.getInstance().setEventTypeChannelRevs(eventTypeChannelRevs);
            }
        }
        catch (Exception e) {
            log.error("parseSqsEventTypeQueueConfig error {}", (Object)ErrorUtil.getStackMsg((Exception)e));
        }
        catch (Error error) {
            log.error("parseSqsEventTypeQueueConfig error {}", (Object)ErrorUtil.getStackMsg((Throwable)error));
        }
    }

    private void buildEventTypeChannelConfigs(Map<String, List<String>> eventTypeChannels, String key, String value) {
        if (value != null && !value.trim().equals("") && key != null && !key.trim().equals("")) {
            String eventTypeName = key.trim();
            HashSet<String> channelSources = new HashSet<String>();
            String[] values = value.split(",");
            if (values != null && values.length > 0) {
                for (String temp : values) {
                    String source;
                    String sourceVal;
                    if (temp == null || (sourceVal = JanusStandaloneAssit.MessageSourceMap.get(source = temp.trim())) == null) continue;
                    channelSources.add(sourceVal);
                }
            }
            if (channelSources.size() > 0) {
                eventTypeChannels.put(eventTypeName, new ArrayList(channelSources));
            }
        }
    }

    public void nullValueHandler() {
        this.firstIn = false;
    }
}

