/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.apollo.janus.standalone.sdk.message;

import com.xforceplus.apollo.janus.standalone.sdk.annotation.GlobalEventListener;
import com.xforceplus.apollo.janus.standalone.sdk.annotation.GlobalMessageEventListener;
import com.xforceplus.apollo.janus.standalone.sdk.config.JanusStandaloneConfigInit;
import com.xforceplus.apollo.janus.standalone.sdk.config.LocalCLusterProperties;
import com.xforceplus.apollo.janus.standalone.sdk.message.IGlobalMessageEventListener;
import com.xforceplus.apollo.janus.standalone.sdk.message.sqs.DefaultSQSListener;
import com.xforceplus.apollo.janus.standalone.sdk.message.sqs.PullSqsMessageTask;
import com.xforceplus.apollo.utils.ErrorUtil;
import com.xforceplus.janus.config.core.config.HttpConfig;
import com.xforceplus.xplat.aws.sqs.SqsService;
import com.xforceplus.xplat.aws.sqs.singleton.SqsClientSingleton;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationListener;

public class MessageEventInitListener
implements ApplicationListener<ApplicationReadyEvent>,
ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(MessageEventInitListener.class);
    public static volatile ConcurrentHashMap<String, ConcurrentHashMap<String, Set<IGlobalMessageEventListener>>> EVENT_HANDLERS = new ConcurrentHashMap();
    public static volatile ConcurrentHashMap<String, IGlobalMessageEventListener> EVENT_CLASS_HANDLERS = new ConcurrentHashMap();
    private ApplicationContext applicationContext;
    private ConcurrentHashMap<String, PullSqsMessageTask> pullSqsMessageTaskMap = new ConcurrentHashMap();

    public MessageEventInitListener(HttpConfig httpConfig) {
        httpConfig.setClientType("4");
        httpConfig.setClientVersion(JanusStandaloneConfigInit.janusStandaloneSdkVersion);
    }

    public static boolean needReceiveHandle(String queueName, String eventType, String sqs) {
        return LocalCLusterProperties.getInstance().needReceiveHandle(queueName, eventType);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void onApplicationEvent(ApplicationReadyEvent event) {
        this.refreshListener();
    }

    private void refreshListener() {
        if (!LocalCLusterProperties.getInstance().hasConfig()) {
            log.error("\u65e0\u5c5e\u5730\u96c6\u6210\u5e73\u53f0sdk\u76f8\u5173\u914d\u7f6e");
            return;
        }
        ConcurrentHashMap<String, ConcurrentHashMap<String, Set<IGlobalMessageEventListener>>> event_handlers_temp = new ConcurrentHashMap<String, ConcurrentHashMap<String, Set<IGlobalMessageEventListener>>>();
        ConcurrentHashMap<String, IGlobalMessageEventListener> event_class_handlers_temp = new ConcurrentHashMap<String, IGlobalMessageEventListener>();
        this.doIGlobalMessageEventListener(event_handlers_temp, event_class_handlers_temp);
        this.doIGlobalEventListener(event_handlers_temp, event_class_handlers_temp);
        EVENT_HANDLERS = event_handlers_temp;
        EVENT_CLASS_HANDLERS = event_class_handlers_temp;
        this.refreshSqsHandler();
        if (event_handlers_temp.size() == 0) {
            log.info("not found GlobalMessageEventListener ");
        }
    }

    private void doIGlobalMessageEventListener(ConcurrentHashMap<String, ConcurrentHashMap<String, Set<IGlobalMessageEventListener>>> event_handlers_temp, ConcurrentHashMap<String, IGlobalMessageEventListener> event_class_handlers_temp) {
        block8: {
            try {
                Map beans = this.applicationContext.getBeansWithAnnotation(GlobalMessageEventListener.class);
                if (null == beans) break block8;
                for (Map.Entry entry : beans.entrySet()) {
                    Object v = entry.getValue();
                    if (v instanceof IGlobalMessageEventListener) {
                        GlobalMessageEventListener eventListener = v.getClass().getAnnotation(GlobalMessageEventListener.class);
                        String eventType = eventListener.queueName();
                        if (StringUtils.isBlank((CharSequence)eventType)) {
                            log.warn("\u6d88\u606f\u76d1\u542c\u5668\u961f\u5217\u540d\u4e0d\u80fd\u4e3a\u7a7a\uff01\uff01\uff01");
                            continue;
                        }
                        eventType = eventType.trim();
                        IGlobalMessageEventListener globalMessageEventListener = (IGlobalMessageEventListener)v;
                        String classFullName = v.getClass().getName();
                        String shortName = classFullName.substring(classFullName.lastIndexOf(".") + 1, classFullName.length());
                        event_class_handlers_temp.put(shortName, globalMessageEventListener);
                        if (eventType.endsWith("*")) {
                            this.addEventHandlersTemp(event_handlers_temp, "*", eventType, globalMessageEventListener);
                            continue;
                        }
                        Set<String> sources = LocalCLusterProperties.getInstance().getRevSources(eventType);
                        if (!CollectionUtils.isNotEmpty(sources)) continue;
                        for (String source : sources) {
                            this.addEventHandlersTemp(event_handlers_temp, source, eventType, globalMessageEventListener);
                        }
                        continue;
                    }
                    log.warn(" {} \u6ca1\u6709\u5b9e\u73b0 IGlobalMessageEventListener \u63a5\u53e3", (Object)v.getClass().getName());
                }
            }
            catch (Exception e) {
                log.error("doIGlobalMessageEventListener error {}", (Object)ErrorUtil.getStackMsg((Exception)e));
            }
            catch (Error e) {
                log.error("doIGlobalMessageEventListener error {}", (Object)ErrorUtil.getStackMsg((Throwable)e));
            }
        }
    }

    private void addEventHandlersTemp(ConcurrentHashMap<String, ConcurrentHashMap<String, Set<IGlobalMessageEventListener>>> event_handlers_temp, String source, String eventType, IGlobalMessageEventListener globalMessageEventListener) {
        Set<IGlobalMessageEventListener> listeners;
        ConcurrentHashMap<String, Set<IGlobalMessageEventListener>> event_handler_map = event_handlers_temp.get(source);
        if (event_handler_map == null) {
            event_handler_map = new ConcurrentHashMap();
        }
        if ((listeners = event_handler_map.get(eventType)) == null) {
            listeners = new HashSet<IGlobalMessageEventListener>();
        }
        listeners.add(globalMessageEventListener);
        event_handler_map.put(eventType, listeners);
        event_handlers_temp.put(source, event_handler_map);
    }

    private void doIGlobalEventListener(ConcurrentHashMap<String, ConcurrentHashMap<String, Set<IGlobalMessageEventListener>>> event_handlers_temp, ConcurrentHashMap<String, IGlobalMessageEventListener> event_class_handlers_temp) {
        block9: {
            try {
                Map beans = this.applicationContext.getBeansWithAnnotation(GlobalEventListener.class);
                if (null == beans) break block9;
                for (Map.Entry entry : beans.entrySet()) {
                    Object v = entry.getValue();
                    if (v instanceof IGlobalMessageEventListener) {
                        GlobalEventListener eventListener = v.getClass().getAnnotation(GlobalEventListener.class);
                        if (eventListener == null) {
                            log.warn("\u6d88\u606f\u76d1\u542c\u5668\u9519\u8bef\uff01\uff01\uff01");
                            continue;
                        }
                        IGlobalMessageEventListener globalMessageEventListener = (IGlobalMessageEventListener)v;
                        String classFullName = v.getClass().getName();
                        String shortName = classFullName.substring(classFullName.lastIndexOf(".") + 1, classFullName.length());
                        event_class_handlers_temp.put(shortName, globalMessageEventListener);
                        String eventType = eventListener.eventType();
                        if (StringUtils.isBlank((CharSequence)eventType)) {
                            log.warn("\u6d88\u606f\u76d1\u542c\u5668\u961f\u5217\u540d\u4e0d\u80fd\u4e3a\u7a7a\uff01\uff01\uff01");
                            continue;
                        }
                        if ((eventType = eventType.trim()).endsWith("*")) {
                            this.addEventHandlersTemp(event_handlers_temp, "*", eventType, globalMessageEventListener);
                            continue;
                        }
                        Set<String> sources = LocalCLusterProperties.getInstance().getRevSources(eventType);
                        if (!CollectionUtils.isNotEmpty(sources)) continue;
                        for (String source : sources) {
                            this.addEventHandlersTemp(event_handlers_temp, source, eventType, globalMessageEventListener);
                        }
                        continue;
                    }
                    log.warn(" {} \u6ca1\u6709\u5b9e\u73b0 IGlobalMessageEventListener \u63a5\u53e3", (Object)v.getClass().getName());
                }
            }
            catch (Exception e) {
                log.error("doIGlobalEventListener error {}", (Object)ErrorUtil.getStackMsg((Exception)e));
            }
            catch (Error e) {
                log.error("doIGlobalEventListener error {}", (Object)ErrorUtil.getStackMsg((Throwable)e));
            }
        }
    }

    public void refreshSqsHandler() {
        block11: {
            try {
                boolean sqsEnabled = LocalCLusterProperties.getInstance().isSqsEnabled();
                Set<String> sqsReceiveQueues = LocalCLusterProperties.getInstance().getSqsReceiveQueues();
                if (sqsEnabled && sqsReceiveQueues != null && sqsReceiveQueues.size() > 0) {
                    SqsService sqs = null;
                    try {
                        sqs = (SqsService)this.applicationContext.getBean(SqsService.class);
                    }
                    catch (Exception e2) {
                        sqs = SqsClientSingleton.getInst().getSqs();
                    }
                    if (sqs == null) {
                        log.error("SqsService init fail");
                        return;
                    }
                    if (this.pullSqsMessageTaskMap.size() > 0) {
                        Set exits = this.pullSqsMessageTaskMap.keySet();
                        Set notExits = exits.stream().filter(e -> !sqsReceiveQueues.contains(e)).collect(Collectors.toSet());
                        Iterator<Map.Entry<String, PullSqsMessageTask>> it = this.pullSqsMessageTaskMap.entrySet().iterator();
                        while (it.hasNext()) {
                            Map.Entry<String, PullSqsMessageTask> entry = it.next();
                            String queue = entry.getKey();
                            if (!notExits.contains(queue)) continue;
                            entry.getValue().setCanRun(false);
                            it.remove();
                        }
                    }
                    for (String queueName : sqsReceiveQueues) {
                        if (this.pullSqsMessageTaskMap.get(queueName) != null) continue;
                        DefaultSQSListener defaultSQSListener = new DefaultSQSListener(queueName);
                        log.info("initOrRemoveSqsHandler :{} has listening", (Object)queueName);
                        PullSqsMessageTask pullSqsMessageTask = new PullSqsMessageTask(queueName, defaultSQSListener, sqs);
                        pullSqsMessageTask.start();
                        this.pullSqsMessageTaskMap.put(queueName, pullSqsMessageTask);
                    }
                    break block11;
                }
                if (this.pullSqsMessageTaskMap.size() > 0) {
                    Iterator<Map.Entry<String, PullSqsMessageTask>> it = this.pullSqsMessageTaskMap.entrySet().iterator();
                    while (it.hasNext()) {
                        Map.Entry<String, PullSqsMessageTask> entry = it.next();
                        entry.getValue().setCanRun(false);
                        it.remove();
                    }
                }
            }
            catch (Exception e3) {
                log.error("initOrRemoveSqsHandler error: {}", (Object)ErrorUtil.getStackMsg((Exception)e3));
            }
        }
    }

    public static Set<IGlobalMessageEventListener> findHandler(String eventType, String source) {
        ConcurrentHashMap<String, ConcurrentHashMap<String, Set<IGlobalMessageEventListener>>> eventHandlerMap;
        ConcurrentHashMap<String, Set<IGlobalMessageEventListener>> handler_map;
        HashSet<IGlobalMessageEventListener> handlers = new HashSet<IGlobalMessageEventListener>();
        if (source.equals("sqs") && LocalCLusterProperties.getInstance().getSqsEventTypeAndListenermapping().size() > 0) {
            String listenerName;
            Map<String, String> sqsEventTypeAndListenermapping = LocalCLusterProperties.getInstance().getSqsEventTypeAndListenermapping();
            ConcurrentHashMap<String, IGlobalMessageEventListener> event_class_handlers = EVENT_CLASS_HANDLERS;
            if (sqsEventTypeAndListenermapping.get(eventType) != null && (listenerName = sqsEventTypeAndListenermapping.get(eventType)) != null && event_class_handlers.get(listenerName) != null) {
                handlers.add(event_class_handlers.get(listenerName));
            }
            List<String> candidateEventTypes = new ArrayList<String>(sqsEventTypeAndListenermapping.keySet());
            if (CollectionUtils.isNotEmpty(candidateEventTypes = candidateEventTypes.stream().filter(o -> StringUtils.isNotBlank((CharSequence)o) && o.endsWith("*")).collect(Collectors.toList()))) {
                Collections.sort(candidateEventTypes, (o1, o2) -> {
                    int index2;
                    int index1 = o1.indexOf("*");
                    if (index1 < (index2 = o2.indexOf("*"))) {
                        return 1;
                    }
                    if (index1 > index2) {
                        return -1;
                    }
                    return 0;
                });
                for (String candidateEventType : candidateEventTypes) {
                    String listenerName2;
                    String prefixkey = candidateEventType.substring(0, candidateEventType.length() - 1);
                    if (!eventType.startsWith(prefixkey) || (listenerName2 = sqsEventTypeAndListenermapping.get(candidateEventType)) == null || event_class_handlers.get(listenerName2) == null) continue;
                    handlers.add(event_class_handlers.get(listenerName2));
                }
            }
            if (handlers.size() > 0) {
                return handlers;
            }
        }
        if ((handler_map = (eventHandlerMap = EVENT_HANDLERS).get(source)) != null) {
            Set<IGlobalMessageEventListener> temps = handler_map.get(eventType);
            if (temps != null && temps.size() > 0) {
                handlers.addAll(temps);
            }
            for (Map.Entry<String, Set<IGlobalMessageEventListener>> entry : handler_map.entrySet()) {
                String temp;
                String eventTypeName = entry.getKey();
                if (eventTypeName.equals("*")) {
                    temps = entry.getValue();
                    if (temps == null || temps.size() <= 0) continue;
                    handlers.addAll(temps);
                    continue;
                }
                if (!eventTypeName.endsWith("*") || !eventType.startsWith(temp = eventTypeName.substring(0, eventTypeName.length() - 1)) || (temps = entry.getValue()) == null || temps.size() <= 0) continue;
                handlers.addAll(temps);
            }
        } else {
            log.error("{},{}  NO MessageEventListener\uff01\uff01\uff01", (Object)eventType, (Object)source);
        }
        handler_map = eventHandlerMap.get("*");
        if (handler_map != null) {
            for (Map.Entry<String, Set<IGlobalMessageEventListener>> entry : handler_map.entrySet()) {
                Set<IGlobalMessageEventListener> temps;
                String temp;
                String eventTypeName = entry.getKey();
                if (eventTypeName.equals("*")) {
                    Set<IGlobalMessageEventListener> temps2 = entry.getValue();
                    if (temps2 == null || temps2.size() <= 0) continue;
                    handlers.addAll(temps2);
                    continue;
                }
                if (!eventTypeName.endsWith("*") || !eventType.startsWith(temp = eventTypeName.substring(0, eventTypeName.length() - 1)) || (temps = entry.getValue()) == null || temps.size() <= 0) continue;
                handlers.addAll(temps);
            }
        }
        return handlers;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public ConcurrentHashMap<String, PullSqsMessageTask> getPullSqsMessageTaskMap() {
        return this.pullSqsMessageTaskMap;
    }

    public void setPullSqsMessageTaskMap(ConcurrentHashMap<String, PullSqsMessageTask> pullSqsMessageTaskMap) {
        this.pullSqsMessageTaskMap = pullSqsMessageTaskMap;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MessageEventInitListener)) {
            return false;
        }
        MessageEventInitListener other = (MessageEventInitListener)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ApplicationContext this$applicationContext = this.getApplicationContext();
        ApplicationContext other$applicationContext = other.getApplicationContext();
        if (this$applicationContext == null ? other$applicationContext != null : !this$applicationContext.equals(other$applicationContext)) {
            return false;
        }
        ConcurrentHashMap<String, PullSqsMessageTask> this$pullSqsMessageTaskMap = this.getPullSqsMessageTaskMap();
        ConcurrentHashMap<String, PullSqsMessageTask> other$pullSqsMessageTaskMap = other.getPullSqsMessageTaskMap();
        return !(this$pullSqsMessageTaskMap == null ? other$pullSqsMessageTaskMap != null : !((Object)this$pullSqsMessageTaskMap).equals(other$pullSqsMessageTaskMap));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MessageEventInitListener;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ApplicationContext $applicationContext = this.getApplicationContext();
        result = result * 59 + ($applicationContext == null ? 43 : $applicationContext.hashCode());
        ConcurrentHashMap<String, PullSqsMessageTask> $pullSqsMessageTaskMap = this.getPullSqsMessageTaskMap();
        result = result * 59 + ($pullSqsMessageTaskMap == null ? 43 : ((Object)$pullSqsMessageTaskMap).hashCode());
        return result;
    }

    public String toString() {
        return "MessageEventInitListener(applicationContext=" + this.getApplicationContext() + ", pullSqsMessageTaskMap=" + this.getPullSqsMessageTaskMap() + ")";
    }
}

