/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.apollo.janus.standalone.sdk.message;

import com.xforceplus.apollo.client.netty.MCFactory;
import com.xforceplus.apollo.janus.standalone.sdk.beans.ClientInfoDTO;
import com.xforceplus.apollo.janus.standalone.sdk.config.JanusStandaloneConfigInit;
import com.xforceplus.apollo.janus.standalone.sdk.config.LocalCLusterProperties;
import com.xforceplus.apollo.janus.standalone.sdk.message.PubMessageResponse;
import com.xforceplus.apollo.janus.standalone.sdk.message.messageBus.MBClient;
import com.xforceplus.apollo.janus.standalone.sdk.message.messageBus.RequestMessage;
import com.xforceplus.apollo.janus.standalone.sdk.message.messageBus.request.PubRequest;
import com.xforceplus.apollo.janus.standalone.sdk.message.messageBus.response.PubResponse;
import com.xforceplus.apollo.janus.standalone.sdk.message.standaloneJanus.StandaloneJanusService;
import com.xforceplus.apollo.msg.SealedMessage;
import com.xforceplus.apollo.utils.ErrorUtil;
import com.xforceplus.apollo.utils.JacksonUtil;
import com.xforceplus.janus.config.core.config.HttpConfig;
import com.xforceplus.xplat.aws.sqs.SqsService;
import java.util.ArrayList;
import java.util.Map;
import net.wicp.tams.common.Result;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;

public class MessageSenderUtils {
    private static final Logger log = LoggerFactory.getLogger(MessageSenderUtils.class);
    @Autowired(required=false)
    private SqsService service;
    @Autowired(required=false)
    private StandaloneJanusService standaloneJanusService;
    @Autowired
    private Environment environment;
    @Autowired
    private HttpConfig httpConfig;

    public static SealedMessage converterToJanus(Map headers, String messageBody) {
        String userId = headers.get("userId") == null ? "" : (String)headers.get("userId");
        String requestName = headers.get("requestName") == null ? "" : (String)headers.get("requestName");
        SealedMessage.Header header = new SealedMessage.Header(userId, requestName, headers);
        SealedMessage.Payload payload = new SealedMessage.Payload((Object)messageBody);
        SealedMessage sealedMessage = new SealedMessage(header, payload);
        return sealedMessage;
    }

    public PubMessageResponse sendMsgWithConfig(String eventType, String message, Map<String, String> properties) {
        eventType = eventType.trim();
        PubMessageResponse response = this.sendMsgToMultiChannel(eventType, message, properties);
        log.debug(JacksonUtil.getInstance().toJson((Object)response));
        return response;
    }

    private PubMessageResponse sendMsgToMultiChannel(String eventType, String message, Map<String, String> properties) {
        PubMessageResponse response = new PubMessageResponse();
        if (StringUtils.isBlank((CharSequence)eventType)) {
            response.setSuccess(false);
            response.setMessage("eventType is null");
            return response;
        }
        if (StringUtils.isBlank((CharSequence)message)) {
            response.setSuccess(false);
            response.setMessage("\u53d1\u9001\u7684\u6d88\u606f\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
            return response;
        }
        if (properties == null || StringUtils.isBlank((CharSequence)properties.get("businessNo"))) {
            response.setSuccess(false);
            response.setMessage("\u6ca1\u6709businessNo \u5c5e\u6027\uff01");
            return response;
        }
        properties.put("janusStandaloneSdkVersion", JanusStandaloneConfigInit.janusStandaloneSdkVersion);
        ArrayList<PubMessageResponse> responses = new ArrayList<PubMessageResponse>();
        LocalCLusterProperties localCLusterProperties = LocalCLusterProperties.getInstance();
        if (localCLusterProperties.canSendToSqs(eventType)) {
            responses.add(this.sendMsgToSqs(eventType, message, properties));
        }
        if (localCLusterProperties.canSendToMessageBus(eventType)) {
            responses.add(this.sendMsgToBUS(eventType, message, properties));
        }
        if (localCLusterProperties.canSendToJanus(eventType)) {
            responses.add(this.sendMsgToJanus(eventType, message, properties));
        }
        if (localCLusterProperties.canSendToStandaloneJanus(eventType)) {
            responses.add(this.sendMsgToStandaloneJanus(eventType, message, properties));
        }
        if (responses.size() == 0) {
            if (localCLusterProperties.isSqsEnabled()) {
                responses.add(this.sendMsgToSqs(eventType, message, properties));
            }
            if (localCLusterProperties.isMessageBusEnabled()) {
                responses.add(this.sendMsgToBUS(eventType, message, properties));
            }
            if (localCLusterProperties.isJanusStandaloneEnabled()) {
                responses.add(this.sendMsgToStandaloneJanus(eventType, message, properties));
            }
            if (localCLusterProperties.isJanusEnabled()) {
                responses.add(this.sendMsgToJanus(eventType, message, properties));
            }
        }
        if (responses.size() == 0) {
            response.setSuccess(false);
            response.setMessage("\u672a\u5f00\u542f\u6d88\u606f\u53d1\u9001\u76f8\u5173\u914d\u7f6e\uff01");
            return response;
        }
        if (responses.size() == 1) {
            return (PubMessageResponse)responses.get(0);
        }
        boolean sendResultFlag = true;
        for (PubMessageResponse temp : responses) {
            if (temp.getSuccess().booleanValue()) continue;
            sendResultFlag = false;
            break;
        }
        response.setSuccess(sendResultFlag);
        response.setMessage(JacksonUtil.getInstance().toJson(responses));
        return response;
    }

    private PubMessageResponse sendMsgToSingleChannel(String eventType, String message, Map<String, String> properties) {
        LocalCLusterProperties localCLusterProperties = LocalCLusterProperties.getInstance();
        properties.put("janusStandaloneSdkVersion", JanusStandaloneConfigInit.janusStandaloneSdkVersion);
        if (localCLusterProperties.canSendToSqs(eventType)) {
            return this.sendMsgToSqs(eventType, message, properties);
        }
        if (localCLusterProperties.canSendToMessageBus(eventType)) {
            return this.sendMsgToBUS(eventType, message, properties);
        }
        if (localCLusterProperties.canSendToJanus(eventType)) {
            return this.sendMsgToJanus(eventType, message, properties);
        }
        if (localCLusterProperties.canSendToStandaloneJanus(eventType)) {
            return this.sendMsgToStandaloneJanus(eventType, message, properties);
        }
        if (localCLusterProperties.isSqsEnabled()) {
            return this.sendMsgToSqs(eventType, message, properties);
        }
        if (localCLusterProperties.isMessageBusEnabled()) {
            return this.sendMsgToBUS(eventType, message, properties);
        }
        if (localCLusterProperties.isJanusStandaloneEnabled()) {
            return this.sendMsgToStandaloneJanus(eventType, message, properties);
        }
        if (localCLusterProperties.isJanusEnabled()) {
            return this.sendMsgToJanus(eventType, message, properties);
        }
        PubMessageResponse response = new PubMessageResponse();
        response.setSuccess(false);
        response.setMessage("\u672a\u5f00\u542f\u6d88\u606f\u53d1\u9001\u76f8\u5173\u914d\u7f6e\uff01");
        return response;
    }

    private PubMessageResponse sendMsgToBUS(String eventType, String message, Map<String, String> properties) {
        properties.put("standaloneSdkSendTime", System.currentTimeMillis() + "");
        PubMessageResponse response = new PubMessageResponse();
        MBClient mbClient = null;
        try {
            String url = this.environment.getProperty("message-bus.url");
            String token = this.environment.getProperty("message-bus.token");
            mbClient = MBClient.getInstance(url, token);
        }
        catch (Exception e) {
            log.error("MessageBusInit error :{} ", (Object)ErrorUtil.getStackMsg((Exception)e));
            mbClient = null;
        }
        if (mbClient == null) {
            response.setSuccess(false);
            response.setMessage("\u672a\u5f00\u542f\u6d88\u606f\u603b\u7ebf\u76f8\u5173\u914d\u7f6e\uff01");
            return response;
        }
        if (properties == null || properties.get("businessNo") == null) {
            response.setSuccess(false);
            response.setMessage("\u5c5e\u6027\u4e2d\u5fc5\u987b\u6709businessNo");
            return response;
        }
        RequestMessage requestMessage = new RequestMessage();
        requestMessage.setBusinessNo(properties.get("businessNo"));
        requestMessage.setSentTime(System.currentTimeMillis());
        requestMessage.getProperties().putAll(properties);
        requestMessage.setContent(message);
        PubRequest pubRequest = new PubRequest(eventType, requestMessage);
        PubResponse pub = mbClient.pub(pubRequest);
        log.debug("eventType:{},message:{},properties:{} ", new Object[]{eventType, message, JacksonUtil.getInstance().toJson(properties), JacksonUtil.getInstance().toJson((Object)pub)});
        response.setSuccess(pub.getSuccess());
        response.setMessage(pub.getError());
        response.setMessageId(pub.getMessageId());
        return response;
    }

    private PubMessageResponse sendMsgToJanus(String eventType, String message, Map<String, String> properties) {
        PubMessageResponse response = new PubMessageResponse();
        try {
            ClientInfoDTO clientInfo;
            if (properties == null || properties.get("businessNo") == null) {
                response.setSuccess(false);
                response.setMessage("\u5c5e\u6027\u4e2d\u5fc5\u987b\u6709businessNo");
                return response;
            }
            properties.put("standaloneSdkSentTime", System.currentTimeMillis() + "");
            MCFactory mcFactory = null;
            try {
                mcFactory = MCFactory.getInstance();
            }
            catch (Exception e) {
                log.error(ErrorUtil.getStackMsg((Exception)e));
                response.setSuccess(false);
                response.setMessage("\u672a\u5f00\u542f\u4e91\u7aef\u96c6\u6210\u5e73\u53f0\u76f8\u5173\u914d\u7f6e\uff01");
                return response;
            }
            if (properties.get("payLoadId") == null) {
                properties.put("payLoadId", properties.get("businessNo"));
            }
            if ((clientInfo = (ClientInfoDTO)JacksonUtil.getInstance().fromJson(this.httpConfig.getClientInfo(), ClientInfoDTO.class)) == null || clientInfo.getClientId() == null) {
                response.setSuccess(false);
                response.setMessage("\u672a\u5f00\u542f\u4e91\u7aef\u96c6\u6210\u5e73\u53f0\u76f8\u5173\u914d\u7f6e\uff01");
                return response;
            }
            String clientId = clientInfo.getClientId();
            SealedMessage.Header header = new SealedMessage.Header(clientId, eventType, properties);
            SealedMessage sealedMessage = new SealedMessage(header, new SealedMessage.Payload((Object)message));
            if (mcFactory.sendMessage(sealedMessage)) {
                response.setSuccess(true);
                response.setMessage("\u5411\u4e91\u7aef\u96c6\u6210\u5e73\u53f0\u53d1\u9001\u6d88\u606f\u6210\u529f\uff01");
            } else {
                response.setSuccess(false);
                response.setMessage("\u5411\u4e91\u7aef\u96c6\u6210\u5e73\u53f0\u53d1\u9001\u6d88\u606f\u5931\u8d25\uff01");
            }
        }
        catch (Exception e) {
            log.error(ErrorUtil.getStackMsg((Exception)e));
            response.setSuccess(false);
            response.setMessage("\u5411\u4e91\u7aef\u96c6\u6210\u5e73\u53f0\u53d1\u9001\u6d88\u606f\u5f02\u5e38\uff01");
        }
        return response;
    }

    private PubMessageResponse sendMsgToStandaloneJanus(String eventType, String message, Map<String, String> properties) {
        properties.put("standaloneSdkSentTime", System.currentTimeMillis() + "");
        PubMessageResponse response = new PubMessageResponse();
        if (this.standaloneJanusService == null) {
            response.setSuccess(false);
            response.setMessage("\u672a\u5f00\u542f\u5c5e\u5730\u96c6\u6210\u5e73\u53f0\u76f8\u5173\u914d\u7f6e\uff01");
            return response;
        }
        Result result = this.standaloneJanusService.sendStrMsg(eventType, message, properties);
        log.debug("queueName:{},result:{} ", (Object)eventType, (Object)JacksonUtil.getInstance().toJson((Object)result));
        response.setSuccess(result.isSuc());
        response.setMessage(result.getMessage());
        return response;
    }

    private PubMessageResponse sendMsgToSqs(String eventType, String message, Map<String, String> properties) {
        properties.put("standaloneSdkSentTime", System.currentTimeMillis() + "");
        PubMessageResponse response = new PubMessageResponse();
        String businessNo = properties.get("businessNo");
        if (StringUtils.isBlank((CharSequence)businessNo)) {
            response.setSuccess(false);
            response.setMessage("properties  businessNo is null");
            return response;
        }
        String queueName = properties.get("queueName");
        if (queueName == null || queueName.trim().equals("")) {
            queueName = LocalCLusterProperties.getInstance().getQueueName(eventType);
            if (queueName == null || queueName.trim().equals("")) {
                response.setSuccess(false);
                response.setMessage("properties  queueName is null");
                return response;
            }
            properties.put("queueName", queueName);
        }
        properties.put("eventType", eventType);
        if (this.httpConfig == null || this.httpConfig.getClientInfo() == null) {
            response.setSuccess(false);
            response.setMessage("\u672a\u5f00\u542f\u4e91\u7aef\u96c6\u6210\u5e73\u53f0\u76f8\u5173\u914d\u7f6e\uff01");
            return response;
        }
        ClientInfoDTO clientInfo = (ClientInfoDTO)JacksonUtil.getInstance().fromJson(this.httpConfig.getClientInfo(), ClientInfoDTO.class);
        if (clientInfo == null || clientInfo.getClientId() == null) {
            response.setSuccess(false);
            response.setMessage("\u672a\u5f00\u542f\u4e91\u7aef\u96c6\u6210\u5e73\u53f0\u76f8\u5173\u914d\u7f6e\uff01");
            return response;
        }
        String janus_userId = clientInfo.getClientId();
        properties.put("janus_userId", janus_userId);
        if (this.service == null) {
            response.setSuccess(false);
            response.setMessage("\u672a\u5f00\u542fsqs\u76f8\u5173\u914d\u7f6e\uff01");
            return response;
        }
        Result result = this.service.sendStrMsg(queueName, message, properties);
        log.debug("queueName:{},result:{} ", (Object)queueName, (Object)JacksonUtil.getInstance().toJson((Object)result));
        response.setSuccess(result.isSuc());
        response.setMessage(result.getMessage());
        return response;
    }
}

