/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.apollo.janus.standalone.sdk.message.janus;

import com.xforceplus.apollo.janus.standalone.sdk.message.AbsGlobalMessageEventWithResultListener;
import com.xforceplus.apollo.janus.standalone.sdk.message.AckTuple;
import com.xforceplus.apollo.janus.standalone.sdk.message.IGlobalMessageEventListener;
import com.xforceplus.apollo.janus.standalone.sdk.message.MessageEventInitListener;
import com.xforceplus.apollo.msg.SealedMessage;
import com.xforceplus.apollo.utils.ErrorUtil;
import com.xforceplus.apollo.utils.JacksonUtil;
import com.xforceplus.janus.framework.event.ISealedMessageEventListener;
import com.xforceplus.janus.framework.event.SealedMessageEvent;
import com.xforceplus.janus.framework.event.SealedMessageEventListener;
import java.util.HashMap;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SealedMessageEventListener(requestName="*")
public class ReceiveAllJanusMessageListener
implements ISealedMessageEventListener {
    private static final Logger log = LoggerFactory.getLogger(ReceiveAllJanusMessageListener.class);

    public com.xforceplus.janus.framework.event.AckTuple<Boolean, String> onEvent(SealedMessageEvent sealedMessageEvent) {
        SealedMessage sealedMessage = sealedMessageEvent.getSealedMessage();
        String requestName = sealedMessage.getHeader().getRequestName();
        log.debug("SealedMessage  : {}", (Object)JacksonUtil.getInstance().toJson((Object)sealedMessage));
        com.xforceplus.janus.framework.event.AckTuple ackTuple = null;
        try {
            Set<IGlobalMessageEventListener> handlers = MessageEventInitListener.findHandler(requestName, "janus");
            if (handlers != null && handlers.size() != 0) {
                if (handlers.size() == 1) {
                    return this.handlerOne(sealedMessage, handlers.iterator().next());
                }
                boolean finalResult = true;
                HashMap<String, com.xforceplus.janus.framework.event.AckTuple<Boolean, String>> map = new HashMap<String, com.xforceplus.janus.framework.event.AckTuple<Boolean, String>>();
                for (IGlobalMessageEventListener handler : handlers) {
                    com.xforceplus.janus.framework.event.AckTuple<Boolean, String> ackTemp = this.handlerOne(sealedMessage, handler);
                    String classFullName = handler.getClass().getName();
                    String shortName = classFullName.substring(classFullName.lastIndexOf(".") + 1, classFullName.length());
                    map.put(shortName, ackTemp);
                    if (((Boolean)ackTemp.status).booleanValue()) continue;
                    finalResult = false;
                }
                return new com.xforceplus.janus.framework.event.AckTuple((Object)finalResult, (Object)JacksonUtil.getInstance().toJson(map));
            }
            log.error("{} NO MessageEventListener\uff01\uff01\uff01", (Object)requestName);
            ackTuple = new com.xforceplus.janus.framework.event.AckTuple((Object)true, (Object)("\u96c6\u6210\u5e73\u53f0\u4e0b\u53d1\u7684\u6d88\u606f\u65e0\u6d88\u606f\u5904\u7406\u5668,requestName:" + requestName));
        }
        catch (Exception e) {
            log.error(ErrorUtil.getStackMsg((Exception)e));
            ackTuple = new com.xforceplus.janus.framework.event.AckTuple((Object)false, (Object)ErrorUtil.getStackMsg((Exception)e));
        }
        catch (Error e) {
            log.error(ErrorUtil.getStackMsg((Throwable)e));
            ackTuple = new com.xforceplus.janus.framework.event.AckTuple((Object)false, (Object)ErrorUtil.getStackMsg((Throwable)e));
        }
        return ackTuple;
    }

    private com.xforceplus.janus.framework.event.AckTuple<Boolean, String> handlerOne(SealedMessage sealedMessage, IGlobalMessageEventListener handler) {
        com.xforceplus.janus.framework.event.AckTuple ackTuple = null;
        String msgId = sealedMessage.getHeader().getMsgId();
        try {
            HashMap<String, String> header = new HashMap<String, String>();
            header.put("msgId", sealedMessage.getHeader().getMsgId());
            header.put("createTime", sealedMessage.getHeader().getCreateTime());
            header.put("userId", sealedMessage.getHeader().getUserId());
            header.put("requestName", sealedMessage.getHeader().getRequestName());
            header.put("payLoadId", sealedMessage.getHeader().getPayLoadId());
            header.putAll(sealedMessage.getHeader().getOthers());
            if (handler instanceof AbsGlobalMessageEventWithResultListener) {
                AbsGlobalMessageEventWithResultListener absMessageListener = (AbsGlobalMessageEventWithResultListener)handler;
                AckTuple ackTuple1 = absMessageListener.onMessageWithResult(msgId, header, String.valueOf(sealedMessage.getPayload().getObj()), "janus");
                ackTuple = new com.xforceplus.janus.framework.event.AckTuple(ackTuple1.getStatus(), ackTuple1.getMessage());
            } else {
                boolean flag = handler.onMessage(msgId, header, String.valueOf(sealedMessage.getPayload().getObj()), "janus");
                String message = flag ? "\u5904\u7406\u6210\u529f" : "\u5904\u7406\u5931\u8d25";
                ackTuple = new com.xforceplus.janus.framework.event.AckTuple((Object)flag, (Object)message);
            }
        }
        catch (Exception ex) {
            log.error("msgId:{}\u5904\u7406\u5f02\u5e38,{}", (Object)msgId, (Object)ErrorUtil.getStackMsg((Exception)ex));
            ackTuple = new com.xforceplus.janus.framework.event.AckTuple((Object)false, (Object)ErrorUtil.getStackMsg((Exception)ex));
        }
        catch (Error ex) {
            log.error("msgId:{}\u5904\u7406\u5f02\u5e38,{}", (Object)msgId, (Object)ErrorUtil.getStackMsg((Throwable)ex));
            ackTuple = new com.xforceplus.janus.framework.event.AckTuple((Object)false, (Object)ErrorUtil.getStackMsg((Throwable)ex));
        }
        if (null == ackTuple) {
            log.error("{} \u7f3a\u5931\u6709\u6548\u56de\u6267\uff0c\u8bf7\u8865\u5145\u56de\u6267\u5185\u5bb9\uff01\uff01\uff01", (Object)msgId);
            ackTuple = new com.xforceplus.janus.framework.event.AckTuple((Object)false, (Object)"\u7f3a\u5931\u6709\u6548\u56de\u6267\uff0c\u8bf7\u8865\u5145\u56de\u6267\u5185\u5bb9");
        }
        return ackTuple;
    }
}

