/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.apollo.janus.standalone.sdk.message.messageBus;

import com.xforceplus.apollo.janus.standalone.sdk.message.messageBus.core.AbsMbRequest;
import com.xforceplus.apollo.janus.standalone.sdk.message.messageBus.core.HttpResp;
import com.xforceplus.apollo.janus.standalone.sdk.message.messageBus.request.AddSubRuleRequest;
import com.xforceplus.apollo.janus.standalone.sdk.message.messageBus.request.DeleteSubRuleRequest;
import com.xforceplus.apollo.janus.standalone.sdk.message.messageBus.request.ListSubRuleRequest;
import com.xforceplus.apollo.janus.standalone.sdk.message.messageBus.response.AddSubRuleResponse;
import com.xforceplus.apollo.janus.standalone.sdk.message.messageBus.response.DeleteSubRuleResponse;
import com.xforceplus.apollo.janus.standalone.sdk.message.messageBus.response.ListSubRuleResponse;
import com.xforceplus.apollo.janus.standalone.sdk.message.messageBus.utils.HttpUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class MBAdminClient {
    private String url;

    private MBAdminClient() {
    }

    public static MBAdminClient getInstance(String url) {
        MBAdminClient mbClient = SingletonClassInstance.instance;
        if (Objects.isNull(mbClient.getUrl()) || "".equals(mbClient.getUrl())) {
            mbClient.setUrl(url);
        }
        return mbClient;
    }

    public ListSubRuleResponse listSubRule(ListSubRuleRequest request) {
        return ListSubRuleResponse.transform(this.exec(request));
    }

    public AddSubRuleResponse addSubRule(AddSubRuleRequest request) {
        return AddSubRuleResponse.transform(this.exec(request));
    }

    public DeleteSubRuleResponse deleteSubRule(DeleteSubRuleRequest request) {
        return DeleteSubRuleResponse.transform(this.exec(request));
    }

    public HttpResp exec(AbsMbRequest request) {
        String url = this.getUrl() + request.getRequestPath();
        Map<String, String> headers = request.getHeaders();
        if (headers == null) {
            headers = new HashMap<String, String>();
        }
        headers.put("content-type", "application/json");
        headers.put("CLIENT_VERSION", "1.0.6.21");
        if ("get".equals(request.httpMethod())) {
            return HttpUtils.getRequest(url, headers, request.getParam());
        }
        if ("post".equals(request.httpMethod())) {
            return HttpUtils.postRequest(url, headers, request.getParamJson());
        }
        if ("put".equals(request.httpMethod())) {
            return HttpUtils.putRequest(url, headers, request.getParamJson());
        }
        return null;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    private static class SingletonClassInstance {
        private static final MBAdminClient instance = new MBAdminClient();

        private SingletonClassInstance() {
        }
    }
}

