/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.apollo.janus.standalone.sdk.message.messageBus;

import com.alibaba.fastjson.JSONObject;
import com.xforceplus.apollo.janus.standalone.sdk.config.LocalCLusterProperties;
import com.xforceplus.apollo.janus.standalone.sdk.enums.MessageSourceEnum;
import com.xforceplus.apollo.janus.standalone.sdk.message.AbsGlobalMessageEventWithResultListener;
import com.xforceplus.apollo.janus.standalone.sdk.message.AckTuple;
import com.xforceplus.apollo.janus.standalone.sdk.message.IGlobalMessageEventListener;
import com.xforceplus.apollo.janus.standalone.sdk.message.MessageEventInitListener;
import com.xforceplus.apollo.janus.standalone.sdk.message.messageBus.MBAdminClient;
import com.xforceplus.apollo.janus.standalone.sdk.message.messageBus.MBClient;
import com.xforceplus.apollo.janus.standalone.sdk.message.messageBus.ResponseMessage;
import com.xforceplus.apollo.janus.standalone.sdk.message.messageBus.request.AckRequest;
import com.xforceplus.apollo.janus.standalone.sdk.message.messageBus.response.AckResponse;
import com.xforceplus.apollo.janus.standalone.sdk.message.messageBus.response.SubResponse;
import com.xforceplus.apollo.utils.ErrorUtil;
import com.xforceplus.apollo.utils.JacksonUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.env.Environment;

public class MessageBusInit
implements InitializingBean,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(MessageBusInit.class);
    private MBClient mbClient;
    private MBAdminClient mBAdminClient;
    private Environment environment;
    private int messageBusListenerSize;
    private MessageEventInitListener messageEventInitListener;
    private volatile boolean canRun = true;

    public MessageBusInit(Environment environment, MessageEventInitListener messageEventInitListener) {
        try {
            this.messageEventInitListener = messageEventInitListener;
            ConcurrentHashMap<String, Set<IGlobalMessageEventListener>> handler_map = MessageEventInitListener.EVENT_HANDLERS.get(MessageSourceEnum.MESSAGE_BUS.getCode());
            this.messageBusListenerSize = handler_map == null ? 0 : handler_map.size();
            this.environment = environment;
            String url = environment.getProperty("message-bus.url");
            String token = environment.getProperty("message-bus.token");
            if (StringUtils.isBlank((CharSequence)url) || StringUtils.isBlank((CharSequence)token)) {
                throw new IllegalArgumentException("message-bus.url ,message-bus.token \u4e3a\u7a7a ");
            }
            this.mbClient = MBClient.getInstance(url, token);
            log.info("MessageBusInit created");
        }
        catch (Exception e) {
            log.error("MessageBusInit error :{} ", (Object)ErrorUtil.getStackMsg((Exception)e));
            this.mbClient = null;
            this.mBAdminClient = null;
        }
    }

    public boolean pullMessage() {
        try {
            SubResponse sub = this.mbClient.sub();
            log.debug("\u62c9\u53d6\u7684\u6d88\u606f\u5185\u5bb9:[{}]", (Object)JSONObject.toJSONString((Object)sub));
            List<ResponseMessage> responseMessages = sub.getResponseMessages();
            log.info("\u62c9\u53d6\u7684\u6d88\u606f\u4e2a\u6570:[{}]", (Object)(responseMessages == null ? 0 : responseMessages.size()));
            if (CollectionUtils.isEmpty(responseMessages)) {
                return false;
            }
            ArrayList<String> acks = new ArrayList<String>();
            responseMessages.forEach(responseMessage -> {
                String pubAppKey = responseMessage.getPubAppKey();
                String pubCode = responseMessage.getPubCode();
                String tenantId = responseMessage.getProperties().get("tenantId");
                log.debug("pubAppKey:[{}],pubCode:[{}],tenantId:[{}]", new Object[]{pubAppKey, pubCode, tenantId});
                String msgId = responseMessage.getId() + "";
                com.xforceplus.janus.framework.event.AckTuple ackTuple = null;
                try {
                    Set<IGlobalMessageEventListener> handlers = MessageEventInitListener.findHandler(pubCode, "messageBus");
                    if (handlers == null || handlers.size() == 0) {
                        ackTuple = new com.xforceplus.janus.framework.event.AckTuple((Object)true, (Object)("\u6d88\u606f\u603b\u7ebf\u4e0b\u53d1\u7684\u6d88\u606f\u65e0\u6d88\u606f\u5904\u7406\u5668,pubCode:" + pubCode));
                    } else if (handlers.size() == 1) {
                        ackTuple = this.handlerOne((ResponseMessage)responseMessage, handlers.iterator().next());
                    } else {
                        boolean finalResult = true;
                        HashMap<String, com.xforceplus.janus.framework.event.AckTuple<Boolean, String>> map = new HashMap<String, com.xforceplus.janus.framework.event.AckTuple<Boolean, String>>();
                        for (IGlobalMessageEventListener handler : handlers) {
                            com.xforceplus.janus.framework.event.AckTuple<Boolean, String> ackTemp = this.handlerOne((ResponseMessage)responseMessage, handler);
                            String classFullName = handler.getClass().getName();
                            String shortName = classFullName.substring(classFullName.lastIndexOf(".") + 1, classFullName.length());
                            map.put(shortName, ackTemp);
                            if (((Boolean)ackTemp.status).booleanValue()) continue;
                            finalResult = false;
                        }
                        log.info(JacksonUtil.getInstance().toJson(map));
                        ackTuple = new com.xforceplus.janus.framework.event.AckTuple((Object)finalResult, (Object)JacksonUtil.getInstance().toJson(map));
                    }
                }
                catch (Exception e) {
                    log.error("msgId:{}\u5904\u7406\u5f02\u5e38,{}", (Object)msgId, (Object)ErrorUtil.getStackMsg((Exception)e));
                    ackTuple = new com.xforceplus.janus.framework.event.AckTuple((Object)false, (Object)ErrorUtil.getStackMsg((Exception)e));
                }
                catch (Error ex) {
                    log.error("msgId:{}\u5904\u7406\u5f02\u5e38,{}", (Object)msgId, (Object)ErrorUtil.getStackMsg((Throwable)ex));
                    ackTuple = new com.xforceplus.janus.framework.event.AckTuple((Object)false, (Object)ErrorUtil.getStackMsg((Throwable)ex));
                }
                if (null == ackTuple) {
                    log.error("{} \u7f3a\u5931\u6709\u6548\u56de\u6267\uff0c\u8bf7\u8865\u5145\u56de\u6267\u5185\u5bb9\uff01\uff01\uff01", (Object)msgId);
                    ackTuple = new com.xforceplus.janus.framework.event.AckTuple((Object)false, (Object)"\u7f3a\u5931\u6709\u6548\u56de\u6267\uff0c\u8bf7\u8865\u5145\u56de\u6267\u5185\u5bb9");
                }
                if (((Boolean)ackTuple.status).booleanValue()) {
                    acks.add(responseMessage.getReceiptHandle());
                }
            });
            if (CollectionUtils.isNotEmpty(acks)) {
                AckRequest ackRequest = new AckRequest(acks);
                AckResponse ack = this.mbClient.ack(ackRequest);
                log.debug("\u6d88\u606f\u56de\u6267\u53cd\u9988:[{}]", (Object)JSONObject.toJSONString((Object)ack));
            }
            return true;
        }
        catch (Exception e) {
            log.error(ErrorUtil.getStackMsg((Exception)e));
        }
        catch (Error e) {
            log.error(ErrorUtil.getStackMsg((Throwable)e));
        }
        return false;
    }

    private com.xforceplus.janus.framework.event.AckTuple<Boolean, String> handlerOne(ResponseMessage responseMessage, IGlobalMessageEventListener handler) {
        com.xforceplus.janus.framework.event.AckTuple ackTuple = null;
        String pubAppKey = responseMessage.getPubAppKey();
        String pubCode = responseMessage.getPubCode();
        String msgId = responseMessage.getId() + "";
        try {
            HashMap<String, Object> header = new HashMap<String, Object>();
            header.putAll(responseMessage.getProperties());
            header.put("pubAppKey", pubAppKey);
            header.put("pubCode", pubCode);
            header.put("thirdPartyId", responseMessage.getThirdPartyId());
            header.put("consumeTimes", responseMessage.getConsumeTimes());
            header.put("receivedTime", responseMessage.getReceivedTime());
            if (header.get("msgId") == null) {
                header.put("msgId", responseMessage.getId());
            }
            if (header.get("createTime") == null) {
                header.put("createTime", responseMessage.getReceivedTime());
            }
            if (header.get("userId") == null) {
                header.put("userId", pubAppKey);
            }
            if (header.get("requestName") == null) {
                header.put("requestName", pubCode);
            }
            if (header.get("payLoadId") == null) {
                header.put("payLoadId", responseMessage.getId());
            }
            if (handler instanceof AbsGlobalMessageEventWithResultListener) {
                AbsGlobalMessageEventWithResultListener absMessageListener = (AbsGlobalMessageEventWithResultListener)handler;
                AckTuple ackTuple1 = absMessageListener.onMessageWithResult(msgId, header, responseMessage.getContent(), "messageBus");
                ackTuple = new com.xforceplus.janus.framework.event.AckTuple(ackTuple1.getStatus(), ackTuple1.getMessage());
            } else {
                boolean flag = handler.onMessage(msgId, header, responseMessage.getContent(), "messageBus");
                String message = flag ? "\u5904\u7406\u6210\u529f" : "\u5904\u7406\u5931\u8d25";
                ackTuple = new com.xforceplus.janus.framework.event.AckTuple((Object)flag, (Object)message);
            }
        }
        catch (Exception ex) {
            log.error("msgId:{}\u5904\u7406\u5f02\u5e38,{}", (Object)msgId, (Object)ErrorUtil.getStackMsg((Exception)ex));
            ackTuple = new com.xforceplus.janus.framework.event.AckTuple((Object)false, (Object)ErrorUtil.getStackMsg((Exception)ex));
        }
        catch (Error ex) {
            log.error("msgId:{}\u5904\u7406\u5f02\u5e38,{}", (Object)msgId, (Object)ErrorUtil.getStackMsg((Throwable)ex));
            ackTuple = new com.xforceplus.janus.framework.event.AckTuple((Object)false, (Object)ErrorUtil.getStackMsg((Throwable)ex));
        }
        return ackTuple;
    }

    public void afterPropertiesSet() throws Exception {
        new Thread(() -> {
            while (this.canRun && this.mbClient != null) {
                ConcurrentHashMap<String, Set<IGlobalMessageEventListener>> handler_map = MessageEventInitListener.EVENT_HANDLERS.get(MessageSourceEnum.MESSAGE_BUS.getCode());
                int n = this.messageBusListenerSize = handler_map == null ? 0 : handler_map.size();
                if (this.messageBusListenerSize != 0 && this.pullMessage()) continue;
                try {
                    TimeUnit.MILLISECONDS.sleep(LocalCLusterProperties.getInstance().getFetchMessageInterval());
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }, "PullMessageFromMessageBus").start();
    }

    public void destroy() throws Exception {
        this.canRun = false;
    }
}

