/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.apollo.janus.standalone.sdk.message.sqs;

import com.xforceplus.apollo.janus.standalone.sdk.message.AbsGlobalMessageEventWithResultListener;
import com.xforceplus.apollo.janus.standalone.sdk.message.AckTuple;
import com.xforceplus.apollo.janus.standalone.sdk.message.IGlobalMessageEventListener;
import com.xforceplus.apollo.janus.standalone.sdk.message.MessageEventInitListener;
import com.xforceplus.apollo.janus.standalone.sdk.message.sqs.BaseSQSListener;
import com.xforceplus.apollo.utils.ErrorUtil;
import com.xforceplus.apollo.utils.JacksonUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSQSListener
extends BaseSQSListener {
    private static final Logger log = LoggerFactory.getLogger(DefaultSQSListener.class);
    private String queueName;

    public DefaultSQSListener(String queueName) {
        this.queueName = queueName;
    }

    @Override
    public boolean onMessage(String messageId, Map headers, String messageBody) {
        com.xforceplus.janus.framework.event.AckTuple ackTuple = null;
        try {
            log.debug("messageId {},  headers {},  messageBody {}", new Object[]{messageId, JacksonUtil.getInstance().toJson((Object)headers), messageBody});
            if (headers == null) {
                log.warn("properties is null ,messageId {},  headers {},  messageBody {}", new Object[]{messageId, JacksonUtil.getInstance().toJson((Object)headers), messageBody});
                return true;
            }
            if (headers.get("eventType") == null) {
                log.warn("properties  eventType is null ,messageId {} ,headers {},  messageBody {}", new Object[]{messageId, JacksonUtil.getInstance().toJson((Object)headers), messageBody});
                return true;
            }
            String eventType = (String)headers.get("eventType");
            if (StringUtils.isBlank((CharSequence)(eventType = eventType.trim()))) {
                log.warn("properties  eventType is null ,messageId {},headers {},  messageBody {}", new Object[]{messageId, JacksonUtil.getInstance().toJson((Object)headers), messageBody});
                return true;
            }
            boolean needReceiveHandle = MessageEventInitListener.needReceiveHandle(this.queueName, eventType, "sqs");
            if (!needReceiveHandle) {
                log.warn("queueName[{}]  eventType[{}] no need to be handle,messageId {},headers {},  messageBody {}", new Object[]{this.queueName, eventType, messageId, JacksonUtil.getInstance().toJson((Object)headers), messageBody});
                return true;
            }
            Set<IGlobalMessageEventListener> handlers = MessageEventInitListener.findHandler(eventType, "sqs");
            if (handlers == null || handlers.size() == 0) {
                log.warn("no IGlobalMessageEventListener handler  ,messageId {},eventType {},  headers {},  messageBody {}", new Object[]{messageId, eventType, JacksonUtil.getInstance().toJson((Object)headers), messageBody});
                return true;
            }
            if (handlers.size() == 1) {
                return (Boolean)this.handlerOne((String)messageId, (Map)headers, (String)messageBody, (IGlobalMessageEventListener)handlers.iterator().next()).status;
            }
            boolean finalResult = true;
            HashMap<String, com.xforceplus.janus.framework.event.AckTuple<Boolean, String>> map = new HashMap<String, com.xforceplus.janus.framework.event.AckTuple<Boolean, String>>();
            for (IGlobalMessageEventListener handler : handlers) {
                com.xforceplus.janus.framework.event.AckTuple<Boolean, String> ackTemp = this.handlerOne(messageId, headers, messageBody, handler);
                String classFullName = handler.getClass().getName();
                String shortName = classFullName.substring(classFullName.lastIndexOf(".") + 1, classFullName.length());
                map.put(shortName, ackTemp);
                if (((Boolean)ackTemp.status).booleanValue()) continue;
                finalResult = false;
            }
            log.info(JacksonUtil.getInstance().toJson(map));
            return finalResult;
        }
        catch (Exception e) {
            log.error(" {} {}", (Object)messageId, (Object)ErrorUtil.getStackMsg((Exception)e));
            ackTuple = new com.xforceplus.janus.framework.event.AckTuple((Object)false, (Object)ErrorUtil.getStackMsg((Exception)e));
        }
        catch (Error error) {
            log.error(" {} {}", (Object)messageId, (Object)ErrorUtil.getStackMsg((Throwable)error));
            ackTuple = new com.xforceplus.janus.framework.event.AckTuple((Object)false, (Object)ErrorUtil.getStackMsg((Throwable)error));
        }
        return (Boolean)ackTuple.getStatus();
    }

    private com.xforceplus.janus.framework.event.AckTuple<Boolean, String> handlerOne(String messageId, Map h, String messageBody, IGlobalMessageEventListener handler) {
        com.xforceplus.janus.framework.event.AckTuple ackTuple = null;
        try {
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.putAll(h);
            headers.put("sourceSqsQueue", this.queueName);
            if (handler instanceof AbsGlobalMessageEventWithResultListener) {
                AbsGlobalMessageEventWithResultListener absMessageListener = (AbsGlobalMessageEventWithResultListener)handler;
                AckTuple ackTuple1 = absMessageListener.onMessageWithResult(messageId, headers, messageBody, "sqs");
                ackTuple = new com.xforceplus.janus.framework.event.AckTuple(ackTuple1.getStatus(), ackTuple1.getMessage());
            } else {
                boolean flag = handler.onMessage(messageId, headers, messageBody, "sqs");
                String message = flag ? "\u5904\u7406\u6210\u529f" : "\u5904\u7406\u5931\u8d25";
                ackTuple = new com.xforceplus.janus.framework.event.AckTuple((Object)flag, (Object)message);
            }
        }
        catch (Exception ex) {
            log.error("msgId:{}\u5904\u7406\u5f02\u5e38,{}", (Object)messageId, (Object)ErrorUtil.getStackMsg((Exception)ex));
            ackTuple = new com.xforceplus.janus.framework.event.AckTuple((Object)false, (Object)ErrorUtil.getStackMsg((Exception)ex));
        }
        catch (Error error) {
            log.error("msgId:{}\u5904\u7406\u5f02\u5e38,{}", (Object)messageId, (Object)ErrorUtil.getStackMsg((Throwable)error));
            ackTuple = new com.xforceplus.janus.framework.event.AckTuple((Object)false, (Object)ErrorUtil.getStackMsg((Throwable)error));
        }
        if (null == ackTuple) {
            log.error("{} \u7f3a\u5931\u6709\u6548\u56de\u6267\uff0c\u8bf7\u8865\u5145\u56de\u6267\u5185\u5bb9\uff01\uff01\uff01", (Object)messageId);
            ackTuple = new com.xforceplus.janus.framework.event.AckTuple((Object)false, (Object)"\u7f3a\u5931\u6709\u6548\u56de\u6267\uff0c\u8bf7\u8865\u5145\u56de\u6267\u5185\u5bb9");
        }
        return ackTuple;
    }
}

