/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.apollo.janus.standalone.sdk.message.standaloneJanus;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.xforceplus.apollo.janus.standalone.sdk.config.LocalCLusterProperties;
import com.xforceplus.apollo.janus.standalone.sdk.message.standaloneJanus.StandaloneJanusService;
import com.xforceplus.apollo.janus.standalone.sdk.utils.DateUtils;
import com.xforceplus.apollo.janus.standalone.sdk.utils.FileCmdCache;
import com.xforceplus.apollo.janus.standalone.sdk.utils.HttpUtils;
import com.xforceplus.apollo.janus.standalone.sdk.utils.IPUtils;
import com.xforceplus.apollo.janus.standalone.sdk.utils.ThreadPoolCmdUtils;
import com.xforceplus.apollo.utils.ErrorUtil;
import com.xforceplus.apollo.utils.JacksonUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.wicp.tams.common.apiext.StringUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogQueryCmdThread
extends Thread {
    private static final Logger log = LoggerFactory.getLogger(LogQueryCmdThread.class);
    private static final int cmd_response_max = 100000;
    private static final int cmd_response_max_line = 100;
    private final String sub = "message/sub";
    private String logStorePath;
    private String standalonePath = "";
    private String clientFlags = "";
    private static final String log_folder = "/logs";
    private volatile Map<String, List<String>> fileMap = new HashMap<String, List<String>>();
    private volatile List<String> address = new LinkedList<String>();
    private StandaloneJanusService standaloneJanusService;
    private volatile boolean canRun = true;

    public void setCanRun(boolean flag) {
        this.canRun = flag;
    }

    public LogQueryCmdThread(StandaloneJanusService standaloneJanusService) {
        this.standaloneJanusService = standaloneJanusService;
        this.init();
    }

    private void init() {
        LocalCLusterProperties localCLusterProperties = LocalCLusterProperties.getInstance();
        String logPath = localCLusterProperties.getLogStorePath();
        if (logPath == null) {
            logPath = "";
        } else if (!(logPath = logPath.trim()).startsWith("/")) {
            logPath = "/" + logPath;
        }
        this.logStorePath = logPath;
        String standalonePathTemp = localCLusterProperties.getStandalonePath();
        if (StringUtil.isNotNull((Object)standalonePathTemp)) {
            String clientFlagsTemp = LogQueryCmdThread.subWords(standalonePathTemp, 3);
            this.clientFlags = clientFlagsTemp.replaceFirst("/", "");
            this.standalonePath = standalonePathTemp.replace(this.clientFlags, "");
        }
    }

    public static String subWords(String path, int index) {
        if (StringUtils.isBlank((CharSequence)path) || index < 1) {
            return "";
        }
        int start = path.indexOf("/") == -1 ? 0 : path.indexOf("/");
        int end = path.indexOf("/", start + 1);
        for (int i = 1; i < index; ++i) {
            start = end;
            end = path.indexOf("/", start + 1) == -1 ? path.length() : path.indexOf("/", start + 1);
        }
        return path.substring(start, end);
    }

    @Override
    public void run() {
        int count = 0;
        while (this.canRun) {
            try {
                if (count > 30) {
                    this.scanLogFiles();
                    count = 0;
                }
                this.queryLogCmd();
            }
            finally {
                ++count;
                try {
                    TimeUnit.SECONDS.sleep(1L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void queryLogCmd() {
        try {
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("content-type", "application/json");
            headers.put("clientFlags", this.clientFlags);
            headers.put("logQueryCmd", "true");
            headers.put("Accept", "application/json");
            String requestUrl = this.standalonePath + "message/sub";
            String response = HttpUtils.getRequest(requestUrl, headers, null);
            this.handleResponse(response);
        }
        catch (Exception e) {
            log.error(ErrorUtil.getStackMsg((Exception)e));
        }
    }

    private boolean handleResponse(String response) {
        String ipAddress = this.address == null || this.address.size() == 0 ? "" : String.join((CharSequence)",", this.address);
        JSONObject responseObject = JSON.parseObject((String)response);
        String code = responseObject.getString("code");
        if (StringUtil.isNotNull((Object)code) && code.equals("200") && responseObject.get((Object)"result") != null) {
            boolean fileListNotLoaded;
            JSONObject jsonObject = responseObject.getJSONObject("result");
            if (jsonObject == null || jsonObject.size() == 0) {
                return false;
            }
            String content = jsonObject.getString("content");
            JSONObject properties = jsonObject.getJSONObject("properties");
            if (properties == null || properties.size() == 0) {
                return false;
            }
            String hasTaskCmd = properties.getString("hasTaskCmd");
            if (hasTaskCmd == null || "".equals(hasTaskCmd.trim()) || "false".equals(hasTaskCmd.trim())) {
                return false;
            }
            JSONObject contentObject = JSON.parseObject((String)content);
            String startTime = contentObject.getString("startTime");
            int index = 0;
            int limit = 100000;
            String logFileName = "";
            String keyWords = contentObject.getString("keyWords");
            String uuid = contentObject.getString("uuid");
            String sourceType = contentObject.getString("sourceType");
            String cmdSerialKey = contentObject.getString("cmdSerialKey");
            String startDay = startTime.substring(0, 10);
            String today = DateUtils.format(new Date(), "yyyy-MM-dd");
            boolean isToday = today.equals(startDay);
            List<String> files1 = this.fileMap.get(startDay);
            List<String> files2 = this.fileMap.get("nodateTime");
            HashMap<String, String> properties1 = new HashMap<String, String>();
            properties1.put("uuid", uuid);
            properties1.put("sourceType", sourceType);
            properties1.put("cmdSerialKey", cmdSerialKey);
            properties1.put("ipAddress", ipAddress);
            properties1.put("businessNo", "logQueryCmd_" + System.currentTimeMillis());
            boolean bl = fileListNotLoaded = CollectionUtils.isEmpty(files1) && CollectionUtils.isEmpty(files2);
            if (fileListNotLoaded) {
                String errorMsg = "\u672a\u8bfb\u53d6\u5230\u65e5\u5fd7\u6587\u4ef6";
                this.sendError(errorMsg, properties1);
                return true;
            }
            if (isToday ? this.noUseIndex(properties1, index, limit, startTime, keyWords, files1, files2) : this.userIndex(properties1, index, limit, startTime, logFileName, keyWords, files1, files2)) {
                return true;
            }
            String errorMsg = "\u6ca1\u6709\u67e5\u8be2\u5230\u65e5\u5fd7";
            this.sendError(errorMsg, properties1);
            return true;
        }
        return false;
    }

    private boolean noUseIndex(Map<String, String> properties, int index, int limit, String startTime, String keyWords, List<String> files1, List<String> files2) {
        String fileName;
        Object cmd;
        Map<String, String> resultMap;
        if (CollectionUtils.isNotEmpty(files2) && (resultMap = this.doCmd((String)(cmd = this.getCmd(startTime, keyWords, fileName = files2.get(0))), fileName, false, 0, 100000)) != null && "true".equals(resultMap.get("readStatus"))) {
            log.info("send1Succ {}", (Object)fileName);
            this.sendSucc(resultMap, properties);
            return true;
        }
        ArrayList<FutureTask<Map>> tasks = new ArrayList<FutureTask<Map>>();
        if (CollectionUtils.isNotEmpty(files1)) {
            for (String fileName2 : files1) {
                Map<String, String> resultMap2;
                String string = this.getCmd(startTime, keyWords, fileName2);
                Integer size = (Integer)FileCmdCache.get(string);
                if (size == null) {
                    int finalLimit = limit;
                    Callable<Map> callable = () -> this.doCmd(cmd2, fileName2, true, 0, finalLimit);
                    FutureTask<Map> task = new FutureTask<Map>(callable);
                    tasks.add(task);
                    continue;
                }
                if (size == 0 || size <= index || (resultMap2 = this.doCmd(string, fileName2, true, index, limit)) == null || !"true".equals(resultMap2.get("readStatus"))) continue;
                log.info("send1Succ {}", (Object)fileName2);
                this.sendSucc(resultMap2, properties);
                return true;
            }
        }
        HashMap resultMap3 = new HashMap();
        if (CollectionUtils.isNotEmpty(tasks)) {
            Map cmdResultMap;
            for (FutureTask futureTask : tasks) {
                ThreadPoolCmdUtils.execute(futureTask);
            }
            for (FutureTask futureTask : tasks) {
                try {
                    cmdResultMap = (Map)futureTask.get();
                    if (!"true".equals(cmdResultMap.get("readStatus"))) continue;
                    resultMap3.put(cmdResultMap.get("logFileName"), cmdResultMap);
                }
                catch (InterruptedException e) {
                    log.error("InterruptedException[{}]", (Throwable)e);
                }
                catch (ExecutionException e) {
                    log.error("ExecutionException[{}]", (Throwable)e);
                }
                catch (Exception e) {
                    log.error("exception[{}]", (Throwable)e);
                }
            }
            if (CollectionUtils.isNotEmpty(files1)) {
                for (String string : files1) {
                    cmdResultMap = (Map)resultMap3.get(string);
                    if (cmdResultMap == null || !"true".equals(cmdResultMap.get("readStatus"))) continue;
                    log.info("send1Succ {}", (Object)string);
                    this.sendSucc(cmdResultMap, properties);
                    return true;
                }
            }
        }
        return false;
    }

    private boolean userIndex(Map<String, String> properties, int index, int limit, String startTime, String logFileName, String keyWords, List<String> files1, List<String> files2) {
        Map cmdResultMap;
        ArrayList<FutureTask<Map>> tasks = new ArrayList<FutureTask<Map>>();
        if (CollectionUtils.isNotEmpty(files1)) {
            for (String iterator : files1) {
                Map<String, String> resultMap;
                log.info("fileName.compareTo(logFileName) {} :{} ,{}", new Object[]{iterator.compareTo(logFileName), iterator, logFileName});
                if (iterator.compareTo(logFileName) < 0) continue;
                String string = this.getCmd(startTime, keyWords, iterator);
                Integer size = (Integer)FileCmdCache.get(string);
                log.info("fileName.compareTo(logFileName) {} :{} ,{}", new Object[]{iterator.compareTo(logFileName), iterator, logFileName});
                if (size == null) {
                    int finalLimit = limit;
                    Callable<Map> callable = () -> this.doCmd(cmd, fileName, true, 0, finalLimit);
                    FutureTask<Map> task = new FutureTask<Map>(callable);
                    tasks.add(task);
                    continue;
                }
                if (iterator.compareTo(logFileName) > 0) {
                    Map<String, String> resultMap2 = this.doCmd(string, iterator, true, 0, limit);
                    if (resultMap2 == null || !"true".equals(resultMap2.get("readStatus"))) continue;
                    log.info("send1Succ {}", (Object)iterator);
                    this.sendSucc(resultMap2, properties);
                    return true;
                }
                if (size <= index || (resultMap = this.doCmd(string, iterator, true, index, limit)) == null || !"true".equals(resultMap.get("readStatus"))) continue;
                log.info("send1Succ {}", (Object)iterator);
                this.sendSucc(resultMap, properties);
                return true;
            }
        }
        if (CollectionUtils.isNotEmpty(files2)) {
            String fileName = files2.get(0);
            String string = this.getCmd(startTime, keyWords, fileName);
            int n = limit;
            Callable<Map> callable = () -> this.doCmd(cmd, fileName, false, 0, finalLimit);
            FutureTask<Map> task = new FutureTask<Map>(callable);
            tasks.add(task);
        }
        if (CollectionUtils.isNotEmpty(tasks)) {
            for (FutureTask futureTask : tasks) {
                ThreadPoolCmdUtils.execute(futureTask);
            }
        }
        HashMap resultMap = new HashMap();
        for (FutureTask futureTask : tasks) {
            try {
                cmdResultMap = (Map)futureTask.get();
                if (!"true".equals(cmdResultMap.get("readStatus"))) continue;
                resultMap.put(cmdResultMap.get("logFileName"), cmdResultMap);
            }
            catch (InterruptedException e) {
                log.error("InterruptedException[{}]", (Throwable)e);
            }
            catch (ExecutionException e) {
                log.error("ExecutionException[{}]", (Throwable)e);
            }
            catch (Exception e) {
                log.error("exception[{}]", (Throwable)e);
            }
        }
        if (CollectionUtils.isNotEmpty(files1)) {
            Iterator<String> iterator = files1.iterator();
            while (iterator.hasNext()) {
                String string;
                cmdResultMap = (Map)resultMap.get(string = iterator.next());
                log.info("fileName: {} ,{} ", (Object)string, (Object)(cmdResultMap != null && "true".equals(cmdResultMap.get("readStatus")) ? 1 : 0));
                if (cmdResultMap == null || !"true".equals(cmdResultMap.get("readStatus"))) continue;
                log.info("send1Succ {}", (Object)string);
                this.sendSucc(cmdResultMap, properties);
                return true;
            }
        }
        if (CollectionUtils.isNotEmpty(files2)) {
            for (String string : files2) {
                cmdResultMap = (Map)resultMap.get(string);
                if (cmdResultMap == null || !"true".equals(cmdResultMap.get("readStatus"))) continue;
                log.info("send1Succ {}", (Object)string);
                this.sendSucc(cmdResultMap, properties);
                return true;
            }
        }
        return false;
    }

    private void sendError(String errorMsg, Map<String, String> properties) {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("readStatus", "false");
        result.put("readResult", errorMsg);
        result.put("readInx", "0");
        result.put("totalLength", "0");
        result.put("logFileName", "");
        result.put("uuid", properties.get("uuid"));
        result.put("ipAddress", properties.get("ipAddress"));
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("code", "0");
        resultMap.put("message", "FAILED");
        resultMap.put("executeSysCmd", "executeSysCmd");
        resultMap.put("result", result);
        String message = JacksonUtil.getInstance().toJson(resultMap);
        this.standaloneJanusService.sendStrMsg("logQueryCmd", message, properties);
    }

    private void sendSucc(Map<String, String> result, Map<String, String> properties) {
        result.put("uuid", properties.get("uuid"));
        result.put("ipAddress", properties.get("ipAddress"));
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("code", "1");
        resultMap.put("message", "FINISHED");
        resultMap.put("executeSysCmd", "executeSysCmd");
        resultMap.put("result", result);
        String message = JacksonUtil.getInstance().toJson(resultMap);
        this.standaloneJanusService.sendStrMsg("logQueryCmd", message, properties);
    }

    private String getCmd(String startTime, String keyWords, String fileName) {
        StringBuilder sb = new StringBuilder();
        if (fileName.endsWith(".gz")) {
            sb.append("zcat ").append(fileName).append(" | grep  '").append(startTime).append("' ");
            this.buildKeyWords(keyWords, sb);
        } else {
            sb.append("cat ").append(fileName).append(" | grep  '").append(startTime).append("' ");
            this.buildKeyWords(keyWords, sb);
        }
        sb.append("  | grep  -v 'executeSysCmd' ");
        return sb.toString();
    }

    private void buildKeyWords(String keyWords, StringBuilder sb) {
        if (keyWords.contains(",")) {
            String[] splits;
            for (String split : splits = keyWords.split(",")) {
                if (!StringUtils.isNotBlank((CharSequence)split)) continue;
                sb.append(" | grep  '").append(split.trim()).append("' ");
            }
        } else {
            sb.append(" | grep  '").append(keyWords.trim()).append("' ");
        }
    }

    /*
     * Exception decompiling
     */
    private Map<String, String> doCmd(String cmd, String fileName, boolean cache, int index, int limit) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void scanLogFiles() {
        try {
            this.address = IPUtils.getIpAddress();
            String taskId = System.currentTimeMillis() + "";
            String listFilesSmd = "ls " + this.deployJarDir() + log_folder;
            if (this.logStorePath != null && !"".equals(this.logStorePath)) {
                listFilesSmd = "ls " + this.logStorePath;
            }
            String result = this.doCmd(listFilesSmd);
            HashMap<String, List<String>> fileMapTemp = new HashMap<String, List<String>>();
            if (StringUtils.isNotBlank((CharSequence)result)) {
                String[] lines;
                for (String fileName : lines = result.split("\\r?\\n")) {
                    if (!StringUtils.isNotBlank((CharSequence)fileName)) continue;
                    fileName = fileName.replace("\r", "").trim();
                    Map<String, String> map = LogQueryCmdThread.findDateTime(fileName);
                    String dateTime = map.get("dateTime");
                    this.putfile(fileMapTemp, fileName, dateTime);
                }
            }
            if (fileMapTemp.size() > 0) {
                for (Map.Entry entry : fileMapTemp.entrySet()) {
                    List files = (List)entry.getValue();
                    String date = (String)entry.getKey();
                    Collections.sort(files, String::compareTo);
                    fileMapTemp.put(date, files);
                }
            }
            this.fileMap = fileMapTemp;
            log.info("checklogFiles , taskId:{} ,CMD: {}end fileMap:{}", new Object[]{taskId, listFilesSmd, JacksonUtil.getInstance().toJson(this.fileMap)});
        }
        catch (Exception var6) {
            log.error(ErrorUtil.getStackMsg((Exception)var6));
        }
        catch (Error var7) {
            log.error(ErrorUtil.getStackMsg((Throwable)var7));
        }
    }

    private String deployJarDir() {
        String workDir = "";
        try {
            workDir = System.getProperty("user.dir");
            return workDir;
        }
        catch (Exception e) {
            log.info("checklogFiles, path  error:{} ", (Object)ErrorUtil.getStackMsg((Exception)e));
            workDir = "";
            return workDir;
        }
    }

    /*
     * Exception decompiling
     */
    private String doCmd(String cmd) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void putfile(Map<String, List<String>> fileMapTemp, String fileName, String dateTime) {
        List<String> files = fileMapTemp.get(dateTime);
        if (files == null) {
            files = new ArrayList<String>();
        }
        fileName = this.deployJarDir() + log_folder + "/" + fileName;
        if (this.logStorePath != null && !"".equals(this.logStorePath)) {
            fileName = this.logStorePath + "/" + fileName;
        }
        files.add(fileName);
        fileMapTemp.put(dateTime, files);
    }

    private static Map<String, String> findDateTime(String fileName) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("orginFileName", fileName);
        map.put("hasDateTime", "false");
        map.put("dateTime", "nodateTime");
        try {
            Pattern p = Pattern.compile("(\\d{4})-(\\d{1,2})-(\\d{1,2})");
            Matcher m = p.matcher(fileName);
            if (m.find()) {
                String dateTime = m.group(0);
                map.put("dateTime", dateTime);
                map.put("hasDateTime", "true");
            }
        }
        catch (Exception e) {
            log.info(ErrorUtil.getStackMsg((Exception)e));
        }
        return map;
    }
}

