/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.apollo.janus.standalone.sdk.message.standaloneJanus;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.util.concurrent.RateLimiter;
import com.xforceplus.apollo.janus.standalone.sdk.config.JanusStandaloneConfigInit;
import com.xforceplus.apollo.janus.standalone.sdk.config.LocalCLusterProperties;
import com.xforceplus.apollo.janus.standalone.sdk.message.AbsGlobalMessageEventWithResultListener;
import com.xforceplus.apollo.janus.standalone.sdk.message.AckTuple;
import com.xforceplus.apollo.janus.standalone.sdk.message.IGlobalMessageEventListener;
import com.xforceplus.apollo.janus.standalone.sdk.message.MessageEventInitListener;
import com.xforceplus.apollo.janus.standalone.sdk.message.standaloneJanus.LogQueryCmdThread;
import com.xforceplus.apollo.janus.standalone.sdk.utils.HttpUtils;
import com.xforceplus.apollo.janus.standalone.sdk.utils.IPUtils;
import com.xforceplus.apollo.janus.standalone.sdk.utils.SnowflakeIdWorker;
import com.xforceplus.apollo.utils.ErrorUtil;
import com.xforceplus.apollo.utils.JacksonUtil;
import com.xforceplus.apollo.utils.SystemUtil;
import com.xforceplus.xplat.aws.sqs.bean.MessageXplat;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import net.wicp.tams.common.Conf;
import net.wicp.tams.common.Result;
import net.wicp.tams.common.apiext.StringUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.map.HashedMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class StandaloneJanusService
implements InitializingBean,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(StandaloneJanusService.class);
    private final String pub = "message/pub";
    private final String sub = "message/sub";
    private final String ack = "message/ack";
    private String standalonePath = "";
    private String clientFlags = "";
    private final Map<String, RateLimiter> rateLimiterMap = new ConcurrentHashMap<String, RateLimiter>();
    private final RateLimiter rateLimiterReceiver;
    private int qps;
    private int messageRefuseSize;
    private int messageCompressSize;
    private LogQueryCmdThread logQueryCmdThread;
    private MessageEventInitListener messageEventInitListener;
    private String ackIpAddress = "";
    private volatile boolean canRun = true;

    public StandaloneJanusService(MessageEventInitListener messageEventInitListener) {
        try {
            List<String> ips = IPUtils.getIpAddress();
            if (CollectionUtils.isNotEmpty(ips)) {
                this.ackIpAddress = String.join((CharSequence)",", ips);
                log.debug("ackIpAddress: {} ", (Object)this.ackIpAddress);
            }
        }
        catch (Exception e) {
            log.error(ErrorUtil.getStackMsg((Exception)e));
        }
        this.messageEventInitListener = messageEventInitListener;
        String standalonePathTemp = LocalCLusterProperties.getInstance().getStandalonePath();
        if (!StringUtil.isNotNull((Object)standalonePathTemp)) {
            throw new IllegalArgumentException("janus.standalone.sdk.path is null");
        }
        String clientFlagsTemp = StandaloneJanusService.subWords(standalonePathTemp, 3);
        this.clientFlags = clientFlagsTemp.replaceFirst("/", "");
        this.standalonePath = standalonePathTemp.replace(this.clientFlags, "");
        this.qps = LocalCLusterProperties.getInstance().getQps();
        if (this.qps < 1 || this.qps > 20) {
            this.qps = 1;
        }
        this.messageRefuseSize = LocalCLusterProperties.getInstance().getMessageRefuseSize();
        this.messageCompressSize = LocalCLusterProperties.getInstance().getMessageCompressSize();
        this.rateLimiterReceiver = RateLimiter.create((double)this.qps);
        String logStorePath = LocalCLusterProperties.getInstance().getLogStorePath();
        if (StringUtils.isNotBlank((CharSequence)logStorePath)) {
            this.logQueryCmdThread = new LogQueryCmdThread(this);
        }
    }

    public static String subWords(String path, int index) {
        if (StringUtils.isBlank((CharSequence)path) || index < 1) {
            return "";
        }
        int start = path.indexOf("/") == -1 ? 0 : path.indexOf("/");
        int end = path.indexOf("/", start + 1);
        for (int i = 1; i < index; ++i) {
            start = end;
            end = path.indexOf("/", start + 1) == -1 ? path.length() : path.indexOf("/", start + 1);
        }
        return path.substring(start, end);
    }

    private void sendHeartBeatMsg() {
        try {
            long time = System.currentTimeMillis();
            HashedMap properties = new HashedMap();
            properties.put("serialNo", "serialNo-msg-0420-005-" + time);
            properties.put("sendTime", "" + time);
            String content = JSON.toJSONString((Object)SystemUtil.getSystemInfo());
            String queueName = "heart-beat-task";
            properties.put("ipAddress", this.ackIpAddress);
            Result result = this.sendStrMsg(queueName, content, (Map<String, String>)properties);
            log.info("heart-beat-task:{},result: {}", (Object)time, (Object)result);
        }
        catch (Exception e) {
            log.error("sendHeartBeatMsg error ,{}", (Object)ErrorUtil.getStackMsg((Exception)e));
        }
    }

    public boolean pullMessage() {
        boolean resultFlag = false;
        String requestId = SnowflakeIdWorker.getId();
        long receiveTime = System.currentTimeMillis();
        try {
            JSONArray jsonObjects;
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("content-type", "application/json");
            headers.put("clientFlags", this.clientFlags);
            headers.put("Accept", "application/json");
            headers.put("batchSub", "true");
            String requestUrl = this.standalonePath + "message/sub";
            String response = HttpUtils.getRequest(requestUrl, headers, null);
            log.debug("requestId:{},pullMessage: {}", (Object)requestId, (Object)response);
            if (response == null) {
                return false;
            }
            JSONObject responseObject = JSON.parseObject((String)response);
            if (responseObject == null) {
                return false;
            }
            String code = responseObject.getString("code");
            if (StringUtil.isNotNull((Object)code) && code.equals("200") && responseObject.get((Object)"result") != null && (jsonObjects = responseObject.getJSONArray("result")) != null && jsonObjects.size() > 0) {
                for (int i = 0; i < jsonObjects.size(); ++i) {
                    JSONObject jsonObject = jsonObjects.getJSONObject(i);
                    if (!this.dispatcherSingleMessage(jsonObject, requestId, receiveTime)) continue;
                    resultFlag = true;
                }
            }
        }
        catch (Exception e) {
            log.error(ErrorUtil.getStackMsg((Exception)e));
            resultFlag = false;
        }
        return resultFlag;
    }

    private boolean dispatcherSingleMessage(JSONObject jsonObject, String requestId, long receiveTime) {
        if (jsonObject == null || jsonObject.size() == 0) {
            log.info("requestId:{},jsonObject is null", (Object)requestId);
            return false;
        }
        String content = jsonObject.getString("content");
        JSONObject properties = jsonObject.getJSONObject("properties");
        JSONObject innerProps = jsonObject.getJSONObject("innerProps");
        String msgId = innerProps.getString("msgId");
        String pubCode = innerProps.getString("pubCode");
        if (StringUtil.isNotNull((Object)pubCode) && pubCode.equals("heart-beat-task")) {
            log.error("requestId:{},pubCode is null or heart-beat-task ", (Object)requestId);
            com.xforceplus.janus.framework.event.AckTuple ackTuple = new com.xforceplus.janus.framework.event.AckTuple((Object)true, (Object)"\u5904\u7406\u6210\u529f");
            innerProps.put("ackIpAddress", (Object)this.ackIpAddress);
            innerProps.put("janusStandaloneSdkVersion", (Object)JanusStandaloneConfigInit.janusStandaloneSdkVersion);
            jsonObject.put("content", (Object)JacksonUtil.getInstance().toJson((Object)ackTuple));
            this.ackMsg(jsonObject);
            this.sendHeartBeatMsg();
            return true;
        }
        com.xforceplus.janus.framework.event.AckTuple ackTuple = null;
        try {
            Set<IGlobalMessageEventListener> handlers = MessageEventInitListener.findHandler(pubCode, "standaloneJanus");
            if (handlers == null || handlers.size() == 0) {
                log.error("requestId:{},pubCode:{},\u65e0\u6d88\u606f\u5904\u7406\u5668 ", (Object)requestId, (Object)pubCode);
                ackTuple = new com.xforceplus.janus.framework.event.AckTuple((Object)true, (Object)("\u5c5e\u5730\u96c6\u6210\u5e73\u53f0\u4e0b\u53d1\u7684\u6d88\u606f\u65e0\u6d88\u606f\u5904\u7406\u5668" + pubCode));
            } else if (handlers.size() == 1) {
                ackTuple = this.handlerOne(jsonObject, requestId, receiveTime, handlers.iterator().next());
            } else {
                boolean finalResult = true;
                HashMap<String, com.xforceplus.janus.framework.event.AckTuple<Boolean, String>> map = new HashMap<String, com.xforceplus.janus.framework.event.AckTuple<Boolean, String>>();
                for (IGlobalMessageEventListener handler : handlers) {
                    com.xforceplus.janus.framework.event.AckTuple<Boolean, String> ackTemp = this.handlerOne(jsonObject, requestId, receiveTime, handler);
                    String classFullName = handler.getClass().getName();
                    String shortName = classFullName.substring(classFullName.lastIndexOf(".") + 1, classFullName.length());
                    map.put(shortName, ackTemp);
                    if (((Boolean)ackTemp.status).booleanValue()) continue;
                    finalResult = false;
                }
                log.info(JacksonUtil.getInstance().toJson(map));
                ackTuple = new com.xforceplus.janus.framework.event.AckTuple((Object)finalResult, (Object)JacksonUtil.getInstance().toJson(map));
            }
        }
        catch (Exception e) {
            log.error("msgId:{}\u5904\u7406\u5f02\u5e38,{}", (Object)msgId, (Object)ErrorUtil.getStackMsg((Exception)e));
            ackTuple = new com.xforceplus.janus.framework.event.AckTuple((Object)false, (Object)ErrorUtil.getStackMsg((Exception)e));
        }
        catch (Error error) {
            log.error("msgId:{}\u5904\u7406\u5f02\u5e38,{}", (Object)msgId, (Object)ErrorUtil.getStackMsg((Throwable)error));
            ackTuple = new com.xforceplus.janus.framework.event.AckTuple((Object)false, (Object)ErrorUtil.getStackMsg((Throwable)error));
        }
        if (null == ackTuple) {
            log.error("{} \u7f3a\u5931\u6709\u6548\u56de\u6267\uff0c\u8bf7\u8865\u5145\u56de\u6267\u5185\u5bb9\uff01\uff01\uff01", (Object)msgId);
            ackTuple = new com.xforceplus.janus.framework.event.AckTuple((Object)false, (Object)"\u7f3a\u5931\u6709\u6548\u56de\u6267\uff0c\u8bf7\u8865\u5145\u56de\u6267\u5185\u5bb9");
        }
        innerProps.put("ackIpAddress", (Object)this.ackIpAddress);
        innerProps.put("janusStandaloneSdkVersion", (Object)JanusStandaloneConfigInit.janusStandaloneSdkVersion);
        JSONObject ackObject = new JSONObject();
        ackObject.put("innerProps", (Object)innerProps);
        ackObject.put("content", (Object)JacksonUtil.getInstance().toJson((Object)ackTuple));
        this.ackMsg(ackObject);
        return true;
    }

    private com.xforceplus.janus.framework.event.AckTuple<Boolean, String> handlerOne(JSONObject jsonObject, String requestId, long receiveTime, IGlobalMessageEventListener handler) {
        com.xforceplus.janus.framework.event.AckTuple ackTuple = null;
        String content = jsonObject.getString("content");
        JSONObject properties = jsonObject.getJSONObject("properties");
        JSONObject innerProps = jsonObject.getJSONObject("innerProps");
        String msgId = innerProps.getString("msgId");
        JSONObject propertiesnew = new JSONObject();
        propertiesnew.putAll((Map)properties);
        try {
            innerProps.put("receivedTime", (Object)receiveTime);
            if (handler instanceof AbsGlobalMessageEventWithResultListener) {
                AbsGlobalMessageEventWithResultListener absMessageListener = (AbsGlobalMessageEventWithResultListener)handler;
                AckTuple ackTuple1 = absMessageListener.onMessageWithResult(msgId, (Map)propertiesnew, content, "standaloneJanus");
                ackTuple = new com.xforceplus.janus.framework.event.AckTuple(ackTuple1.getStatus(), ackTuple1.getMessage());
            } else {
                boolean flag = handler.onMessage(msgId, (Map)propertiesnew, content, "standaloneJanus");
                String message = flag ? "\u5904\u7406\u6210\u529f" : "\u5904\u7406\u5931\u8d25";
                ackTuple = new com.xforceplus.janus.framework.event.AckTuple((Object)flag, (Object)message);
            }
        }
        catch (Exception ex) {
            log.error("msgId:{}\u5904\u7406\u5f02\u5e38,{}", (Object)msgId, (Object)ErrorUtil.getStackMsg((Exception)ex));
            ackTuple = new com.xforceplus.janus.framework.event.AckTuple((Object)false, (Object)ErrorUtil.getStackMsg((Exception)ex));
        }
        catch (Error error) {
            log.error("msgId:{}\u5904\u7406\u5f02\u5e38,{}", (Object)msgId, (Object)ErrorUtil.getStackMsg((Throwable)error));
            ackTuple = new com.xforceplus.janus.framework.event.AckTuple((Object)false, (Object)ErrorUtil.getStackMsg((Throwable)error));
        }
        return ackTuple;
    }

    private boolean ackMsg(JSONObject obj) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String nowStr = sdf.format(new Date());
            String requestUrl = this.standalonePath + "message/ack";
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("timeStamp", nowStr);
            headers.put("clientFlags", this.clientFlags);
            headers.put("content-type", "application/json");
            headers.put("Accept", "application/json");
            String json = JSON.toJSONString((Object)obj);
            String response = HttpUtils.postRequest(requestUrl, headers, json);
            JSONObject jsonObject = JSON.parseObject((String)response);
            String code = jsonObject.getString("code");
            String messageRt = jsonObject.getString("message");
            String result = jsonObject.getString("result");
            return StringUtil.isNotNull((Object)code) && code.equals("200");
        }
        catch (Exception e) {
            log.error(ErrorUtil.getStackMsg((Exception)e));
            return false;
        }
    }

    public List<MessageXplat> queueReceiver(String queueName, String ... attributeNames) {
        return this.queueReceiver(queueName, new String[0]);
    }

    public List<MessageXplat> queueReceiverAllattr(String queueName) {
        return this.queueReceiver(queueName, new String[0]);
    }

    public List<MessageXplat> queueReceiver(String queueName, int maxNumberOfMessages, int waitTimeSeconds, String ... attributeNames) {
        return this.queueReceiver(queueName, new String[0]);
    }

    public Result sendStrMsg(String queueName, String message, Map<String, String> properties, JSONObject context, int delaySeconds) {
        properties.put("context", JSON.toJSONString((Object)context));
        properties.put("delaySeconds", String.valueOf(delaySeconds));
        return this.sendStrMsg(queueName, message, properties);
    }

    public Result sendStrMsg(String eventType, String message, Map<String, String> properties) {
        try {
            boolean acquire;
            RateLimiter rateLimiter;
            if (StringUtils.isBlank((CharSequence)eventType)) {
                return Result.getError((String)"\u6d88\u606f\u53d1\u9001\u65f6\u961f\u5217\u540d\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (eventType.indexOf("it-bus-priority") > -1 && (properties == null || StringUtils.isBlank((CharSequence)properties.get("eventType")))) {
                return Result.getError((String)"\u6d88\u606f\u53d1\u9001\u65f6\u961f\u5217\u540d\u4e2d\u5305\u542b[it-bus-priority],\u5c5e\u6027\u4e2d\u5fc5\u987b\u6709eventType\uff01");
            }
            eventType = properties.get("eventType").trim();
            if (!this.rateLimiterMap.containsKey(eventType)) {
                if (this.qps < 1 || this.qps > 20) {
                    this.qps = 1;
                }
                rateLimiter = RateLimiter.create((double)this.qps);
                this.rateLimiterMap.put(eventType, rateLimiter);
            }
            if (acquire = (rateLimiter = this.rateLimiterMap.get(eventType)).tryAcquire()) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                String nowStr = sdf.format(new Date());
                String requestUrl = this.standalonePath + "message/pub";
                HashMap<String, String> headers = new HashMap<String, String>();
                headers.put("clientFlags", this.clientFlags);
                headers.put("timeStamp", nowStr);
                headers.put("pubCode", eventType);
                headers.put("content-type", "application/json");
                headers.put("Accept", "application/json");
                properties.put("xplat.aws.sqs.receiver.queueName.prefix", Conf.get((String)"xplat.aws.sqs.receiver.queueName.prefix"));
                HashMap<String, Object> messageMap = new HashMap<String, Object>();
                int messageLength = message.getBytes(StandardCharsets.UTF_8).length;
                if (messageLength > this.messageRefuseSize) {
                    return Result.getError((String)("\u53d1\u9001\u5931\u8d25,\u6d88\u606f\u5927\u5c0f\u4e0d\u80fd\u8d85\u8fc7:" + this.messageRefuseSize + " \u5f53\u524d\u6d88\u606f\u5927\u5c0f :" + messageLength));
                }
                messageMap.put("content", message);
                messageMap.put("properties", properties);
                String requestBody = JSON.toJSONString(messageMap);
                String response = HttpUtils.postRequest(requestUrl, headers, requestBody);
                JSONObject jsonObject = JSON.parseObject((String)response);
                String code = jsonObject.getString("code");
                String messageRt = jsonObject.getString("message");
                String result = jsonObject.getString("result");
                if (StringUtil.isNotNull((Object)code) && code.equals("200")) {
                    String jsonStr = "{\"message\":\"" + result + "\",\"except\":\"no\",\"suc\":true}";
                    return Result.getFromJson((String)jsonStr);
                }
                return Result.getError((String)messageRt);
            }
            log.warn("\u8bf7\u6c42\u88ab\u9650\u6d41,eventType:{} ,qps: {}", (Object)eventType, (Object)this.qps);
            return Result.getError((String)("\u8bf7\u6c42\u88ab\u9650\u6d41: eventType:" + eventType + " qps :" + this.qps));
        }
        catch (Exception e) {
            log.error(ErrorUtil.getStackMsg((Exception)e));
            return Result.getError((String)"\u6d88\u606f\u53d1\u9001\u5f02\u5e38");
        }
    }

    public Result sendStrMsg(String queueName, String message, String bucketName, Map<String, String> properties) {
        properties.put("bucketName", bucketName);
        return this.sendStrMsg(queueName, message, properties);
    }

    public Result sendBase64Msg(String queueName, byte[] message, Map<String, String> properties, JSONObject context, int delaySeconds) {
        properties.put("context", JSON.toJSONString((Object)context));
        properties.put("delaySeconds", String.valueOf(delaySeconds));
        return this.sendBase64Msg(queueName, message, properties);
    }

    public Result sendBase64Msg(String queueName, byte[] message, Map<String, String> properties) {
        try {
            String messageStr = new String(message, "utf-8");
            return this.sendStrMsg(queueName, messageStr, properties);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            return null;
        }
    }

    public Result sendBase64Msg(String queueName, byte[] message, String bucketName, Map<String, String> properties) {
        properties.put("bucketName", bucketName);
        return this.sendBase64Msg(queueName, message, properties);
    }

    public Result sendByteMsg(String queueName, byte[] msgBytes, Map<String, String> properties, JSONObject context, int delaySeconds) {
        properties.put("context", JSON.toJSONString((Object)context));
        properties.put("delaySeconds", String.valueOf(delaySeconds));
        return this.sendBase64Msg(queueName, msgBytes, properties);
    }

    public Result sendByteMsg(String queueName, byte[] msgBytes, Map<String, String> properties) {
        return this.sendBase64Msg(queueName, msgBytes, properties);
    }

    public Result sendByteMsg(String queueName, byte[] msgBytes, String bucketName, Map<String, String> properties) {
        properties.put("bucketName", bucketName);
        return this.sendBase64Msg(queueName, msgBytes, properties);
    }

    public void startTask() {
    }

    public void afterPropertiesSet() throws Exception {
        new Thread(() -> {
            int times = 1;
            long heartBeatTime = System.currentTimeMillis();
            while (this.canRun) {
                if (!this.pullMessage()) {
                    try {
                        TimeUnit.MILLISECONDS.sleep(LocalCLusterProperties.getInstance().getFetchMessageInterval());
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                long time = System.currentTimeMillis();
                long costTime = time - heartBeatTime;
                if (++times <= 120 && costTime < 40000L) continue;
                heartBeatTime = time;
                times = 1;
                try {
                    HashedMap properties = new HashedMap();
                    properties.put("serialNo", "heart-beat-task-" + time);
                    properties.put("sendTime", "" + time);
                    String content = JSON.toJSONString((Object)SystemUtil.getSystemInfo());
                    String eventType = "heart-beat-task";
                    properties.put("ipAddress", this.ackIpAddress);
                    Result result = this.sendStrMsg(eventType, content, (Map<String, String>)properties);
                    log.debug("heart-beat-task:{},result: {}", (Object)time, (Object)result);
                }
                catch (Exception e) {
                    log.error(ErrorUtil.getStackMsg((Exception)e));
                }
            }
        }, "PullMessageFromStandaloneJanus").start();
        if (this.logQueryCmdThread != null) {
            this.logQueryCmdThread.start();
        }
    }

    public void destroy() throws Exception {
        this.canRun = false;
        if (this.logQueryCmdThread != null) {
            this.logQueryCmdThread.setCanRun(false);
        }
    }
}

