/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.apollo.janus.standalone.sdk.utils;

import java.util.Calendar;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;

public class FileCmdCache {
    private static Map<String, CacheData> cache = new ConcurrentHashMap<String, CacheData>();

    public static <T> void set(String key, T t) {
        cache.put(key, new CacheData<T>(t, 0L));
    }

    public static <T> void set(String key, T t, long expire) {
        cache.put(key, new CacheData<T>(t, expire));
    }

    public static <T> T get(String key) {
        CacheData data = cache.get(key);
        if (null == data) {
            return null;
        }
        if (data.isExpire()) {
            FileCmdCache.remove(key);
            return null;
        }
        return data.getData();
    }

    public static long getExpireTime(String key) {
        CacheData data = cache.get(key);
        if (null == data || data.expireTime == 0L) {
            return 0L;
        }
        return data.expireTime - Calendar.getInstance().getTimeInMillis();
    }

    public static void remove(String key) {
        cache.remove(key);
    }

    public static void removeAll() {
        cache.clear();
    }

    static {
        Timer t = new Timer();
        t.schedule((TimerTask)new ClearTimerTask(cache), 0L, 120000L);
    }

    private static class ClearTimerTask
    extends TimerTask {
        Map<String, CacheData> cache;

        public ClearTimerTask(Map<String, CacheData> cache) {
            this.cache = cache;
        }

        @Override
        public void run() {
            Set<String> keys = this.cache.keySet();
            for (String key : keys) {
                CacheData data = this.cache.get(key);
                if (data.expireTime <= 0L || data.expireTime > Calendar.getInstance().getTimeInMillis()) continue;
                this.cache.remove(key);
            }
        }
    }

    private static class CacheData<T> {
        private T data;
        private long expireTime;

        public CacheData(T t, long expire) {
            this.data = t;
            this.expireTime = expire <= 0L ? 0L : Calendar.getInstance().getTimeInMillis() + expire;
        }

        public boolean isExpire() {
            if (this.expireTime <= 0L) {
                return false;
            }
            return this.expireTime <= Calendar.getInstance().getTimeInMillis();
        }

        public T getData() {
            return this.data;
        }
    }
}

