/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.apollo.janus.standalone.sdk.utils;

import com.alibaba.fastjson.JSONObject;
import com.xforceplus.apollo.utils.ErrorUtil;
import java.io.IOException;
import java.nio.charset.Charset;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Map;
import javax.net.ssl.SSLContext;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContexts;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicHeader;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtils {
    private static final Logger log = LoggerFactory.getLogger(HttpUtils.class);
    public static String defaultEncoding = "utf-8";

    public static String putRequest(String url) {
        return HttpUtils.postRequest(url, null, null);
    }

    public static String postRequest(String url) {
        return HttpUtils.postRequest(url, null, null);
    }

    public static String postRequest(String url, Map<String, Object> params) {
        return HttpUtils.postRequest(url, null, JSONObject.toJSONString(params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String postRequest(String url, Map<String, String> headers, String json) {
        String result = null;
        CloseableHttpClient httpClient = HttpUtils.buildHttpClient();
        HttpPost httpPost = new HttpPost(url);
        if (null != headers && headers.size() > 0) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                httpPost.addHeader((Header)new BasicHeader(key, value));
            }
        }
        if (json != null) {
            httpPost.setEntity((HttpEntity)new StringEntity(json, Charset.forName(defaultEncoding)));
        }
        try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);){
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                result = EntityUtils.toString((HttpEntity)entity, (Charset)Charset.forName(defaultEncoding));
            }
        }
        catch (Exception ex) {
            log.error(ErrorUtil.getStackMsg((Exception)ex));
        }
        finally {
            try {
                httpClient.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String putRequest(String url, Map<String, String> headers, String json) {
        String result = null;
        CloseableHttpClient httpClient = HttpUtils.buildHttpClient();
        HttpPut httpPut = new HttpPut(url);
        if (null != headers && headers.size() > 0) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                httpPut.addHeader((Header)new BasicHeader(key, value));
            }
        }
        if (json != null) {
            httpPut.setEntity((HttpEntity)new StringEntity(json, Charset.forName(defaultEncoding)));
        }
        try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPut);){
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                result = EntityUtils.toString((HttpEntity)entity, (Charset)Charset.forName(defaultEncoding));
            }
        }
        catch (Exception ex) {
            log.error(ErrorUtil.getStackMsg((Exception)ex));
        }
        finally {
            try {
                httpClient.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public static String getRequest(String url) {
        return HttpUtils.getRequest(url, null);
    }

    public static String getRequest(String url, Map<String, Object> params) {
        return HttpUtils.getRequest(url, null, params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getRequest(String url, Map<String, String> headersMap, Map<String, Object> params) {
        String result = null;
        CloseableHttpClient httpClient = HttpUtils.buildHttpClient();
        try {
            String apiUrl = url;
            if (null != params && params.size() > 0) {
                StringBuffer param = new StringBuffer();
                int i = 0;
                for (String key : params.keySet()) {
                    if (i == 0) {
                        param.append("?");
                    } else {
                        param.append("&");
                    }
                    param.append(key).append("=").append(params.get(key));
                    ++i;
                }
                apiUrl = apiUrl + param;
            }
            HttpGet httpGet = new HttpGet(apiUrl);
            if (null != headersMap && headersMap.size() > 0) {
                for (Map.Entry<String, String> entry : headersMap.entrySet()) {
                    String key;
                    key = entry.getKey();
                    String value = entry.getValue();
                    httpGet.addHeader((Header)new BasicHeader(key, value));
                }
            }
            try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);){
                HttpEntity entity = response.getEntity();
                if (null != entity) {
                    result = EntityUtils.toString((HttpEntity)entity, (String)defaultEncoding);
                }
            }
        }
        catch (Exception ex) {
            log.error(ErrorUtil.getStackMsg((Exception)ex));
        }
        finally {
            try {
                httpClient.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public static CloseableHttpClient buildHttpClient() {
        try {
            RegistryBuilder builder = RegistryBuilder.create();
            PlainConnectionSocketFactory factory = new PlainConnectionSocketFactory();
            builder.register("http", (Object)factory);
            KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
            SSLContext context = SSLContexts.custom().useTLS().loadTrustMaterial(trustStore, new TrustStrategy(){

                public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    return true;
                }
            }).build();
            SSLConnectionSocketFactory sslFactory = new SSLConnectionSocketFactory(context, SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
            builder.register("https", (Object)sslFactory);
            Registry registry = builder.build();
            PoolingHttpClientConnectionManager manager = new PoolingHttpClientConnectionManager(registry);
            ConnectionConfig connConfig = ConnectionConfig.custom().setCharset(Charset.forName(defaultEncoding)).build();
            SocketConfig socketConfig = SocketConfig.custom().setSoTimeout(100000).build();
            manager.setDefaultConnectionConfig(connConfig);
            manager.setDefaultSocketConfig(socketConfig);
            return HttpClientBuilder.create().setConnectionManager((HttpClientConnectionManager)manager).build();
        }
        catch (Exception ex) {
            log.error(ErrorUtil.getStackMsg((Exception)ex));
            return null;
        }
    }
}

