/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.apollo.janus.standalone.sdk.utils;

import com.xforceplus.apollo.utils.ErrorUtil;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IPUtils {
    private static final Logger log = LoggerFactory.getLogger(IPUtils.class);

    public static List<String> getIpAddress() {
        LinkedList<String> list = new LinkedList<String>();
        try {
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            while (enumeration.hasMoreElements()) {
                NetworkInterface network = enumeration.nextElement();
                Enumeration<InetAddress> addresses = network.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    InetAddress address = addresses.nextElement();
                    if (address == null || !(address instanceof Inet4Address) || "127.0.0.1".equals(address.getHostAddress())) continue;
                    list.add(address.getHostAddress());
                }
            }
        }
        catch (Exception e) {
            log.error(ErrorUtil.getStackMsg((Exception)e));
        }
        catch (Error e) {
            log.error(ErrorUtil.getStackMsg((Throwable)e));
        }
        return list;
    }
}

