package com.xforceplus.appomtest.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.appomtest.entity.Bbbb;
import com.xforceplus.appomtest.service.IBbbbService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-01-13
 */
@RestController
public class BbbbController {

  @Autowired
  private IBbbbService bbbbServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param bbbb ${table.comment}
   * @return
   */
  @GetMapping("/bbbbs" )
  public XfR getBbbbs(XfPage page, Bbbb bbbb) {
    return XfR.ok(bbbbServiceImpl.page(page, Wrappers.query(bbbb)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/bbbbs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(bbbbServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param bbbb ${table.comment}
   * @return XfR
   */
  @PostMapping("/bbbbs")
  public XfR save(@RequestBody Bbbb bbbb) {
     return XfR.ok(bbbbServiceImpl.save(bbbb));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param bbbb ${table.comment}
   * @return XfR
   */
  @PutMapping("/bbbbs/{id}")
  public XfR putUpdate(@RequestBody Bbbb bbbb,@PathVariable Long id) {
      bbbb.setId(id);
      return XfR.ok(bbbbServiceImpl.updateById(bbbb));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param bbbb ${table.comment}
   * @return XfR
   */
  @PatchMapping("/bbbbs/{id}")
  public XfR patchUpdate(@RequestBody Bbbb bbbb,@PathVariable Long id) {
      Bbbb upbbbb = bbbbServiceImpl.getById(id);
      if(upbbbb != null){
        upbbbb = ObjectCopyUtils.copyProperties(bbbb,upbbbb,true);
      }
      return XfR.ok(bbbbServiceImpl.updateById(upbbbb));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/bbbbs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(bbbbServiceImpl.removeById(id));
  }

  @PostMapping("/bbbbs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "bbbb");
     params.put("request", condition);

     return XfR.ok(bbbbServiceImpl.querys(params));
  }

}
