package com.xforceplus.appomtest.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.appomtest.entity.Fdg;
import com.xforceplus.appomtest.service.IFdgService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * dg前端控制器
 *
 * @author ultraman
 * @date 2022-01-13
 */
@RestController
public class FdgController {

  @Autowired
  private IFdgService fdgServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param fdg dg
   * @return
   */
  @GetMapping("/fdgs" )
  public XfR getFdgs(XfPage page, Fdg fdg) {
    return XfR.ok(fdgServiceImpl.page(page, Wrappers.query(fdg)));
  }

  /**
   * 通过id查询dg
   * @param  id
   * @return XfR
   */
  @GetMapping("/fdgs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(fdgServiceImpl.getById(id));
  }

  /**
   * 新增dg
   * @param fdg dg
   * @return XfR
   */
  @PostMapping("/fdgs")
  public XfR save(@RequestBody Fdg fdg) {
     return XfR.ok(fdgServiceImpl.save(fdg));
  }

  /**
   * 修改-传入修改后的全部数据dg
   * @param fdg dg
   * @return XfR
   */
  @PutMapping("/fdgs/{id}")
  public XfR putUpdate(@RequestBody Fdg fdg,@PathVariable Long id) {
      fdg.setId(id);
      return XfR.ok(fdgServiceImpl.updateById(fdg));
  }

  /**
   * 修改-传入修改的数据dg
   * @param fdg dg
   * @return XfR
   */
  @PatchMapping("/fdgs/{id}")
  public XfR patchUpdate(@RequestBody Fdg fdg,@PathVariable Long id) {
      Fdg upfdg = fdgServiceImpl.getById(id);
      if(upfdg != null){
        upfdg = ObjectCopyUtils.copyProperties(fdg,upfdg,true);
      }
      return XfR.ok(fdgServiceImpl.updateById(upfdg));
  }

  /**
   * 通过id删除dg
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/fdgs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(fdgServiceImpl.removeById(id));
  }

  @PostMapping("/fdgs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "fdg");
     params.put("request", condition);

     return XfR.ok(fdgServiceImpl.querys(params));
  }

}
