package com.xforceplus.appomtest.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.appomtest.entity.Hlj;
import com.xforceplus.appomtest.service.IHljService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-01-13
 */
@RestController
public class HljController {

  @Autowired
  private IHljService hljServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param hlj ${table.comment}
   * @return
   */
  @GetMapping("/hljs" )
  public XfR getHljs(XfPage page, Hlj hlj) {
    return XfR.ok(hljServiceImpl.page(page, Wrappers.query(hlj)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/hljs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(hljServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param hlj ${table.comment}
   * @return XfR
   */
  @PostMapping("/hljs")
  public XfR save(@RequestBody Hlj hlj) {
     return XfR.ok(hljServiceImpl.save(hlj));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param hlj ${table.comment}
   * @return XfR
   */
  @PutMapping("/hljs/{id}")
  public XfR putUpdate(@RequestBody Hlj hlj,@PathVariable Long id) {
      hlj.setId(id);
      return XfR.ok(hljServiceImpl.updateById(hlj));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param hlj ${table.comment}
   * @return XfR
   */
  @PatchMapping("/hljs/{id}")
  public XfR patchUpdate(@RequestBody Hlj hlj,@PathVariable Long id) {
      Hlj uphlj = hljServiceImpl.getById(id);
      if(uphlj != null){
        uphlj = ObjectCopyUtils.copyProperties(hlj,uphlj,true);
      }
      return XfR.ok(hljServiceImpl.updateById(uphlj));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/hljs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(hljServiceImpl.removeById(id));
  }

  @PostMapping("/hljs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "hlj");
     params.put("request", condition);

     return XfR.ok(hljServiceImpl.querys(params));
  }

}
