package com.xforceplus.appomtest.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.appomtest.entity.OmBoChild;
import com.xforceplus.appomtest.service.IOmBoChildService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * omBoChild前端控制器
 *
 * @author ultraman
 * @date 2022-01-13
 */
@RestController
public class OmBoChildController {

  @Autowired
  private IOmBoChildService omBoChildServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param omBoChild omBoChild
   * @return
   */
  @GetMapping("/ombochilds" )
  public XfR getOmBoChilds(XfPage page, OmBoChild omBoChild) {
    return XfR.ok(omBoChildServiceImpl.page(page, Wrappers.query(omBoChild)));
  }

  /**
   * 通过id查询omBoChild
   * @param  id
   * @return XfR
   */
  @GetMapping("/ombochilds/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(omBoChildServiceImpl.getById(id));
  }

  /**
   * 新增omBoChild
   * @param omBoChild omBoChild
   * @return XfR
   */
  @PostMapping("/ombochilds")
  public XfR save(@RequestBody OmBoChild omBoChild) {
     return XfR.ok(omBoChildServiceImpl.save(omBoChild));
  }

  /**
   * 修改-传入修改后的全部数据omBoChild
   * @param omBoChild omBoChild
   * @return XfR
   */
  @PutMapping("/ombochilds/{id}")
  public XfR putUpdate(@RequestBody OmBoChild omBoChild,@PathVariable Long id) {
      omBoChild.setId(id);
      return XfR.ok(omBoChildServiceImpl.updateById(omBoChild));
  }

  /**
   * 修改-传入修改的数据omBoChild
   * @param omBoChild omBoChild
   * @return XfR
   */
  @PatchMapping("/ombochilds/{id}")
  public XfR patchUpdate(@RequestBody OmBoChild omBoChild,@PathVariable Long id) {
      OmBoChild upomBoChild = omBoChildServiceImpl.getById(id);
      if(upomBoChild != null){
        upomBoChild = ObjectCopyUtils.copyProperties(omBoChild,upomBoChild,true);
      }
      return XfR.ok(omBoChildServiceImpl.updateById(upomBoChild));
  }

  /**
   * 通过id删除omBoChild
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/ombochilds/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(omBoChildServiceImpl.removeById(id));
  }

  @PostMapping("/ombochilds/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "om_bo_child");
     params.put("request", condition);

     return XfR.ok(omBoChildServiceImpl.querys(params));
  }

}
