package com.xforceplus.appomtest.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.appomtest.entity.OmBo;
import com.xforceplus.appomtest.service.IOmBoService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * omBo前端控制器
 *
 * @author ultraman
 * @date 2022-01-13
 */
@RestController
public class OmBoController {

  @Autowired
  private IOmBoService omBoServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param omBo omBo
   * @return
   */
  @GetMapping("/ombos" )
  public XfR getOmBos(XfPage page, OmBo omBo) {
    return XfR.ok(omBoServiceImpl.page(page, Wrappers.query(omBo)));
  }

  /**
   * 通过id查询omBo
   * @param  id
   * @return XfR
   */
  @GetMapping("/ombos/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(omBoServiceImpl.getById(id));
  }

  /**
   * 新增omBo
   * @param omBo omBo
   * @return XfR
   */
  @PostMapping("/ombos")
  public XfR save(@RequestBody OmBo omBo) {
     return XfR.ok(omBoServiceImpl.save(omBo));
  }

  /**
   * 修改-传入修改后的全部数据omBo
   * @param omBo omBo
   * @return XfR
   */
  @PutMapping("/ombos/{id}")
  public XfR putUpdate(@RequestBody OmBo omBo,@PathVariable Long id) {
      omBo.setId(id);
      return XfR.ok(omBoServiceImpl.updateById(omBo));
  }

  /**
   * 修改-传入修改的数据omBo
   * @param omBo omBo
   * @return XfR
   */
  @PatchMapping("/ombos/{id}")
  public XfR patchUpdate(@RequestBody OmBo omBo,@PathVariable Long id) {
      OmBo upomBo = omBoServiceImpl.getById(id);
      if(upomBo != null){
        upomBo = ObjectCopyUtils.copyProperties(omBo,upomBo,true);
      }
      return XfR.ok(omBoServiceImpl.updateById(upomBo));
  }

  /**
   * 通过id删除omBo
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/ombos/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(omBoServiceImpl.removeById(id));
  }

  @PostMapping("/ombos/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "om_bo");
     params.put("request", condition);

     return XfR.ok(omBoServiceImpl.querys(params));
  }

}
