package com.xforceplus.appomtest.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.appomtest.entity.OmToMBo;
import com.xforceplus.appomtest.service.IOmToMBoService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-01-13
 */
@RestController
public class OmToMBoController {

  @Autowired
  private IOmToMBoService omToMBoServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param omToMBo ${table.comment}
   * @return
   */
  @GetMapping("/omtombos" )
  public XfR getOmToMBos(XfPage page, OmToMBo omToMBo) {
    return XfR.ok(omToMBoServiceImpl.page(page, Wrappers.query(omToMBo)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/omtombos/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(omToMBoServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param omToMBo ${table.comment}
   * @return XfR
   */
  @PostMapping("/omtombos")
  public XfR save(@RequestBody OmToMBo omToMBo) {
     return XfR.ok(omToMBoServiceImpl.save(omToMBo));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param omToMBo ${table.comment}
   * @return XfR
   */
  @PutMapping("/omtombos/{id}")
  public XfR putUpdate(@RequestBody OmToMBo omToMBo,@PathVariable Long id) {
      omToMBo.setId(id);
      return XfR.ok(omToMBoServiceImpl.updateById(omToMBo));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param omToMBo ${table.comment}
   * @return XfR
   */
  @PatchMapping("/omtombos/{id}")
  public XfR patchUpdate(@RequestBody OmToMBo omToMBo,@PathVariable Long id) {
      OmToMBo upomToMBo = omToMBoServiceImpl.getById(id);
      if(upomToMBo != null){
        upomToMBo = ObjectCopyUtils.copyProperties(omToMBo,upomToMBo,true);
      }
      return XfR.ok(omToMBoServiceImpl.updateById(upomToMBo));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/omtombos/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(omToMBoServiceImpl.removeById(id));
  }

  @PostMapping("/omtombos/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "om_to_m_bo");
     params.put("request", condition);

     return XfR.ok(omToMBoServiceImpl.querys(params));
  }

}
