package com.xforceplus.appomtest.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.appomtest.entity.OmToOBo;
import com.xforceplus.appomtest.service.IOmToOBoService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-01-13
 */
@RestController
public class OmToOBoController {

  @Autowired
  private IOmToOBoService omToOBoServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param omToOBo ${table.comment}
   * @return
   */
  @GetMapping("/omtoobos" )
  public XfR getOmToOBos(XfPage page, OmToOBo omToOBo) {
    return XfR.ok(omToOBoServiceImpl.page(page, Wrappers.query(omToOBo)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/omtoobos/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(omToOBoServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param omToOBo ${table.comment}
   * @return XfR
   */
  @PostMapping("/omtoobos")
  public XfR save(@RequestBody OmToOBo omToOBo) {
     return XfR.ok(omToOBoServiceImpl.save(omToOBo));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param omToOBo ${table.comment}
   * @return XfR
   */
  @PutMapping("/omtoobos/{id}")
  public XfR putUpdate(@RequestBody OmToOBo omToOBo,@PathVariable Long id) {
      omToOBo.setId(id);
      return XfR.ok(omToOBoServiceImpl.updateById(omToOBo));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param omToOBo ${table.comment}
   * @return XfR
   */
  @PatchMapping("/omtoobos/{id}")
  public XfR patchUpdate(@RequestBody OmToOBo omToOBo,@PathVariable Long id) {
      OmToOBo upomToOBo = omToOBoServiceImpl.getById(id);
      if(upomToOBo != null){
        upomToOBo = ObjectCopyUtils.copyProperties(omToOBo,upomToOBo,true);
      }
      return XfR.ok(omToOBoServiceImpl.updateById(upomToOBo));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/omtoobos/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(omToOBoServiceImpl.removeById(id));
  }

  @PostMapping("/omtoobos/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "om_to_o_bo");
     params.put("request", condition);

     return XfR.ok(omToOBoServiceImpl.querys(params));
  }

}
