package com.xforceplus.appomtest.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.appomtest.entity.Sadasd;
import com.xforceplus.appomtest.service.ISadasdService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-01-13
 */
@RestController
public class SadasdController {

  @Autowired
  private ISadasdService sadasdServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param sadasd ${table.comment}
   * @return
   */
  @GetMapping("/sadasds" )
  public XfR getSadasds(XfPage page, Sadasd sadasd) {
    return XfR.ok(sadasdServiceImpl.page(page, Wrappers.query(sadasd)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/sadasds/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(sadasdServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param sadasd ${table.comment}
   * @return XfR
   */
  @PostMapping("/sadasds")
  public XfR save(@RequestBody Sadasd sadasd) {
     return XfR.ok(sadasdServiceImpl.save(sadasd));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param sadasd ${table.comment}
   * @return XfR
   */
  @PutMapping("/sadasds/{id}")
  public XfR putUpdate(@RequestBody Sadasd sadasd,@PathVariable Long id) {
      sadasd.setId(id);
      return XfR.ok(sadasdServiceImpl.updateById(sadasd));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param sadasd ${table.comment}
   * @return XfR
   */
  @PatchMapping("/sadasds/{id}")
  public XfR patchUpdate(@RequestBody Sadasd sadasd,@PathVariable Long id) {
      Sadasd upsadasd = sadasdServiceImpl.getById(id);
      if(upsadasd != null){
        upsadasd = ObjectCopyUtils.copyProperties(sadasd,upsadasd,true);
      }
      return XfR.ok(sadasdServiceImpl.updateById(upsadasd));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/sadasds/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(sadasdServiceImpl.removeById(id));
  }

  @PostMapping("/sadasds/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "sadasd");
     params.put("request", condition);

     return XfR.ok(sadasdServiceImpl.querys(params));
  }

}
