package com.xforceplus.appomtest.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.appomtest.entity.TestBug;
import com.xforceplus.appomtest.service.ITestBugService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * testBug前端控制器
 *
 * @author ultraman
 * @date 2022-01-13
 */
@RestController
public class TestBugController {

  @Autowired
  private ITestBugService testBugServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param testBug testBug
   * @return
   */
  @GetMapping("/testbugs" )
  public XfR getTestBugs(XfPage page, TestBug testBug) {
    return XfR.ok(testBugServiceImpl.page(page, Wrappers.query(testBug)));
  }

  /**
   * 通过id查询testBug
   * @param  id
   * @return XfR
   */
  @GetMapping("/testbugs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(testBugServiceImpl.getById(id));
  }

  /**
   * 新增testBug
   * @param testBug testBug
   * @return XfR
   */
  @PostMapping("/testbugs")
  public XfR save(@RequestBody TestBug testBug) {
     return XfR.ok(testBugServiceImpl.save(testBug));
  }

  /**
   * 修改-传入修改后的全部数据testBug
   * @param testBug testBug
   * @return XfR
   */
  @PutMapping("/testbugs/{id}")
  public XfR putUpdate(@RequestBody TestBug testBug,@PathVariable Long id) {
      testBug.setId(id);
      return XfR.ok(testBugServiceImpl.updateById(testBug));
  }

  /**
   * 修改-传入修改的数据testBug
   * @param testBug testBug
   * @return XfR
   */
  @PatchMapping("/testbugs/{id}")
  public XfR patchUpdate(@RequestBody TestBug testBug,@PathVariable Long id) {
      TestBug uptestBug = testBugServiceImpl.getById(id);
      if(uptestBug != null){
        uptestBug = ObjectCopyUtils.copyProperties(testBug,uptestBug,true);
      }
      return XfR.ok(testBugServiceImpl.updateById(uptestBug));
  }

  /**
   * 通过id删除testBug
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/testbugs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(testBugServiceImpl.removeById(id));
  }

  @PostMapping("/testbugs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "test_bug");
     params.put("request", condition);

     return XfR.ok(testBugServiceImpl.querys(params));
  }

}
