package com.xforceplus.arterydocument.controller;


/**
 * 执行任务主表feign客户端
 *
 * @author ultraman
 * @date 2024-09-11
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.arterydocument.entity.ExecutionTask;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "artery-document")
public interface ExecutionTaskFeignApi {

  /**
   * 通过id查询执行任务主表
   * @param  id
   * @return R
   */
  @GetMapping("/executionTask/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增执行任务主表
   * @param executionTask 执行任务主表
   * @return R
   */
  @PostMapping("/executionTask/add")
  public R save(@RequestBody ExecutionTask executionTask);

  /**
   * 修改执行任务主表
   * @param executionTask 执行任务主表
   * @return R
   */
  @PostMapping("/executionTask/update")
  public R updateById(@RequestBody ExecutionTask executionTask);

  /**
   * 通过id删除执行任务主表
   * @param  id
   * @return R
   */
  @DeleteMapping("/executionTask/del/{id}" )
  public R removeById(@PathVariable Long id);

}