package com.xforceplus.arterydocument.controller;


/**
 * POS自动补录feign客户端
 *
 * @author ultraman
 * @date 2024-09-11
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.arterydocument.entity.NewPosBackTracking;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "artery-document")
public interface NewPosBackTrackingFeignApi {

  /**
   * 通过id查询POS自动补录
   * @param  id
   * @return R
   */
  @GetMapping("/newPosBackTracking/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增POS自动补录
   * @param newPosBackTracking POS自动补录
   * @return R
   */
  @PostMapping("/newPosBackTracking/add")
  public R save(@RequestBody NewPosBackTracking newPosBackTracking);

  /**
   * 修改POS自动补录
   * @param newPosBackTracking POS自动补录
   * @return R
   */
  @PostMapping("/newPosBackTracking/update")
  public R updateById(@RequestBody NewPosBackTracking newPosBackTracking);

  /**
   * 通过id删除POS自动补录
   * @param  id
   * @return R
   */
  @DeleteMapping("/newPosBackTracking/del/{id}" )
  public R removeById(@PathVariable Long id);

}