package com.xforceplus.arterydocument.controller;


/**
 * ${table.comment}feign客户端
 *
 * @author ultraman
 * @date 2024-09-11
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.arterydocument.entity.PurchaseOrderStoreDetail;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "artery-document")
public interface PurchaseOrderStoreDetailFeignApi {

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return R
   */
  @GetMapping("/purchaseOrderStoreDetail/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增${table.comment}
   * @param purchaseOrderStoreDetail ${table.comment}
   * @return R
   */
  @PostMapping("/purchaseOrderStoreDetail/add")
  public R save(@RequestBody PurchaseOrderStoreDetail purchaseOrderStoreDetail);

  /**
   * 修改${table.comment}
   * @param purchaseOrderStoreDetail ${table.comment}
   * @return R
   */
  @PostMapping("/purchaseOrderStoreDetail/update")
  public R updateById(@RequestBody PurchaseOrderStoreDetail purchaseOrderStoreDetail);

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return R
   */
  @DeleteMapping("/purchaseOrderStoreDetail/del/{id}" )
  public R removeById(@PathVariable Long id);

}