package com.xforceplus.arterydocument.controller;


/**
 * ${table.comment}feign客户端
 *
 * @author ultraman
 * @date 2024-01-07
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.arterydocument.entity.BusinessTag;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "artery-document")
public interface BusinessTagFeignApi {

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return R
   */
  @GetMapping("/businessTag/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增${table.comment}
   * @param businessTag ${table.comment}
   * @return R
   */
  @PostMapping("/businessTag/add")
  public R save(@RequestBody BusinessTag businessTag);

  /**
   * 修改${table.comment}
   * @param businessTag ${table.comment}
   * @return R
   */
  @PostMapping("/businessTag/update")
  public R updateById(@RequestBody BusinessTag businessTag);

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return R
   */
  @DeleteMapping("/businessTag/del/{id}" )
  public R removeById(@PathVariable Long id);

}