package com.xforceplus.arterydocument.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 单据状态
 * </p>
 *
 * @author ultraman
 * @since 2023-02-08
 */
public enum BillStatus {

    DRAFT("draft", "草稿"),
    CONFIRMED("confirmed", "已提交"),
    DELIVERED("delivered", "已发货");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    BillStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static BillStatus fromCode(String code){
        switch(code) {
            case "draft":
                return DRAFT;
            case "confirmed":
                return CONFIRMED;
            case "delivered":
                return DELIVERED;
            default:
                return null;
        }
    }
}
