package com.xforceplus.arterydocument.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2023-02-08
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class GoodsReceiveNote implements Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 是否是最新版本
   */
  private Boolean latest;

  /**
   * 原始单据Id数组
   */
  private String srcids;

  /**
   * 数据MD5摘要
   */
  private String md5;

  /**
   * 所属租户
   */
  @TableField("belongTenant")
  private String belongTenant;

  /**
   * 商超账号
   */
  @TableField("collectionAccount")
  private String collectionAccount;

  /**
   * 预计到货日期
   */
  @TableField("exceptReceiveDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime exceptReceiveDate;

  /**
   * 实际收货日期
   */
  @TableField("receiveDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime receiveDate;

  /**
   * 物流方式
   */
  @TableField("logisticsType")
  private String logisticsType;

  /**
   * 发货单号
   */
  @TableField("deliverNo")
  private String deliverNo;

  /**
   * 收货单号
   */
  @TableField("receiveNo")
  private String receiveNo;

  /**
   * 版本号
   */
  @TableField("versionNo")
  private String versionNo;

  /**
   * 单据类型
   */
  @TableField("receiptType")
  private String receiptType;

  /**
   * 创建人id
   */
  @TableField("createId")
  private String createId;

  /**
   * 创建人名称
   */
  @TableField("createName")
  private String createName;

  /**
   * 创建日期
   */
  @TableField("createDate")
  private String createDate;

  /**
   * 审核人id
   */
  @TableField("checkerId")
  private String checkerId;

  /**
   * 审核人名称
   */
  @TableField("checkerName")
  private String checkerName;

  /**
   * 审核日期
   */
  @TableField("checkDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime checkDate;

  /**
   * 投单日期
   */
  @TableField("sendDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime sendDate;

  /**
   * 收货单取消日期
   */
  @TableField("grnCancelDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime grnCancelDate;

  /**
   * 订单类型
   */
  @TableField("poType")
  private String poType;

  /**
   * 采购订单编号
   */
  @TableField("poNo")
  private String poNo;

  /**
   * 收货单商品总数
   */
  @TableField("poItemQty")
  private BigDecimal poItemQty;

  /**
   * 收货单总金额
   */
  @TableField("totalAmt")
  private BigDecimal totalAmt;

  /**
   * 收货单不含税金额
   */
  @TableField("totalAmtWithoutTax")
  private BigDecimal totalAmtWithoutTax;

  /**
   * 收货单税额
   */
  @TableField("poTaxAmt")
  private BigDecimal poTaxAmt;

  /**
   * 折扣总金额
   */
  @TableField("discountTotalAmt")
  private BigDecimal discountTotalAmt;

  /**
   * 结算单号
   */
  @TableField("statementNo")
  private String statementNo;

  /**
   * 结算状态
   */
  @TableField("statementStatus")
  private String statementStatus;

  /**
   * 零售商编码
   */
  @TableField("purchaseRetailerId")
  private String purchaseRetailerId;

  /**
   * 零售商描述
   */
  @TableField("purchaseRetailerName")
  private String purchaseRetailerName;

  /**
   * 购方公司名称
   */
  @TableField("purchaseCompanyName")
  private String purchaseCompanyName;

  /**
   * 购方公司编码
   */
  @TableField("purchaseCompanyCode")
  private String purchaseCompanyCode;

  /**
   * 购方统一社会信用代码
   */
  @TableField("purchaseCompanyTaxNo")
  private String purchaseCompanyTaxNo;

  /**
   * 购方接收部门编码
   */
  @TableField("purchaseReceiveOrgCode")
  private String purchaseReceiveOrgCode;

  /**
   * 购方接收部门名称
   */
  @TableField("purchaseReceiveOrgName")
  private String purchaseReceiveOrgName;

  /**
   * 购方门店编码
   */
  @TableField("purchaseStoreCode")
  private String purchaseStoreCode;

  /**
   * 购方门店名称
   */
  @TableField("purchaseStoreName")
  private String purchaseStoreName;

  /**
   * 购方门店地址
   */
  @TableField("purchaseStoreAddress")
  private String purchaseStoreAddress;

  /**
   * 购方门店电话
   */
  @TableField("purchaseStoreTel")
  private String purchaseStoreTel;

  /**
   * 购方门店GLN
   */
  @TableField("purchaseStoreGLN")
  private String purchaseStoreGLN;

  /**
   * 区域编码
   */
  @TableField("regionCode")
  private String regionCode;

  /**
   * 区域名称
   */
  @TableField("regionName")
  private String regionName;

  /**
   * 销方名称
   */
  @TableField("sellerName")
  private String sellerName;

  /**
   * 销方统一社会信用代码
   */
  @TableField("sellerCompanyTaxNo")
  private String sellerCompanyTaxNo;

  /**
   * 销方编码
   */
  @TableField("sellerCode")
  private String sellerCode;

  /**
   * 销方地址
   */
  @TableField("sellerAddress")
  private String sellerAddress;

  /**
   * 销方电话
   */
  @TableField("sellerTel")
  private String sellerTel;

  /**
   * 备注
   */
  private String remark;

  /**
   * 扩展字段_字符串_1
   */
  @TableField("extStr1")
  private String extStr1;

  /**
   * 扩展字段_字符串_2
   */
  @TableField("extStr2")
  private String extStr2;

  /**
   * 扩展字段_字符串_3
   */
  @TableField("extStr3")
  private String extStr3;

  /**
   * 扩展字段_字符串_4
   */
  @TableField("extStr4")
  private String extStr4;

  /**
   * 扩展字段_字符串_5
   */
  @TableField("extStr5")
  private String extStr5;

  /**
   * 扩展字段_字符串_6
   */
  @TableField("extStr6")
  private String extStr6;

  /**
   * 扩展字段_字符串_7
   */
  @TableField("extStr7")
  private String extStr7;

  /**
   * 扩展字段_字符串_8
   */
  @TableField("extStr8")
  private String extStr8;

  /**
   * 扩展字段_字符串_9
   */
  @TableField("extStr9")
  private String extStr9;

  /**
   * 扩展字段_字符串_10
   */
  @TableField("extStr10")
  private String extStr10;

  /**
   * 模版变量Id
   */
  @TableField("vVariableId")
  private String vVariableId;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 收货状态
   */
  @TableField("receiveStatus")
  private String receiveStatus;

  /**
   * 价格方式
   */
  @TableField("priceStatus")
  private String priceStatus;

  /**
   * 转换方式
   */
  @TableField("docTransformer")
  private String docTransformer;

  /**
   * 业务id字段
   */
  @TableField("businessId")
  private Long businessId;

  /**
   * 发货日期
   */
  @TableField("deliveryDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime deliveryDate;

  /**
   * 销方公司编码
   */
  @TableField("sellerCompanyCode")
  private String sellerCompanyCode;

  /**
   * 销方公司名称
   */
  @TableField("sellerCompanyName")
  private String sellerCompanyName;

  /**
   * 销方对账状态
   */
  @TableField("sellerRenconStatus")
  private String sellerRenconStatus;

  /**
   * 销方开票状态
   */
  @TableField("sellerInvoiceStatus")
  private String sellerInvoiceStatus;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("latest", latest);
      map.put("srcids", srcids);
      map.put("md5", md5);
      map.put("belongTenant", belongTenant);
      map.put("collectionAccount", collectionAccount);
      map.put("exceptReceiveDate", BocpGenUtils.toTimestamp(exceptReceiveDate));
      map.put("receiveDate", BocpGenUtils.toTimestamp(receiveDate));
      map.put("logisticsType", logisticsType);
      map.put("deliverNo", deliverNo);
      map.put("receiveNo", receiveNo);
      map.put("versionNo", versionNo);
      map.put("receiptType", receiptType);
      map.put("createId", createId);
      map.put("createName", createName);
      map.put("createDate", createDate);
      map.put("checkerId", checkerId);
      map.put("checkerName", checkerName);
      map.put("checkDate", BocpGenUtils.toTimestamp(checkDate));
      map.put("sendDate", BocpGenUtils.toTimestamp(sendDate));
      map.put("grnCancelDate", BocpGenUtils.toTimestamp(grnCancelDate));
      map.put("poType", poType);
      map.put("poNo", poNo);
      map.put("poItemQty", poItemQty);
      map.put("totalAmt", totalAmt);
      map.put("totalAmtWithoutTax", totalAmtWithoutTax);
      map.put("poTaxAmt", poTaxAmt);
      map.put("discountTotalAmt", discountTotalAmt);
      map.put("statementNo", statementNo);
      map.put("statementStatus", statementStatus);
      map.put("purchaseRetailerId", purchaseRetailerId);
      map.put("purchaseRetailerName", purchaseRetailerName);
      map.put("purchaseCompanyName", purchaseCompanyName);
      map.put("purchaseCompanyCode", purchaseCompanyCode);
      map.put("purchaseCompanyTaxNo", purchaseCompanyTaxNo);
      map.put("purchaseReceiveOrgCode", purchaseReceiveOrgCode);
      map.put("purchaseReceiveOrgName", purchaseReceiveOrgName);
      map.put("purchaseStoreCode", purchaseStoreCode);
      map.put("purchaseStoreName", purchaseStoreName);
      map.put("purchaseStoreAddress", purchaseStoreAddress);
      map.put("purchaseStoreTel", purchaseStoreTel);
      map.put("purchaseStoreGLN", purchaseStoreGLN);
      map.put("regionCode", regionCode);
      map.put("regionName", regionName);
      map.put("sellerName", sellerName);
      map.put("sellerCompanyTaxNo", sellerCompanyTaxNo);
      map.put("sellerCode", sellerCode);
      map.put("sellerAddress", sellerAddress);
      map.put("sellerTel", sellerTel);
      map.put("remark", remark);
      map.put("extStr1", extStr1);
      map.put("extStr2", extStr2);
      map.put("extStr3", extStr3);
      map.put("extStr4", extStr4);
      map.put("extStr5", extStr5);
      map.put("extStr6", extStr6);
      map.put("extStr7", extStr7);
      map.put("extStr8", extStr8);
      map.put("extStr9", extStr9);
      map.put("extStr10", extStr10);
      map.put("vVariableId", vVariableId);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("receiveStatus", receiveStatus);
      map.put("priceStatus", priceStatus);
      map.put("docTransformer", docTransformer);
      map.put("businessId", businessId);
      map.put("deliveryDate", BocpGenUtils.toTimestamp(deliveryDate));
      map.put("sellerCompanyCode", sellerCompanyCode);
      map.put("sellerCompanyName", sellerCompanyName);
      map.put("sellerRenconStatus", sellerRenconStatus);
      map.put("sellerInvoiceStatus", sellerInvoiceStatus);
      return map;
  }

  public static GoodsReceiveNote fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    GoodsReceiveNote entity = new GoodsReceiveNote();
    if(map.containsKey("latest")) {
      Object obj = map.get("latest");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setLatest((Boolean)obj);
        } else if(obj instanceof String) {
          entity.setLatest(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("srcids")) {
      Object obj = map.get("srcids");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSrcids((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("md5")) {
      Object obj = map.get("md5");
      if(obj != null) {
        if(obj instanceof String){
          entity.setMd5((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("belongTenant")) {
      Object obj = map.get("belongTenant");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBelongTenant((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("collectionAccount")) {
      Object obj = map.get("collectionAccount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCollectionAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("exceptReceiveDate")) {
      Object obj = map.get("exceptReceiveDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setExceptReceiveDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setExceptReceiveDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setExceptReceiveDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setExceptReceiveDate(null);
      }
    }
    if(map.containsKey("receiveDate")) {
      Object obj = map.get("receiveDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setReceiveDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setReceiveDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setReceiveDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setReceiveDate(null);
      }
    }
    if(map.containsKey("logisticsType")) {
      Object obj = map.get("logisticsType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setLogisticsType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("deliverNo")) {
      Object obj = map.get("deliverNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeliverNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("receiveNo")) {
      Object obj = map.get("receiveNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setReceiveNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("versionNo")) {
      Object obj = map.get("versionNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setVersionNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("receiptType")) {
      Object obj = map.get("receiptType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setReceiptType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("createId")) {
      Object obj = map.get("createId");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("createName")) {
      Object obj = map.get("createName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("createDate")) {
      Object obj = map.get("createDate");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateDate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("checkerId")) {
      Object obj = map.get("checkerId");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCheckerId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("checkerName")) {
      Object obj = map.get("checkerName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCheckerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("checkDate")) {
      Object obj = map.get("checkDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCheckDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCheckDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCheckDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCheckDate(null);
      }
    }
    if(map.containsKey("sendDate")) {
      Object obj = map.get("sendDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSendDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setSendDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setSendDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setSendDate(null);
      }
    }
    if(map.containsKey("grnCancelDate")) {
      Object obj = map.get("grnCancelDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setGrnCancelDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setGrnCancelDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setGrnCancelDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setGrnCancelDate(null);
      }
    }
    if(map.containsKey("poType")) {
      Object obj = map.get("poType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPoType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("poNo")) {
      Object obj = map.get("poNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPoNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("poItemQty")) {
      Object obj = map.get("poItemQty");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPoItemQty((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPoItemQty(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPoItemQty(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setPoItemQty(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPoItemQty(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("totalAmt")) {
      Object obj = map.get("totalAmt");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTotalAmt((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTotalAmt(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTotalAmt(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setTotalAmt(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTotalAmt(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("totalAmtWithoutTax")) {
      Object obj = map.get("totalAmtWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTotalAmtWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTotalAmtWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTotalAmtWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setTotalAmtWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTotalAmtWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("poTaxAmt")) {
      Object obj = map.get("poTaxAmt");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPoTaxAmt((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPoTaxAmt(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPoTaxAmt(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setPoTaxAmt(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPoTaxAmt(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("discountTotalAmt")) {
      Object obj = map.get("discountTotalAmt");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setDiscountTotalAmt((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setDiscountTotalAmt(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setDiscountTotalAmt(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setDiscountTotalAmt(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setDiscountTotalAmt(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("statementNo")) {
      Object obj = map.get("statementNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setStatementNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("statementStatus")) {
      Object obj = map.get("statementStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setStatementStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseRetailerId")) {
      Object obj = map.get("purchaseRetailerId");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaseRetailerId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseRetailerName")) {
      Object obj = map.get("purchaseRetailerName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaseRetailerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseCompanyName")) {
      Object obj = map.get("purchaseCompanyName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaseCompanyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseCompanyCode")) {
      Object obj = map.get("purchaseCompanyCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaseCompanyCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseCompanyTaxNo")) {
      Object obj = map.get("purchaseCompanyTaxNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaseCompanyTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseReceiveOrgCode")) {
      Object obj = map.get("purchaseReceiveOrgCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaseReceiveOrgCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseReceiveOrgName")) {
      Object obj = map.get("purchaseReceiveOrgName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaseReceiveOrgName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseStoreCode")) {
      Object obj = map.get("purchaseStoreCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaseStoreCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseStoreName")) {
      Object obj = map.get("purchaseStoreName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaseStoreName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseStoreAddress")) {
      Object obj = map.get("purchaseStoreAddress");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaseStoreAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseStoreTel")) {
      Object obj = map.get("purchaseStoreTel");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaseStoreTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseStoreGLN")) {
      Object obj = map.get("purchaseStoreGLN");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaseStoreGLN((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("regionCode")) {
      Object obj = map.get("regionCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRegionCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("regionName")) {
      Object obj = map.get("regionName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRegionName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerName")) {
      Object obj = map.get("sellerName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerCompanyTaxNo")) {
      Object obj = map.get("sellerCompanyTaxNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerCompanyTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerCode")) {
      Object obj = map.get("sellerCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerAddress")) {
      Object obj = map.get("sellerAddress");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerTel")) {
      Object obj = map.get("sellerTel");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("extStr1")) {
      Object obj = map.get("extStr1");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExtStr1((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("extStr2")) {
      Object obj = map.get("extStr2");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExtStr2((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("extStr3")) {
      Object obj = map.get("extStr3");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExtStr3((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("extStr4")) {
      Object obj = map.get("extStr4");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExtStr4((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("extStr5")) {
      Object obj = map.get("extStr5");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExtStr5((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("extStr6")) {
      Object obj = map.get("extStr6");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExtStr6((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("extStr7")) {
      Object obj = map.get("extStr7");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExtStr7((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("extStr8")) {
      Object obj = map.get("extStr8");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExtStr8((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("extStr9")) {
      Object obj = map.get("extStr9");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExtStr9((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("extStr10")) {
      Object obj = map.get("extStr10");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExtStr10((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("vVariableId")) {
      Object obj = map.get("vVariableId");
      if(obj != null) {
        if(obj instanceof String){
          entity.setVVariableId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("receiveStatus")) {
      Object obj = map.get("receiveStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setReceiveStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("priceStatus")) {
      Object obj = map.get("priceStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPriceStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("docTransformer")) {
      Object obj = map.get("docTransformer");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDocTransformer((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("businessId")) {
      Object obj = map.get("businessId");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setBusinessId((Long)obj);
        } else if(obj instanceof String) {
          entity.setBusinessId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setBusinessId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("deliveryDate")) {
      Object obj = map.get("deliveryDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setDeliveryDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setDeliveryDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setDeliveryDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setDeliveryDate(null);
      }
    }
    if(map.containsKey("sellerCompanyCode")) {
      Object obj = map.get("sellerCompanyCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerCompanyCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerCompanyName")) {
      Object obj = map.get("sellerCompanyName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerCompanyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerRenconStatus")) {
      Object obj = map.get("sellerRenconStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerRenconStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerInvoiceStatus")) {
      Object obj = map.get("sellerInvoiceStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerInvoiceStatus((String)obj);
        }
      } else{
      }
    }
    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("latest")) {
      Object obj = map.get("latest");
      if(obj != null) {
        if(obj instanceof Boolean) {
          this.setLatest((Boolean)obj);
        } else if(obj instanceof String) {
          this.setLatest(Boolean.valueOf((String)obj));
        }
      } else {
      }
    }
    if(map.containsKey("srcids")) {
      Object obj = map.get("srcids");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSrcids((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("md5")) {
      Object obj = map.get("md5");
      if(obj != null) {
        if(obj instanceof String) {
          this.setMd5((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("belongTenant")) {
      Object obj = map.get("belongTenant");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBelongTenant((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("collectionAccount")) {
      Object obj = map.get("collectionAccount");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCollectionAccount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("exceptReceiveDate")) {
      Object obj = map.get("exceptReceiveDate");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setExceptReceiveDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setExceptReceiveDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          this.setExceptReceiveDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setExceptReceiveDate(null);
      }
    }
    if(map.containsKey("receiveDate")) {
      Object obj = map.get("receiveDate");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setReceiveDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setReceiveDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          this.setReceiveDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setReceiveDate(null);
      }
    }
    if(map.containsKey("logisticsType")) {
      Object obj = map.get("logisticsType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setLogisticsType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("deliverNo")) {
      Object obj = map.get("deliverNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeliverNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("receiveNo")) {
      Object obj = map.get("receiveNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setReceiveNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("versionNo")) {
      Object obj = map.get("versionNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setVersionNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("receiptType")) {
      Object obj = map.get("receiptType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setReceiptType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("createId")) {
      Object obj = map.get("createId");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("createName")) {
      Object obj = map.get("createName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("createDate")) {
      Object obj = map.get("createDate");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateDate((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("checkerId")) {
      Object obj = map.get("checkerId");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCheckerId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("checkerName")) {
      Object obj = map.get("checkerName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCheckerName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("checkDate")) {
      Object obj = map.get("checkDate");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCheckDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCheckDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          this.setCheckDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCheckDate(null);
      }
    }
    if(map.containsKey("sendDate")) {
      Object obj = map.get("sendDate");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setSendDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setSendDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          this.setSendDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setSendDate(null);
      }
    }
    if(map.containsKey("grnCancelDate")) {
      Object obj = map.get("grnCancelDate");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setGrnCancelDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setGrnCancelDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          this.setGrnCancelDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setGrnCancelDate(null);
      }
    }
    if(map.containsKey("poType")) {
      Object obj = map.get("poType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPoType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("poNo")) {
      Object obj = map.get("poNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPoNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("poItemQty")) {
      Object obj = map.get("poItemQty");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setPoItemQty((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setPoItemQty(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setPoItemQty(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          this.setPoItemQty(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setPoItemQty(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("totalAmt")) {
      Object obj = map.get("totalAmt");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setTotalAmt((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setTotalAmt(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setTotalAmt(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          this.setTotalAmt(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setTotalAmt(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("totalAmtWithoutTax")) {
      Object obj = map.get("totalAmtWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setTotalAmtWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setTotalAmtWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setTotalAmtWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          this.setTotalAmtWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setTotalAmtWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("poTaxAmt")) {
      Object obj = map.get("poTaxAmt");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setPoTaxAmt((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setPoTaxAmt(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setPoTaxAmt(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          this.setPoTaxAmt(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setPoTaxAmt(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("discountTotalAmt")) {
      Object obj = map.get("discountTotalAmt");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setDiscountTotalAmt((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setDiscountTotalAmt(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setDiscountTotalAmt(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          this.setDiscountTotalAmt(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setDiscountTotalAmt(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("statementNo")) {
      Object obj = map.get("statementNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setStatementNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("statementStatus")) {
      Object obj = map.get("statementStatus");
      if(obj != null) {
        if(obj instanceof String) {
          this.setStatementStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaseRetailerId")) {
      Object obj = map.get("purchaseRetailerId");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaseRetailerId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaseRetailerName")) {
      Object obj = map.get("purchaseRetailerName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaseRetailerName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaseCompanyName")) {
      Object obj = map.get("purchaseCompanyName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaseCompanyName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaseCompanyCode")) {
      Object obj = map.get("purchaseCompanyCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaseCompanyCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaseCompanyTaxNo")) {
      Object obj = map.get("purchaseCompanyTaxNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaseCompanyTaxNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaseReceiveOrgCode")) {
      Object obj = map.get("purchaseReceiveOrgCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaseReceiveOrgCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaseReceiveOrgName")) {
      Object obj = map.get("purchaseReceiveOrgName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaseReceiveOrgName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaseStoreCode")) {
      Object obj = map.get("purchaseStoreCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaseStoreCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaseStoreName")) {
      Object obj = map.get("purchaseStoreName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaseStoreName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaseStoreAddress")) {
      Object obj = map.get("purchaseStoreAddress");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaseStoreAddress((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaseStoreTel")) {
      Object obj = map.get("purchaseStoreTel");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaseStoreTel((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaseStoreGLN")) {
      Object obj = map.get("purchaseStoreGLN");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaseStoreGLN((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("regionCode")) {
      Object obj = map.get("regionCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRegionCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("regionName")) {
      Object obj = map.get("regionName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRegionName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerName")) {
      Object obj = map.get("sellerName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerCompanyTaxNo")) {
      Object obj = map.get("sellerCompanyTaxNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerCompanyTaxNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerCode")) {
      Object obj = map.get("sellerCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerAddress")) {
      Object obj = map.get("sellerAddress");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerAddress((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerTel")) {
      Object obj = map.get("sellerTel");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerTel((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRemark((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("extStr1")) {
      Object obj = map.get("extStr1");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExtStr1((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("extStr2")) {
      Object obj = map.get("extStr2");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExtStr2((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("extStr3")) {
      Object obj = map.get("extStr3");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExtStr3((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("extStr4")) {
      Object obj = map.get("extStr4");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExtStr4((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("extStr5")) {
      Object obj = map.get("extStr5");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExtStr5((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("extStr6")) {
      Object obj = map.get("extStr6");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExtStr6((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("extStr7")) {
      Object obj = map.get("extStr7");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExtStr7((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("extStr8")) {
      Object obj = map.get("extStr8");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExtStr8((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("extStr9")) {
      Object obj = map.get("extStr9");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExtStr9((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("extStr10")) {
      Object obj = map.get("extStr10");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExtStr10((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("vVariableId")) {
      Object obj = map.get("vVariableId");
      if(obj != null) {
        if(obj instanceof String) {
          this.setVVariableId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("receiveStatus")) {
      Object obj = map.get("receiveStatus");
      if(obj != null) {
        if(obj instanceof String) {
          this.setReceiveStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("priceStatus")) {
      Object obj = map.get("priceStatus");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPriceStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("docTransformer")) {
      Object obj = map.get("docTransformer");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDocTransformer((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("businessId")) {
      Object obj = map.get("businessId");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setBusinessId((Long)obj);
        } else if(obj instanceof String) {
          this.setBusinessId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setBusinessId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("deliveryDate")) {
      Object obj = map.get("deliveryDate");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setDeliveryDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setDeliveryDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          this.setDeliveryDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setDeliveryDate(null);
      }
    }
    if(map.containsKey("sellerCompanyCode")) {
      Object obj = map.get("sellerCompanyCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerCompanyCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerCompanyName")) {
      Object obj = map.get("sellerCompanyName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerCompanyName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerRenconStatus")) {
      Object obj = map.get("sellerRenconStatus");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerRenconStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerInvoiceStatus")) {
      Object obj = map.get("sellerInvoiceStatus");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerInvoiceStatus((String)obj);
        }
      } else {
      }
    }
  }
}
