package com.xforceplus.arterydocument.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2023-02-08
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class Payment implements Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 所属租户
   */
  @TableField("belongTenant")
  private String belongTenant;

  /**
   * 关联商超账号
   */
  @TableField("collectionAccount")
  private String collectionAccount;

  /**
   * 零售商编码
   */
  @TableField("purchaseRetailerId")
  private String purchaseRetailerId;

  /**
   * 零售商描述
   */
  @TableField("purchaseRetailerName")
  private String purchaseRetailerName;

  /**
   * 付款单头ID
   */
  @TableField("paymentId")
  private String paymentId;

  /**
   * 付款单号
   */
  @TableField("paymentNo")
  private String paymentNo;

  /**
   * 付款单类型
   */
  @TableField("paymentType")
  private String paymentType;

  /**
   * 支付日期
   */
  @TableField("paymentDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime paymentDate;

  /**
   * 结算顺序
   */
  @TableField("settlementSequence")
  private String settlementSequence;

  /**
   * 创建日期
   */
  @TableField("creationDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime creationDate;

  /**
   * 更新日期
   */
  @TableField("updateDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateDate;

  /**
   * 关联红字通知单号
   */
  @TableField("refRedIVNoticeNo")
  private String refRedIVNoticeNo;

  /**
   * 关联凭证编号
   */
  @TableField("refDocumentNo")
  private String refDocumentNo;

  /**
   * 关联采购订单ID
   */
  @TableField("refPOId")
  private String refPOId;

  /**
   * 关联采购订单编号
   */
  @TableField("refPONo")
  private String refPONo;

  /**
   * 关联购方结算单ID
   */
  @TableField("refPurchaseSettlementId")
  private String refPurchaseSettlementId;

  /**
   * 关联购方结算单号
   */
  @TableField("refPurchaseSettlementNo")
  private String refPurchaseSettlementNo;

  /**
   * 关联购方结算清单号
   */
  @TableField("refPurchaseSettlementListNo")
  private String refPurchaseSettlementListNo;

  /**
   * 付款方式
   */
  @TableField("paymentMethod")
  private String paymentMethod;

  /**
   * 付款银行
   */
  @TableField("paymentBank")
  private String paymentBank;

  /**
   * 是否退票
   */
  private String refund;

  /**
   * 到期日
   */
  private String deadline;

  /**
   * 发票号码
   */
  @TableField("invoiceNo")
  private String invoiceNo;

  /**
   * 发票代码
   */
  @TableField("invoiceCode")
  private String invoiceCode;

  /**
   * 发票日期
   */
  @TableField("invoiceDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime invoiceDate;

  /**
   * 随机密码
   */
  @TableField("randomPassword")
  private String randomPassword;

  /**
   * 付款结果
   */
  @TableField("paymentResults")
  private String paymentResults;

  /**
   * 收款方统一社会信用代码
   */
  @TableField("receiverCompanyTaxNo")
  private String receiverCompanyTaxNo;

  /**
   * 收款方公司编码
   */
  @TableField("receiverCompanyCode")
  private String receiverCompanyCode;

  /**
   * 收款方公司名称
   */
  @TableField("receiverCompanyName")
  private String receiverCompanyName;

  /**
   * 销方销售组编码
   */
  @TableField("sellerSalesGroupCode")
  private String sellerSalesGroupCode;

  /**
   * 销方销售组名称
   */
  @TableField("sellerSalesGroupName")
  private String sellerSalesGroupName;

  /**
   * 付款方公司编码
   */
  @TableField("payCompanyCode")
  private String payCompanyCode;

  /**
   * 付款方公司名称
   */
  @TableField("payCompanyName")
  private String payCompanyName;

  /**
   * 付款方统一社会信用代码
   */
  @TableField("payCompanyTaxNo")
  private String payCompanyTaxNo;

  /**
   * 支付金额
   */
  @TableField("payAmount")
  private BigDecimal payAmount;

  /**
   * 应付金额
   */
  @TableField("payableAmount")
  private BigDecimal payableAmount;

  /**
   * 已付金额
   */
  @TableField("paidAmont")
  private BigDecimal paidAmont;

  /**
   * 剩余可付
   */
  @TableField("remainingPayable")
  private BigDecimal remainingPayable;

  /**
   * 销方冲账状态
   */
  @TableField("sellerOffsetStatus")
  private String sellerOffsetStatus;

  /**
   * 备注
   */
  private String remark;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 是否是最新版本
   */
  private Boolean latest;

  /**
   * 原始单据Id数组
   */
  private String srcids;

  /**
   * 数据MD5摘要
   */
  private String md5;

  /**
   * 版本号
   */
  @TableField("versionNo")
  private String versionNo;

  /**
   * 模版变量Id
   */
  private String vvariableid;

  /**
   * 转换方式信息
   */
  @TableField("docTransformer")
  private String docTransformer;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("belongTenant", belongTenant);
      map.put("collectionAccount", collectionAccount);
      map.put("purchaseRetailerId", purchaseRetailerId);
      map.put("purchaseRetailerName", purchaseRetailerName);
      map.put("paymentId", paymentId);
      map.put("paymentNo", paymentNo);
      map.put("paymentType", paymentType);
      map.put("paymentDate", BocpGenUtils.toTimestamp(paymentDate));
      map.put("settlementSequence", settlementSequence);
      map.put("creationDate", BocpGenUtils.toTimestamp(creationDate));
      map.put("updateDate", BocpGenUtils.toTimestamp(updateDate));
      map.put("refRedIVNoticeNo", refRedIVNoticeNo);
      map.put("refDocumentNo", refDocumentNo);
      map.put("refPOId", refPOId);
      map.put("refPONo", refPONo);
      map.put("refPurchaseSettlementId", refPurchaseSettlementId);
      map.put("refPurchaseSettlementNo", refPurchaseSettlementNo);
      map.put("refPurchaseSettlementListNo", refPurchaseSettlementListNo);
      map.put("paymentMethod", paymentMethod);
      map.put("paymentBank", paymentBank);
      map.put("refund", refund);
      map.put("deadline", deadline);
      map.put("invoiceNo", invoiceNo);
      map.put("invoiceCode", invoiceCode);
      map.put("invoiceDate", BocpGenUtils.toTimestamp(invoiceDate));
      map.put("randomPassword", randomPassword);
      map.put("paymentResults", paymentResults);
      map.put("receiverCompanyTaxNo", receiverCompanyTaxNo);
      map.put("receiverCompanyCode", receiverCompanyCode);
      map.put("receiverCompanyName", receiverCompanyName);
      map.put("sellerSalesGroupCode", sellerSalesGroupCode);
      map.put("sellerSalesGroupName", sellerSalesGroupName);
      map.put("payCompanyCode", payCompanyCode);
      map.put("payCompanyName", payCompanyName);
      map.put("payCompanyTaxNo", payCompanyTaxNo);
      map.put("payAmount", payAmount);
      map.put("payableAmount", payableAmount);
      map.put("paidAmont", paidAmont);
      map.put("remainingPayable", remainingPayable);
      map.put("sellerOffsetStatus", sellerOffsetStatus);
      map.put("remark", remark);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("latest", latest);
      map.put("srcids", srcids);
      map.put("md5", md5);
      map.put("versionNo", versionNo);
      map.put("vvariableid", vvariableid);
      map.put("docTransformer", docTransformer);
      return map;
  }

  public static Payment fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    Payment entity = new Payment();
    if(map.containsKey("belongTenant")) {
      Object obj = map.get("belongTenant");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBelongTenant((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("collectionAccount")) {
      Object obj = map.get("collectionAccount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCollectionAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseRetailerId")) {
      Object obj = map.get("purchaseRetailerId");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaseRetailerId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseRetailerName")) {
      Object obj = map.get("purchaseRetailerName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaseRetailerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paymentId")) {
      Object obj = map.get("paymentId");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPaymentId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paymentNo")) {
      Object obj = map.get("paymentNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPaymentNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paymentType")) {
      Object obj = map.get("paymentType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPaymentType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paymentDate")) {
      Object obj = map.get("paymentDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPaymentDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setPaymentDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setPaymentDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setPaymentDate(null);
      }
    }
    if(map.containsKey("settlementSequence")) {
      Object obj = map.get("settlementSequence");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSettlementSequence((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("creationDate")) {
      Object obj = map.get("creationDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreationDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreationDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreationDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreationDate(null);
      }
    }
    if(map.containsKey("updateDate")) {
      Object obj = map.get("updateDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateDate(null);
      }
    }
    if(map.containsKey("refRedIVNoticeNo")) {
      Object obj = map.get("refRedIVNoticeNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRefRedIVNoticeNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("refDocumentNo")) {
      Object obj = map.get("refDocumentNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRefDocumentNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("refPOId")) {
      Object obj = map.get("refPOId");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRefPOId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("refPONo")) {
      Object obj = map.get("refPONo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRefPONo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("refPurchaseSettlementId")) {
      Object obj = map.get("refPurchaseSettlementId");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRefPurchaseSettlementId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("refPurchaseSettlementNo")) {
      Object obj = map.get("refPurchaseSettlementNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRefPurchaseSettlementNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("refPurchaseSettlementListNo")) {
      Object obj = map.get("refPurchaseSettlementListNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRefPurchaseSettlementListNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paymentMethod")) {
      Object obj = map.get("paymentMethod");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPaymentMethod((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paymentBank")) {
      Object obj = map.get("paymentBank");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPaymentBank((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("refund")) {
      Object obj = map.get("refund");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRefund((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("deadline")) {
      Object obj = map.get("deadline");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeadline((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceNo")) {
      Object obj = map.get("invoiceNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceCode")) {
      Object obj = map.get("invoiceCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceDate")) {
      Object obj = map.get("invoiceDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setInvoiceDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setInvoiceDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setInvoiceDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setInvoiceDate(null);
      }
    }
    if(map.containsKey("randomPassword")) {
      Object obj = map.get("randomPassword");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRandomPassword((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("paymentResults")) {
      Object obj = map.get("paymentResults");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPaymentResults((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("receiverCompanyTaxNo")) {
      Object obj = map.get("receiverCompanyTaxNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setReceiverCompanyTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("receiverCompanyCode")) {
      Object obj = map.get("receiverCompanyCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setReceiverCompanyCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("receiverCompanyName")) {
      Object obj = map.get("receiverCompanyName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setReceiverCompanyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerSalesGroupCode")) {
      Object obj = map.get("sellerSalesGroupCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerSalesGroupCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerSalesGroupName")) {
      Object obj = map.get("sellerSalesGroupName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerSalesGroupName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("payCompanyCode")) {
      Object obj = map.get("payCompanyCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPayCompanyCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("payCompanyName")) {
      Object obj = map.get("payCompanyName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPayCompanyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("payCompanyTaxNo")) {
      Object obj = map.get("payCompanyTaxNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPayCompanyTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("payAmount")) {
      Object obj = map.get("payAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPayAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPayAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPayAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setPayAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPayAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("payableAmount")) {
      Object obj = map.get("payableAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPayableAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPayableAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPayableAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setPayableAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPayableAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("paidAmont")) {
      Object obj = map.get("paidAmont");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPaidAmont((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPaidAmont(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPaidAmont(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setPaidAmont(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPaidAmont(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("remainingPayable")) {
      Object obj = map.get("remainingPayable");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setRemainingPayable((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setRemainingPayable(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setRemainingPayable(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setRemainingPayable(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setRemainingPayable(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("sellerOffsetStatus")) {
      Object obj = map.get("sellerOffsetStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSellerOffsetStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("latest")) {
      Object obj = map.get("latest");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setLatest((Boolean)obj);
        } else if(obj instanceof String) {
          entity.setLatest(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("srcids")) {
      Object obj = map.get("srcids");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSrcids((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("md5")) {
      Object obj = map.get("md5");
      if(obj != null) {
        if(obj instanceof String){
          entity.setMd5((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("versionNo")) {
      Object obj = map.get("versionNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setVersionNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("vvariableid")) {
      Object obj = map.get("vvariableid");
      if(obj != null) {
        if(obj instanceof String){
          entity.setVvariableid((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("docTransformer")) {
      Object obj = map.get("docTransformer");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDocTransformer((String)obj);
        }
      } else{
      }
    }
    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("belongTenant")) {
      Object obj = map.get("belongTenant");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBelongTenant((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("collectionAccount")) {
      Object obj = map.get("collectionAccount");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCollectionAccount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaseRetailerId")) {
      Object obj = map.get("purchaseRetailerId");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaseRetailerId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaseRetailerName")) {
      Object obj = map.get("purchaseRetailerName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaseRetailerName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("paymentId")) {
      Object obj = map.get("paymentId");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPaymentId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("paymentNo")) {
      Object obj = map.get("paymentNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPaymentNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("paymentType")) {
      Object obj = map.get("paymentType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPaymentType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("paymentDate")) {
      Object obj = map.get("paymentDate");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setPaymentDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setPaymentDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          this.setPaymentDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setPaymentDate(null);
      }
    }
    if(map.containsKey("settlementSequence")) {
      Object obj = map.get("settlementSequence");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSettlementSequence((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("creationDate")) {
      Object obj = map.get("creationDate");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreationDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreationDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          this.setCreationDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreationDate(null);
      }
    }
    if(map.containsKey("updateDate")) {
      Object obj = map.get("updateDate");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          this.setUpdateDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateDate(null);
      }
    }
    if(map.containsKey("refRedIVNoticeNo")) {
      Object obj = map.get("refRedIVNoticeNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRefRedIVNoticeNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("refDocumentNo")) {
      Object obj = map.get("refDocumentNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRefDocumentNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("refPOId")) {
      Object obj = map.get("refPOId");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRefPOId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("refPONo")) {
      Object obj = map.get("refPONo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRefPONo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("refPurchaseSettlementId")) {
      Object obj = map.get("refPurchaseSettlementId");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRefPurchaseSettlementId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("refPurchaseSettlementNo")) {
      Object obj = map.get("refPurchaseSettlementNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRefPurchaseSettlementNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("refPurchaseSettlementListNo")) {
      Object obj = map.get("refPurchaseSettlementListNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRefPurchaseSettlementListNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("paymentMethod")) {
      Object obj = map.get("paymentMethod");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPaymentMethod((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("paymentBank")) {
      Object obj = map.get("paymentBank");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPaymentBank((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("refund")) {
      Object obj = map.get("refund");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRefund((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("deadline")) {
      Object obj = map.get("deadline");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeadline((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoiceNo")) {
      Object obj = map.get("invoiceNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoiceCode")) {
      Object obj = map.get("invoiceCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoiceDate")) {
      Object obj = map.get("invoiceDate");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setInvoiceDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setInvoiceDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          this.setInvoiceDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setInvoiceDate(null);
      }
    }
    if(map.containsKey("randomPassword")) {
      Object obj = map.get("randomPassword");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRandomPassword((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("paymentResults")) {
      Object obj = map.get("paymentResults");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPaymentResults((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("receiverCompanyTaxNo")) {
      Object obj = map.get("receiverCompanyTaxNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setReceiverCompanyTaxNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("receiverCompanyCode")) {
      Object obj = map.get("receiverCompanyCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setReceiverCompanyCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("receiverCompanyName")) {
      Object obj = map.get("receiverCompanyName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setReceiverCompanyName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerSalesGroupCode")) {
      Object obj = map.get("sellerSalesGroupCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerSalesGroupCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerSalesGroupName")) {
      Object obj = map.get("sellerSalesGroupName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerSalesGroupName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("payCompanyCode")) {
      Object obj = map.get("payCompanyCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPayCompanyCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("payCompanyName")) {
      Object obj = map.get("payCompanyName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPayCompanyName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("payCompanyTaxNo")) {
      Object obj = map.get("payCompanyTaxNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPayCompanyTaxNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("payAmount")) {
      Object obj = map.get("payAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setPayAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setPayAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setPayAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          this.setPayAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setPayAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("payableAmount")) {
      Object obj = map.get("payableAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setPayableAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setPayableAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setPayableAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          this.setPayableAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setPayableAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("paidAmont")) {
      Object obj = map.get("paidAmont");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setPaidAmont((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setPaidAmont(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setPaidAmont(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          this.setPaidAmont(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setPaidAmont(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("remainingPayable")) {
      Object obj = map.get("remainingPayable");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setRemainingPayable((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setRemainingPayable(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setRemainingPayable(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          this.setRemainingPayable(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setRemainingPayable(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("sellerOffsetStatus")) {
      Object obj = map.get("sellerOffsetStatus");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerOffsetStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRemark((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("latest")) {
      Object obj = map.get("latest");
      if(obj != null) {
        if(obj instanceof Boolean) {
          this.setLatest((Boolean)obj);
        } else if(obj instanceof String) {
          this.setLatest(Boolean.valueOf((String)obj));
        }
      } else {
      }
    }
    if(map.containsKey("srcids")) {
      Object obj = map.get("srcids");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSrcids((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("md5")) {
      Object obj = map.get("md5");
      if(obj != null) {
        if(obj instanceof String) {
          this.setMd5((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("versionNo")) {
      Object obj = map.get("versionNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setVersionNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("vvariableid")) {
      Object obj = map.get("vvariableid");
      if(obj != null) {
        if(obj instanceof String) {
          this.setVvariableid((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("docTransformer")) {
      Object obj = map.get("docTransformer");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDocTransformer((String)obj);
        }
      } else {
      }
    }
  }
}
