package com.xforceplus.arterydocument.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * OQSSDK运维工具操作记录
 * </p>
 *
 * @author ultraman
 * @since 2023-04-23
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class OqsengineSdkOmAuditLog implements Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 用户ID
   */
  private Long operatorId;

  /**
   * 操作代码
   */
  private String operatorCode;

  /**
   * 操作名称
   */
  private String operatorName;

  /**
   * 操作类型
   */
  private String operateType;

  /**
   * 操作时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime operateTime;

  /**
   * 应用ID
   */
  private Long appId;

  /**
   * 应用代码
   */
  private String appCode;

  /**
   * 对象ID
   */
  private Long boId;

  /**
   * 对象代码
   */
  private String boCode;

  /**
   * 对象名称
   */
  private String boName;

  /**
   * 应用ID
   */
  private Long entityId;

  /**
   * 请求数据
   */
  private String requestData;

  /**
   * 响应数据
   */
  private String responseData;

  /**
   * 备注
   */
  private String remark;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("operator_id", operatorId);
      map.put("operator_code", operatorCode);
      map.put("operator_name", operatorName);
      map.put("operate_type", operateType);
      map.put("operate_time", BocpGenUtils.toTimestamp(operateTime));
      map.put("app_id", appId);
      map.put("app_code", appCode);
      map.put("bo_id", boId);
      map.put("bo_code", boCode);
      map.put("bo_name", boName);
      map.put("entity_id", entityId);
      map.put("request_data", requestData);
      map.put("response_data", responseData);
      map.put("remark", remark);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      return map;
  }

  public static OqsengineSdkOmAuditLog fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    OqsengineSdkOmAuditLog entity = new OqsengineSdkOmAuditLog();
    if(map.containsKey("operator_id")) {
      Object obj = map.get("operator_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setOperatorId((Long)obj);
        } else if(obj instanceof String) {
          entity.setOperatorId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setOperatorId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("operator_code")) {
      Object obj = map.get("operator_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOperatorCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("operator_name")) {
      Object obj = map.get("operator_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOperatorName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("operate_type")) {
      Object obj = map.get("operate_type");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOperateType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("operate_time")) {
      Object obj = map.get("operate_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setOperateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setOperateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setOperateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setOperateTime(null);
      }
    }
    if(map.containsKey("app_id")) {
      Object obj = map.get("app_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setAppId((Long)obj);
        } else if(obj instanceof String) {
          entity.setAppId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAppId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("app_code")) {
      Object obj = map.get("app_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAppCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bo_id")) {
      Object obj = map.get("bo_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setBoId((Long)obj);
        } else if(obj instanceof String) {
          entity.setBoId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setBoId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("bo_code")) {
      Object obj = map.get("bo_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBoCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bo_name")) {
      Object obj = map.get("bo_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBoName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("entity_id")) {
      Object obj = map.get("entity_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setEntityId((Long)obj);
        } else if(obj instanceof String) {
          entity.setEntityId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setEntityId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("request_data")) {
      Object obj = map.get("request_data");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRequestData((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("response_data")) {
      Object obj = map.get("response_data");
      if(obj != null) {
        if(obj instanceof String){
          entity.setResponseData((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("operator_id")) {
      Object obj = map.get("operator_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setOperatorId((Long)obj);
        } else if(obj instanceof String) {
          this.setOperatorId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setOperatorId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("operator_code")) {
      Object obj = map.get("operator_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOperatorCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("operator_name")) {
      Object obj = map.get("operator_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOperatorName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("operate_type")) {
      Object obj = map.get("operate_type");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOperateType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("operate_time")) {
      Object obj = map.get("operate_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setOperateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setOperateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          this.setOperateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setOperateTime(null);
      }
    }
    if(map.containsKey("app_id")) {
      Object obj = map.get("app_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setAppId((Long)obj);
        } else if(obj instanceof String) {
          this.setAppId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setAppId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("app_code")) {
      Object obj = map.get("app_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAppCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("bo_id")) {
      Object obj = map.get("bo_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setBoId((Long)obj);
        } else if(obj instanceof String) {
          this.setBoId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setBoId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("bo_code")) {
      Object obj = map.get("bo_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBoCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("bo_name")) {
      Object obj = map.get("bo_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBoName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("entity_id")) {
      Object obj = map.get("entity_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setEntityId((Long)obj);
        } else if(obj instanceof String) {
          this.setEntityId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setEntityId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("request_data")) {
      Object obj = map.get("request_data");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRequestData((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("response_data")) {
      Object obj = map.get("response_data");
      if(obj != null) {
        if(obj instanceof String) {
          this.setResponseData((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRemark((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
  }
}
