package com.xforceplus.arterydocument.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2023-04-23
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class PurchaseOrderDetail implements Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 行编号
   */
  @TableField("lineNo")
  private String lineNo;

  /**
   * 订货通知单号
   */
  @TableField("poNoticeNo")
  private String poNoticeNo;

  /**
   * 行创建日期
   */
  @TableField("lineCreateDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime lineCreateDate;

  /**
   * 行更新日期
   */
  @TableField("lineUpdateDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime lineUpdateDate;

  /**
   * 行取消日期
   */
  @TableField("lineCancelDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime lineCancelDate;

  /**
   * 状态
   */
  @TableField("lineStatus")
  private String lineStatus;

  /**
   * 商品大类
   */
  @TableField("firstCategory")
  private String firstCategory;

  /**
   * 商品中类
   */
  @TableField("secCategory")
  private String secCategory;

  /**
   * 商品小类
   */
  @TableField("thirdCategory")
  private String thirdCategory;

  /**
   * 商品名称
   */
  @TableField("itemDesc")
  private String itemDesc;

  /**
   * 商品编码
   */
  @TableField("itemCode")
  private String itemCode;

  /**
   * 商品条码
   */
  private String barcode;

  /**
   * 商品子编码
   */
  @TableField("itemSubCode")
  private String itemSubCode;

  /**
   * 品牌
   */
  private String brand;

  /**
   * 规格
   */
  private String standards;

  /**
   * 型号
   */
  private String model;

  /**
   * 颜色
   */
  private String color;

  /**
   * 尺寸
   */
  private String size;

  /**
   * 产地
   */
  @TableField("produceArea")
  private String produceArea;

  /**
   * 保质期
   */
  @TableField("guaranteePeriod")
  private String guaranteePeriod;

  /**
   * 净重量
   */
  @TableField("netWeight")
  private String netWeight;

  /**
   * 总重量
   */
  @TableField("totalWeight")
  private String totalWeight;

  /**
   * 体积
   */
  private String volume;

  /**
   * 体积单位
   */
  @TableField("volumeUnit")
  private String volumeUnit;

  /**
   * 批量包装规格
   */
  @TableField("packageSize")
  private String packageSize;

  /**
   * 批量包装数量
   */
  @TableField("packageQty")
  private BigDecimal packageQty;

  /**
   * 批量包装单位
   */
  @TableField("packageUnit")
  private String packageUnit;

  /**
   * 批量包装单价
   */
  @TableField("packageUnitPrice")
  private BigDecimal packageUnitPrice;

  /**
   * 供应商商品编码
   */
  @TableField("cusItemCode")
  private String cusItemCode;

  /**
   * 基本单位
   */
  private String unit;

  /**
   * 基本单位数量
   */
  private BigDecimal qty;

  /**
   * 进单价（不含税）
   */
  @TableField("unitPriceWithoutTax")
  private BigDecimal unitPriceWithoutTax;

  /**
   * 进单价（含税）
   */
  @TableField("unitPriceWithTax")
  private BigDecimal unitPriceWithTax;

  /**
   * 价格方式
   */
  @TableField("priceStatus")
  private BigDecimal priceStatus;

  /**
   * 物流发货单号
   */
  @TableField("shipmentNo")
  private String shipmentNo;

  /**
   * 发货日期
   */
  @TableField("deliveryDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime deliveryDate;

  /**
   * 发运方式
   */
  @TableField("shipMethod")
  private String shipMethod;

  /**
   * 接收数量
   */
  @TableField("receiveQty")
  private BigDecimal receiveQty;

  /**
   * 接收允差
   */
  @TableField("receiveTolerance")
  private BigDecimal receiveTolerance;

  /**
   * 接收方式
   */
  @TableField("receiveMethod")
  private String receiveMethod;

  /**
   * 库房
   */
  private String inventory;

  /**
   * 库位
   */
  private String location;

  /**
   * 存放组
   */
  @TableField("storageGroup")
  private String storageGroup;

  /**
   * 税收分类
   */
  @TableField("taxType")
  private String taxType;

  /**
   * 税率
   */
  @TableField("taxRate")
  private BigDecimal taxRate;

  /**
   * 折扣率
   */
  @TableField("discountRate")
  private BigDecimal discountRate;

  /**
   * 折扣金额
   */
  @TableField("discountAmt")
  private BigDecimal discountAmt;

  /**
   * 是否促销
   */
  @TableField("promtFlag")
  private String promtFlag;

  /**
   * 是否赠品
   */
  @TableField("freeFlag")
  private String freeFlag;

  /**
   * 赠品数量
   */
  @TableField("freeQty")
  private BigDecimal freeQty;

  /**
   * 最低起订含税金额
   */
  @TableField("minOrdAmt")
  private BigDecimal minOrdAmt;

  /**
   * 最低起订量
   */
  @TableField("minOrdQty")
  private BigDecimal minOrdQty;

  /**
   * 备注
   */
  private String remark;

  /**
   * 模版变量Id
   */
  private String vvariableid;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 含税标识
   */
  @TableField("taxStatus")
  private String taxStatus;

  /**
   * 进价总额（不含税）
   */
  @TableField("amountWithoutTax")
  private BigDecimal amountWithoutTax;

  /**
   * 进价总额（含税）
   */
  @TableField("amountWithTax")
  private BigDecimal amountWithTax;

  /**
   * 本币进价总额（不含税）
   */
  @TableField("amountWithoutTaxDc")
  private BigDecimal amountWithoutTaxDc;

  /**
   * 本币进价总额（含税）
   */
  @TableField("amountWithTaxDc")
  private BigDecimal amountWithTaxDc;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("lineNo", lineNo);
      map.put("poNoticeNo", poNoticeNo);
      map.put("lineCreateDate", BocpGenUtils.toTimestamp(lineCreateDate));
      map.put("lineUpdateDate", BocpGenUtils.toTimestamp(lineUpdateDate));
      map.put("lineCancelDate", BocpGenUtils.toTimestamp(lineCancelDate));
      map.put("lineStatus", lineStatus);
      map.put("firstCategory", firstCategory);
      map.put("secCategory", secCategory);
      map.put("thirdCategory", thirdCategory);
      map.put("itemDesc", itemDesc);
      map.put("itemCode", itemCode);
      map.put("barcode", barcode);
      map.put("itemSubCode", itemSubCode);
      map.put("brand", brand);
      map.put("standards", standards);
      map.put("model", model);
      map.put("color", color);
      map.put("size", size);
      map.put("produceArea", produceArea);
      map.put("guaranteePeriod", guaranteePeriod);
      map.put("netWeight", netWeight);
      map.put("totalWeight", totalWeight);
      map.put("volume", volume);
      map.put("volumeUnit", volumeUnit);
      map.put("packageSize", packageSize);
      map.put("packageQty", packageQty);
      map.put("packageUnit", packageUnit);
      map.put("packageUnitPrice", packageUnitPrice);
      map.put("cusItemCode", cusItemCode);
      map.put("unit", unit);
      map.put("qty", qty);
      map.put("unitPriceWithoutTax", unitPriceWithoutTax);
      map.put("unitPriceWithTax", unitPriceWithTax);
      map.put("priceStatus", priceStatus);
      map.put("shipmentNo", shipmentNo);
      map.put("deliveryDate", BocpGenUtils.toTimestamp(deliveryDate));
      map.put("shipMethod", shipMethod);
      map.put("receiveQty", receiveQty);
      map.put("receiveTolerance", receiveTolerance);
      map.put("receiveMethod", receiveMethod);
      map.put("inventory", inventory);
      map.put("location", location);
      map.put("storageGroup", storageGroup);
      map.put("taxType", taxType);
      map.put("taxRate", taxRate);
      map.put("discountRate", discountRate);
      map.put("discountAmt", discountAmt);
      map.put("promtFlag", promtFlag);
      map.put("freeFlag", freeFlag);
      map.put("freeQty", freeQty);
      map.put("minOrdAmt", minOrdAmt);
      map.put("minOrdQty", minOrdQty);
      map.put("remark", remark);
      map.put("vvariableid", vvariableid);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("taxStatus", taxStatus);
      map.put("amountWithoutTax", amountWithoutTax);
      map.put("amountWithTax", amountWithTax);
      map.put("amountWithoutTaxDc", amountWithoutTaxDc);
      map.put("amountWithTaxDc", amountWithTaxDc);
      return map;
  }

  public static PurchaseOrderDetail fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    PurchaseOrderDetail entity = new PurchaseOrderDetail();
    if(map.containsKey("lineNo")) {
      Object obj = map.get("lineNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setLineNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("poNoticeNo")) {
      Object obj = map.get("poNoticeNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPoNoticeNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("lineCreateDate")) {
      Object obj = map.get("lineCreateDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setLineCreateDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setLineCreateDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setLineCreateDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setLineCreateDate(null);
      }
    }
    if(map.containsKey("lineUpdateDate")) {
      Object obj = map.get("lineUpdateDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setLineUpdateDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setLineUpdateDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setLineUpdateDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setLineUpdateDate(null);
      }
    }
    if(map.containsKey("lineCancelDate")) {
      Object obj = map.get("lineCancelDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setLineCancelDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setLineCancelDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setLineCancelDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setLineCancelDate(null);
      }
    }
    if(map.containsKey("lineStatus")) {
      Object obj = map.get("lineStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setLineStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("firstCategory")) {
      Object obj = map.get("firstCategory");
      if(obj != null) {
        if(obj instanceof String){
          entity.setFirstCategory((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("secCategory")) {
      Object obj = map.get("secCategory");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSecCategory((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("thirdCategory")) {
      Object obj = map.get("thirdCategory");
      if(obj != null) {
        if(obj instanceof String){
          entity.setThirdCategory((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("itemDesc")) {
      Object obj = map.get("itemDesc");
      if(obj != null) {
        if(obj instanceof String){
          entity.setItemDesc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("itemCode")) {
      Object obj = map.get("itemCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setItemCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("barcode")) {
      Object obj = map.get("barcode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBarcode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("itemSubCode")) {
      Object obj = map.get("itemSubCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setItemSubCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("brand")) {
      Object obj = map.get("brand");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBrand((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("standards")) {
      Object obj = map.get("standards");
      if(obj != null) {
        if(obj instanceof String){
          entity.setStandards((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("model")) {
      Object obj = map.get("model");
      if(obj != null) {
        if(obj instanceof String){
          entity.setModel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("color")) {
      Object obj = map.get("color");
      if(obj != null) {
        if(obj instanceof String){
          entity.setColor((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("size")) {
      Object obj = map.get("size");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSize((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("produceArea")) {
      Object obj = map.get("produceArea");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProduceArea((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("guaranteePeriod")) {
      Object obj = map.get("guaranteePeriod");
      if(obj != null) {
        if(obj instanceof String){
          entity.setGuaranteePeriod((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("netWeight")) {
      Object obj = map.get("netWeight");
      if(obj != null) {
        if(obj instanceof String){
          entity.setNetWeight((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("totalWeight")) {
      Object obj = map.get("totalWeight");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTotalWeight((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("volume")) {
      Object obj = map.get("volume");
      if(obj != null) {
        if(obj instanceof String){
          entity.setVolume((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("volumeUnit")) {
      Object obj = map.get("volumeUnit");
      if(obj != null) {
        if(obj instanceof String){
          entity.setVolumeUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("packageSize")) {
      Object obj = map.get("packageSize");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPackageSize((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("packageQty")) {
      Object obj = map.get("packageQty");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPackageQty((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPackageQty(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPackageQty(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setPackageQty(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPackageQty(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("packageUnit")) {
      Object obj = map.get("packageUnit");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPackageUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("packageUnitPrice")) {
      Object obj = map.get("packageUnitPrice");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPackageUnitPrice((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPackageUnitPrice(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPackageUnitPrice(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setPackageUnitPrice(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPackageUnitPrice(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("cusItemCode")) {
      Object obj = map.get("cusItemCode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCusItemCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("unit")) {
      Object obj = map.get("unit");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("qty")) {
      Object obj = map.get("qty");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setQty((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setQty(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setQty(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setQty(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setQty(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("unitPriceWithoutTax")) {
      Object obj = map.get("unitPriceWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setUnitPriceWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setUnitPriceWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setUnitPriceWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setUnitPriceWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUnitPriceWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("unitPriceWithTax")) {
      Object obj = map.get("unitPriceWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setUnitPriceWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setUnitPriceWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setUnitPriceWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setUnitPriceWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUnitPriceWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("priceStatus")) {
      Object obj = map.get("priceStatus");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPriceStatus((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPriceStatus(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPriceStatus(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setPriceStatus(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPriceStatus(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("shipmentNo")) {
      Object obj = map.get("shipmentNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setShipmentNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("deliveryDate")) {
      Object obj = map.get("deliveryDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setDeliveryDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setDeliveryDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setDeliveryDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setDeliveryDate(null);
      }
    }
    if(map.containsKey("shipMethod")) {
      Object obj = map.get("shipMethod");
      if(obj != null) {
        if(obj instanceof String){
          entity.setShipMethod((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("receiveQty")) {
      Object obj = map.get("receiveQty");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setReceiveQty((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setReceiveQty(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setReceiveQty(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setReceiveQty(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setReceiveQty(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("receiveTolerance")) {
      Object obj = map.get("receiveTolerance");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setReceiveTolerance((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setReceiveTolerance(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setReceiveTolerance(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setReceiveTolerance(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setReceiveTolerance(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("receiveMethod")) {
      Object obj = map.get("receiveMethod");
      if(obj != null) {
        if(obj instanceof String){
          entity.setReceiveMethod((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("inventory")) {
      Object obj = map.get("inventory");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInventory((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("location")) {
      Object obj = map.get("location");
      if(obj != null) {
        if(obj instanceof String){
          entity.setLocation((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("storageGroup")) {
      Object obj = map.get("storageGroup");
      if(obj != null) {
        if(obj instanceof String){
          entity.setStorageGroup((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxType")) {
      Object obj = map.get("taxType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTaxType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxRate")) {
      Object obj = map.get("taxRate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTaxRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTaxRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTaxRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setTaxRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTaxRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("discountRate")) {
      Object obj = map.get("discountRate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setDiscountRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setDiscountRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setDiscountRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setDiscountRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setDiscountRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("discountAmt")) {
      Object obj = map.get("discountAmt");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setDiscountAmt((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setDiscountAmt(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setDiscountAmt(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setDiscountAmt(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setDiscountAmt(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("promtFlag")) {
      Object obj = map.get("promtFlag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPromtFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("freeFlag")) {
      Object obj = map.get("freeFlag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setFreeFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("freeQty")) {
      Object obj = map.get("freeQty");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setFreeQty((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setFreeQty(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setFreeQty(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setFreeQty(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setFreeQty(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("minOrdAmt")) {
      Object obj = map.get("minOrdAmt");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setMinOrdAmt((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setMinOrdAmt(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setMinOrdAmt(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setMinOrdAmt(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setMinOrdAmt(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("minOrdQty")) {
      Object obj = map.get("minOrdQty");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setMinOrdQty((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setMinOrdQty(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setMinOrdQty(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setMinOrdQty(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setMinOrdQty(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("vvariableid")) {
      Object obj = map.get("vvariableid");
      if(obj != null) {
        if(obj instanceof String){
          entity.setVvariableid((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxStatus")) {
      Object obj = map.get("taxStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTaxStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("amountWithoutTax")) {
      Object obj = map.get("amountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("amountWithTax")) {
      Object obj = map.get("amountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("amountWithoutTaxDc")) {
      Object obj = map.get("amountWithoutTaxDc");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountWithoutTaxDc((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountWithoutTaxDc(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountWithoutTaxDc(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setAmountWithoutTaxDc(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountWithoutTaxDc(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("amountWithTaxDc")) {
      Object obj = map.get("amountWithTaxDc");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountWithTaxDc((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountWithTaxDc(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountWithTaxDc(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setAmountWithTaxDc(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountWithTaxDc(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("lineNo")) {
      Object obj = map.get("lineNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setLineNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("poNoticeNo")) {
      Object obj = map.get("poNoticeNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPoNoticeNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("lineCreateDate")) {
      Object obj = map.get("lineCreateDate");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setLineCreateDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setLineCreateDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          this.setLineCreateDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setLineCreateDate(null);
      }
    }
    if(map.containsKey("lineUpdateDate")) {
      Object obj = map.get("lineUpdateDate");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setLineUpdateDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setLineUpdateDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          this.setLineUpdateDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setLineUpdateDate(null);
      }
    }
    if(map.containsKey("lineCancelDate")) {
      Object obj = map.get("lineCancelDate");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setLineCancelDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setLineCancelDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          this.setLineCancelDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setLineCancelDate(null);
      }
    }
    if(map.containsKey("lineStatus")) {
      Object obj = map.get("lineStatus");
      if(obj != null) {
        if(obj instanceof String) {
          this.setLineStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("firstCategory")) {
      Object obj = map.get("firstCategory");
      if(obj != null) {
        if(obj instanceof String) {
          this.setFirstCategory((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("secCategory")) {
      Object obj = map.get("secCategory");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSecCategory((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("thirdCategory")) {
      Object obj = map.get("thirdCategory");
      if(obj != null) {
        if(obj instanceof String) {
          this.setThirdCategory((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("itemDesc")) {
      Object obj = map.get("itemDesc");
      if(obj != null) {
        if(obj instanceof String) {
          this.setItemDesc((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("itemCode")) {
      Object obj = map.get("itemCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setItemCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("barcode")) {
      Object obj = map.get("barcode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBarcode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("itemSubCode")) {
      Object obj = map.get("itemSubCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setItemSubCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("brand")) {
      Object obj = map.get("brand");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBrand((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("standards")) {
      Object obj = map.get("standards");
      if(obj != null) {
        if(obj instanceof String) {
          this.setStandards((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("model")) {
      Object obj = map.get("model");
      if(obj != null) {
        if(obj instanceof String) {
          this.setModel((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("color")) {
      Object obj = map.get("color");
      if(obj != null) {
        if(obj instanceof String) {
          this.setColor((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("size")) {
      Object obj = map.get("size");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSize((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("produceArea")) {
      Object obj = map.get("produceArea");
      if(obj != null) {
        if(obj instanceof String) {
          this.setProduceArea((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("guaranteePeriod")) {
      Object obj = map.get("guaranteePeriod");
      if(obj != null) {
        if(obj instanceof String) {
          this.setGuaranteePeriod((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("netWeight")) {
      Object obj = map.get("netWeight");
      if(obj != null) {
        if(obj instanceof String) {
          this.setNetWeight((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("totalWeight")) {
      Object obj = map.get("totalWeight");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTotalWeight((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("volume")) {
      Object obj = map.get("volume");
      if(obj != null) {
        if(obj instanceof String) {
          this.setVolume((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("volumeUnit")) {
      Object obj = map.get("volumeUnit");
      if(obj != null) {
        if(obj instanceof String) {
          this.setVolumeUnit((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("packageSize")) {
      Object obj = map.get("packageSize");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPackageSize((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("packageQty")) {
      Object obj = map.get("packageQty");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setPackageQty((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setPackageQty(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setPackageQty(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          this.setPackageQty(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setPackageQty(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("packageUnit")) {
      Object obj = map.get("packageUnit");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPackageUnit((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("packageUnitPrice")) {
      Object obj = map.get("packageUnitPrice");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setPackageUnitPrice((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setPackageUnitPrice(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setPackageUnitPrice(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          this.setPackageUnitPrice(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setPackageUnitPrice(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("cusItemCode")) {
      Object obj = map.get("cusItemCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCusItemCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("unit")) {
      Object obj = map.get("unit");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUnit((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("qty")) {
      Object obj = map.get("qty");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setQty((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setQty(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setQty(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          this.setQty(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setQty(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("unitPriceWithoutTax")) {
      Object obj = map.get("unitPriceWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setUnitPriceWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setUnitPriceWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setUnitPriceWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          this.setUnitPriceWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setUnitPriceWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("unitPriceWithTax")) {
      Object obj = map.get("unitPriceWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setUnitPriceWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setUnitPriceWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setUnitPriceWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          this.setUnitPriceWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setUnitPriceWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("priceStatus")) {
      Object obj = map.get("priceStatus");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setPriceStatus((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setPriceStatus(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setPriceStatus(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          this.setPriceStatus(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setPriceStatus(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("shipmentNo")) {
      Object obj = map.get("shipmentNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setShipmentNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("deliveryDate")) {
      Object obj = map.get("deliveryDate");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setDeliveryDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setDeliveryDate((LocalDateTime)obj);
        } else if(obj instanceof String) {
          this.setDeliveryDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setDeliveryDate(null);
      }
    }
    if(map.containsKey("shipMethod")) {
      Object obj = map.get("shipMethod");
      if(obj != null) {
        if(obj instanceof String) {
          this.setShipMethod((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("receiveQty")) {
      Object obj = map.get("receiveQty");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setReceiveQty((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setReceiveQty(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setReceiveQty(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          this.setReceiveQty(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setReceiveQty(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("receiveTolerance")) {
      Object obj = map.get("receiveTolerance");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setReceiveTolerance((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setReceiveTolerance(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setReceiveTolerance(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          this.setReceiveTolerance(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setReceiveTolerance(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("receiveMethod")) {
      Object obj = map.get("receiveMethod");
      if(obj != null) {
        if(obj instanceof String) {
          this.setReceiveMethod((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("inventory")) {
      Object obj = map.get("inventory");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInventory((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("location")) {
      Object obj = map.get("location");
      if(obj != null) {
        if(obj instanceof String) {
          this.setLocation((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("storageGroup")) {
      Object obj = map.get("storageGroup");
      if(obj != null) {
        if(obj instanceof String) {
          this.setStorageGroup((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("taxType")) {
      Object obj = map.get("taxType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTaxType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("taxRate")) {
      Object obj = map.get("taxRate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setTaxRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setTaxRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setTaxRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          this.setTaxRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setTaxRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("discountRate")) {
      Object obj = map.get("discountRate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setDiscountRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setDiscountRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setDiscountRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          this.setDiscountRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setDiscountRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("discountAmt")) {
      Object obj = map.get("discountAmt");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setDiscountAmt((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setDiscountAmt(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setDiscountAmt(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          this.setDiscountAmt(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setDiscountAmt(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("promtFlag")) {
      Object obj = map.get("promtFlag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPromtFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("freeFlag")) {
      Object obj = map.get("freeFlag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setFreeFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("freeQty")) {
      Object obj = map.get("freeQty");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setFreeQty((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setFreeQty(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setFreeQty(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          this.setFreeQty(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setFreeQty(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("minOrdAmt")) {
      Object obj = map.get("minOrdAmt");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setMinOrdAmt((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setMinOrdAmt(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setMinOrdAmt(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          this.setMinOrdAmt(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setMinOrdAmt(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("minOrdQty")) {
      Object obj = map.get("minOrdQty");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setMinOrdQty((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setMinOrdQty(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setMinOrdQty(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          this.setMinOrdQty(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setMinOrdQty(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRemark((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("vvariableid")) {
      Object obj = map.get("vvariableid");
      if(obj != null) {
        if(obj instanceof String) {
          this.setVvariableid((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("taxStatus")) {
      Object obj = map.get("taxStatus");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTaxStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("amountWithoutTax")) {
      Object obj = map.get("amountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          this.setAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("amountWithTax")) {
      Object obj = map.get("amountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          this.setAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("amountWithoutTaxDc")) {
      Object obj = map.get("amountWithoutTaxDc");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setAmountWithoutTaxDc((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setAmountWithoutTaxDc(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setAmountWithoutTaxDc(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          this.setAmountWithoutTaxDc(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setAmountWithoutTaxDc(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("amountWithTaxDc")) {
      Object obj = map.get("amountWithTaxDc");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setAmountWithTaxDc((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setAmountWithTaxDc(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setAmountWithTaxDc(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          this.setAmountWithTaxDc(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setAmountWithTaxDc(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
  }
}
