package com.xforceplus.arterydocument.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * capture_type
 * </p>
 *
 * @author ultraman
 * @since 2024-05-16
 */
public enum CaptureType {

    WEBPAGE("WEBPAGE", "网页采集"),
    API("API", "接口采集"),
    EDI("EDI", "EDI采集"),
    CLIENT("CLIENT", "客户端"),
    GONGZHONGHAO("GONGZHONGHAO", "微信公众号");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    CaptureType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static CaptureType fromCode(String code){
        switch(code) {
            case "WEBPAGE":
                return WEBPAGE;
            case "API":
                return API;
            case "EDI":
                return EDI;
            case "CLIENT":
                return CLIENT;
            case "GONGZHONGHAO":
                return GONGZHONGHAO;
            default:
                return null;
        }
    }
}
