package com.xforceplus.arterydocument.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * execution_task_status
 * </p>
 *
 * @author ultraman
 * @since 2024-05-16
 */
public enum ExecutionTaskStatus {

    IDLE("idle", "待处理"),
    PROC("proc", "执行中"),
    DONE("done", "完成"),
    FAIL("fail", "失败"),
    CANCEL("cancel", "取消");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    ExecutionTaskStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ExecutionTaskStatus fromCode(String code){
        switch(code) {
            case "idle":
                return IDLE;
            case "proc":
                return PROC;
            case "done":
                return DONE;
            case "fail":
                return FAIL;
            case "cancel":
                return CANCEL;
            default:
                return null;
        }
    }
}
