package com.xforceplus.arterydocument.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2024-05-16
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class PosAndIrTransferHeader implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 数据类型
   */
  @TableField("sourceDocType")
  private String sourceDocType;

  /**
   * 采集批次号
   */
  @TableField("collectionBatch")
  private String collectionBatch;

  /**
   * 零售商编码
   */
  @TableField("purchaseRetailerId")
  private String purchaseRetailerId;

  /**
   * 零售商名称
   */
  @TableField("purchaseRetailerName")
  private String purchaseRetailerName;

  /**
   * 目标单据类型
   */
  @TableField("targetDocType")
  private String targetDocType;

  /**
   * 转换时间
   */
  @TableField("transferTime")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime transferTime;

  /**
   * 数据批次转换状态
   */
  @TableField("batchTransferStatus")
  private String batchTransferStatus;

  /**
   * 租户单据检查状态
   */
  @TableField("pCheckStatus")
  private String pCheckStatus;

  /**
   * 单据检查标签
   */
  @TableField("pCheckTags")
  private String pCheckTags;

  /**
   * 错误信息
   */
  @TableField("errorMessage")
  private String errorMessage;

  /**
   * 流ID
   */
  @TableField("flowID")
  private String flowID;

  /**
   * sqsID
   */
  @TableField("sqsID")
  private String sqsID;

  /**
   * 转换次数
   */
  @TableField("transferNum")
  private Long transferNum;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 流日志ID
   */
  @TableField("flowLogID")
  private String flowLogID;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("sourceDocType", sourceDocType);
      map.put("collectionBatch", collectionBatch);
      map.put("purchaseRetailerId", purchaseRetailerId);
      map.put("purchaseRetailerName", purchaseRetailerName);
      map.put("targetDocType", targetDocType);
      map.put("transferTime", BocpGenUtils.toTimestamp(transferTime));
      map.put("batchTransferStatus", batchTransferStatus);
      map.put("pCheckStatus", pCheckStatus);
      map.put("pCheckTags", pCheckTags);
      map.put("errorMessage", errorMessage);
      map.put("flowID", flowID);
      map.put("sqsID", sqsID);
      map.put("transferNum", transferNum);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("flowLogID", flowLogID);

      return map;
  }

  public static PosAndIrTransferHeader fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    PosAndIrTransferHeader entity = new PosAndIrTransferHeader();
    if(map.containsKey("sourceDocType")) {
      Object obj = map.get("sourceDocType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSourceDocType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("collectionBatch")) {
      Object obj = map.get("collectionBatch");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCollectionBatch((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseRetailerId")) {
      Object obj = map.get("purchaseRetailerId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseRetailerId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseRetailerName")) {
      Object obj = map.get("purchaseRetailerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseRetailerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("targetDocType")) {
      Object obj = map.get("targetDocType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTargetDocType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("transferTime")) {
      Object obj = map.get("transferTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTransferTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setTransferTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTransferTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setTransferTime(null);
      }
    }
    if(map.containsKey("batchTransferStatus")) {
      Object obj = map.get("batchTransferStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBatchTransferStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pCheckStatus")) {
      Object obj = map.get("pCheckStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPCheckStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pCheckTags")) {
      Object obj = map.get("pCheckTags");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPCheckTags((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("errorMessage")) {
      Object obj = map.get("errorMessage");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setErrorMessage((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("flowID")) {
      Object obj = map.get("flowID");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setFlowID((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sqsID")) {
      Object obj = map.get("sqsID");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSqsID((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("transferNum")) {
      Object obj = map.get("transferNum");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTransferNum((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTransferNum(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTransferNum(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("flowLogID")) {
      Object obj = map.get("flowLogID");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setFlowLogID((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("sourceDocType")) {
      Object obj = map.get("sourceDocType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSourceDocType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("collectionBatch")) {
      Object obj = map.get("collectionBatch");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCollectionBatch((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaseRetailerId")) {
      Object obj = map.get("purchaseRetailerId");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaseRetailerId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaseRetailerName")) {
      Object obj = map.get("purchaseRetailerName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaseRetailerName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("targetDocType")) {
      Object obj = map.get("targetDocType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTargetDocType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("transferTime")) {
      Object obj = map.get("transferTime");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTransferTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setTransferTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTransferTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setTransferTime(null);
      }
    }
    if(map.containsKey("batchTransferStatus")) {
      Object obj = map.get("batchTransferStatus");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBatchTransferStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("pCheckStatus")) {
      Object obj = map.get("pCheckStatus");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPCheckStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("pCheckTags")) {
      Object obj = map.get("pCheckTags");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPCheckTags((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("errorMessage")) {
      Object obj = map.get("errorMessage");
      if(obj != null) {
        if(obj instanceof String) {
          this.setErrorMessage((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("flowID")) {
      Object obj = map.get("flowID");
      if(obj != null) {
        if(obj instanceof String) {
          this.setFlowID((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sqsID")) {
      Object obj = map.get("sqsID");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSqsID((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("transferNum")) {
      Object obj = map.get("transferNum");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTransferNum((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTransferNum(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTransferNum(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("flowLogID")) {
      Object obj = map.get("flowLogID");
      if(obj != null) {
        if(obj instanceof String) {
          this.setFlowLogID((String)obj);
        }
      } else {
      }
    }
  }
}
