package com.xforceplus.arterydocument.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * account_secret_key_status
 * </p>
 *
 * @author ultraman
 * @since 2024-07-09
 */
public enum AccountSecretKeyStatus {

    _0("0", "待生成"),
    _1("1", "已更新"),
    _2("2", "密钥异常");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    AccountSecretKeyStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static AccountSecretKeyStatus fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "1":
                return _1;
            case "2":
                return _2;
            default:
                return null;
        }
    }
}
