package com.xforceplus.arterydocument.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * transfer_status
 * </p>
 *
 * @author ultraman
 * @since 2024-07-09
 */
public enum TransferStatus {

    SUCCESS("success", "成功"),
    ERROR("error", "异常"),
    TRANSFERRING("transferring", "转换中");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    TransferStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static TransferStatus fromCode(String code){
        switch(code) {
            case "success":
                return SUCCESS;
            case "error":
                return ERROR;
            case "transferring":
                return TRANSFERRING;
            default:
                return null;
        }
    }
}
