package com.xforceplus.arterydocument.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2024-07-09
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class RetryTask implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 任务ID
   */
  @TableField("taskID")
  private String taskID;

  /**
   * 任务描述
   */
  @TableField("taskDesc")
  private String taskDesc;

  /**
   * 关键信息
   */
  @TableField("keyInfo")
  private String keyInfo;

  /**
   * 业务Id
   */
  @TableField("pBusinessId")
  private String pBusinessId;

  /**
   * 数据MD5
   */
  @TableField("pDataMD5")
  private String pDataMD5;

  /**
   * 所属租户
   */
  @TableField("belongTenant")
  private String belongTenant;

  /**
   * 所属商超
   */
  @TableField("purchaseRetailerId")
  private String purchaseRetailerId;

  /**
   * 单据类型
   */
  @TableField("documentType")
  private String documentType;

  /**
   * 执行Cron的ID
   */
  @TableField("cronID")
  private String cronID;

  /**
   * 执行Cron表达式
   */
  private String cron;

  /**
   * SQS地址
   */
  @TableField("sqsAddress")
  private String sqsAddress;

  /**
   * SQS文件
   */
  @TableField("sqsFile")
  private String sqsFile;

  /**
   * 动作流编码
   */
  @TableField("sqsCode")
  private String sqsCode;

  /**
   * 动作流ID
   */
  @TableField("sqsID")
  private String sqsID;

  /**
   * 执行模式
   */
  private String type;

  /**
   * 执行状态
   */
  private String status;

  /**
   * 执行失败次数
   */
  @TableField("failureCounts")
  private Long failureCounts;

  /**
   * 创建流ID
   */
  @TableField("createSQSID")
  private String createSQSID;

  /**
   * 创建流描述
   */
  @TableField("createSQSDesc")
  private String createSQSDesc;

  /**
   * 创建节点ID
   */
  @TableField("createNodeID")
  private String createNodeID;

  /**
   * 创建节点描述
   */
  @TableField("createNodeDesc")
  private String createNodeDesc;

  /**
   * 其它参数
   */
  @TableField("otherInputs")
  private String otherInputs;

  /**
   * 采集时间
   */
  @TableField("collectionDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime collectionDate;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("taskID", taskID);
      map.put("taskDesc", taskDesc);
      map.put("keyInfo", keyInfo);
      map.put("pBusinessId", pBusinessId);
      map.put("pDataMD5", pDataMD5);
      map.put("belongTenant", belongTenant);
      map.put("purchaseRetailerId", purchaseRetailerId);
      map.put("documentType", documentType);
      map.put("cronID", cronID);
      map.put("cron", cron);
      map.put("sqsAddress", sqsAddress);
      map.put("sqsFile", sqsFile);
      map.put("sqsCode", sqsCode);
      map.put("sqsID", sqsID);
      map.put("type", type);
      map.put("status", status);
      map.put("failureCounts", failureCounts);
      map.put("createSQSID", createSQSID);
      map.put("createSQSDesc", createSQSDesc);
      map.put("createNodeID", createNodeID);
      map.put("createNodeDesc", createNodeDesc);
      map.put("otherInputs", otherInputs);
      map.put("collectionDate", BocpGenUtils.toTimestamp(collectionDate));
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);

      return map;
  }

  public static RetryTask fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    RetryTask entity = new RetryTask();
    if(map.containsKey("taskID")) {
      Object obj = map.get("taskID");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTaskID((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taskDesc")) {
      Object obj = map.get("taskDesc");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTaskDesc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("keyInfo")) {
      Object obj = map.get("keyInfo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setKeyInfo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pBusinessId")) {
      Object obj = map.get("pBusinessId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPBusinessId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pDataMD5")) {
      Object obj = map.get("pDataMD5");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPDataMD5((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("belongTenant")) {
      Object obj = map.get("belongTenant");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBelongTenant((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseRetailerId")) {
      Object obj = map.get("purchaseRetailerId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseRetailerId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("documentType")) {
      Object obj = map.get("documentType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDocumentType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cronID")) {
      Object obj = map.get("cronID");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCronID((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cron")) {
      Object obj = map.get("cron");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCron((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sqsAddress")) {
      Object obj = map.get("sqsAddress");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSqsAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sqsFile")) {
      Object obj = map.get("sqsFile");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSqsFile((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sqsCode")) {
      Object obj = map.get("sqsCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSqsCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sqsID")) {
      Object obj = map.get("sqsID");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSqsID((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("type")) {
      Object obj = map.get("type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("status")) {
      Object obj = map.get("status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("failureCounts")) {
      Object obj = map.get("failureCounts");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setFailureCounts((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setFailureCounts(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setFailureCounts(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("createSQSID")) {
      Object obj = map.get("createSQSID");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateSQSID((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("createSQSDesc")) {
      Object obj = map.get("createSQSDesc");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateSQSDesc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("createNodeID")) {
      Object obj = map.get("createNodeID");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateNodeID((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("createNodeDesc")) {
      Object obj = map.get("createNodeDesc");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateNodeDesc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("otherInputs")) {
      Object obj = map.get("otherInputs");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOtherInputs((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("collectionDate")) {
      Object obj = map.get("collectionDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCollectionDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCollectionDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCollectionDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCollectionDate(null);
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("taskID")) {
      Object obj = map.get("taskID");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTaskID((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("taskDesc")) {
      Object obj = map.get("taskDesc");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTaskDesc((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("keyInfo")) {
      Object obj = map.get("keyInfo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setKeyInfo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("pBusinessId")) {
      Object obj = map.get("pBusinessId");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPBusinessId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("pDataMD5")) {
      Object obj = map.get("pDataMD5");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPDataMD5((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("belongTenant")) {
      Object obj = map.get("belongTenant");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBelongTenant((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaseRetailerId")) {
      Object obj = map.get("purchaseRetailerId");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaseRetailerId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("documentType")) {
      Object obj = map.get("documentType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDocumentType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("cronID")) {
      Object obj = map.get("cronID");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCronID((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("cron")) {
      Object obj = map.get("cron");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCron((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sqsAddress")) {
      Object obj = map.get("sqsAddress");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSqsAddress((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sqsFile")) {
      Object obj = map.get("sqsFile");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSqsFile((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sqsCode")) {
      Object obj = map.get("sqsCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSqsCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sqsID")) {
      Object obj = map.get("sqsID");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSqsID((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("type")) {
      Object obj = map.get("type");
      if(obj != null) {
        if(obj instanceof String) {
          this.setType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("status")) {
      Object obj = map.get("status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("failureCounts")) {
      Object obj = map.get("failureCounts");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setFailureCounts((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setFailureCounts(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setFailureCounts(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("createSQSID")) {
      Object obj = map.get("createSQSID");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateSQSID((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("createSQSDesc")) {
      Object obj = map.get("createSQSDesc");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateSQSDesc((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("createNodeID")) {
      Object obj = map.get("createNodeID");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateNodeID((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("createNodeDesc")) {
      Object obj = map.get("createNodeDesc");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateNodeDesc((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("otherInputs")) {
      Object obj = map.get("otherInputs");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOtherInputs((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("collectionDate")) {
      Object obj = map.get("collectionDate");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCollectionDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCollectionDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCollectionDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCollectionDate(null);
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
  }
}
