package com.xforceplus.arterydocument.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * huaweicloud_po_status
 * </p>
 *
 * @author ultraman
 * @since 2024-07-29
 */
public enum HuaweicloudPoStatus {

    NEW("new", "待生效"),
    EFFECTIVE("effective", "生效中"),
    EXPIRING_SOON("expiringSoon", "快过期"),
    EXPIRED("expired", "已过期");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    HuaweicloudPoStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static HuaweicloudPoStatus fromCode(String code){
        switch(code) {
            case "new":
                return NEW;
            case "effective":
                return EFFECTIVE;
            case "expiringSoon":
                return EXPIRING_SOON;
            case "expired":
                return EXPIRED;
            default:
                return null;
        }
    }
}
