package com.xforceplus.arterydocument.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * po_sys_doc_type
 * </p>
 *
 * @author ultraman
 * @since 2024-07-29
 */
public enum PoSysDocType {

    STANDARD("standard", "标准订单"),
    RETURN("return", "退货订单");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    PoSysDocType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static PoSysDocType fromCode(String code){
        switch(code) {
            case "standard":
                return STANDARD;
            case "return":
                return RETURN;
            default:
                return null;
        }
    }
}
