package com.xforceplus.arterydocument.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * V2
 * </p>
 *
 * @author ultraman
 * @since 2024-07-29
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class SettlementDocAdvInvoiceDetail implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 序号
   */
  @TableField("lineNo")
  private String lineNo;

  /**
   * 单据日期
   */
  @TableField("documentDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime documentDate;

  /**
   * 商品编码
   */
  @TableField("itemCode")
  private String itemCode;

  /**
   * 商品条码
   */
  private String barcode;

  /**
   * 商品名称
   */
  @TableField("itemDesc")
  private String itemDesc;

  /**
   * 税收分类编码
   */
  @TableField("goodsTaxNo")
  private String goodsTaxNo;

  /**
   * 批量包装规格
   */
  @TableField("packageSize")
  private String packageSize;

  /**
   * 批量包装数量
   */
  @TableField("packageQty")
  private BigDecimal packageQty;

  /**
   * 批量包装单位
   */
  @TableField("packageUnit")
  private String packageUnit;

  /**
   * 批量包装单价
   */
  @TableField("packageUnitPrice")
  private BigDecimal packageUnitPrice;

  /**
   * 单据单位
   */
  private String unit;

  /**
   * 单据单位描述
   */
  @TableField("unitDesc")
  private String unitDesc;

  /**
   * 单据数量
   */
  private BigDecimal qty;

  /**
   * 单价（不含税）
   */
  @TableField("unitPriceWithoutTax")
  private BigDecimal unitPriceWithoutTax;

  /**
   * 单价（含税）
   */
  @TableField("unitPriceWithTax")
  private BigDecimal unitPriceWithTax;

  /**
   * 开票单价（不含税）
   */
  @TableField("invoicePriceWithoutTax")
  private BigDecimal invoicePriceWithoutTax;

  /**
   * 开票单价（含税）
   */
  @TableField("invoicePriceWithTax")
  private BigDecimal invoicePriceWithTax;

  /**
   * 价内折扣金额（含税）
   */
  @TableField("innerDiscountWithTax")
  private BigDecimal innerDiscountWithTax;

  /**
   * 价内折扣金额（不含税）
   */
  @TableField("innerDiscountWithoutTax")
  private BigDecimal innerDiscountWithoutTax;

  /**
   * 价内折扣税额
   */
  @TableField("innerDiscountTax")
  private BigDecimal innerDiscountTax;

  /**
   * 价外折扣金额（含税）
   */
  @TableField("outterDiscountWithTax")
  private BigDecimal outterDiscountWithTax;

  /**
   * 价外折扣金额（不含税）
   */
  @TableField("outterDiscountWithoutTax")
  private BigDecimal outterDiscountWithoutTax;

  /**
   * 价外折扣税额
   */
  @TableField("outterDiscountTax")
  private BigDecimal outterDiscountTax;

  /**
   * 总额（含税）
   */
  @TableField("amountWithTax")
  private BigDecimal amountWithTax;

  /**
   * 总额（不含税）
   */
  @TableField("amountWithoutTax")
  private BigDecimal amountWithoutTax;

  /**
   * 税额
   */
  @TableField("taxAmount")
  private BigDecimal taxAmount;

  /**
   * 税率
   */
  @TableField("taxRate")
  private BigDecimal taxRate;

  /**
   * 备注
   */
  private String remark;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 来源往期结算单号
   */
  @TableField("previousSettlementNo")
  private String previousSettlementNo;

  /**
   * 建议开票金额（含税）
   */
  @TableField("invoiceAmtWithTax")
  private BigDecimal invoiceAmtWithTax;

  /**
   * 建议开票金额（不含税）
   */
  @TableField("invoiceAmtWithoutTax")
  private BigDecimal invoiceAmtWithoutTax;

  /**
   * 建议开票税额
   */
  @TableField("invoiceTaxAmt")
  private BigDecimal invoiceTaxAmt;

  /**
   * 行业务ID
   */
  @TableField("pBusinessLineId")
  private String pBusinessLineId;

  /**
   * 行数据MD5
   */
  @TableField("pDataLineMD5")
  private String pDataLineMD5;

  /**
   * 删除标记
   */
  @TableField("pDeleteFlag")
  private Boolean pDeleteFlag;


  /**
   * 对一关联关系 关联对象 settlementDoc
   */
    private Long headIdId;


  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("lineNo", lineNo);
      map.put("documentDate", BocpGenUtils.toTimestamp(documentDate));
      map.put("itemCode", itemCode);
      map.put("barcode", barcode);
      map.put("itemDesc", itemDesc);
      map.put("goodsTaxNo", goodsTaxNo);
      map.put("packageSize", packageSize);
      map.put("packageQty", packageQty);
      map.put("packageUnit", packageUnit);
      map.put("packageUnitPrice", packageUnitPrice);
      map.put("unit", unit);
      map.put("unitDesc", unitDesc);
      map.put("qty", qty);
      map.put("unitPriceWithoutTax", unitPriceWithoutTax);
      map.put("unitPriceWithTax", unitPriceWithTax);
      map.put("invoicePriceWithoutTax", invoicePriceWithoutTax);
      map.put("invoicePriceWithTax", invoicePriceWithTax);
      map.put("innerDiscountWithTax", innerDiscountWithTax);
      map.put("innerDiscountWithoutTax", innerDiscountWithoutTax);
      map.put("innerDiscountTax", innerDiscountTax);
      map.put("outterDiscountWithTax", outterDiscountWithTax);
      map.put("outterDiscountWithoutTax", outterDiscountWithoutTax);
      map.put("outterDiscountTax", outterDiscountTax);
      map.put("amountWithTax", amountWithTax);
      map.put("amountWithoutTax", amountWithoutTax);
      map.put("taxAmount", taxAmount);
      map.put("taxRate", taxRate);
      map.put("remark", remark);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("previousSettlementNo", previousSettlementNo);
      map.put("invoiceAmtWithTax", invoiceAmtWithTax);
      map.put("invoiceAmtWithoutTax", invoiceAmtWithoutTax);
      map.put("invoiceTaxAmt", invoiceTaxAmt);
      map.put("pBusinessLineId", pBusinessLineId);
      map.put("pDataLineMD5", pDataLineMD5);
      map.put("pDeleteFlag", pDeleteFlag);

       map.put("headId.id", headIdId);
      return map;
  }

  public static SettlementDocAdvInvoiceDetail fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    SettlementDocAdvInvoiceDetail entity = new SettlementDocAdvInvoiceDetail();
    if(map.containsKey("lineNo")) {
      Object obj = map.get("lineNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setLineNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("documentDate")) {
      Object obj = map.get("documentDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setDocumentDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setDocumentDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setDocumentDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setDocumentDate(null);
      }
    }
    if(map.containsKey("itemCode")) {
      Object obj = map.get("itemCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setItemCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("barcode")) {
      Object obj = map.get("barcode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBarcode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("itemDesc")) {
      Object obj = map.get("itemDesc");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setItemDesc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("goodsTaxNo")) {
      Object obj = map.get("goodsTaxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setGoodsTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("packageSize")) {
      Object obj = map.get("packageSize");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPackageSize((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("packageQty")) {
      Object obj = map.get("packageQty");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPackageQty((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPackageQty(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPackageQty(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPackageQty(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPackageQty(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("packageUnit")) {
      Object obj = map.get("packageUnit");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPackageUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("packageUnitPrice")) {
      Object obj = map.get("packageUnitPrice");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPackageUnitPrice((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPackageUnitPrice(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPackageUnitPrice(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPackageUnitPrice(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPackageUnitPrice(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("unit")) {
      Object obj = map.get("unit");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("unitDesc")) {
      Object obj = map.get("unitDesc");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUnitDesc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("qty")) {
      Object obj = map.get("qty");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setQty((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setQty(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setQty(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setQty(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setQty(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("unitPriceWithoutTax")) {
      Object obj = map.get("unitPriceWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setUnitPriceWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setUnitPriceWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setUnitPriceWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUnitPriceWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUnitPriceWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("unitPriceWithTax")) {
      Object obj = map.get("unitPriceWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setUnitPriceWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setUnitPriceWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setUnitPriceWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUnitPriceWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUnitPriceWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("invoicePriceWithoutTax")) {
      Object obj = map.get("invoicePriceWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setInvoicePriceWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setInvoicePriceWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setInvoicePriceWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setInvoicePriceWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setInvoicePriceWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("invoicePriceWithTax")) {
      Object obj = map.get("invoicePriceWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setInvoicePriceWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setInvoicePriceWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setInvoicePriceWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setInvoicePriceWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setInvoicePriceWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("innerDiscountWithTax")) {
      Object obj = map.get("innerDiscountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setInnerDiscountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setInnerDiscountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setInnerDiscountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setInnerDiscountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setInnerDiscountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("innerDiscountWithoutTax")) {
      Object obj = map.get("innerDiscountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setInnerDiscountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setInnerDiscountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setInnerDiscountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setInnerDiscountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setInnerDiscountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("innerDiscountTax")) {
      Object obj = map.get("innerDiscountTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setInnerDiscountTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setInnerDiscountTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setInnerDiscountTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setInnerDiscountTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setInnerDiscountTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("outterDiscountWithTax")) {
      Object obj = map.get("outterDiscountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setOutterDiscountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setOutterDiscountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setOutterDiscountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setOutterDiscountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setOutterDiscountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("outterDiscountWithoutTax")) {
      Object obj = map.get("outterDiscountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setOutterDiscountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setOutterDiscountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setOutterDiscountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setOutterDiscountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setOutterDiscountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("outterDiscountTax")) {
      Object obj = map.get("outterDiscountTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setOutterDiscountTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setOutterDiscountTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setOutterDiscountTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setOutterDiscountTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setOutterDiscountTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("amountWithTax")) {
      Object obj = map.get("amountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("amountWithoutTax")) {
      Object obj = map.get("amountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("taxAmount")) {
      Object obj = map.get("taxAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("taxRate")) {
      Object obj = map.get("taxRate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTaxRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTaxRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTaxRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTaxRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTaxRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("previousSettlementNo")) {
      Object obj = map.get("previousSettlementNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPreviousSettlementNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceAmtWithTax")) {
      Object obj = map.get("invoiceAmtWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setInvoiceAmtWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setInvoiceAmtWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setInvoiceAmtWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setInvoiceAmtWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setInvoiceAmtWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("invoiceAmtWithoutTax")) {
      Object obj = map.get("invoiceAmtWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setInvoiceAmtWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setInvoiceAmtWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setInvoiceAmtWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setInvoiceAmtWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setInvoiceAmtWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("invoiceTaxAmt")) {
      Object obj = map.get("invoiceTaxAmt");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setInvoiceTaxAmt((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setInvoiceTaxAmt(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setInvoiceTaxAmt(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setInvoiceTaxAmt(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setInvoiceTaxAmt(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("pBusinessLineId")) {
      Object obj = map.get("pBusinessLineId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPBusinessLineId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pDataLineMD5")) {
      Object obj = map.get("pDataLineMD5");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPDataLineMD5((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pDeleteFlag")) {
      Object obj = map.get("pDeleteFlag");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setPDeleteFlag((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPDeleteFlag(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }

    if(map.containsKey("headId.id")) {
        Object obj = map.get("headId.id");
      if(obj instanceof Long) {
        entity.setHeadIdId((Long)obj);
      } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
        entity.setHeadIdId(Long.parseLong((String)obj));
      }
    }
    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("lineNo")) {
      Object obj = map.get("lineNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setLineNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("documentDate")) {
      Object obj = map.get("documentDate");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setDocumentDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setDocumentDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setDocumentDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setDocumentDate(null);
      }
    }
    if(map.containsKey("itemCode")) {
      Object obj = map.get("itemCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setItemCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("barcode")) {
      Object obj = map.get("barcode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBarcode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("itemDesc")) {
      Object obj = map.get("itemDesc");
      if(obj != null) {
        if(obj instanceof String) {
          this.setItemDesc((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("goodsTaxNo")) {
      Object obj = map.get("goodsTaxNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setGoodsTaxNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("packageSize")) {
      Object obj = map.get("packageSize");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPackageSize((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("packageQty")) {
      Object obj = map.get("packageQty");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setPackageQty((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setPackageQty(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setPackageQty(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPackageQty(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setPackageQty(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("packageUnit")) {
      Object obj = map.get("packageUnit");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPackageUnit((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("packageUnitPrice")) {
      Object obj = map.get("packageUnitPrice");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setPackageUnitPrice((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setPackageUnitPrice(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setPackageUnitPrice(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPackageUnitPrice(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setPackageUnitPrice(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("unit")) {
      Object obj = map.get("unit");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUnit((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("unitDesc")) {
      Object obj = map.get("unitDesc");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUnitDesc((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("qty")) {
      Object obj = map.get("qty");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setQty((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setQty(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setQty(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setQty(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setQty(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("unitPriceWithoutTax")) {
      Object obj = map.get("unitPriceWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setUnitPriceWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setUnitPriceWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setUnitPriceWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUnitPriceWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setUnitPriceWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("unitPriceWithTax")) {
      Object obj = map.get("unitPriceWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setUnitPriceWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setUnitPriceWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setUnitPriceWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUnitPriceWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setUnitPriceWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("invoicePriceWithoutTax")) {
      Object obj = map.get("invoicePriceWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setInvoicePriceWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setInvoicePriceWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setInvoicePriceWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setInvoicePriceWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setInvoicePriceWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("invoicePriceWithTax")) {
      Object obj = map.get("invoicePriceWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setInvoicePriceWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setInvoicePriceWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setInvoicePriceWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setInvoicePriceWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setInvoicePriceWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("innerDiscountWithTax")) {
      Object obj = map.get("innerDiscountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setInnerDiscountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setInnerDiscountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setInnerDiscountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setInnerDiscountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setInnerDiscountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("innerDiscountWithoutTax")) {
      Object obj = map.get("innerDiscountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setInnerDiscountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setInnerDiscountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setInnerDiscountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setInnerDiscountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setInnerDiscountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("innerDiscountTax")) {
      Object obj = map.get("innerDiscountTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setInnerDiscountTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setInnerDiscountTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setInnerDiscountTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setInnerDiscountTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setInnerDiscountTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("outterDiscountWithTax")) {
      Object obj = map.get("outterDiscountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setOutterDiscountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setOutterDiscountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setOutterDiscountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setOutterDiscountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setOutterDiscountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("outterDiscountWithoutTax")) {
      Object obj = map.get("outterDiscountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setOutterDiscountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setOutterDiscountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setOutterDiscountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setOutterDiscountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setOutterDiscountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("outterDiscountTax")) {
      Object obj = map.get("outterDiscountTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setOutterDiscountTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setOutterDiscountTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setOutterDiscountTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setOutterDiscountTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setOutterDiscountTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("amountWithTax")) {
      Object obj = map.get("amountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("amountWithoutTax")) {
      Object obj = map.get("amountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("taxAmount")) {
      Object obj = map.get("taxAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("taxRate")) {
      Object obj = map.get("taxRate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setTaxRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setTaxRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setTaxRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTaxRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setTaxRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRemark((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("previousSettlementNo")) {
      Object obj = map.get("previousSettlementNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPreviousSettlementNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoiceAmtWithTax")) {
      Object obj = map.get("invoiceAmtWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setInvoiceAmtWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setInvoiceAmtWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setInvoiceAmtWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setInvoiceAmtWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setInvoiceAmtWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("invoiceAmtWithoutTax")) {
      Object obj = map.get("invoiceAmtWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setInvoiceAmtWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setInvoiceAmtWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setInvoiceAmtWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setInvoiceAmtWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setInvoiceAmtWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("invoiceTaxAmt")) {
      Object obj = map.get("invoiceTaxAmt");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setInvoiceTaxAmt((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setInvoiceTaxAmt(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setInvoiceTaxAmt(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setInvoiceTaxAmt(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setInvoiceTaxAmt(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("pBusinessLineId")) {
      Object obj = map.get("pBusinessLineId");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPBusinessLineId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("pDataLineMD5")) {
      Object obj = map.get("pDataLineMD5");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPDataLineMD5((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("pDeleteFlag")) {
      Object obj = map.get("pDeleteFlag");
      if(obj != null) {
        if(obj instanceof Boolean) {
          this.setPDeleteFlag((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPDeleteFlag(Boolean.valueOf((String)obj));
        }
      } else {
      }
    }
      if(map.containsKey("headId.id")) {
        Object obj = map.get("headId.id");
        if(obj instanceof Long) {
          this.setHeadIdId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setHeadIdId(Long.parseLong((String)obj));
        }
      }
  }
}
