package com.xforceplus.arterydocument.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * linereservation_delivery_note_status
 * </p>
 *
 * @author ultraman
 * @since 2025-02-28
 */
public enum LinereservationDeliveryNoteStatus {

    _0("0", "待预约"),
    _1("1", "预约中"),
    _2("2", "已预约"),
    _3("3", "预约异常"),
    _4("4", "取消预约"),
    _5("5", "待上传明细"),
    _6("6", "取消中"),
    _7("7", "取消预约失败");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    LinereservationDeliveryNoteStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static LinereservationDeliveryNoteStatus fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            case "5":
                return _5;
            case "6":
                return _6;
            case "7":
                return _7;
            default:
                return null;
        }
    }
}
