package com.xforceplus.arterydocument.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * pos_date_source
 * </p>
 *
 * @author ultraman
 * @since 2025-02-28
 */
public enum PosDateSource {

    数据采集("数据采集", "数据采集"),
    数据导入("数据导入", "导入补录"),
    销方创建("销方创建", "自动补录");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    PosDateSource(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static PosDateSource fromCode(String code){
        switch(code) {
            case "数据采集":
                return 数据采集;
            case "数据导入":
                return 数据导入;
            case "销方创建":
                return 销方创建;
            default:
                return null;
        }
    }
}
