package com.xforceplus.arterydocument.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2025-02-28
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class Inventory implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 是否是最新版本
   */
  private Boolean latest;

  /**
   * 原始单据Id数组
   */
  private String srcids;

  /**
   * 所属租户
   */
  @TableField("belongTenant")
  private String belongTenant;

  /**
   * 商超账号
   */
  @TableField("collectionAccount")
  private String collectionAccount;

  /**
   * 采集批次
   */
  @TableField("collectionBatch")
  private String collectionBatch;

  /**
   * 采集日期
   */
  @TableField("collectionDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime collectionDate;

  /**
   * 购方统一社会信用代码
   */
  @TableField("purchaseCompanyTaxNo")
  private String purchaseCompanyTaxNo;

  /**
   * 零售商编码
   */
  @TableField("purchaseRetailerId")
  private String purchaseRetailerId;

  /**
   * 零售商描述
   */
  @TableField("purchaseRetailerName")
  private String purchaseRetailerName;

  /**
   * 购方公司编码
   */
  @TableField("purchaseCompanyCode")
  private String purchaseCompanyCode;

  /**
   * 购方公司名称
   */
  @TableField("purchaseCompanyName")
  private String purchaseCompanyName;

  /**
   * 区域编码
   */
  @TableField("regionCode")
  private String regionCode;

  /**
   * 区域名称
   */
  @TableField("regionName")
  private String regionName;

  /**
   * 购方门店编码
   */
  @TableField("purchaseStoreCode")
  private String purchaseStoreCode;

  /**
   * 购方门店GLN
   */
  @TableField("purchaseStoreGLN")
  private String purchaseStoreGLN;

  /**
   * 购方门店名称
   */
  @TableField("purchaseStoreName")
  private String purchaseStoreName;

  /**
   * 品类编码
   */
  @TableField("categoryCode")
  private String categoryCode;

  /**
   * 品类名称
   */
  @TableField("categoryName")
  private String categoryName;

  /**
   * 销方编码
   */
  @TableField("sellerCode")
  private String sellerCode;

  /**
   * 销方名称
   */
  @TableField("sellerName")
  private String sellerName;

  /**
   * 商品编码
   */
  @TableField("itemCode")
  private String itemCode;

  /**
   * 商品条码
   */
  private String barcode;

  /**
   * 商品子编码
   */
  @TableField("itemSubCode")
  private String itemSubCode;

  /**
   * 商品名称
   */
  @TableField("itemDesc")
  private String itemDesc;

  /**
   * 品牌
   */
  private String brand;

  /**
   * 规格
   */
  private String standards;

  /**
   * 型号
   */
  private String model;

  /**
   * 基本单位
   */
  private String unit;

  /**
   * 期间类型
   */
  @TableField("sectionType")
  private String sectionType;

  /**
   * 年/月/日
   */
  @TableField("sectionDate")
  private String sectionDate;

  /**
   * 进货数量
   */
  @TableField("purchaseQty")
  private String purchaseQty;

  /**
   * 年/月/日均进货量
   */
  @TableField("averagePurchaseAmt")
  private BigDecimal averagePurchaseAmt;

  /**
   * 销售数量
   */
  @TableField("salesQty")
  private BigDecimal salesQty;

  /**
   * 销售金额
   */
  @TableField("saleAmt")
  private BigDecimal saleAmt;

  /**
   * 年/月/日均销售量
   */
  @TableField("averageSaleQty")
  private BigDecimal averageSaleQty;

  /**
   * 库存日期
   */
  @TableField("stockDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime stockDate;

  /**
   * 库存余额数量
   */
  @TableField("stockQty")
  private BigDecimal stockQty;

  /**
   * 在途数量
   */
  @TableField("transitQty")
  private BigDecimal transitQty;

  /**
   * 备注
   */
  private String remark;

  /**
   * 扩展字段_字符串_1
   */
  private String extstr1;

  /**
   * 扩展字段_字符串_2
   */
  private String extstr2;

  /**
   * 扩展字段_字符串_3
   */
  private String extstr3;

  /**
   * 扩展字段_字符串_4
   */
  private String extstr4;

  /**
   * 扩展字段_字符串_5
   */
  private String extstr5;

  /**
   * 扩展字段_字符串_6
   */
  private String extstr6;

  /**
   * 扩展字段_字符串_7
   */
  private String extstr7;

  /**
   * 扩展字段_字符串_8
   */
  private String extstr8;

  /**
   * 扩展字段_字符串_9
   */
  private String extstr9;

  /**
   * 扩展字段_字符串_10
   */
  private String extstr10;

  /**
   * 模版变量Id
   */
  private String vvariableid;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 转换方式信息
   */
  @TableField("docTransformer")
  private String docTransformer;

  /**
   * 业务id
   */
  @TableField("pBusinessId")
  private String pBusinessId;

  /**
   * 版本号
   */
  @TableField("versionNo")
  private String versionNo;

  /**
   * 业态编码
   */
  @TableField("purchaseBusinessTypeNo")
  private String purchaseBusinessTypeNo;

  /**
   * 业态名称
   */
  @TableField("purchaseBusinessTypeName")
  private String purchaseBusinessTypeName;

  /**
   * 销方版本号
   */
  @TableField("sVersionNo")
  private String sVersionNo;

  /**
   * 售达方编码
   */
  @TableField("sSoldToCode")
  private String sSoldToCode;

  /**
   * 售达方名称
   */
  @TableField("sSoldToName")
  private String sSoldToName;

  /**
   * 送达方编码
   */
  @TableField("sShipToCode")
  private String sShipToCode;

  /**
   * 送达方名称
   */
  @TableField("sShipToName")
  private String sShipToName;

  /**
   * 客户组编码
   */
  @TableField("sCustomerGroupCode")
  private String sCustomerGroupCode;

  /**
   * 客户组名称
   */
  @TableField("sCustomerGroupName")
  private String sCustomerGroupName;

  /**
   * 客户类型
   */
  @TableField("sCustomerType")
  private String sCustomerType;

  /**
   * 客户编码
   */
  @TableField("sCustomerCode")
  private String sCustomerCode;

  /**
   * 客户名称
   */
  @TableField("sCustomerName")
  private String sCustomerName;

  /**
   * 业务单元编码
   */
  @TableField("sBuCode")
  private String sBuCode;

  /**
   * 业务单元名称
   */
  @TableField("sBuName")
  private String sBuName;

  /**
   * 销售公司编码
   */
  @TableField("sCompanyCode")
  private String sCompanyCode;

  /**
   * 销售公司名称
   */
  @TableField("sCompanyName")
  private String sCompanyName;

  /**
   * 销售公司税号
   */
  @TableField("sCompanyTaxNo")
  private String sCompanyTaxNo;

  /**
   * 销售组织编码
   */
  @TableField("sSalesOrganizationCode")
  private String sSalesOrganizationCode;

  /**
   * 销售组织名称
   */
  @TableField("sSalesOrganizationName")
  private String sSalesOrganizationName;

  /**
   * 价格方式
   */
  @TableField("priceStatus")
  private Long priceStatus;

  /**
   * 商超原单文件地址
   */
  @TableField("pSourceFileURL")
  private String pSourceFileURL;

  /**
   * 统一单据标记
   */
  @TableField("pUnifyDocFlag")
  private Boolean pUnifyDocFlag;

  /**
   * 租户单据标记
   */
  @TableField("pTenantDocFlag")
  private Boolean pTenantDocFlag;

  /**
   * 转换批次号
   */
  @TableField("batchNumberOD2UD")
  private String batchNumberOD2UD;

  /**
   * 删除标记
   */
  @TableField("pDeleteFlag")
  private Boolean pDeleteFlag;

  /**
   * 数据状态标记
   */
  @TableField("dataStatus")
  private String dataStatus;

  /**
   * 下发ID
   */
  @TableField("dataIssueID")
  private String dataIssueID;

  /**
   * 统计头MD5
   */
  @TableField("statisticalHeaderMD5")
  private String statisticalHeaderMD5;

  /**
   * 数据MD5
   */
  @TableField("dataMD5")
  private String dataMD5;

  /**
   * 销方商品编码
   */
  @TableField("sItemCode")
  private String sItemCode;

  /**
   * 销方商品条码
   */
  @TableField("sBarcode")
  private String sBarcode;

  /**
   * 销方商品子编码
   */
  @TableField("sItemSubCode")
  private String sItemSubCode;

  /**
   * 销方商品名称
   */
  @TableField("sItemDesc")
  private String sItemDesc;

  /**
   * 销方是否组套商品
   */
  @TableField("sSuitFlag")
  private String sSuitFlag;

  /**
   * 销方组套商品（数组）
   */
  @TableField("sSuitInfo")
  private String sSuitInfo;

  /**
   * 销方是否新老品
   */
  @TableField("sNewOldFlag")
  private String sNewOldFlag;

  /**
   * 销方新老商品（数组）
   */
  @TableField("sNewOldInfo")
  private String sNewOldInfo;

  /**
   * 单位转换规则（对象数组）
   */
  @TableField("sUnitRules")
  private String sUnitRules;

  /**
   * 销方批量包装单位
   */
  @TableField("sPackageUnit")
  private String sPackageUnit;

  /**
   * 销方批量包装规格
   */
  @TableField("sPackageSize")
  private String sPackageSize;

  /**
   * 销方单据单位
   */
  @TableField("sUnit")
  private String sUnit;

  /**
   * 客户商品单位
   */
  @TableField("sCustomUnit")
  private String sCustomUnit;

  /**
   * 被拆分标记
   */
  @TableField("pBeSplitFlag")
  private Boolean pBeSplitFlag;

  /**
   * 拆分单标记
   */
  @TableField("pSplitDocFlag")
  private Boolean pSplitDocFlag;

  /**
   * 关联被拆分单据ID
   */
  @TableField("pRefBeSplitDocId")
  private String pRefBeSplitDocId;

  /**
   * 关联被拆分单据编号
   */
  @TableField("pRefBeSplitDocNo")
  private String pRefBeSplitDocNo;

  /**
   * 业务头MD5
   */
  @TableField("businessHeaderMD5")
  private String businessHeaderMD5;

  /**
   * 销方批量包装数量
   */
  @TableField("sPackageQty")
  private BigDecimal sPackageQty;

  /**
   * 销方单据单位数量
   */
  @TableField("sQty")
  private BigDecimal sQty;

  /**
   * 销方总重量
   */
  @TableField("sTotalWeight")
  private BigDecimal sTotalWeight;

  /**
   * 库存余额金额（含税）
   */
  @TableField("stockAmountWithTax")
  private BigDecimal stockAmountWithTax;

  /**
   * 库存余额金额（不含税）
   */
  @TableField("stockAmountWithoutTax")
  private BigDecimal stockAmountWithoutTax;

  /**
   * 进货金额（含税）
   */
  @TableField("purchaseAmountWithTax")
  private BigDecimal purchaseAmountWithTax;

  /**
   * 进货金额（不含税）
   */
  @TableField("purchaseAmountWithoutTax")
  private BigDecimal purchaseAmountWithoutTax;

  /**
   * 在途金额（含税）
   */
  @TableField("transitAmountWithTax")
  private BigDecimal transitAmountWithTax;

  /**
   * 在途金额（不含税）
   */
  @TableField("transitAmountWithoutTax")
  private BigDecimal transitAmountWithoutTax;

  /**
   * 商品状态
   */
  @TableField("itemStatus")
  private String itemStatus;

  /**
   * 日志Id
   */
  @TableField("traceId")
  private String traceId;

  /**
   * 平均进货单价（含税）
   */
  @TableField("averagePurchasePriceWithTax")
  private BigDecimal averagePurchasePriceWithTax;

  /**
   * 平均进货单价（不含税）
   */
  @TableField("averagePurchasePriceWithoutTax")
  private BigDecimal averagePurchasePriceWithoutTax;

  /**
   * 税率
   */
  @TableField("taxRate")
  private BigDecimal taxRate;

  /**
   * 库存周转天数
   */
  @TableField("daysOfInventory")
  private BigDecimal daysOfInventory;

  /**
   * 库存周转率
   */
  @TableField("daysOfInventoryRatio")
  private BigDecimal daysOfInventoryRatio;

  /**
   * 库存可销售天数
   */
  @TableField("daysOfSales")
  private BigDecimal daysOfSales;

  /**
   * 期初数量
   */
  @TableField("openingQty")
  private BigDecimal openingQty;

  /**
   * 期初金额（含税）
   */
  @TableField("openingAmountWithTax")
  private BigDecimal openingAmountWithTax;

  /**
   * 期初金额（不含税）
   */
  @TableField("openingAmountWithoutTax")
  private BigDecimal openingAmountWithoutTax;

  /**
   * 采集渠道
   */
  @TableField("collectionChannel")
  private String collectionChannel;

  /**
   * 仓库库存数量
   */
  @TableField("storageStockQty")
  private BigDecimal storageStockQty;

  /**
   * 库存类型
   */
  @TableField("stockType")
  private String stockType;

  /**
   * 销售趋势分类
   */
  @TableField("salesTrendClassification")
  private String salesTrendClassification;

  /**
   * 销方品牌
   */
  @TableField("sBrand")
  private String sBrand;

  /**
   * 销方子品牌
   */
  @TableField("sSubBrand")
  private String sSubBrand;

  /**
   * 销售组编码
   */
  @TableField("sSalesGroupCode")
  private String sSalesGroupCode;

  /**
   * 销售组名称
   */
  @TableField("sSalesGroupName")
  private String sSalesGroupName;

  /**
   * 销售部门
   */
  @TableField("sSalesDepartmentName")
  private String sSalesDepartmentName;

  /**
   * 分销渠道名称
   */
  @TableField("sDistributionChannelName")
  private String sDistributionChannelName;

  /**
   * 分销渠道编码
   */
  @TableField("sDistributionChannelCode")
  private String sDistributionChannelCode;

  /**
   * 组织树
   */
  private String orgTree;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("latest", latest);
      map.put("srcids", srcids);
      map.put("belongTenant", belongTenant);
      map.put("collectionAccount", collectionAccount);
      map.put("collectionBatch", collectionBatch);
      map.put("collectionDate", BocpGenUtils.toTimestamp(collectionDate));
      map.put("purchaseCompanyTaxNo", purchaseCompanyTaxNo);
      map.put("purchaseRetailerId", purchaseRetailerId);
      map.put("purchaseRetailerName", purchaseRetailerName);
      map.put("purchaseCompanyCode", purchaseCompanyCode);
      map.put("purchaseCompanyName", purchaseCompanyName);
      map.put("regionCode", regionCode);
      map.put("regionName", regionName);
      map.put("purchaseStoreCode", purchaseStoreCode);
      map.put("purchaseStoreGLN", purchaseStoreGLN);
      map.put("purchaseStoreName", purchaseStoreName);
      map.put("categoryCode", categoryCode);
      map.put("categoryName", categoryName);
      map.put("sellerCode", sellerCode);
      map.put("sellerName", sellerName);
      map.put("itemCode", itemCode);
      map.put("barcode", barcode);
      map.put("itemSubCode", itemSubCode);
      map.put("itemDesc", itemDesc);
      map.put("brand", brand);
      map.put("standards", standards);
      map.put("model", model);
      map.put("unit", unit);
      map.put("sectionType", sectionType);
      map.put("sectionDate", sectionDate);
      map.put("purchaseQty", purchaseQty);
      map.put("averagePurchaseAmt", averagePurchaseAmt);
      map.put("salesQty", salesQty);
      map.put("saleAmt", saleAmt);
      map.put("averageSaleQty", averageSaleQty);
      map.put("stockDate", BocpGenUtils.toTimestamp(stockDate));
      map.put("stockQty", stockQty);
      map.put("transitQty", transitQty);
      map.put("remark", remark);
      map.put("extstr1", extstr1);
      map.put("extstr2", extstr2);
      map.put("extstr3", extstr3);
      map.put("extstr4", extstr4);
      map.put("extstr5", extstr5);
      map.put("extstr6", extstr6);
      map.put("extstr7", extstr7);
      map.put("extstr8", extstr8);
      map.put("extstr9", extstr9);
      map.put("extstr10", extstr10);
      map.put("vvariableid", vvariableid);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("docTransformer", docTransformer);
      map.put("pBusinessId", pBusinessId);
      map.put("versionNo", versionNo);
      map.put("purchaseBusinessTypeNo", purchaseBusinessTypeNo);
      map.put("purchaseBusinessTypeName", purchaseBusinessTypeName);
      map.put("sVersionNo", sVersionNo);
      map.put("sSoldToCode", sSoldToCode);
      map.put("sSoldToName", sSoldToName);
      map.put("sShipToCode", sShipToCode);
      map.put("sShipToName", sShipToName);
      map.put("sCustomerGroupCode", sCustomerGroupCode);
      map.put("sCustomerGroupName", sCustomerGroupName);
      map.put("sCustomerType", sCustomerType);
      map.put("sCustomerCode", sCustomerCode);
      map.put("sCustomerName", sCustomerName);
      map.put("sBuCode", sBuCode);
      map.put("sBuName", sBuName);
      map.put("sCompanyCode", sCompanyCode);
      map.put("sCompanyName", sCompanyName);
      map.put("sCompanyTaxNo", sCompanyTaxNo);
      map.put("sSalesOrganizationCode", sSalesOrganizationCode);
      map.put("sSalesOrganizationName", sSalesOrganizationName);
      map.put("priceStatus", priceStatus);
      map.put("pSourceFileURL", pSourceFileURL);
      map.put("pUnifyDocFlag", pUnifyDocFlag);
      map.put("pTenantDocFlag", pTenantDocFlag);
      map.put("batchNumberOD2UD", batchNumberOD2UD);
      map.put("pDeleteFlag", pDeleteFlag);
      map.put("dataStatus", dataStatus);
      map.put("dataIssueID", dataIssueID);
      map.put("statisticalHeaderMD5", statisticalHeaderMD5);
      map.put("dataMD5", dataMD5);
      map.put("sItemCode", sItemCode);
      map.put("sBarcode", sBarcode);
      map.put("sItemSubCode", sItemSubCode);
      map.put("sItemDesc", sItemDesc);
      map.put("sSuitFlag", sSuitFlag);
      map.put("sSuitInfo", sSuitInfo);
      map.put("sNewOldFlag", sNewOldFlag);
      map.put("sNewOldInfo", sNewOldInfo);
      map.put("sUnitRules", sUnitRules);
      map.put("sPackageUnit", sPackageUnit);
      map.put("sPackageSize", sPackageSize);
      map.put("sUnit", sUnit);
      map.put("sCustomUnit", sCustomUnit);
      map.put("pBeSplitFlag", pBeSplitFlag);
      map.put("pSplitDocFlag", pSplitDocFlag);
      map.put("pRefBeSplitDocId", pRefBeSplitDocId);
      map.put("pRefBeSplitDocNo", pRefBeSplitDocNo);
      map.put("businessHeaderMD5", businessHeaderMD5);
      map.put("sPackageQty", sPackageQty);
      map.put("sQty", sQty);
      map.put("sTotalWeight", sTotalWeight);
      map.put("stockAmountWithTax", stockAmountWithTax);
      map.put("stockAmountWithoutTax", stockAmountWithoutTax);
      map.put("purchaseAmountWithTax", purchaseAmountWithTax);
      map.put("purchaseAmountWithoutTax", purchaseAmountWithoutTax);
      map.put("transitAmountWithTax", transitAmountWithTax);
      map.put("transitAmountWithoutTax", transitAmountWithoutTax);
      map.put("itemStatus", itemStatus);
      map.put("traceId", traceId);
      map.put("averagePurchasePriceWithTax", averagePurchasePriceWithTax);
      map.put("averagePurchasePriceWithoutTax", averagePurchasePriceWithoutTax);
      map.put("taxRate", taxRate);
      map.put("daysOfInventory", daysOfInventory);
      map.put("daysOfInventoryRatio", daysOfInventoryRatio);
      map.put("daysOfSales", daysOfSales);
      map.put("openingQty", openingQty);
      map.put("openingAmountWithTax", openingAmountWithTax);
      map.put("openingAmountWithoutTax", openingAmountWithoutTax);
      map.put("collectionChannel", collectionChannel);
      map.put("storageStockQty", storageStockQty);
      map.put("stockType", stockType);
      map.put("salesTrendClassification", salesTrendClassification);
      map.put("sBrand", sBrand);
      map.put("sSubBrand", sSubBrand);
      map.put("sSalesGroupCode", sSalesGroupCode);
      map.put("sSalesGroupName", sSalesGroupName);
      map.put("sSalesDepartmentName", sSalesDepartmentName);
      map.put("sDistributionChannelName", sDistributionChannelName);
      map.put("sDistributionChannelCode", sDistributionChannelCode);
      map.put("org_tree", orgTree);

      return map;
  }

  public static Inventory fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    Inventory entity = new Inventory();
    if(map.containsKey("latest")) {
      Object obj = map.get("latest");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setLatest((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setLatest(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("srcids")) {
      Object obj = map.get("srcids");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSrcids((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("belongTenant")) {
      Object obj = map.get("belongTenant");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBelongTenant((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("collectionAccount")) {
      Object obj = map.get("collectionAccount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCollectionAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("collectionBatch")) {
      Object obj = map.get("collectionBatch");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCollectionBatch((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("collectionDate")) {
      Object obj = map.get("collectionDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCollectionDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCollectionDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCollectionDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCollectionDate(null);
      }
    }
    if(map.containsKey("purchaseCompanyTaxNo")) {
      Object obj = map.get("purchaseCompanyTaxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseCompanyTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseRetailerId")) {
      Object obj = map.get("purchaseRetailerId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseRetailerId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseRetailerName")) {
      Object obj = map.get("purchaseRetailerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseRetailerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseCompanyCode")) {
      Object obj = map.get("purchaseCompanyCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseCompanyCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseCompanyName")) {
      Object obj = map.get("purchaseCompanyName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseCompanyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("regionCode")) {
      Object obj = map.get("regionCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRegionCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("regionName")) {
      Object obj = map.get("regionName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRegionName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseStoreCode")) {
      Object obj = map.get("purchaseStoreCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseStoreCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseStoreGLN")) {
      Object obj = map.get("purchaseStoreGLN");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseStoreGLN((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseStoreName")) {
      Object obj = map.get("purchaseStoreName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseStoreName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("categoryCode")) {
      Object obj = map.get("categoryCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCategoryCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("categoryName")) {
      Object obj = map.get("categoryName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCategoryName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerCode")) {
      Object obj = map.get("sellerCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerName")) {
      Object obj = map.get("sellerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("itemCode")) {
      Object obj = map.get("itemCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setItemCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("barcode")) {
      Object obj = map.get("barcode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBarcode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("itemSubCode")) {
      Object obj = map.get("itemSubCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setItemSubCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("itemDesc")) {
      Object obj = map.get("itemDesc");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setItemDesc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("brand")) {
      Object obj = map.get("brand");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBrand((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("standards")) {
      Object obj = map.get("standards");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setStandards((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("model")) {
      Object obj = map.get("model");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setModel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("unit")) {
      Object obj = map.get("unit");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sectionType")) {
      Object obj = map.get("sectionType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSectionType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sectionDate")) {
      Object obj = map.get("sectionDate");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSectionDate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseQty")) {
      Object obj = map.get("purchaseQty");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseQty((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("averagePurchaseAmt")) {
      Object obj = map.get("averagePurchaseAmt");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAveragePurchaseAmt((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAveragePurchaseAmt(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAveragePurchaseAmt(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAveragePurchaseAmt(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAveragePurchaseAmt(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("salesQty")) {
      Object obj = map.get("salesQty");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSalesQty((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSalesQty(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSalesQty(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSalesQty(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSalesQty(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("saleAmt")) {
      Object obj = map.get("saleAmt");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSaleAmt((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSaleAmt(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSaleAmt(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSaleAmt(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSaleAmt(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("averageSaleQty")) {
      Object obj = map.get("averageSaleQty");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAverageSaleQty((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAverageSaleQty(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAverageSaleQty(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAverageSaleQty(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAverageSaleQty(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("stockDate")) {
      Object obj = map.get("stockDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setStockDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setStockDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setStockDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setStockDate(null);
      }
    }
    if(map.containsKey("stockQty")) {
      Object obj = map.get("stockQty");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setStockQty((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setStockQty(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setStockQty(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setStockQty(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setStockQty(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("transitQty")) {
      Object obj = map.get("transitQty");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTransitQty((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTransitQty(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTransitQty(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTransitQty(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTransitQty(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("extstr1")) {
      Object obj = map.get("extstr1");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExtstr1((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("extstr2")) {
      Object obj = map.get("extstr2");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExtstr2((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("extstr3")) {
      Object obj = map.get("extstr3");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExtstr3((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("extstr4")) {
      Object obj = map.get("extstr4");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExtstr4((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("extstr5")) {
      Object obj = map.get("extstr5");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExtstr5((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("extstr6")) {
      Object obj = map.get("extstr6");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExtstr6((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("extstr7")) {
      Object obj = map.get("extstr7");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExtstr7((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("extstr8")) {
      Object obj = map.get("extstr8");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExtstr8((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("extstr9")) {
      Object obj = map.get("extstr9");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExtstr9((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("extstr10")) {
      Object obj = map.get("extstr10");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExtstr10((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("vvariableid")) {
      Object obj = map.get("vvariableid");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setVvariableid((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("docTransformer")) {
      Object obj = map.get("docTransformer");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDocTransformer((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pBusinessId")) {
      Object obj = map.get("pBusinessId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPBusinessId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("versionNo")) {
      Object obj = map.get("versionNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setVersionNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseBusinessTypeNo")) {
      Object obj = map.get("purchaseBusinessTypeNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseBusinessTypeNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseBusinessTypeName")) {
      Object obj = map.get("purchaseBusinessTypeName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseBusinessTypeName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sVersionNo")) {
      Object obj = map.get("sVersionNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSVersionNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sSoldToCode")) {
      Object obj = map.get("sSoldToCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSSoldToCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sSoldToName")) {
      Object obj = map.get("sSoldToName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSSoldToName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sShipToCode")) {
      Object obj = map.get("sShipToCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSShipToCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sShipToName")) {
      Object obj = map.get("sShipToName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSShipToName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sCustomerGroupCode")) {
      Object obj = map.get("sCustomerGroupCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSCustomerGroupCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sCustomerGroupName")) {
      Object obj = map.get("sCustomerGroupName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSCustomerGroupName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sCustomerType")) {
      Object obj = map.get("sCustomerType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSCustomerType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sCustomerCode")) {
      Object obj = map.get("sCustomerCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSCustomerCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sCustomerName")) {
      Object obj = map.get("sCustomerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSCustomerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sBuCode")) {
      Object obj = map.get("sBuCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSBuCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sBuName")) {
      Object obj = map.get("sBuName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSBuName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sCompanyCode")) {
      Object obj = map.get("sCompanyCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSCompanyCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sCompanyName")) {
      Object obj = map.get("sCompanyName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSCompanyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sCompanyTaxNo")) {
      Object obj = map.get("sCompanyTaxNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSCompanyTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sSalesOrganizationCode")) {
      Object obj = map.get("sSalesOrganizationCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSSalesOrganizationCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sSalesOrganizationName")) {
      Object obj = map.get("sSalesOrganizationName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSSalesOrganizationName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("priceStatus")) {
      Object obj = map.get("priceStatus");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPriceStatus((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPriceStatus(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPriceStatus(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("pSourceFileURL")) {
      Object obj = map.get("pSourceFileURL");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPSourceFileURL((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pUnifyDocFlag")) {
      Object obj = map.get("pUnifyDocFlag");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setPUnifyDocFlag((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPUnifyDocFlag(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("pTenantDocFlag")) {
      Object obj = map.get("pTenantDocFlag");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setPTenantDocFlag((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPTenantDocFlag(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("batchNumberOD2UD")) {
      Object obj = map.get("batchNumberOD2UD");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBatchNumberOD2UD((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pDeleteFlag")) {
      Object obj = map.get("pDeleteFlag");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setPDeleteFlag((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPDeleteFlag(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("dataStatus")) {
      Object obj = map.get("dataStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDataStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("dataIssueID")) {
      Object obj = map.get("dataIssueID");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDataIssueID((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("statisticalHeaderMD5")) {
      Object obj = map.get("statisticalHeaderMD5");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setStatisticalHeaderMD5((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("dataMD5")) {
      Object obj = map.get("dataMD5");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDataMD5((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sItemCode")) {
      Object obj = map.get("sItemCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSItemCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sBarcode")) {
      Object obj = map.get("sBarcode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSBarcode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sItemSubCode")) {
      Object obj = map.get("sItemSubCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSItemSubCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sItemDesc")) {
      Object obj = map.get("sItemDesc");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSItemDesc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sSuitFlag")) {
      Object obj = map.get("sSuitFlag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSSuitFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sSuitInfo")) {
      Object obj = map.get("sSuitInfo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSSuitInfo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sNewOldFlag")) {
      Object obj = map.get("sNewOldFlag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSNewOldFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sNewOldInfo")) {
      Object obj = map.get("sNewOldInfo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSNewOldInfo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sUnitRules")) {
      Object obj = map.get("sUnitRules");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSUnitRules((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sPackageUnit")) {
      Object obj = map.get("sPackageUnit");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSPackageUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sPackageSize")) {
      Object obj = map.get("sPackageSize");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSPackageSize((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sUnit")) {
      Object obj = map.get("sUnit");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sCustomUnit")) {
      Object obj = map.get("sCustomUnit");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSCustomUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pBeSplitFlag")) {
      Object obj = map.get("pBeSplitFlag");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setPBeSplitFlag((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPBeSplitFlag(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("pSplitDocFlag")) {
      Object obj = map.get("pSplitDocFlag");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setPSplitDocFlag((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPSplitDocFlag(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("pRefBeSplitDocId")) {
      Object obj = map.get("pRefBeSplitDocId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPRefBeSplitDocId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pRefBeSplitDocNo")) {
      Object obj = map.get("pRefBeSplitDocNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPRefBeSplitDocNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("businessHeaderMD5")) {
      Object obj = map.get("businessHeaderMD5");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBusinessHeaderMD5((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sPackageQty")) {
      Object obj = map.get("sPackageQty");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSPackageQty((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSPackageQty(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSPackageQty(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSPackageQty(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSPackageQty(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("sQty")) {
      Object obj = map.get("sQty");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSQty((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSQty(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSQty(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSQty(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSQty(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("sTotalWeight")) {
      Object obj = map.get("sTotalWeight");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSTotalWeight((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSTotalWeight(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSTotalWeight(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSTotalWeight(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSTotalWeight(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("stockAmountWithTax")) {
      Object obj = map.get("stockAmountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setStockAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setStockAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setStockAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setStockAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setStockAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("stockAmountWithoutTax")) {
      Object obj = map.get("stockAmountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setStockAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setStockAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setStockAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setStockAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setStockAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("purchaseAmountWithTax")) {
      Object obj = map.get("purchaseAmountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPurchaseAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPurchaseAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPurchaseAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPurchaseAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPurchaseAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("purchaseAmountWithoutTax")) {
      Object obj = map.get("purchaseAmountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPurchaseAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPurchaseAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPurchaseAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPurchaseAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPurchaseAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("transitAmountWithTax")) {
      Object obj = map.get("transitAmountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTransitAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTransitAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTransitAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTransitAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTransitAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("transitAmountWithoutTax")) {
      Object obj = map.get("transitAmountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTransitAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTransitAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTransitAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTransitAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTransitAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("itemStatus")) {
      Object obj = map.get("itemStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setItemStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("traceId")) {
      Object obj = map.get("traceId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTraceId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("averagePurchasePriceWithTax")) {
      Object obj = map.get("averagePurchasePriceWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAveragePurchasePriceWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAveragePurchasePriceWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAveragePurchasePriceWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAveragePurchasePriceWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAveragePurchasePriceWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("averagePurchasePriceWithoutTax")) {
      Object obj = map.get("averagePurchasePriceWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAveragePurchasePriceWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAveragePurchasePriceWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAveragePurchasePriceWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAveragePurchasePriceWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAveragePurchasePriceWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("taxRate")) {
      Object obj = map.get("taxRate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTaxRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTaxRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTaxRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTaxRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTaxRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("daysOfInventory")) {
      Object obj = map.get("daysOfInventory");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setDaysOfInventory((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setDaysOfInventory(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setDaysOfInventory(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setDaysOfInventory(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setDaysOfInventory(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("daysOfInventoryRatio")) {
      Object obj = map.get("daysOfInventoryRatio");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setDaysOfInventoryRatio((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setDaysOfInventoryRatio(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setDaysOfInventoryRatio(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setDaysOfInventoryRatio(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setDaysOfInventoryRatio(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("daysOfSales")) {
      Object obj = map.get("daysOfSales");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setDaysOfSales((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setDaysOfSales(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setDaysOfSales(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setDaysOfSales(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setDaysOfSales(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("openingQty")) {
      Object obj = map.get("openingQty");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setOpeningQty((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setOpeningQty(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setOpeningQty(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setOpeningQty(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setOpeningQty(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("openingAmountWithTax")) {
      Object obj = map.get("openingAmountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setOpeningAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setOpeningAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setOpeningAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setOpeningAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setOpeningAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("openingAmountWithoutTax")) {
      Object obj = map.get("openingAmountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setOpeningAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setOpeningAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setOpeningAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setOpeningAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setOpeningAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("collectionChannel")) {
      Object obj = map.get("collectionChannel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCollectionChannel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("storageStockQty")) {
      Object obj = map.get("storageStockQty");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setStorageStockQty((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setStorageStockQty(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setStorageStockQty(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setStorageStockQty(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setStorageStockQty(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("stockType")) {
      Object obj = map.get("stockType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setStockType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("salesTrendClassification")) {
      Object obj = map.get("salesTrendClassification");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSalesTrendClassification((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sBrand")) {
      Object obj = map.get("sBrand");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSBrand((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sSubBrand")) {
      Object obj = map.get("sSubBrand");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSSubBrand((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sSalesGroupCode")) {
      Object obj = map.get("sSalesGroupCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSSalesGroupCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sSalesGroupName")) {
      Object obj = map.get("sSalesGroupName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSSalesGroupName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sSalesDepartmentName")) {
      Object obj = map.get("sSalesDepartmentName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSSalesDepartmentName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sDistributionChannelName")) {
      Object obj = map.get("sDistributionChannelName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSDistributionChannelName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sDistributionChannelCode")) {
      Object obj = map.get("sDistributionChannelCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSDistributionChannelCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrgTree((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("latest")) {
      Object obj = map.get("latest");
      if(obj != null) {
        if(obj instanceof Boolean) {
          this.setLatest((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setLatest(Boolean.valueOf((String)obj));
        }
      } else {
      }
    }
    if(map.containsKey("srcids")) {
      Object obj = map.get("srcids");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSrcids((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("belongTenant")) {
      Object obj = map.get("belongTenant");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBelongTenant((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("collectionAccount")) {
      Object obj = map.get("collectionAccount");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCollectionAccount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("collectionBatch")) {
      Object obj = map.get("collectionBatch");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCollectionBatch((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("collectionDate")) {
      Object obj = map.get("collectionDate");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCollectionDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCollectionDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCollectionDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCollectionDate(null);
      }
    }
    if(map.containsKey("purchaseCompanyTaxNo")) {
      Object obj = map.get("purchaseCompanyTaxNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaseCompanyTaxNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaseRetailerId")) {
      Object obj = map.get("purchaseRetailerId");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaseRetailerId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaseRetailerName")) {
      Object obj = map.get("purchaseRetailerName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaseRetailerName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaseCompanyCode")) {
      Object obj = map.get("purchaseCompanyCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaseCompanyCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaseCompanyName")) {
      Object obj = map.get("purchaseCompanyName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaseCompanyName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("regionCode")) {
      Object obj = map.get("regionCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRegionCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("regionName")) {
      Object obj = map.get("regionName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRegionName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaseStoreCode")) {
      Object obj = map.get("purchaseStoreCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaseStoreCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaseStoreGLN")) {
      Object obj = map.get("purchaseStoreGLN");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaseStoreGLN((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaseStoreName")) {
      Object obj = map.get("purchaseStoreName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaseStoreName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("categoryCode")) {
      Object obj = map.get("categoryCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCategoryCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("categoryName")) {
      Object obj = map.get("categoryName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCategoryName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerCode")) {
      Object obj = map.get("sellerCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerName")) {
      Object obj = map.get("sellerName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("itemCode")) {
      Object obj = map.get("itemCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setItemCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("barcode")) {
      Object obj = map.get("barcode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBarcode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("itemSubCode")) {
      Object obj = map.get("itemSubCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setItemSubCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("itemDesc")) {
      Object obj = map.get("itemDesc");
      if(obj != null) {
        if(obj instanceof String) {
          this.setItemDesc((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("brand")) {
      Object obj = map.get("brand");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBrand((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("standards")) {
      Object obj = map.get("standards");
      if(obj != null) {
        if(obj instanceof String) {
          this.setStandards((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("model")) {
      Object obj = map.get("model");
      if(obj != null) {
        if(obj instanceof String) {
          this.setModel((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("unit")) {
      Object obj = map.get("unit");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUnit((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sectionType")) {
      Object obj = map.get("sectionType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSectionType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sectionDate")) {
      Object obj = map.get("sectionDate");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSectionDate((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaseQty")) {
      Object obj = map.get("purchaseQty");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaseQty((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("averagePurchaseAmt")) {
      Object obj = map.get("averagePurchaseAmt");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setAveragePurchaseAmt((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setAveragePurchaseAmt(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setAveragePurchaseAmt(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setAveragePurchaseAmt(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setAveragePurchaseAmt(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("salesQty")) {
      Object obj = map.get("salesQty");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setSalesQty((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setSalesQty(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setSalesQty(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSalesQty(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setSalesQty(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("saleAmt")) {
      Object obj = map.get("saleAmt");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setSaleAmt((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setSaleAmt(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setSaleAmt(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSaleAmt(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setSaleAmt(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("averageSaleQty")) {
      Object obj = map.get("averageSaleQty");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setAverageSaleQty((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setAverageSaleQty(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setAverageSaleQty(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setAverageSaleQty(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setAverageSaleQty(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("stockDate")) {
      Object obj = map.get("stockDate");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setStockDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setStockDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setStockDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setStockDate(null);
      }
    }
    if(map.containsKey("stockQty")) {
      Object obj = map.get("stockQty");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setStockQty((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setStockQty(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setStockQty(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setStockQty(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setStockQty(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("transitQty")) {
      Object obj = map.get("transitQty");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setTransitQty((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setTransitQty(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setTransitQty(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTransitQty(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setTransitQty(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRemark((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("extstr1")) {
      Object obj = map.get("extstr1");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExtstr1((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("extstr2")) {
      Object obj = map.get("extstr2");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExtstr2((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("extstr3")) {
      Object obj = map.get("extstr3");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExtstr3((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("extstr4")) {
      Object obj = map.get("extstr4");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExtstr4((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("extstr5")) {
      Object obj = map.get("extstr5");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExtstr5((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("extstr6")) {
      Object obj = map.get("extstr6");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExtstr6((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("extstr7")) {
      Object obj = map.get("extstr7");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExtstr7((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("extstr8")) {
      Object obj = map.get("extstr8");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExtstr8((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("extstr9")) {
      Object obj = map.get("extstr9");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExtstr9((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("extstr10")) {
      Object obj = map.get("extstr10");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExtstr10((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("vvariableid")) {
      Object obj = map.get("vvariableid");
      if(obj != null) {
        if(obj instanceof String) {
          this.setVvariableid((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("docTransformer")) {
      Object obj = map.get("docTransformer");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDocTransformer((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("pBusinessId")) {
      Object obj = map.get("pBusinessId");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPBusinessId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("versionNo")) {
      Object obj = map.get("versionNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setVersionNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaseBusinessTypeNo")) {
      Object obj = map.get("purchaseBusinessTypeNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaseBusinessTypeNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaseBusinessTypeName")) {
      Object obj = map.get("purchaseBusinessTypeName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaseBusinessTypeName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sVersionNo")) {
      Object obj = map.get("sVersionNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSVersionNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sSoldToCode")) {
      Object obj = map.get("sSoldToCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSSoldToCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sSoldToName")) {
      Object obj = map.get("sSoldToName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSSoldToName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sShipToCode")) {
      Object obj = map.get("sShipToCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSShipToCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sShipToName")) {
      Object obj = map.get("sShipToName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSShipToName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sCustomerGroupCode")) {
      Object obj = map.get("sCustomerGroupCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSCustomerGroupCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sCustomerGroupName")) {
      Object obj = map.get("sCustomerGroupName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSCustomerGroupName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sCustomerType")) {
      Object obj = map.get("sCustomerType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSCustomerType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sCustomerCode")) {
      Object obj = map.get("sCustomerCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSCustomerCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sCustomerName")) {
      Object obj = map.get("sCustomerName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSCustomerName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sBuCode")) {
      Object obj = map.get("sBuCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSBuCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sBuName")) {
      Object obj = map.get("sBuName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSBuName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sCompanyCode")) {
      Object obj = map.get("sCompanyCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSCompanyCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sCompanyName")) {
      Object obj = map.get("sCompanyName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSCompanyName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sCompanyTaxNo")) {
      Object obj = map.get("sCompanyTaxNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSCompanyTaxNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sSalesOrganizationCode")) {
      Object obj = map.get("sSalesOrganizationCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSSalesOrganizationCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sSalesOrganizationName")) {
      Object obj = map.get("sSalesOrganizationName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSSalesOrganizationName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("priceStatus")) {
      Object obj = map.get("priceStatus");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setPriceStatus((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPriceStatus(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setPriceStatus(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("pSourceFileURL")) {
      Object obj = map.get("pSourceFileURL");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPSourceFileURL((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("pUnifyDocFlag")) {
      Object obj = map.get("pUnifyDocFlag");
      if(obj != null) {
        if(obj instanceof Boolean) {
          this.setPUnifyDocFlag((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPUnifyDocFlag(Boolean.valueOf((String)obj));
        }
      } else {
      }
    }
    if(map.containsKey("pTenantDocFlag")) {
      Object obj = map.get("pTenantDocFlag");
      if(obj != null) {
        if(obj instanceof Boolean) {
          this.setPTenantDocFlag((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPTenantDocFlag(Boolean.valueOf((String)obj));
        }
      } else {
      }
    }
    if(map.containsKey("batchNumberOD2UD")) {
      Object obj = map.get("batchNumberOD2UD");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBatchNumberOD2UD((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("pDeleteFlag")) {
      Object obj = map.get("pDeleteFlag");
      if(obj != null) {
        if(obj instanceof Boolean) {
          this.setPDeleteFlag((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPDeleteFlag(Boolean.valueOf((String)obj));
        }
      } else {
      }
    }
    if(map.containsKey("dataStatus")) {
      Object obj = map.get("dataStatus");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDataStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("dataIssueID")) {
      Object obj = map.get("dataIssueID");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDataIssueID((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("statisticalHeaderMD5")) {
      Object obj = map.get("statisticalHeaderMD5");
      if(obj != null) {
        if(obj instanceof String) {
          this.setStatisticalHeaderMD5((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("dataMD5")) {
      Object obj = map.get("dataMD5");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDataMD5((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sItemCode")) {
      Object obj = map.get("sItemCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSItemCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sBarcode")) {
      Object obj = map.get("sBarcode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSBarcode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sItemSubCode")) {
      Object obj = map.get("sItemSubCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSItemSubCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sItemDesc")) {
      Object obj = map.get("sItemDesc");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSItemDesc((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sSuitFlag")) {
      Object obj = map.get("sSuitFlag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSSuitFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sSuitInfo")) {
      Object obj = map.get("sSuitInfo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSSuitInfo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sNewOldFlag")) {
      Object obj = map.get("sNewOldFlag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSNewOldFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sNewOldInfo")) {
      Object obj = map.get("sNewOldInfo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSNewOldInfo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sUnitRules")) {
      Object obj = map.get("sUnitRules");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSUnitRules((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sPackageUnit")) {
      Object obj = map.get("sPackageUnit");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSPackageUnit((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sPackageSize")) {
      Object obj = map.get("sPackageSize");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSPackageSize((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sUnit")) {
      Object obj = map.get("sUnit");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSUnit((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sCustomUnit")) {
      Object obj = map.get("sCustomUnit");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSCustomUnit((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("pBeSplitFlag")) {
      Object obj = map.get("pBeSplitFlag");
      if(obj != null) {
        if(obj instanceof Boolean) {
          this.setPBeSplitFlag((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPBeSplitFlag(Boolean.valueOf((String)obj));
        }
      } else {
      }
    }
    if(map.containsKey("pSplitDocFlag")) {
      Object obj = map.get("pSplitDocFlag");
      if(obj != null) {
        if(obj instanceof Boolean) {
          this.setPSplitDocFlag((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPSplitDocFlag(Boolean.valueOf((String)obj));
        }
      } else {
      }
    }
    if(map.containsKey("pRefBeSplitDocId")) {
      Object obj = map.get("pRefBeSplitDocId");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPRefBeSplitDocId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("pRefBeSplitDocNo")) {
      Object obj = map.get("pRefBeSplitDocNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPRefBeSplitDocNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("businessHeaderMD5")) {
      Object obj = map.get("businessHeaderMD5");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBusinessHeaderMD5((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sPackageQty")) {
      Object obj = map.get("sPackageQty");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setSPackageQty((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setSPackageQty(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setSPackageQty(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSPackageQty(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setSPackageQty(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("sQty")) {
      Object obj = map.get("sQty");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setSQty((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setSQty(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setSQty(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSQty(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setSQty(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("sTotalWeight")) {
      Object obj = map.get("sTotalWeight");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setSTotalWeight((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setSTotalWeight(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setSTotalWeight(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSTotalWeight(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setSTotalWeight(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("stockAmountWithTax")) {
      Object obj = map.get("stockAmountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setStockAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setStockAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setStockAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setStockAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setStockAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("stockAmountWithoutTax")) {
      Object obj = map.get("stockAmountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setStockAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setStockAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setStockAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setStockAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setStockAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("purchaseAmountWithTax")) {
      Object obj = map.get("purchaseAmountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setPurchaseAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setPurchaseAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setPurchaseAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPurchaseAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setPurchaseAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("purchaseAmountWithoutTax")) {
      Object obj = map.get("purchaseAmountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setPurchaseAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setPurchaseAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setPurchaseAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPurchaseAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setPurchaseAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("transitAmountWithTax")) {
      Object obj = map.get("transitAmountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setTransitAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setTransitAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setTransitAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTransitAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setTransitAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("transitAmountWithoutTax")) {
      Object obj = map.get("transitAmountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setTransitAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setTransitAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setTransitAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTransitAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setTransitAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("itemStatus")) {
      Object obj = map.get("itemStatus");
      if(obj != null) {
        if(obj instanceof String) {
          this.setItemStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("traceId")) {
      Object obj = map.get("traceId");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTraceId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("averagePurchasePriceWithTax")) {
      Object obj = map.get("averagePurchasePriceWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setAveragePurchasePriceWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setAveragePurchasePriceWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setAveragePurchasePriceWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setAveragePurchasePriceWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setAveragePurchasePriceWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("averagePurchasePriceWithoutTax")) {
      Object obj = map.get("averagePurchasePriceWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setAveragePurchasePriceWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setAveragePurchasePriceWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setAveragePurchasePriceWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setAveragePurchasePriceWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setAveragePurchasePriceWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("taxRate")) {
      Object obj = map.get("taxRate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setTaxRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setTaxRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setTaxRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTaxRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setTaxRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("daysOfInventory")) {
      Object obj = map.get("daysOfInventory");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setDaysOfInventory((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setDaysOfInventory(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setDaysOfInventory(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setDaysOfInventory(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setDaysOfInventory(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("daysOfInventoryRatio")) {
      Object obj = map.get("daysOfInventoryRatio");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setDaysOfInventoryRatio((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setDaysOfInventoryRatio(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setDaysOfInventoryRatio(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setDaysOfInventoryRatio(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setDaysOfInventoryRatio(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("daysOfSales")) {
      Object obj = map.get("daysOfSales");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setDaysOfSales((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setDaysOfSales(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setDaysOfSales(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setDaysOfSales(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setDaysOfSales(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("openingQty")) {
      Object obj = map.get("openingQty");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setOpeningQty((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setOpeningQty(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setOpeningQty(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setOpeningQty(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setOpeningQty(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("openingAmountWithTax")) {
      Object obj = map.get("openingAmountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setOpeningAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setOpeningAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setOpeningAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setOpeningAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setOpeningAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("openingAmountWithoutTax")) {
      Object obj = map.get("openingAmountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setOpeningAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setOpeningAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setOpeningAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setOpeningAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setOpeningAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("collectionChannel")) {
      Object obj = map.get("collectionChannel");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCollectionChannel((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("storageStockQty")) {
      Object obj = map.get("storageStockQty");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setStorageStockQty((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setStorageStockQty(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setStorageStockQty(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setStorageStockQty(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setStorageStockQty(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("stockType")) {
      Object obj = map.get("stockType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setStockType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("salesTrendClassification")) {
      Object obj = map.get("salesTrendClassification");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSalesTrendClassification((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sBrand")) {
      Object obj = map.get("sBrand");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSBrand((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sSubBrand")) {
      Object obj = map.get("sSubBrand");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSSubBrand((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sSalesGroupCode")) {
      Object obj = map.get("sSalesGroupCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSSalesGroupCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sSalesGroupName")) {
      Object obj = map.get("sSalesGroupName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSSalesGroupName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sSalesDepartmentName")) {
      Object obj = map.get("sSalesDepartmentName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSSalesDepartmentName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sDistributionChannelName")) {
      Object obj = map.get("sDistributionChannelName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSDistributionChannelName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sDistributionChannelCode")) {
      Object obj = map.get("sDistributionChannelCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSDistributionChannelCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrgTree((String)obj);
        }
      } else {
      }
    }
  }
}
