package com.xforceplus.arterydocument.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2025-02-28
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class MarketAccountOperationRecord implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 操作时间
   */
  @TableField("operationTime")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime operationTime;

  /**
   * 操作人账号
   */
  @TableField("operatorAccount")
  private String operatorAccount;

  /**
   * 操作人
   */
  private String operator;

  /**
   * 业务模块
   */
  @TableField("businessModule")
  private String businessModule;

  /**
   * 关联业务ID
   */
  @TableField("pRefBusinessID")
  private String pRefBusinessID;

  /**
   * 操作类型
   */
  @TableField("operationType")
  private String operationType;

  /**
   * 变更域
   */
  @TableField("changeDomain")
  private String changeDomain;

  /**
   * 变更前内容
   */
  @TableField("contentBeforeChange")
  private String contentBeforeChange;

  /**
   * 变更后内容
   */
  @TableField("contentAfterChange")
  private String contentAfterChange;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 组织树
   */
  private String orgTree;


  /**
   * 对一关联关系 关联对象 marketAccount
   */
    private Long relationAccountWithOperationHistoryId;


  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("operationTime", BocpGenUtils.toTimestamp(operationTime));
      map.put("operatorAccount", operatorAccount);
      map.put("operator", operator);
      map.put("businessModule", businessModule);
      map.put("pRefBusinessID", pRefBusinessID);
      map.put("operationType", operationType);
      map.put("changeDomain", changeDomain);
      map.put("contentBeforeChange", contentBeforeChange);
      map.put("contentAfterChange", contentAfterChange);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("org_tree", orgTree);

       map.put("relationAccountWithOperationHistory.id", relationAccountWithOperationHistoryId);
      return map;
  }

  public static MarketAccountOperationRecord fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    MarketAccountOperationRecord entity = new MarketAccountOperationRecord();
    if(map.containsKey("operationTime")) {
      Object obj = map.get("operationTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setOperationTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setOperationTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setOperationTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setOperationTime(null);
      }
    }
    if(map.containsKey("operatorAccount")) {
      Object obj = map.get("operatorAccount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOperatorAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("operator")) {
      Object obj = map.get("operator");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOperator((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("businessModule")) {
      Object obj = map.get("businessModule");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBusinessModule((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pRefBusinessID")) {
      Object obj = map.get("pRefBusinessID");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPRefBusinessID((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("operationType")) {
      Object obj = map.get("operationType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOperationType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("changeDomain")) {
      Object obj = map.get("changeDomain");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setChangeDomain((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("contentBeforeChange")) {
      Object obj = map.get("contentBeforeChange");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setContentBeforeChange((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("contentAfterChange")) {
      Object obj = map.get("contentAfterChange");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setContentAfterChange((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrgTree((String)obj);
        }
      } else{
      }
    }

    if(map.containsKey("relationAccountWithOperationHistory.id")) {
        Object obj = map.get("relationAccountWithOperationHistory.id");
      if(obj instanceof Long) {
        entity.setRelationAccountWithOperationHistoryId((Long)obj);
      } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
        entity.setRelationAccountWithOperationHistoryId(Long.parseLong((String)obj));
      }
    }
    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("operationTime")) {
      Object obj = map.get("operationTime");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setOperationTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setOperationTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setOperationTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setOperationTime(null);
      }
    }
    if(map.containsKey("operatorAccount")) {
      Object obj = map.get("operatorAccount");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOperatorAccount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("operator")) {
      Object obj = map.get("operator");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOperator((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("businessModule")) {
      Object obj = map.get("businessModule");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBusinessModule((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("pRefBusinessID")) {
      Object obj = map.get("pRefBusinessID");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPRefBusinessID((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("operationType")) {
      Object obj = map.get("operationType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOperationType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("changeDomain")) {
      Object obj = map.get("changeDomain");
      if(obj != null) {
        if(obj instanceof String) {
          this.setChangeDomain((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("contentBeforeChange")) {
      Object obj = map.get("contentBeforeChange");
      if(obj != null) {
        if(obj instanceof String) {
          this.setContentBeforeChange((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("contentAfterChange")) {
      Object obj = map.get("contentAfterChange");
      if(obj != null) {
        if(obj instanceof String) {
          this.setContentAfterChange((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrgTree((String)obj);
        }
      } else {
      }
    }
      if(map.containsKey("relationAccountWithOperationHistory.id")) {
        Object obj = map.get("relationAccountWithOperationHistory.id");
        if(obj instanceof Long) {
          this.setRelationAccountWithOperationHistoryId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setRelationAccountWithOperationHistoryId(Long.parseLong((String)obj));
        }
      }
  }
}
