package com.xforceplus.arterydocument.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 弃用
 * </p>
 *
 * @author ultraman
 * @since 2025-02-28
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class PosBackTracking implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 所属租户
   */
  private String belongTenant;

  /**
   * 商超账号
   */
  private String collectionAccount;

  /**
   * 业务id
   */
  private String pBusinessId;

  /**
   * 模版变量Id
   */
  private String vvariableId;

  /**
   * 原始单据Id数组
   */
  private String srcids;

  /**
   * 采集批次
   */
  private String collectionBatch;

  /**
   * 转换批次号
   */
  @TableField("batch_number_OD2UD")
  private String batchNumberOd2ud;

  /**
   * 导入批次
   */
  private String importBatch;

  /**
   * 区域编码
   */
  private String regionCode;

  /**
   * 区域名称
   */
  private String regionName;

  /**
   * 购方门店编码
   */
  private String purchaseStoreCode;

  /**
   * 购方门店名称
   */
  private String purchaseStoreName;

  /**
   * 购方公司编码
   */
  private String purchaseCompanyCode;

  /**
   * 购方公司名称
   */
  private String purchaseCompanyName;

  /**
   * 零售商编码
   */
  private String purchaseRetailerId;

  /**
   * 零售商描述
   */
  private String purchaseRetailerName;

  /**
   * 购方统一社会信用代码
   */
  private String purchaseCompanyTaxNo;

  /**
   * 购方门店GLN
   */
  @TableField("purchase_store_GLN")
  private String purchaseStoreGln;

  /**
   * 业态编码
   */
  private String purchaseBusinessTypeNo;

  /**
   * 业态名称
   */
  private String purchaseBusinessTypeName;

  /**
   * 销方名称
   */
  private String sellerName;

  /**
   * 销方编码
   */
  private String sellerCode;

  /**
   * 销方统一社会信用代码
   */
  private String sellerCompanyTaxNo;

  /**
   * 销售年份
   */
  private String salesYear;

  /**
   * 销售月份
   */
  private String salesMonth;

  /**
   * 销售周
   */
  private String salesWeek;

  /**
   * 销售日
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime salesDay;

  /**
   * 销售方式
   */
  private String salesType;

  /**
   * 商品编码
   */
  private String itemCode;

  /**
   * 商品子编码
   */
  private String itemSubCode;

  /**
   * 商品名称
   */
  private String itemDesc;

  /**
   * 商品条码
   */
  private String barcode;

  /**
   * 品类编码
   */
  private String categoryCode;

  /**
   * 品类名称
   */
  private String categoryName;

  /**
   * 品牌
   */
  private String brand;

  /**
   * 规格
   */
  private String standards;

  /**
   * 基本单位
   */
  private String unit;

  /**
   * 转换方式
   */
  private String docTransformer;

  /**
   * 客户编码
   */
  private String sCustomerCode;

  /**
   * 客户名称
   */
  private String sCustomerName;

  /**
   * 客户组编码
   */
  private String sCustomerGroupCode;

  /**
   * 客户组名称
   */
  private String sCustomerGroupName;

  /**
   * 销售组织编码
   */
  private String sSalesOrganizationCode;

  /**
   * 销售组织名称
   */
  private String sSalesOrganizationName;

  /**
   * 销售公司编码
   */
  private String sCompanyCode;

  /**
   * 销售公司名称
   */
  private String sCompanyName;

  /**
   * 销售组编码
   */
  private String sSalesGroupCode;

  /**
   * 销售组名称
   */
  private String sSalesGroupName;

  /**
   * 分销渠道编码
   */
  private String sDistributionChannelCode;

  /**
   * 分销渠道名称
   */
  private String sDistributionChannelName;

  /**
   * 产品组编码
   */
  private String sDivisionCode;

  /**
   * 产品组名称
   */
  private String sDivisionName;

  /**
   * 业务单元编码
   */
  private String sBuCode;

  /**
   * 业务单元名称
   */
  private String sBuName;

  /**
   * 销售部门
   */
  private String sSalesDepartmentName;

  /**
   * 销方商品编码
   */
  private String sItemCode;

  /**
   * 销方商品子编码
   */
  private String sItemSubCode;

  /**
   * 销方商品条码
   */
  private String sBarcode;

  /**
   * 销方品牌
   */
  private String sBrand;

  /**
   * 销方商品名称
   */
  private String sItemDesc;

  /**
   * 销方组套商品（数组）
   */
  private String sSuitInfo;

  /**
   * 销方新老商品（数组）
   */
  private String sNewOldInfo;

  /**
   * 销方规格型号
   */
  private String sStandards;

  /**
   * 销方颜色
   */
  private String sColor;

  /**
   * 销方尺寸
   */
  private String sSize;

  /**
   * 单位转换规则（对象数组）
   */
  private String sUnitRules;

  /**
   * 销方批量包装单位
   */
  private String sPackageUnit;

  /**
   * 销方批量包装规格
   */
  private String sPackageSize;

  /**
   * 销方单据单位
   */
  private String sUnit;

  /**
   * 客户商品单位
   */
  private String sCustomUnit;

  /**
   * 商超原单文件地址
   */
  @TableField("p_source_file_URL")
  private String pSourceFileUrl;

  /**
   * 统一单据标记
   */
  private Boolean pUnifyDocFlag;

  /**
   * 租户单据标记
   */
  private Boolean pTenantDocFlag;

  /**
   * 版本号
   */
  private String versionNo;

  /**
   * 销方版本号
   */
  private String sVersionNo;

  /**
   * 是否是最新版本
   */
  private Boolean latest;

  /**
   * 备注
   */
  private String remark;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 统计类型
   */
  private String statisticalType;

  /**
   * 补录状态
   */
  private String appendStatus;

  /**
   * 数据来源
   */
  private String sDataSourcesFrom;

  /**
   * 销方是否组套商品
   */
  private String sSuitFlag;

  /**
   * 价格方式
   */
  private String priceStatus;

  /**
   * 销售数量
   */
  private BigDecimal salesQty;

  /**
   * 单价（含税）
   */
  private BigDecimal purchasePriceWithTax;

  /**
   * 单价（不含税）
   */
  private BigDecimal purchasePriceWithoutTax;

  /**
   * 销售单价（含税）
   */
  private BigDecimal salesPriceWithTax;

  /**
   * 销售单价（不含税）
   */
  private BigDecimal salesPriceWithoutTax;

  /**
   * 税率
   */
  private BigDecimal taxRate;

  /**
   * 销方批量包装单价（不含税）
   */
  private BigDecimal sPackageUnitPriceWithoutTax;

  /**
   * 销方批量包装单价（含税）
   */
  private BigDecimal sPackageUnitPriceWithTax;

  /**
   * 销方单价（不含税）
   */
  private BigDecimal sUnitPriceWithoutTax;

  /**
   * 销方单价（含税）
   */
  private BigDecimal sUnitPriceWithTax;

  /**
   * 销售天数
   */
  private BigDecimal salesDays;

  /**
   * 销方单据单位数量
   */
  private BigDecimal sQty;

  /**
   * 销方批量包装数量
   */
  private BigDecimal sPackageQty;

  /**
   * 销方总重量
   */
  private BigDecimal sTotalWeight;

  /**
   * 销方折扣率
   */
  private BigDecimal sDiscountRate;

  /**
   * 商品毛利金额
   */
  private BigDecimal grossProfit;

  /**
   * 促销金额
   */
  private BigDecimal promotionAmt;

  /**
   * 优惠券折扣金额
   */
  private BigDecimal couponDiscount;

  /**
   * 销方销售金额（含税）
   */
  private BigDecimal sellerSalesAmountWithTax;

  /**
   * 销方销售金额（不含税）
   */
  private BigDecimal sellerSalesAmountWithoutTax;

  /**
   * 销售金额（含税）
   */
  private BigDecimal salesAmountWithTax;

  /**
   * 销售金额（不含税）
   */
  private BigDecimal salesAmountWithoutTax;

  /**
   * 组织树
   */
  private String orgTree;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("belong_tenant", belongTenant);
      map.put("collection_account", collectionAccount);
      map.put("p_business_id", pBusinessId);
      map.put("vvariable_id", vvariableId);
      map.put("srcids", srcids);
      map.put("collection_batch", collectionBatch);
      map.put("batch_number_OD2UD", batchNumberOd2ud);
      map.put("import_batch", importBatch);
      map.put("region_code", regionCode);
      map.put("region_name", regionName);
      map.put("purchase_store_code", purchaseStoreCode);
      map.put("purchase_store_name", purchaseStoreName);
      map.put("purchase_company_code", purchaseCompanyCode);
      map.put("purchase_company_name", purchaseCompanyName);
      map.put("purchase_retailer_id", purchaseRetailerId);
      map.put("purchase_retailer_name", purchaseRetailerName);
      map.put("purchase_company_tax_no", purchaseCompanyTaxNo);
      map.put("purchase_store_GLN", purchaseStoreGln);
      map.put("purchase_business_type_no", purchaseBusinessTypeNo);
      map.put("purchase_business_type_name", purchaseBusinessTypeName);
      map.put("seller_name", sellerName);
      map.put("seller_code", sellerCode);
      map.put("seller_company_tax_no", sellerCompanyTaxNo);
      map.put("sales_year", salesYear);
      map.put("sales_month", salesMonth);
      map.put("sales_week", salesWeek);
      map.put("sales_day", BocpGenUtils.toTimestamp(salesDay));
      map.put("sales_type", salesType);
      map.put("item_code", itemCode);
      map.put("item_sub_code", itemSubCode);
      map.put("item_desc", itemDesc);
      map.put("barcode", barcode);
      map.put("category_code", categoryCode);
      map.put("category_name", categoryName);
      map.put("brand", brand);
      map.put("standards", standards);
      map.put("unit", unit);
      map.put("doc_transformer", docTransformer);
      map.put("s_customer_code", sCustomerCode);
      map.put("s_customer_name", sCustomerName);
      map.put("s_customer_group_code", sCustomerGroupCode);
      map.put("s_customer_group_name", sCustomerGroupName);
      map.put("s_sales_organization_code", sSalesOrganizationCode);
      map.put("s_sales_organization_name", sSalesOrganizationName);
      map.put("s_company_code", sCompanyCode);
      map.put("s_company_name", sCompanyName);
      map.put("s_sales_group_code", sSalesGroupCode);
      map.put("s_sales_group_name", sSalesGroupName);
      map.put("s_distribution_channel_code", sDistributionChannelCode);
      map.put("s_distribution_channel_name", sDistributionChannelName);
      map.put("s_division_code", sDivisionCode);
      map.put("s_division_name", sDivisionName);
      map.put("s_bu_code", sBuCode);
      map.put("s_bu_name", sBuName);
      map.put("s_sales_department_name", sSalesDepartmentName);
      map.put("s_item_code", sItemCode);
      map.put("s_item_sub_code", sItemSubCode);
      map.put("s_barcode", sBarcode);
      map.put("s_brand", sBrand);
      map.put("s_item_desc", sItemDesc);
      map.put("s_suit_info", sSuitInfo);
      map.put("s_new_old_info", sNewOldInfo);
      map.put("s_standards", sStandards);
      map.put("s_color", sColor);
      map.put("s_size", sSize);
      map.put("s_unit_rules", sUnitRules);
      map.put("s_package_unit", sPackageUnit);
      map.put("s_package_size", sPackageSize);
      map.put("s_unit", sUnit);
      map.put("s_custom_unit", sCustomUnit);
      map.put("p_source_file_URL", pSourceFileUrl);
      map.put("p_unify_doc_flag", pUnifyDocFlag);
      map.put("p_tenant_doc_flag", pTenantDocFlag);
      map.put("version_no", versionNo);
      map.put("s_version_no", sVersionNo);
      map.put("latest", latest);
      map.put("remark", remark);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("statistical_type", statisticalType);
      map.put("append_status", appendStatus);
      map.put("s_data_sources_from", sDataSourcesFrom);
      map.put("s_suit_flag", sSuitFlag);
      map.put("price_status", priceStatus);
      map.put("sales_qty", salesQty);
      map.put("purchase_price_with_tax", purchasePriceWithTax);
      map.put("purchase_price_without_tax", purchasePriceWithoutTax);
      map.put("sales_price_with_tax", salesPriceWithTax);
      map.put("sales_price_without_tax", salesPriceWithoutTax);
      map.put("tax_rate", taxRate);
      map.put("s_package_unit_price_without_tax", sPackageUnitPriceWithoutTax);
      map.put("s_package_unit_price_with_tax", sPackageUnitPriceWithTax);
      map.put("s_unit_price_without_tax", sUnitPriceWithoutTax);
      map.put("s_unit_price_with_tax", sUnitPriceWithTax);
      map.put("sales_days", salesDays);
      map.put("s_qty", sQty);
      map.put("s_package_qty", sPackageQty);
      map.put("s_total_weight", sTotalWeight);
      map.put("s_discount_rate", sDiscountRate);
      map.put("gross_profit", grossProfit);
      map.put("promotion_amt", promotionAmt);
      map.put("coupon_discount", couponDiscount);
      map.put("seller_sales_amount_with_tax", sellerSalesAmountWithTax);
      map.put("seller_sales_amount_without_tax", sellerSalesAmountWithoutTax);
      map.put("sales_amount_with_tax", salesAmountWithTax);
      map.put("sales_amount_without_tax", salesAmountWithoutTax);
      map.put("org_tree", orgTree);

      return map;
  }

  public static PosBackTracking fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    PosBackTracking entity = new PosBackTracking();
    if(map.containsKey("belong_tenant")) {
      Object obj = map.get("belong_tenant");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBelongTenant((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("collection_account")) {
      Object obj = map.get("collection_account");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCollectionAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("p_business_id")) {
      Object obj = map.get("p_business_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPBusinessId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("vvariable_id")) {
      Object obj = map.get("vvariable_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setVvariableId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("srcids")) {
      Object obj = map.get("srcids");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSrcids((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("collection_batch")) {
      Object obj = map.get("collection_batch");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCollectionBatch((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("batch_number_OD2UD")) {
      Object obj = map.get("batch_number_OD2UD");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBatchNumberOd2ud((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("import_batch")) {
      Object obj = map.get("import_batch");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setImportBatch((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("region_code")) {
      Object obj = map.get("region_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRegionCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("region_name")) {
      Object obj = map.get("region_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRegionName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchase_store_code")) {
      Object obj = map.get("purchase_store_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseStoreCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchase_store_name")) {
      Object obj = map.get("purchase_store_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseStoreName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchase_company_code")) {
      Object obj = map.get("purchase_company_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseCompanyCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchase_company_name")) {
      Object obj = map.get("purchase_company_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseCompanyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchase_retailer_id")) {
      Object obj = map.get("purchase_retailer_id");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseRetailerId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchase_retailer_name")) {
      Object obj = map.get("purchase_retailer_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseRetailerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchase_company_tax_no")) {
      Object obj = map.get("purchase_company_tax_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseCompanyTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchase_store_GLN")) {
      Object obj = map.get("purchase_store_GLN");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseStoreGln((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchase_business_type_no")) {
      Object obj = map.get("purchase_business_type_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseBusinessTypeNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchase_business_type_name")) {
      Object obj = map.get("purchase_business_type_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseBusinessTypeName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_name")) {
      Object obj = map.get("seller_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_code")) {
      Object obj = map.get("seller_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("seller_company_tax_no")) {
      Object obj = map.get("seller_company_tax_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerCompanyTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sales_year")) {
      Object obj = map.get("sales_year");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSalesYear((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sales_month")) {
      Object obj = map.get("sales_month");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSalesMonth((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sales_week")) {
      Object obj = map.get("sales_week");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSalesWeek((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sales_day")) {
      Object obj = map.get("sales_day");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSalesDay(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setSalesDay((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSalesDay(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setSalesDay(null);
      }
    }
    if(map.containsKey("sales_type")) {
      Object obj = map.get("sales_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSalesType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("item_code")) {
      Object obj = map.get("item_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setItemCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("item_sub_code")) {
      Object obj = map.get("item_sub_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setItemSubCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("item_desc")) {
      Object obj = map.get("item_desc");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setItemDesc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("barcode")) {
      Object obj = map.get("barcode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBarcode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("category_code")) {
      Object obj = map.get("category_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCategoryCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("category_name")) {
      Object obj = map.get("category_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCategoryName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("brand")) {
      Object obj = map.get("brand");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBrand((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("standards")) {
      Object obj = map.get("standards");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setStandards((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("unit")) {
      Object obj = map.get("unit");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("doc_transformer")) {
      Object obj = map.get("doc_transformer");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDocTransformer((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("s_customer_code")) {
      Object obj = map.get("s_customer_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSCustomerCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("s_customer_name")) {
      Object obj = map.get("s_customer_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSCustomerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("s_customer_group_code")) {
      Object obj = map.get("s_customer_group_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSCustomerGroupCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("s_customer_group_name")) {
      Object obj = map.get("s_customer_group_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSCustomerGroupName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("s_sales_organization_code")) {
      Object obj = map.get("s_sales_organization_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSSalesOrganizationCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("s_sales_organization_name")) {
      Object obj = map.get("s_sales_organization_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSSalesOrganizationName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("s_company_code")) {
      Object obj = map.get("s_company_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSCompanyCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("s_company_name")) {
      Object obj = map.get("s_company_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSCompanyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("s_sales_group_code")) {
      Object obj = map.get("s_sales_group_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSSalesGroupCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("s_sales_group_name")) {
      Object obj = map.get("s_sales_group_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSSalesGroupName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("s_distribution_channel_code")) {
      Object obj = map.get("s_distribution_channel_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSDistributionChannelCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("s_distribution_channel_name")) {
      Object obj = map.get("s_distribution_channel_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSDistributionChannelName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("s_division_code")) {
      Object obj = map.get("s_division_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSDivisionCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("s_division_name")) {
      Object obj = map.get("s_division_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSDivisionName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("s_bu_code")) {
      Object obj = map.get("s_bu_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSBuCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("s_bu_name")) {
      Object obj = map.get("s_bu_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSBuName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("s_sales_department_name")) {
      Object obj = map.get("s_sales_department_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSSalesDepartmentName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("s_item_code")) {
      Object obj = map.get("s_item_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSItemCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("s_item_sub_code")) {
      Object obj = map.get("s_item_sub_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSItemSubCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("s_barcode")) {
      Object obj = map.get("s_barcode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSBarcode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("s_brand")) {
      Object obj = map.get("s_brand");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSBrand((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("s_item_desc")) {
      Object obj = map.get("s_item_desc");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSItemDesc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("s_suit_info")) {
      Object obj = map.get("s_suit_info");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSSuitInfo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("s_new_old_info")) {
      Object obj = map.get("s_new_old_info");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSNewOldInfo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("s_standards")) {
      Object obj = map.get("s_standards");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSStandards((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("s_color")) {
      Object obj = map.get("s_color");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSColor((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("s_size")) {
      Object obj = map.get("s_size");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSSize((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("s_unit_rules")) {
      Object obj = map.get("s_unit_rules");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSUnitRules((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("s_package_unit")) {
      Object obj = map.get("s_package_unit");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSPackageUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("s_package_size")) {
      Object obj = map.get("s_package_size");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSPackageSize((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("s_unit")) {
      Object obj = map.get("s_unit");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("s_custom_unit")) {
      Object obj = map.get("s_custom_unit");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSCustomUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("p_source_file_URL")) {
      Object obj = map.get("p_source_file_URL");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPSourceFileUrl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("p_unify_doc_flag")) {
      Object obj = map.get("p_unify_doc_flag");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setPUnifyDocFlag((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPUnifyDocFlag(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("p_tenant_doc_flag")) {
      Object obj = map.get("p_tenant_doc_flag");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setPTenantDocFlag((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPTenantDocFlag(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("version_no")) {
      Object obj = map.get("version_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setVersionNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("s_version_no")) {
      Object obj = map.get("s_version_no");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSVersionNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("latest")) {
      Object obj = map.get("latest");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setLatest((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setLatest(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("statistical_type")) {
      Object obj = map.get("statistical_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setStatisticalType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("append_status")) {
      Object obj = map.get("append_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAppendStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("s_data_sources_from")) {
      Object obj = map.get("s_data_sources_from");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSDataSourcesFrom((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("s_suit_flag")) {
      Object obj = map.get("s_suit_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSSuitFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("price_status")) {
      Object obj = map.get("price_status");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPriceStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sales_qty")) {
      Object obj = map.get("sales_qty");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSalesQty((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSalesQty(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSalesQty(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSalesQty(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSalesQty(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("purchase_price_with_tax")) {
      Object obj = map.get("purchase_price_with_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPurchasePriceWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPurchasePriceWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPurchasePriceWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPurchasePriceWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPurchasePriceWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("purchase_price_without_tax")) {
      Object obj = map.get("purchase_price_without_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPurchasePriceWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPurchasePriceWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPurchasePriceWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPurchasePriceWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPurchasePriceWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("sales_price_with_tax")) {
      Object obj = map.get("sales_price_with_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSalesPriceWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSalesPriceWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSalesPriceWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSalesPriceWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSalesPriceWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("sales_price_without_tax")) {
      Object obj = map.get("sales_price_without_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSalesPriceWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSalesPriceWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSalesPriceWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSalesPriceWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSalesPriceWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("tax_rate")) {
      Object obj = map.get("tax_rate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setTaxRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setTaxRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setTaxRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTaxRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTaxRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("s_package_unit_price_without_tax")) {
      Object obj = map.get("s_package_unit_price_without_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSPackageUnitPriceWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSPackageUnitPriceWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSPackageUnitPriceWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSPackageUnitPriceWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSPackageUnitPriceWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("s_package_unit_price_with_tax")) {
      Object obj = map.get("s_package_unit_price_with_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSPackageUnitPriceWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSPackageUnitPriceWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSPackageUnitPriceWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSPackageUnitPriceWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSPackageUnitPriceWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("s_unit_price_without_tax")) {
      Object obj = map.get("s_unit_price_without_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSUnitPriceWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSUnitPriceWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSUnitPriceWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSUnitPriceWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSUnitPriceWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("s_unit_price_with_tax")) {
      Object obj = map.get("s_unit_price_with_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSUnitPriceWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSUnitPriceWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSUnitPriceWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSUnitPriceWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSUnitPriceWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("sales_days")) {
      Object obj = map.get("sales_days");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSalesDays((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSalesDays(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSalesDays(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSalesDays(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSalesDays(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("s_qty")) {
      Object obj = map.get("s_qty");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSQty((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSQty(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSQty(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSQty(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSQty(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("s_package_qty")) {
      Object obj = map.get("s_package_qty");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSPackageQty((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSPackageQty(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSPackageQty(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSPackageQty(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSPackageQty(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("s_total_weight")) {
      Object obj = map.get("s_total_weight");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSTotalWeight((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSTotalWeight(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSTotalWeight(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSTotalWeight(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSTotalWeight(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("s_discount_rate")) {
      Object obj = map.get("s_discount_rate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSDiscountRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSDiscountRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSDiscountRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSDiscountRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSDiscountRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("gross_profit")) {
      Object obj = map.get("gross_profit");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setGrossProfit((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setGrossProfit(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setGrossProfit(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setGrossProfit(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setGrossProfit(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("promotion_amt")) {
      Object obj = map.get("promotion_amt");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPromotionAmt((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPromotionAmt(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPromotionAmt(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPromotionAmt(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPromotionAmt(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("coupon_discount")) {
      Object obj = map.get("coupon_discount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setCouponDiscount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setCouponDiscount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setCouponDiscount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCouponDiscount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCouponDiscount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("seller_sales_amount_with_tax")) {
      Object obj = map.get("seller_sales_amount_with_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSellerSalesAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSellerSalesAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSellerSalesAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSellerSalesAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSellerSalesAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("seller_sales_amount_without_tax")) {
      Object obj = map.get("seller_sales_amount_without_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSellerSalesAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSellerSalesAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSellerSalesAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSellerSalesAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSellerSalesAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("sales_amount_with_tax")) {
      Object obj = map.get("sales_amount_with_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSalesAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSalesAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSalesAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSalesAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSalesAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("sales_amount_without_tax")) {
      Object obj = map.get("sales_amount_without_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSalesAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSalesAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSalesAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSalesAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSalesAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrgTree((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("belong_tenant")) {
      Object obj = map.get("belong_tenant");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBelongTenant((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("collection_account")) {
      Object obj = map.get("collection_account");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCollectionAccount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("p_business_id")) {
      Object obj = map.get("p_business_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPBusinessId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("vvariable_id")) {
      Object obj = map.get("vvariable_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setVvariableId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("srcids")) {
      Object obj = map.get("srcids");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSrcids((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("collection_batch")) {
      Object obj = map.get("collection_batch");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCollectionBatch((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("batch_number_OD2UD")) {
      Object obj = map.get("batch_number_OD2UD");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBatchNumberOd2ud((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("import_batch")) {
      Object obj = map.get("import_batch");
      if(obj != null) {
        if(obj instanceof String) {
          this.setImportBatch((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("region_code")) {
      Object obj = map.get("region_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRegionCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("region_name")) {
      Object obj = map.get("region_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRegionName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchase_store_code")) {
      Object obj = map.get("purchase_store_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaseStoreCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchase_store_name")) {
      Object obj = map.get("purchase_store_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaseStoreName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchase_company_code")) {
      Object obj = map.get("purchase_company_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaseCompanyCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchase_company_name")) {
      Object obj = map.get("purchase_company_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaseCompanyName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchase_retailer_id")) {
      Object obj = map.get("purchase_retailer_id");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaseRetailerId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchase_retailer_name")) {
      Object obj = map.get("purchase_retailer_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaseRetailerName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchase_company_tax_no")) {
      Object obj = map.get("purchase_company_tax_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaseCompanyTaxNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchase_store_GLN")) {
      Object obj = map.get("purchase_store_GLN");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaseStoreGln((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchase_business_type_no")) {
      Object obj = map.get("purchase_business_type_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaseBusinessTypeNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchase_business_type_name")) {
      Object obj = map.get("purchase_business_type_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaseBusinessTypeName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("seller_name")) {
      Object obj = map.get("seller_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("seller_code")) {
      Object obj = map.get("seller_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("seller_company_tax_no")) {
      Object obj = map.get("seller_company_tax_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerCompanyTaxNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sales_year")) {
      Object obj = map.get("sales_year");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSalesYear((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sales_month")) {
      Object obj = map.get("sales_month");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSalesMonth((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sales_week")) {
      Object obj = map.get("sales_week");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSalesWeek((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sales_day")) {
      Object obj = map.get("sales_day");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setSalesDay(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setSalesDay((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSalesDay(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setSalesDay(null);
      }
    }
    if(map.containsKey("sales_type")) {
      Object obj = map.get("sales_type");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSalesType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("item_code")) {
      Object obj = map.get("item_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setItemCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("item_sub_code")) {
      Object obj = map.get("item_sub_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setItemSubCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("item_desc")) {
      Object obj = map.get("item_desc");
      if(obj != null) {
        if(obj instanceof String) {
          this.setItemDesc((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("barcode")) {
      Object obj = map.get("barcode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBarcode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("category_code")) {
      Object obj = map.get("category_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCategoryCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("category_name")) {
      Object obj = map.get("category_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCategoryName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("brand")) {
      Object obj = map.get("brand");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBrand((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("standards")) {
      Object obj = map.get("standards");
      if(obj != null) {
        if(obj instanceof String) {
          this.setStandards((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("unit")) {
      Object obj = map.get("unit");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUnit((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("doc_transformer")) {
      Object obj = map.get("doc_transformer");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDocTransformer((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("s_customer_code")) {
      Object obj = map.get("s_customer_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSCustomerCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("s_customer_name")) {
      Object obj = map.get("s_customer_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSCustomerName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("s_customer_group_code")) {
      Object obj = map.get("s_customer_group_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSCustomerGroupCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("s_customer_group_name")) {
      Object obj = map.get("s_customer_group_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSCustomerGroupName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("s_sales_organization_code")) {
      Object obj = map.get("s_sales_organization_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSSalesOrganizationCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("s_sales_organization_name")) {
      Object obj = map.get("s_sales_organization_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSSalesOrganizationName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("s_company_code")) {
      Object obj = map.get("s_company_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSCompanyCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("s_company_name")) {
      Object obj = map.get("s_company_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSCompanyName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("s_sales_group_code")) {
      Object obj = map.get("s_sales_group_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSSalesGroupCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("s_sales_group_name")) {
      Object obj = map.get("s_sales_group_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSSalesGroupName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("s_distribution_channel_code")) {
      Object obj = map.get("s_distribution_channel_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSDistributionChannelCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("s_distribution_channel_name")) {
      Object obj = map.get("s_distribution_channel_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSDistributionChannelName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("s_division_code")) {
      Object obj = map.get("s_division_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSDivisionCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("s_division_name")) {
      Object obj = map.get("s_division_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSDivisionName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("s_bu_code")) {
      Object obj = map.get("s_bu_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSBuCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("s_bu_name")) {
      Object obj = map.get("s_bu_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSBuName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("s_sales_department_name")) {
      Object obj = map.get("s_sales_department_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSSalesDepartmentName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("s_item_code")) {
      Object obj = map.get("s_item_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSItemCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("s_item_sub_code")) {
      Object obj = map.get("s_item_sub_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSItemSubCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("s_barcode")) {
      Object obj = map.get("s_barcode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSBarcode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("s_brand")) {
      Object obj = map.get("s_brand");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSBrand((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("s_item_desc")) {
      Object obj = map.get("s_item_desc");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSItemDesc((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("s_suit_info")) {
      Object obj = map.get("s_suit_info");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSSuitInfo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("s_new_old_info")) {
      Object obj = map.get("s_new_old_info");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSNewOldInfo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("s_standards")) {
      Object obj = map.get("s_standards");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSStandards((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("s_color")) {
      Object obj = map.get("s_color");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSColor((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("s_size")) {
      Object obj = map.get("s_size");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSSize((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("s_unit_rules")) {
      Object obj = map.get("s_unit_rules");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSUnitRules((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("s_package_unit")) {
      Object obj = map.get("s_package_unit");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSPackageUnit((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("s_package_size")) {
      Object obj = map.get("s_package_size");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSPackageSize((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("s_unit")) {
      Object obj = map.get("s_unit");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSUnit((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("s_custom_unit")) {
      Object obj = map.get("s_custom_unit");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSCustomUnit((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("p_source_file_URL")) {
      Object obj = map.get("p_source_file_URL");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPSourceFileUrl((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("p_unify_doc_flag")) {
      Object obj = map.get("p_unify_doc_flag");
      if(obj != null) {
        if(obj instanceof Boolean) {
          this.setPUnifyDocFlag((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPUnifyDocFlag(Boolean.valueOf((String)obj));
        }
      } else {
      }
    }
    if(map.containsKey("p_tenant_doc_flag")) {
      Object obj = map.get("p_tenant_doc_flag");
      if(obj != null) {
        if(obj instanceof Boolean) {
          this.setPTenantDocFlag((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPTenantDocFlag(Boolean.valueOf((String)obj));
        }
      } else {
      }
    }
    if(map.containsKey("version_no")) {
      Object obj = map.get("version_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setVersionNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("s_version_no")) {
      Object obj = map.get("s_version_no");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSVersionNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("latest")) {
      Object obj = map.get("latest");
      if(obj != null) {
        if(obj instanceof Boolean) {
          this.setLatest((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setLatest(Boolean.valueOf((String)obj));
        }
      } else {
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRemark((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("statistical_type")) {
      Object obj = map.get("statistical_type");
      if(obj != null) {
        if(obj instanceof String) {
          this.setStatisticalType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("append_status")) {
      Object obj = map.get("append_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAppendStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("s_data_sources_from")) {
      Object obj = map.get("s_data_sources_from");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSDataSourcesFrom((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("s_suit_flag")) {
      Object obj = map.get("s_suit_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSSuitFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("price_status")) {
      Object obj = map.get("price_status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPriceStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sales_qty")) {
      Object obj = map.get("sales_qty");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setSalesQty((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setSalesQty(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setSalesQty(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSalesQty(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setSalesQty(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("purchase_price_with_tax")) {
      Object obj = map.get("purchase_price_with_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setPurchasePriceWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setPurchasePriceWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setPurchasePriceWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPurchasePriceWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setPurchasePriceWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("purchase_price_without_tax")) {
      Object obj = map.get("purchase_price_without_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setPurchasePriceWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setPurchasePriceWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setPurchasePriceWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPurchasePriceWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setPurchasePriceWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("sales_price_with_tax")) {
      Object obj = map.get("sales_price_with_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setSalesPriceWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setSalesPriceWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setSalesPriceWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSalesPriceWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setSalesPriceWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("sales_price_without_tax")) {
      Object obj = map.get("sales_price_without_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setSalesPriceWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setSalesPriceWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setSalesPriceWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSalesPriceWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setSalesPriceWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("tax_rate")) {
      Object obj = map.get("tax_rate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setTaxRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setTaxRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setTaxRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTaxRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setTaxRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("s_package_unit_price_without_tax")) {
      Object obj = map.get("s_package_unit_price_without_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setSPackageUnitPriceWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setSPackageUnitPriceWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setSPackageUnitPriceWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSPackageUnitPriceWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setSPackageUnitPriceWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("s_package_unit_price_with_tax")) {
      Object obj = map.get("s_package_unit_price_with_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setSPackageUnitPriceWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setSPackageUnitPriceWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setSPackageUnitPriceWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSPackageUnitPriceWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setSPackageUnitPriceWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("s_unit_price_without_tax")) {
      Object obj = map.get("s_unit_price_without_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setSUnitPriceWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setSUnitPriceWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setSUnitPriceWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSUnitPriceWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setSUnitPriceWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("s_unit_price_with_tax")) {
      Object obj = map.get("s_unit_price_with_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setSUnitPriceWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setSUnitPriceWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setSUnitPriceWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSUnitPriceWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setSUnitPriceWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("sales_days")) {
      Object obj = map.get("sales_days");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setSalesDays((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setSalesDays(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setSalesDays(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSalesDays(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setSalesDays(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("s_qty")) {
      Object obj = map.get("s_qty");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setSQty((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setSQty(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setSQty(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSQty(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setSQty(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("s_package_qty")) {
      Object obj = map.get("s_package_qty");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setSPackageQty((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setSPackageQty(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setSPackageQty(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSPackageQty(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setSPackageQty(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("s_total_weight")) {
      Object obj = map.get("s_total_weight");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setSTotalWeight((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setSTotalWeight(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setSTotalWeight(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSTotalWeight(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setSTotalWeight(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("s_discount_rate")) {
      Object obj = map.get("s_discount_rate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setSDiscountRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setSDiscountRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setSDiscountRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSDiscountRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setSDiscountRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("gross_profit")) {
      Object obj = map.get("gross_profit");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setGrossProfit((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setGrossProfit(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setGrossProfit(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setGrossProfit(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setGrossProfit(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("promotion_amt")) {
      Object obj = map.get("promotion_amt");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setPromotionAmt((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setPromotionAmt(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setPromotionAmt(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPromotionAmt(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setPromotionAmt(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("coupon_discount")) {
      Object obj = map.get("coupon_discount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setCouponDiscount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setCouponDiscount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setCouponDiscount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCouponDiscount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setCouponDiscount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("seller_sales_amount_with_tax")) {
      Object obj = map.get("seller_sales_amount_with_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setSellerSalesAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setSellerSalesAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setSellerSalesAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSellerSalesAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setSellerSalesAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("seller_sales_amount_without_tax")) {
      Object obj = map.get("seller_sales_amount_without_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setSellerSalesAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setSellerSalesAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setSellerSalesAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSellerSalesAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setSellerSalesAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("sales_amount_with_tax")) {
      Object obj = map.get("sales_amount_with_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setSalesAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setSalesAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setSalesAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSalesAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setSalesAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("sales_amount_without_tax")) {
      Object obj = map.get("sales_amount_without_tax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setSalesAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setSalesAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setSalesAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSalesAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setSalesAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrgTree((String)obj);
        }
      } else {
      }
    }
  }
}
