package com.xforceplus.arterydocument.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 送货预约明细
 * </p>
 *
 * @author ultraman
 * @since 2025-02-28
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class ReservationDeliveryNoteDetail implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 所属租户
   */
  @TableField("belongTenant")
  private String belongTenant;

  /**
   * 商超账号
   */
  @TableField("collectionAccount")
  private String collectionAccount;

  /**
   * 零售商编码
   */
  @TableField("purchaseRetailerId")
  private String purchaseRetailerId;

  /**
   * 零售商描述
   */
  @TableField("purchaseRetailerName")
  private String purchaseRetailerName;

  /**
   * 行业务ID
   */
  @TableField("pBusinessLineId")
  private String pBusinessLineId;

  /**
   * 行数据MD5
   */
  @TableField("pDataLineMD5")
  private String pDataLineMD5;

  /**
   * 是否最新版本
   */
  private Boolean latest;

  /**
   * 单据转换状态
   */
  @TableField("transState")
  private String transState;

  /**
   * 删除标记
   */
  @TableField("pDeleteFlag")
  private Boolean pDeleteFlag;

  /**
   * 系统单据编号
   */
  @TableField("pSysNo")
  private String pSysNo;

  /**
   * 版本号
   */
  @TableField("versionNo")
  private String versionNo;

  /**
   * 批次号
   */
  @TableField("batchNo")
  private String batchNo;

  /**
   * 关联请求任务号
   */
  @TableField("refTaskReqNo")
  private String refTaskReqNo;

  /**
   * 关联回执任务号
   */
  @TableField("refTaskResNo")
  private String refTaskResNo;

  /**
   * 销售订单号
   */
  @TableField("sSalesOrder")
  private String sSalesOrder;

  /**
   * 发货单号
   */
  @TableField("sDeliveryNote")
  private String sDeliveryNote;

  /**
   * 发货单状态
   */
  @TableField("sDeliveryNoteState")
  private String sDeliveryNoteState;

  /**
   * 单据来源
   */
  @TableField("pSourceFrom")
  private String pSourceFrom;

  /**
   * 销方公司编码
   */
  @TableField("sSellerCompanyCode")
  private String sSellerCompanyCode;

  /**
   * 销方公司名称
   */
  @TableField("sSellerCompanyName")
  private String sSellerCompanyName;

  /**
   * 业务单元编码
   */
  @TableField("sBuCode")
  private String sBuCode;

  /**
   * 业务单元名称
   */
  @TableField("sBuName")
  private String sBuName;

  /**
   * 销售组织编码
   */
  @TableField("sSalesOrganizationCode")
  private String sSalesOrganizationCode;

  /**
   * 销售组织名称
   */
  @TableField("sSalesOrganizationName")
  private String sSalesOrganizationName;

  /**
   * 分销渠道编码
   */
  @TableField("sDistributionChannelCode")
  private String sDistributionChannelCode;

  /**
   * 分销渠道名称
   */
  @TableField("sDistributionChannelName")
  private String sDistributionChannelName;

  /**
   * 售达方编码
   */
  @TableField("sSoldToCode")
  private String sSoldToCode;

  /**
   * 售达方名称
   */
  @TableField("sSoldToName")
  private String sSoldToName;

  /**
   * 送达方编码
   */
  @TableField("sShipToCode")
  private String sShipToCode;

  /**
   * 送达方名称
   */
  @TableField("sShipToName")
  private String sShipToName;

  /**
   * 订货时间
   */
  @TableField("sPODate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime sPODate;

  /**
   * 单据时间
   */
  @TableField("sDocumentDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime sDocumentDate;

  /**
   * 创建时间
   */
  @TableField("sCreationDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime sCreationDate;

  /**
   * 更新时间
   */
  @TableField("sUpdateDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime sUpdateDate;

  /**
   * 审批时间
   */
  @TableField("sApproveDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime sApproveDate;

  /**
   * 取消时间
   */
  @TableField("sCancelDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime sCancelDate;

  /**
   * 期望执行时间
   */
  @TableField("sExecutionTime")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime sExecutionTime;

  /**
   * 发货价格方式
   */
  @TableField("sPriceStatus")
  private Long sPriceStatus;

  /**
   * 发货商品总数
   */
  @TableField("sPoItemQty")
  private BigDecimal sPoItemQty;

  /**
   * 总金额（含税）
   */
  @TableField("sTotalAmt")
  private BigDecimal sTotalAmt;

  /**
   * 总金额（不含税）
   */
  @TableField("sTotalAmtWithoutTax")
  private BigDecimal sTotalAmtWithoutTax;

  /**
   * 总税额
   */
  @TableField("sTotalaxAmt")
  private BigDecimal sTotalaxAmt;

  /**
   * 折扣总金额（含税）
   */
  @TableField("sTotalDiscountAmt")
  private BigDecimal sTotalDiscountAmt;

  /**
   * 折扣总金额（不含税）
   */
  @TableField("sTotalDiscountAmtWithoutTax")
  private BigDecimal sTotalDiscountAmtWithoutTax;

  /**
   * 采购订单编号
   */
  @TableField("poNo")
  private String poNo;

  /**
   * 采购合同号
   */
  @TableField("bPOContractNo")
  private String bPOContractNo;

  /**
   * 送货预约单号
   */
  @TableField("bReservationDeliveryNote")
  private String bReservationDeliveryNote;

  /**
   * 送货预约单状态
   */
  @TableField("bRDNStatus")
  private String bRDNStatus;

  /**
   * 送货物流模式
   */
  @TableField("bLogisticsMode")
  private String bLogisticsMode;

  /**
   * 预约日期
   */
  @TableField("bRDNDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime bRDNDate;

  /**
   * 预约开始时间段
   */
  @TableField("bRDNStartTime")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime bRDNStartTime;

  /**
   * 预约结束时间段
   */
  @TableField("bRDNEndTime")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime bRDNEndTime;

  /**
   * 送货人
   */
  @TableField("bDriver")
  private String bDriver;

  /**
   * 车牌号
   */
  @TableField("bPlateNo")
  private String bPlateNo;

  /**
   * 仓库
   */
  @TableField("bWarehouse")
  private String bWarehouse;

  /**
   * 自助卸货
   */
  @TableField("bSelfUnloading")
  private String bSelfUnloading;

  /**
   * 供应商编码
   */
  @TableField("bSellerCode")
  private String bSellerCode;

  /**
   * 供应商名称
   */
  @TableField("bSellerName")
  private String bSellerName;

  /**
   * 公司编码
   */
  @TableField("bCompanyCode")
  private String bCompanyCode;

  /**
   * 公司名称
   */
  @TableField("bCompanyName")
  private String bCompanyName;

  /**
   * 业态编码
   */
  @TableField("bPurchaseBusinessTypeNo")
  private String bPurchaseBusinessTypeNo;

  /**
   * 业态名称
   */
  @TableField("bPurchaseBusinessTypeName")
  private String bPurchaseBusinessTypeName;

  /**
   * 区域编码
   */
  @TableField("bRegionCode")
  private String bRegionCode;

  /**
   * 区域名称
   */
  @TableField("bRegionName")
  private String bRegionName;

  /**
   * 购方门店编码
   */
  @TableField("bPurchaseStoreCode")
  private String bPurchaseStoreCode;

  /**
   * 购方门店名称
   */
  @TableField("bPurchaseStoreName")
  private String bPurchaseStoreName;

  /**
   * 购方门店GLN
   */
  @TableField("bPurchaseStoreGLN")
  private String bPurchaseStoreGLN;

  /**
   * 购方公司名称
   */
  @TableField("bPurchaseCompanyName")
  private String bPurchaseCompanyName;

  /**
   * 购方公司编码
   */
  @TableField("bPurchaseCompanyCode")
  private String bPurchaseCompanyCode;

  /**
   * 采购组织编码
   */
  @TableField("bPurchasePurOrgCode")
  private String bPurchasePurOrgCode;

  /**
   * 采购组织名称
   */
  @TableField("bPurchasePurOrgName")
  private String bPurchasePurOrgName;

  /**
   * 购方接收部门编码
   */
  @TableField("bPurchaseReceiveOrgCode")
  private String bPurchaseReceiveOrgCode;

  /**
   * 购方接收部门名称
   */
  @TableField("bPurchaseReceiveOrgName")
  private String bPurchaseReceiveOrgName;

  /**
   * 购方门店地址
   */
  @TableField("bPurchaseStoreAddress")
  private String bPurchaseStoreAddress;

  /**
   * 购方门店电话
   */
  @TableField("bPurchaseStoreTel")
  private String bPurchaseStoreTel;

  /**
   * 条码
   */
  private String barcode;

  /**
   * 发运单行编号
   */
  @TableField("sDNLineNo")
  private String sDNLineNo;

  /**
   * 销售订单号
   */
  @TableField("sSOLineNo")
  private String sSOLineNo;

  /**
   * 物料编码
   */
  @TableField("sMaterialCode")
  private String sMaterialCode;

  /**
   * 物料名称
   */
  @TableField("sMaterialName")
  private String sMaterialName;

  /**
   * 品类编码
   */
  @TableField("sCategoryCode")
  private String sCategoryCode;

  /**
   * 品类名称
   */
  @TableField("sCategoryName")
  private String sCategoryName;

  /**
   * 品牌
   */
  @TableField("sBrand")
  private String sBrand;

  /**
   * 规格型号
   */
  @TableField("sStandards")
  private String sStandards;

  /**
   * 颜色
   */
  @TableField("sColor")
  private String sColor;

  /**
   * 尺寸
   */
  @TableField("sSize")
  private String sSize;

  /**
   * 产地
   */
  @TableField("sProduceArea")
  private String sProduceArea;

  /**
   * 生产日期
   */
  @TableField("sProductionDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime sProductionDate;

  /**
   * 保质期
   */
  @TableField("sGuaranteePeriod")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime sGuaranteePeriod;

  /**
   * 净重量
   */
  @TableField("sNetWeight")
  private BigDecimal sNetWeight;

  /**
   * 总重量
   */
  @TableField("sTotalWeight")
  private BigDecimal sTotalWeight;

  /**
   * 包装规格
   */
  @TableField("sPackageSize")
  private String sPackageSize;

  /**
   * 发货单位编码
   */
  @TableField("sUnitCode")
  private String sUnitCode;

  /**
   * 发货单位名称
   */
  @TableField("sUnitName")
  private String sUnitName;

  /**
   * 发货单位数量
   */
  @TableField("sUnitQty")
  private BigDecimal sUnitQty;

  /**
   * 发货单价（不含税）
   */
  @TableField("sUnitPriceWithoutTax")
  private BigDecimal sUnitPriceWithoutTax;

  /**
   * 发货单价（含税）
   */
  @TableField("sUnitPriceWithTax")
  private BigDecimal sUnitPriceWithTax;

  /**
   * 发货金额（不含税）
   */
  @TableField("sAmountWithoutTax")
  private BigDecimal sAmountWithoutTax;

  /**
   * 发货金额（含税）
   */
  @TableField("sAmountWithTax")
  private BigDecimal sAmountWithTax;

  /**
   * 发货税率
   */
  @TableField("sTaxRate")
  private BigDecimal sTaxRate;

  /**
   * 发货税额
   */
  @TableField("sTaxAmount")
  private BigDecimal sTaxAmount;

  /**
   * 赠品单位编码
   */
  @TableField("sFreeUnitCode")
  private String sFreeUnitCode;

  /**
   * 赠品单位名称
   */
  @TableField("sFreeUnitName")
  private String sFreeUnitName;

  /**
   * 赠品数量
   */
  @TableField("sFreeQty")
  private BigDecimal sFreeQty;

  /**
   * 折扣率
   */
  @TableField("sDiscountRate")
  private BigDecimal sDiscountRate;

  /**
   * 折扣金额（含税）
   */
  @TableField("sDiscountAmt")
  private BigDecimal sDiscountAmt;

  /**
   * 折扣金额（不含税）
   */
  @TableField("sDiscountAmtWithoutTax")
  private BigDecimal sDiscountAmtWithoutTax;

  /**
   * 接收方式
   */
  @TableField("sReceiveMethod")
  private String sReceiveMethod;

  /**
   * 发货单行预约状态
   */
  @TableField("sLineRDNState")
  private String sLineRDNState;

  /**
   * 采购订单行编号
   */
  @TableField("poLineNo")
  private String poLineNo;

  /**
   * 送货预约单行编号
   */
  @TableField("bRDNLineNo")
  private String bRDNLineNo;

  /**
   * 客户商品编码
   */
  @TableField("bMaterialCode")
  private String bMaterialCode;

  /**
   * 客户商品名称
   */
  @TableField("bMaterialName")
  private String bMaterialName;

  /**
   * 客户品类编码
   */
  @TableField("bCategoryCode")
  private String bCategoryCode;

  /**
   * 客户品类名称
   */
  @TableField("bCategoryName")
  private String bCategoryName;

  /**
   * 品牌
   */
  @TableField("bBrand")
  private String bBrand;

  /**
   * 规格型号
   */
  @TableField("bStandards")
  private String bStandards;

  /**
   * 颜色
   */
  @TableField("bColor")
  private String bColor;

  /**
   * 尺寸
   */
  @TableField("bSize")
  private String bSize;

  /**
   * 产地
   */
  @TableField("bProduceArea")
  private String bProduceArea;

  /**
   * 生产日期
   */
  @TableField("bProductionDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime bProductionDate;

  /**
   * 保质期
   */
  @TableField("bGuaranteePeriod")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime bGuaranteePeriod;

  /**
   * 净重量
   */
  @TableField("bNetWeight")
  private BigDecimal bNetWeight;

  /**
   * 总重量
   */
  @TableField("bTotalWeight")
  private BigDecimal bTotalWeight;

  /**
   * 包装规格
   */
  @TableField("bPackageSize")
  private String bPackageSize;

  /**
   * 预约单位编码
   */
  @TableField("bUnitCode")
  private String bUnitCode;

  /**
   * 预约单位名称
   */
  @TableField("bUnitName")
  private String bUnitName;

  /**
   * 预约单位数量
   */
  @TableField("bUnitQty")
  private BigDecimal bUnitQty;

  /**
   * 实约单位数量
   */
  @TableField("bActualUnitQty")
  private BigDecimal bActualUnitQty;

  /**
   * 预约单价（不含税）
   */
  @TableField("bUnitPriceWithoutTax")
  private BigDecimal bUnitPriceWithoutTax;

  /**
   * 预约单价（含税）
   */
  @TableField("bUnitPriceWithTax")
  private BigDecimal bUnitPriceWithTax;

  /**
   * 实约单价（不含税）
   */
  @TableField("bActualUnitPriceWithoutTax")
  private BigDecimal bActualUnitPriceWithoutTax;

  /**
   * 实约单价（含税）
   */
  @TableField("bActualUnitPriceWithTax")
  private BigDecimal bActualUnitPriceWithTax;

  /**
   * 预约金额（不含税）
   */
  @TableField("bAmountWithoutTax")
  private BigDecimal bAmountWithoutTax;

  /**
   * 预约金额（含税）
   */
  @TableField("bAmountWithTax")
  private BigDecimal bAmountWithTax;

  /**
   * 实约金额（不含税）
   */
  @TableField("bActualAmountWithoutTax")
  private BigDecimal bActualAmountWithoutTax;

  /**
   * 实约金额（含税）
   */
  @TableField("bActualAmountWithTax")
  private BigDecimal bActualAmountWithTax;

  /**
   * 预约税率
   */
  @TableField("bTaxRate")
  private BigDecimal bTaxRate;

  /**
   * 预约税额
   */
  @TableField("bTaxAmount")
  private BigDecimal bTaxAmount;

  /**
   * 预约赠品单位编码
   */
  @TableField("bFreeUnitCode")
  private String bFreeUnitCode;

  /**
   * 预约赠品单位名称
   */
  @TableField("bFreeUnitName")
  private String bFreeUnitName;

  /**
   * 预约赠品数量
   */
  @TableField("bFreeQty")
  private BigDecimal bFreeQty;

  /**
   * 实约赠品数量
   */
  @TableField("bActualFreeQty")
  private BigDecimal bActualFreeQty;

  /**
   * 接收方式
   */
  @TableField("bReceiveMethod")
  private String bReceiveMethod;

  /**
   * 库房
   */
  @TableField("bInventory")
  private String bInventory;

  /**
   * 库位
   */
  @TableField("bLocation")
  private String bLocation;

  /**
   * 商品备注
   */
  @TableField("bRemark")
  private String bRemark;

  /**
   * 预约异常信息
   */
  @TableField("bErrorInfo")
  private String bErrorInfo;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 日志Id
   */
  @TableField("traceId")
  private String traceId;

  /**
   * 期望预送时间
   */
  @TableField("sDeliveryTime")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime sDeliveryTime;

  /**
   * 预约包装单位编码
   */
  @TableField("bPackageUnitCode")
  private String bPackageUnitCode;

  /**
   * 预约包装单位名称
   */
  @TableField("bPackageUnitName")
  private String bPackageUnitName;

  /**
   * 预约包装单位数量
   */
  @TableField("bPackageUnitQty")
  private BigDecimal bPackageUnitQty;

  /**
   * 实约包装单位数量
   */
  @TableField("bPackageActualUnitQty")
  private BigDecimal bPackageActualUnitQty;

  /**
   * 采购订单行数量
   */
  @TableField("poUnitQty")
  private BigDecimal poUnitQty;

  /**
   * 工厂
   */
  @TableField("sPlant")
  private String sPlant;

  /**
   * 最后交货时间
   */
  @TableField("sLastExecDeliveryTime")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime sLastExecDeliveryTime;

  /**
   * 预约采购单商品总数
   */
  @TableField("bPoItemQty")
  private BigDecimal bPoItemQty;

  /**
   * 库位
   */
  @TableField("sWarehouseLocation")
  private String sWarehouseLocation;

  /**
   * 预约异常文件地址
   */
  @TableField("bErrorFileUrl")
  private String bErrorFileUrl;

  /**
   * 组织树
   */
  private String orgTree;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("belongTenant", belongTenant);
      map.put("collectionAccount", collectionAccount);
      map.put("purchaseRetailerId", purchaseRetailerId);
      map.put("purchaseRetailerName", purchaseRetailerName);
      map.put("pBusinessLineId", pBusinessLineId);
      map.put("pDataLineMD5", pDataLineMD5);
      map.put("latest", latest);
      map.put("transState", transState);
      map.put("pDeleteFlag", pDeleteFlag);
      map.put("pSysNo", pSysNo);
      map.put("versionNo", versionNo);
      map.put("batchNo", batchNo);
      map.put("refTaskReqNo", refTaskReqNo);
      map.put("refTaskResNo", refTaskResNo);
      map.put("sSalesOrder", sSalesOrder);
      map.put("sDeliveryNote", sDeliveryNote);
      map.put("sDeliveryNoteState", sDeliveryNoteState);
      map.put("pSourceFrom", pSourceFrom);
      map.put("sSellerCompanyCode", sSellerCompanyCode);
      map.put("sSellerCompanyName", sSellerCompanyName);
      map.put("sBuCode", sBuCode);
      map.put("sBuName", sBuName);
      map.put("sSalesOrganizationCode", sSalesOrganizationCode);
      map.put("sSalesOrganizationName", sSalesOrganizationName);
      map.put("sDistributionChannelCode", sDistributionChannelCode);
      map.put("sDistributionChannelName", sDistributionChannelName);
      map.put("sSoldToCode", sSoldToCode);
      map.put("sSoldToName", sSoldToName);
      map.put("sShipToCode", sShipToCode);
      map.put("sShipToName", sShipToName);
      map.put("sPODate", BocpGenUtils.toTimestamp(sPODate));
      map.put("sDocumentDate", BocpGenUtils.toTimestamp(sDocumentDate));
      map.put("sCreationDate", BocpGenUtils.toTimestamp(sCreationDate));
      map.put("sUpdateDate", BocpGenUtils.toTimestamp(sUpdateDate));
      map.put("sApproveDate", BocpGenUtils.toTimestamp(sApproveDate));
      map.put("sCancelDate", BocpGenUtils.toTimestamp(sCancelDate));
      map.put("sExecutionTime", BocpGenUtils.toTimestamp(sExecutionTime));
      map.put("sPriceStatus", sPriceStatus);
      map.put("sPoItemQty", sPoItemQty);
      map.put("sTotalAmt", sTotalAmt);
      map.put("sTotalAmtWithoutTax", sTotalAmtWithoutTax);
      map.put("sTotalaxAmt", sTotalaxAmt);
      map.put("sTotalDiscountAmt", sTotalDiscountAmt);
      map.put("sTotalDiscountAmtWithoutTax", sTotalDiscountAmtWithoutTax);
      map.put("poNo", poNo);
      map.put("bPOContractNo", bPOContractNo);
      map.put("bReservationDeliveryNote", bReservationDeliveryNote);
      map.put("bRDNStatus", bRDNStatus);
      map.put("bLogisticsMode", bLogisticsMode);
      map.put("bRDNDate", BocpGenUtils.toTimestamp(bRDNDate));
      map.put("bRDNStartTime", BocpGenUtils.toTimestamp(bRDNStartTime));
      map.put("bRDNEndTime", BocpGenUtils.toTimestamp(bRDNEndTime));
      map.put("bDriver", bDriver);
      map.put("bPlateNo", bPlateNo);
      map.put("bWarehouse", bWarehouse);
      map.put("bSelfUnloading", bSelfUnloading);
      map.put("bSellerCode", bSellerCode);
      map.put("bSellerName", bSellerName);
      map.put("bCompanyCode", bCompanyCode);
      map.put("bCompanyName", bCompanyName);
      map.put("bPurchaseBusinessTypeNo", bPurchaseBusinessTypeNo);
      map.put("bPurchaseBusinessTypeName", bPurchaseBusinessTypeName);
      map.put("bRegionCode", bRegionCode);
      map.put("bRegionName", bRegionName);
      map.put("bPurchaseStoreCode", bPurchaseStoreCode);
      map.put("bPurchaseStoreName", bPurchaseStoreName);
      map.put("bPurchaseStoreGLN", bPurchaseStoreGLN);
      map.put("bPurchaseCompanyName", bPurchaseCompanyName);
      map.put("bPurchaseCompanyCode", bPurchaseCompanyCode);
      map.put("bPurchasePurOrgCode", bPurchasePurOrgCode);
      map.put("bPurchasePurOrgName", bPurchasePurOrgName);
      map.put("bPurchaseReceiveOrgCode", bPurchaseReceiveOrgCode);
      map.put("bPurchaseReceiveOrgName", bPurchaseReceiveOrgName);
      map.put("bPurchaseStoreAddress", bPurchaseStoreAddress);
      map.put("bPurchaseStoreTel", bPurchaseStoreTel);
      map.put("barcode", barcode);
      map.put("sDNLineNo", sDNLineNo);
      map.put("sSOLineNo", sSOLineNo);
      map.put("sMaterialCode", sMaterialCode);
      map.put("sMaterialName", sMaterialName);
      map.put("sCategoryCode", sCategoryCode);
      map.put("sCategoryName", sCategoryName);
      map.put("sBrand", sBrand);
      map.put("sStandards", sStandards);
      map.put("sColor", sColor);
      map.put("sSize", sSize);
      map.put("sProduceArea", sProduceArea);
      map.put("sProductionDate", BocpGenUtils.toTimestamp(sProductionDate));
      map.put("sGuaranteePeriod", BocpGenUtils.toTimestamp(sGuaranteePeriod));
      map.put("sNetWeight", sNetWeight);
      map.put("sTotalWeight", sTotalWeight);
      map.put("sPackageSize", sPackageSize);
      map.put("sUnitCode", sUnitCode);
      map.put("sUnitName", sUnitName);
      map.put("sUnitQty", sUnitQty);
      map.put("sUnitPriceWithoutTax", sUnitPriceWithoutTax);
      map.put("sUnitPriceWithTax", sUnitPriceWithTax);
      map.put("sAmountWithoutTax", sAmountWithoutTax);
      map.put("sAmountWithTax", sAmountWithTax);
      map.put("sTaxRate", sTaxRate);
      map.put("sTaxAmount", sTaxAmount);
      map.put("sFreeUnitCode", sFreeUnitCode);
      map.put("sFreeUnitName", sFreeUnitName);
      map.put("sFreeQty", sFreeQty);
      map.put("sDiscountRate", sDiscountRate);
      map.put("sDiscountAmt", sDiscountAmt);
      map.put("sDiscountAmtWithoutTax", sDiscountAmtWithoutTax);
      map.put("sReceiveMethod", sReceiveMethod);
      map.put("sLineRDNState", sLineRDNState);
      map.put("poLineNo", poLineNo);
      map.put("bRDNLineNo", bRDNLineNo);
      map.put("bMaterialCode", bMaterialCode);
      map.put("bMaterialName", bMaterialName);
      map.put("bCategoryCode", bCategoryCode);
      map.put("bCategoryName", bCategoryName);
      map.put("bBrand", bBrand);
      map.put("bStandards", bStandards);
      map.put("bColor", bColor);
      map.put("bSize", bSize);
      map.put("bProduceArea", bProduceArea);
      map.put("bProductionDate", BocpGenUtils.toTimestamp(bProductionDate));
      map.put("bGuaranteePeriod", BocpGenUtils.toTimestamp(bGuaranteePeriod));
      map.put("bNetWeight", bNetWeight);
      map.put("bTotalWeight", bTotalWeight);
      map.put("bPackageSize", bPackageSize);
      map.put("bUnitCode", bUnitCode);
      map.put("bUnitName", bUnitName);
      map.put("bUnitQty", bUnitQty);
      map.put("bActualUnitQty", bActualUnitQty);
      map.put("bUnitPriceWithoutTax", bUnitPriceWithoutTax);
      map.put("bUnitPriceWithTax", bUnitPriceWithTax);
      map.put("bActualUnitPriceWithoutTax", bActualUnitPriceWithoutTax);
      map.put("bActualUnitPriceWithTax", bActualUnitPriceWithTax);
      map.put("bAmountWithoutTax", bAmountWithoutTax);
      map.put("bAmountWithTax", bAmountWithTax);
      map.put("bActualAmountWithoutTax", bActualAmountWithoutTax);
      map.put("bActualAmountWithTax", bActualAmountWithTax);
      map.put("bTaxRate", bTaxRate);
      map.put("bTaxAmount", bTaxAmount);
      map.put("bFreeUnitCode", bFreeUnitCode);
      map.put("bFreeUnitName", bFreeUnitName);
      map.put("bFreeQty", bFreeQty);
      map.put("bActualFreeQty", bActualFreeQty);
      map.put("bReceiveMethod", bReceiveMethod);
      map.put("bInventory", bInventory);
      map.put("bLocation", bLocation);
      map.put("bRemark", bRemark);
      map.put("bErrorInfo", bErrorInfo);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("traceId", traceId);
      map.put("sDeliveryTime", BocpGenUtils.toTimestamp(sDeliveryTime));
      map.put("bPackageUnitCode", bPackageUnitCode);
      map.put("bPackageUnitName", bPackageUnitName);
      map.put("bPackageUnitQty", bPackageUnitQty);
      map.put("bPackageActualUnitQty", bPackageActualUnitQty);
      map.put("poUnitQty", poUnitQty);
      map.put("sPlant", sPlant);
      map.put("sLastExecDeliveryTime", BocpGenUtils.toTimestamp(sLastExecDeliveryTime));
      map.put("bPoItemQty", bPoItemQty);
      map.put("sWarehouseLocation", sWarehouseLocation);
      map.put("bErrorFileUrl", bErrorFileUrl);
      map.put("org_tree", orgTree);

      return map;
  }

  public static ReservationDeliveryNoteDetail fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    ReservationDeliveryNoteDetail entity = new ReservationDeliveryNoteDetail();
    if(map.containsKey("belongTenant")) {
      Object obj = map.get("belongTenant");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBelongTenant((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("collectionAccount")) {
      Object obj = map.get("collectionAccount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCollectionAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseRetailerId")) {
      Object obj = map.get("purchaseRetailerId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseRetailerId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaseRetailerName")) {
      Object obj = map.get("purchaseRetailerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaseRetailerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pBusinessLineId")) {
      Object obj = map.get("pBusinessLineId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPBusinessLineId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pDataLineMD5")) {
      Object obj = map.get("pDataLineMD5");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPDataLineMD5((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("latest")) {
      Object obj = map.get("latest");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setLatest((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setLatest(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("transState")) {
      Object obj = map.get("transState");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTransState((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pDeleteFlag")) {
      Object obj = map.get("pDeleteFlag");
      if(obj != null) {
        if(obj instanceof Boolean) {
          entity.setPDeleteFlag((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPDeleteFlag(Boolean.valueOf((String)obj));
        }
      } else{
      }
    }
    if(map.containsKey("pSysNo")) {
      Object obj = map.get("pSysNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPSysNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("versionNo")) {
      Object obj = map.get("versionNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setVersionNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("batchNo")) {
      Object obj = map.get("batchNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBatchNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("refTaskReqNo")) {
      Object obj = map.get("refTaskReqNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRefTaskReqNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("refTaskResNo")) {
      Object obj = map.get("refTaskResNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRefTaskResNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sSalesOrder")) {
      Object obj = map.get("sSalesOrder");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSSalesOrder((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sDeliveryNote")) {
      Object obj = map.get("sDeliveryNote");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSDeliveryNote((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sDeliveryNoteState")) {
      Object obj = map.get("sDeliveryNoteState");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSDeliveryNoteState((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pSourceFrom")) {
      Object obj = map.get("pSourceFrom");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPSourceFrom((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sSellerCompanyCode")) {
      Object obj = map.get("sSellerCompanyCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSSellerCompanyCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sSellerCompanyName")) {
      Object obj = map.get("sSellerCompanyName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSSellerCompanyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sBuCode")) {
      Object obj = map.get("sBuCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSBuCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sBuName")) {
      Object obj = map.get("sBuName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSBuName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sSalesOrganizationCode")) {
      Object obj = map.get("sSalesOrganizationCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSSalesOrganizationCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sSalesOrganizationName")) {
      Object obj = map.get("sSalesOrganizationName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSSalesOrganizationName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sDistributionChannelCode")) {
      Object obj = map.get("sDistributionChannelCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSDistributionChannelCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sDistributionChannelName")) {
      Object obj = map.get("sDistributionChannelName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSDistributionChannelName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sSoldToCode")) {
      Object obj = map.get("sSoldToCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSSoldToCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sSoldToName")) {
      Object obj = map.get("sSoldToName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSSoldToName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sShipToCode")) {
      Object obj = map.get("sShipToCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSShipToCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sShipToName")) {
      Object obj = map.get("sShipToName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSShipToName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sPODate")) {
      Object obj = map.get("sPODate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSPODate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setSPODate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSPODate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setSPODate(null);
      }
    }
    if(map.containsKey("sDocumentDate")) {
      Object obj = map.get("sDocumentDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSDocumentDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setSDocumentDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSDocumentDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setSDocumentDate(null);
      }
    }
    if(map.containsKey("sCreationDate")) {
      Object obj = map.get("sCreationDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSCreationDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setSCreationDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSCreationDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setSCreationDate(null);
      }
    }
    if(map.containsKey("sUpdateDate")) {
      Object obj = map.get("sUpdateDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSUpdateDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setSUpdateDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSUpdateDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setSUpdateDate(null);
      }
    }
    if(map.containsKey("sApproveDate")) {
      Object obj = map.get("sApproveDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSApproveDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setSApproveDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSApproveDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setSApproveDate(null);
      }
    }
    if(map.containsKey("sCancelDate")) {
      Object obj = map.get("sCancelDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSCancelDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setSCancelDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSCancelDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setSCancelDate(null);
      }
    }
    if(map.containsKey("sExecutionTime")) {
      Object obj = map.get("sExecutionTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSExecutionTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setSExecutionTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSExecutionTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setSExecutionTime(null);
      }
    }
    if(map.containsKey("sPriceStatus")) {
      Object obj = map.get("sPriceStatus");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSPriceStatus((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSPriceStatus(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSPriceStatus(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("sPoItemQty")) {
      Object obj = map.get("sPoItemQty");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSPoItemQty((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSPoItemQty(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSPoItemQty(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSPoItemQty(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSPoItemQty(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("sTotalAmt")) {
      Object obj = map.get("sTotalAmt");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSTotalAmt((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSTotalAmt(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSTotalAmt(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSTotalAmt(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSTotalAmt(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("sTotalAmtWithoutTax")) {
      Object obj = map.get("sTotalAmtWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSTotalAmtWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSTotalAmtWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSTotalAmtWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSTotalAmtWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSTotalAmtWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("sTotalaxAmt")) {
      Object obj = map.get("sTotalaxAmt");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSTotalaxAmt((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSTotalaxAmt(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSTotalaxAmt(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSTotalaxAmt(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSTotalaxAmt(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("sTotalDiscountAmt")) {
      Object obj = map.get("sTotalDiscountAmt");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSTotalDiscountAmt((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSTotalDiscountAmt(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSTotalDiscountAmt(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSTotalDiscountAmt(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSTotalDiscountAmt(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("sTotalDiscountAmtWithoutTax")) {
      Object obj = map.get("sTotalDiscountAmtWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSTotalDiscountAmtWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSTotalDiscountAmtWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSTotalDiscountAmtWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSTotalDiscountAmtWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSTotalDiscountAmtWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("poNo")) {
      Object obj = map.get("poNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPoNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bPOContractNo")) {
      Object obj = map.get("bPOContractNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBPOContractNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bReservationDeliveryNote")) {
      Object obj = map.get("bReservationDeliveryNote");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBReservationDeliveryNote((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bRDNStatus")) {
      Object obj = map.get("bRDNStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBRDNStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bLogisticsMode")) {
      Object obj = map.get("bLogisticsMode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBLogisticsMode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bRDNDate")) {
      Object obj = map.get("bRDNDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setBRDNDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setBRDNDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setBRDNDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setBRDNDate(null);
      }
    }
    if(map.containsKey("bRDNStartTime")) {
      Object obj = map.get("bRDNStartTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setBRDNStartTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setBRDNStartTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setBRDNStartTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setBRDNStartTime(null);
      }
    }
    if(map.containsKey("bRDNEndTime")) {
      Object obj = map.get("bRDNEndTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setBRDNEndTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setBRDNEndTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setBRDNEndTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setBRDNEndTime(null);
      }
    }
    if(map.containsKey("bDriver")) {
      Object obj = map.get("bDriver");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBDriver((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bPlateNo")) {
      Object obj = map.get("bPlateNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBPlateNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bWarehouse")) {
      Object obj = map.get("bWarehouse");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBWarehouse((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bSelfUnloading")) {
      Object obj = map.get("bSelfUnloading");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBSelfUnloading((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bSellerCode")) {
      Object obj = map.get("bSellerCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBSellerCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bSellerName")) {
      Object obj = map.get("bSellerName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBSellerName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bCompanyCode")) {
      Object obj = map.get("bCompanyCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBCompanyCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bCompanyName")) {
      Object obj = map.get("bCompanyName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBCompanyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bPurchaseBusinessTypeNo")) {
      Object obj = map.get("bPurchaseBusinessTypeNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBPurchaseBusinessTypeNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bPurchaseBusinessTypeName")) {
      Object obj = map.get("bPurchaseBusinessTypeName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBPurchaseBusinessTypeName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bRegionCode")) {
      Object obj = map.get("bRegionCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBRegionCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bRegionName")) {
      Object obj = map.get("bRegionName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBRegionName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bPurchaseStoreCode")) {
      Object obj = map.get("bPurchaseStoreCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBPurchaseStoreCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bPurchaseStoreName")) {
      Object obj = map.get("bPurchaseStoreName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBPurchaseStoreName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bPurchaseStoreGLN")) {
      Object obj = map.get("bPurchaseStoreGLN");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBPurchaseStoreGLN((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bPurchaseCompanyName")) {
      Object obj = map.get("bPurchaseCompanyName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBPurchaseCompanyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bPurchaseCompanyCode")) {
      Object obj = map.get("bPurchaseCompanyCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBPurchaseCompanyCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bPurchasePurOrgCode")) {
      Object obj = map.get("bPurchasePurOrgCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBPurchasePurOrgCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bPurchasePurOrgName")) {
      Object obj = map.get("bPurchasePurOrgName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBPurchasePurOrgName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bPurchaseReceiveOrgCode")) {
      Object obj = map.get("bPurchaseReceiveOrgCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBPurchaseReceiveOrgCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bPurchaseReceiveOrgName")) {
      Object obj = map.get("bPurchaseReceiveOrgName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBPurchaseReceiveOrgName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bPurchaseStoreAddress")) {
      Object obj = map.get("bPurchaseStoreAddress");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBPurchaseStoreAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bPurchaseStoreTel")) {
      Object obj = map.get("bPurchaseStoreTel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBPurchaseStoreTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("barcode")) {
      Object obj = map.get("barcode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBarcode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sDNLineNo")) {
      Object obj = map.get("sDNLineNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSDNLineNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sSOLineNo")) {
      Object obj = map.get("sSOLineNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSSOLineNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sMaterialCode")) {
      Object obj = map.get("sMaterialCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSMaterialCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sMaterialName")) {
      Object obj = map.get("sMaterialName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSMaterialName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sCategoryCode")) {
      Object obj = map.get("sCategoryCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSCategoryCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sCategoryName")) {
      Object obj = map.get("sCategoryName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSCategoryName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sBrand")) {
      Object obj = map.get("sBrand");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSBrand((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sStandards")) {
      Object obj = map.get("sStandards");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSStandards((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sColor")) {
      Object obj = map.get("sColor");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSColor((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sSize")) {
      Object obj = map.get("sSize");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSSize((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sProduceArea")) {
      Object obj = map.get("sProduceArea");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSProduceArea((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sProductionDate")) {
      Object obj = map.get("sProductionDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSProductionDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setSProductionDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSProductionDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setSProductionDate(null);
      }
    }
    if(map.containsKey("sGuaranteePeriod")) {
      Object obj = map.get("sGuaranteePeriod");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSGuaranteePeriod(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setSGuaranteePeriod((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSGuaranteePeriod(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setSGuaranteePeriod(null);
      }
    }
    if(map.containsKey("sNetWeight")) {
      Object obj = map.get("sNetWeight");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSNetWeight((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSNetWeight(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSNetWeight(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSNetWeight(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSNetWeight(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("sTotalWeight")) {
      Object obj = map.get("sTotalWeight");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSTotalWeight((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSTotalWeight(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSTotalWeight(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSTotalWeight(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSTotalWeight(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("sPackageSize")) {
      Object obj = map.get("sPackageSize");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSPackageSize((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sUnitCode")) {
      Object obj = map.get("sUnitCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSUnitCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sUnitName")) {
      Object obj = map.get("sUnitName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSUnitName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sUnitQty")) {
      Object obj = map.get("sUnitQty");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSUnitQty((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSUnitQty(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSUnitQty(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSUnitQty(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSUnitQty(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("sUnitPriceWithoutTax")) {
      Object obj = map.get("sUnitPriceWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSUnitPriceWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSUnitPriceWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSUnitPriceWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSUnitPriceWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSUnitPriceWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("sUnitPriceWithTax")) {
      Object obj = map.get("sUnitPriceWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSUnitPriceWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSUnitPriceWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSUnitPriceWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSUnitPriceWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSUnitPriceWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("sAmountWithoutTax")) {
      Object obj = map.get("sAmountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("sAmountWithTax")) {
      Object obj = map.get("sAmountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("sTaxRate")) {
      Object obj = map.get("sTaxRate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSTaxRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSTaxRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSTaxRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSTaxRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSTaxRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("sTaxAmount")) {
      Object obj = map.get("sTaxAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("sFreeUnitCode")) {
      Object obj = map.get("sFreeUnitCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSFreeUnitCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sFreeUnitName")) {
      Object obj = map.get("sFreeUnitName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSFreeUnitName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sFreeQty")) {
      Object obj = map.get("sFreeQty");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSFreeQty((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSFreeQty(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSFreeQty(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSFreeQty(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSFreeQty(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("sDiscountRate")) {
      Object obj = map.get("sDiscountRate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSDiscountRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSDiscountRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSDiscountRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSDiscountRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSDiscountRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("sDiscountAmt")) {
      Object obj = map.get("sDiscountAmt");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSDiscountAmt((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSDiscountAmt(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSDiscountAmt(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSDiscountAmt(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSDiscountAmt(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("sDiscountAmtWithoutTax")) {
      Object obj = map.get("sDiscountAmtWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSDiscountAmtWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSDiscountAmtWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSDiscountAmtWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSDiscountAmtWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSDiscountAmtWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("sReceiveMethod")) {
      Object obj = map.get("sReceiveMethod");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSReceiveMethod((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sLineRDNState")) {
      Object obj = map.get("sLineRDNState");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSLineRDNState((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("poLineNo")) {
      Object obj = map.get("poLineNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPoLineNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bRDNLineNo")) {
      Object obj = map.get("bRDNLineNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBRDNLineNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bMaterialCode")) {
      Object obj = map.get("bMaterialCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBMaterialCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bMaterialName")) {
      Object obj = map.get("bMaterialName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBMaterialName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bCategoryCode")) {
      Object obj = map.get("bCategoryCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBCategoryCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bCategoryName")) {
      Object obj = map.get("bCategoryName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBCategoryName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bBrand")) {
      Object obj = map.get("bBrand");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBBrand((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bStandards")) {
      Object obj = map.get("bStandards");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBStandards((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bColor")) {
      Object obj = map.get("bColor");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBColor((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bSize")) {
      Object obj = map.get("bSize");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBSize((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bProduceArea")) {
      Object obj = map.get("bProduceArea");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBProduceArea((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bProductionDate")) {
      Object obj = map.get("bProductionDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setBProductionDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setBProductionDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setBProductionDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setBProductionDate(null);
      }
    }
    if(map.containsKey("bGuaranteePeriod")) {
      Object obj = map.get("bGuaranteePeriod");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setBGuaranteePeriod(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setBGuaranteePeriod((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setBGuaranteePeriod(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setBGuaranteePeriod(null);
      }
    }
    if(map.containsKey("bNetWeight")) {
      Object obj = map.get("bNetWeight");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setBNetWeight((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setBNetWeight(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setBNetWeight(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setBNetWeight(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setBNetWeight(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("bTotalWeight")) {
      Object obj = map.get("bTotalWeight");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setBTotalWeight((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setBTotalWeight(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setBTotalWeight(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setBTotalWeight(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setBTotalWeight(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("bPackageSize")) {
      Object obj = map.get("bPackageSize");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBPackageSize((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bUnitCode")) {
      Object obj = map.get("bUnitCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBUnitCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bUnitName")) {
      Object obj = map.get("bUnitName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBUnitName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bUnitQty")) {
      Object obj = map.get("bUnitQty");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setBUnitQty((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setBUnitQty(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setBUnitQty(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setBUnitQty(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setBUnitQty(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("bActualUnitQty")) {
      Object obj = map.get("bActualUnitQty");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setBActualUnitQty((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setBActualUnitQty(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setBActualUnitQty(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setBActualUnitQty(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setBActualUnitQty(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("bUnitPriceWithoutTax")) {
      Object obj = map.get("bUnitPriceWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setBUnitPriceWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setBUnitPriceWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setBUnitPriceWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setBUnitPriceWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setBUnitPriceWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("bUnitPriceWithTax")) {
      Object obj = map.get("bUnitPriceWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setBUnitPriceWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setBUnitPriceWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setBUnitPriceWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setBUnitPriceWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setBUnitPriceWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("bActualUnitPriceWithoutTax")) {
      Object obj = map.get("bActualUnitPriceWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setBActualUnitPriceWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setBActualUnitPriceWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setBActualUnitPriceWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setBActualUnitPriceWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setBActualUnitPriceWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("bActualUnitPriceWithTax")) {
      Object obj = map.get("bActualUnitPriceWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setBActualUnitPriceWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setBActualUnitPriceWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setBActualUnitPriceWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setBActualUnitPriceWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setBActualUnitPriceWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("bAmountWithoutTax")) {
      Object obj = map.get("bAmountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setBAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setBAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setBAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setBAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setBAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("bAmountWithTax")) {
      Object obj = map.get("bAmountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setBAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setBAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setBAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setBAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setBAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("bActualAmountWithoutTax")) {
      Object obj = map.get("bActualAmountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setBActualAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setBActualAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setBActualAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setBActualAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setBActualAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("bActualAmountWithTax")) {
      Object obj = map.get("bActualAmountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setBActualAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setBActualAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setBActualAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setBActualAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setBActualAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("bTaxRate")) {
      Object obj = map.get("bTaxRate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setBTaxRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setBTaxRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setBTaxRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setBTaxRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setBTaxRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("bTaxAmount")) {
      Object obj = map.get("bTaxAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setBTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setBTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setBTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setBTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setBTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("bFreeUnitCode")) {
      Object obj = map.get("bFreeUnitCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBFreeUnitCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bFreeUnitName")) {
      Object obj = map.get("bFreeUnitName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBFreeUnitName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bFreeQty")) {
      Object obj = map.get("bFreeQty");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setBFreeQty((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setBFreeQty(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setBFreeQty(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setBFreeQty(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setBFreeQty(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("bActualFreeQty")) {
      Object obj = map.get("bActualFreeQty");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setBActualFreeQty((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setBActualFreeQty(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setBActualFreeQty(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setBActualFreeQty(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setBActualFreeQty(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("bReceiveMethod")) {
      Object obj = map.get("bReceiveMethod");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBReceiveMethod((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bInventory")) {
      Object obj = map.get("bInventory");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBInventory((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bLocation")) {
      Object obj = map.get("bLocation");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBLocation((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bRemark")) {
      Object obj = map.get("bRemark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bErrorInfo")) {
      Object obj = map.get("bErrorInfo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBErrorInfo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("traceId")) {
      Object obj = map.get("traceId");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTraceId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sDeliveryTime")) {
      Object obj = map.get("sDeliveryTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSDeliveryTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setSDeliveryTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSDeliveryTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setSDeliveryTime(null);
      }
    }
    if(map.containsKey("bPackageUnitCode")) {
      Object obj = map.get("bPackageUnitCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBPackageUnitCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bPackageUnitName")) {
      Object obj = map.get("bPackageUnitName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBPackageUnitName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bPackageUnitQty")) {
      Object obj = map.get("bPackageUnitQty");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setBPackageUnitQty((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setBPackageUnitQty(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setBPackageUnitQty(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setBPackageUnitQty(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setBPackageUnitQty(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("bPackageActualUnitQty")) {
      Object obj = map.get("bPackageActualUnitQty");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setBPackageActualUnitQty((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setBPackageActualUnitQty(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setBPackageActualUnitQty(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setBPackageActualUnitQty(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setBPackageActualUnitQty(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("poUnitQty")) {
      Object obj = map.get("poUnitQty");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPoUnitQty((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPoUnitQty(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPoUnitQty(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPoUnitQty(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPoUnitQty(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("sPlant")) {
      Object obj = map.get("sPlant");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSPlant((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sLastExecDeliveryTime")) {
      Object obj = map.get("sLastExecDeliveryTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSLastExecDeliveryTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setSLastExecDeliveryTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSLastExecDeliveryTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setSLastExecDeliveryTime(null);
      }
    }
    if(map.containsKey("bPoItemQty")) {
      Object obj = map.get("bPoItemQty");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setBPoItemQty((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setBPoItemQty(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setBPoItemQty(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setBPoItemQty(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setBPoItemQty(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("sWarehouseLocation")) {
      Object obj = map.get("sWarehouseLocation");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSWarehouseLocation((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bErrorFileUrl")) {
      Object obj = map.get("bErrorFileUrl");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBErrorFileUrl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrgTree((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("belongTenant")) {
      Object obj = map.get("belongTenant");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBelongTenant((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("collectionAccount")) {
      Object obj = map.get("collectionAccount");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCollectionAccount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaseRetailerId")) {
      Object obj = map.get("purchaseRetailerId");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaseRetailerId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaseRetailerName")) {
      Object obj = map.get("purchaseRetailerName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaseRetailerName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("pBusinessLineId")) {
      Object obj = map.get("pBusinessLineId");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPBusinessLineId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("pDataLineMD5")) {
      Object obj = map.get("pDataLineMD5");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPDataLineMD5((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("latest")) {
      Object obj = map.get("latest");
      if(obj != null) {
        if(obj instanceof Boolean) {
          this.setLatest((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setLatest(Boolean.valueOf((String)obj));
        }
      } else {
      }
    }
    if(map.containsKey("transState")) {
      Object obj = map.get("transState");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTransState((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("pDeleteFlag")) {
      Object obj = map.get("pDeleteFlag");
      if(obj != null) {
        if(obj instanceof Boolean) {
          this.setPDeleteFlag((Boolean)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPDeleteFlag(Boolean.valueOf((String)obj));
        }
      } else {
      }
    }
    if(map.containsKey("pSysNo")) {
      Object obj = map.get("pSysNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPSysNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("versionNo")) {
      Object obj = map.get("versionNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setVersionNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("batchNo")) {
      Object obj = map.get("batchNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBatchNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("refTaskReqNo")) {
      Object obj = map.get("refTaskReqNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRefTaskReqNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("refTaskResNo")) {
      Object obj = map.get("refTaskResNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRefTaskResNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sSalesOrder")) {
      Object obj = map.get("sSalesOrder");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSSalesOrder((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sDeliveryNote")) {
      Object obj = map.get("sDeliveryNote");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSDeliveryNote((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sDeliveryNoteState")) {
      Object obj = map.get("sDeliveryNoteState");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSDeliveryNoteState((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("pSourceFrom")) {
      Object obj = map.get("pSourceFrom");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPSourceFrom((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sSellerCompanyCode")) {
      Object obj = map.get("sSellerCompanyCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSSellerCompanyCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sSellerCompanyName")) {
      Object obj = map.get("sSellerCompanyName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSSellerCompanyName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sBuCode")) {
      Object obj = map.get("sBuCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSBuCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sBuName")) {
      Object obj = map.get("sBuName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSBuName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sSalesOrganizationCode")) {
      Object obj = map.get("sSalesOrganizationCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSSalesOrganizationCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sSalesOrganizationName")) {
      Object obj = map.get("sSalesOrganizationName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSSalesOrganizationName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sDistributionChannelCode")) {
      Object obj = map.get("sDistributionChannelCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSDistributionChannelCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sDistributionChannelName")) {
      Object obj = map.get("sDistributionChannelName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSDistributionChannelName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sSoldToCode")) {
      Object obj = map.get("sSoldToCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSSoldToCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sSoldToName")) {
      Object obj = map.get("sSoldToName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSSoldToName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sShipToCode")) {
      Object obj = map.get("sShipToCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSShipToCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sShipToName")) {
      Object obj = map.get("sShipToName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSShipToName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sPODate")) {
      Object obj = map.get("sPODate");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setSPODate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setSPODate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSPODate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setSPODate(null);
      }
    }
    if(map.containsKey("sDocumentDate")) {
      Object obj = map.get("sDocumentDate");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setSDocumentDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setSDocumentDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSDocumentDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setSDocumentDate(null);
      }
    }
    if(map.containsKey("sCreationDate")) {
      Object obj = map.get("sCreationDate");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setSCreationDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setSCreationDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSCreationDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setSCreationDate(null);
      }
    }
    if(map.containsKey("sUpdateDate")) {
      Object obj = map.get("sUpdateDate");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setSUpdateDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setSUpdateDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSUpdateDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setSUpdateDate(null);
      }
    }
    if(map.containsKey("sApproveDate")) {
      Object obj = map.get("sApproveDate");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setSApproveDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setSApproveDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSApproveDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setSApproveDate(null);
      }
    }
    if(map.containsKey("sCancelDate")) {
      Object obj = map.get("sCancelDate");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setSCancelDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setSCancelDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSCancelDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setSCancelDate(null);
      }
    }
    if(map.containsKey("sExecutionTime")) {
      Object obj = map.get("sExecutionTime");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setSExecutionTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setSExecutionTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSExecutionTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setSExecutionTime(null);
      }
    }
    if(map.containsKey("sPriceStatus")) {
      Object obj = map.get("sPriceStatus");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setSPriceStatus((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSPriceStatus(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setSPriceStatus(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("sPoItemQty")) {
      Object obj = map.get("sPoItemQty");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setSPoItemQty((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setSPoItemQty(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setSPoItemQty(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSPoItemQty(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setSPoItemQty(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("sTotalAmt")) {
      Object obj = map.get("sTotalAmt");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setSTotalAmt((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setSTotalAmt(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setSTotalAmt(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSTotalAmt(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setSTotalAmt(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("sTotalAmtWithoutTax")) {
      Object obj = map.get("sTotalAmtWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setSTotalAmtWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setSTotalAmtWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setSTotalAmtWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSTotalAmtWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setSTotalAmtWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("sTotalaxAmt")) {
      Object obj = map.get("sTotalaxAmt");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setSTotalaxAmt((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setSTotalaxAmt(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setSTotalaxAmt(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSTotalaxAmt(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setSTotalaxAmt(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("sTotalDiscountAmt")) {
      Object obj = map.get("sTotalDiscountAmt");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setSTotalDiscountAmt((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setSTotalDiscountAmt(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setSTotalDiscountAmt(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSTotalDiscountAmt(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setSTotalDiscountAmt(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("sTotalDiscountAmtWithoutTax")) {
      Object obj = map.get("sTotalDiscountAmtWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setSTotalDiscountAmtWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setSTotalDiscountAmtWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setSTotalDiscountAmtWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSTotalDiscountAmtWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setSTotalDiscountAmtWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("poNo")) {
      Object obj = map.get("poNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPoNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("bPOContractNo")) {
      Object obj = map.get("bPOContractNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBPOContractNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("bReservationDeliveryNote")) {
      Object obj = map.get("bReservationDeliveryNote");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBReservationDeliveryNote((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("bRDNStatus")) {
      Object obj = map.get("bRDNStatus");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBRDNStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("bLogisticsMode")) {
      Object obj = map.get("bLogisticsMode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBLogisticsMode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("bRDNDate")) {
      Object obj = map.get("bRDNDate");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setBRDNDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setBRDNDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setBRDNDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setBRDNDate(null);
      }
    }
    if(map.containsKey("bRDNStartTime")) {
      Object obj = map.get("bRDNStartTime");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setBRDNStartTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setBRDNStartTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setBRDNStartTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setBRDNStartTime(null);
      }
    }
    if(map.containsKey("bRDNEndTime")) {
      Object obj = map.get("bRDNEndTime");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setBRDNEndTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setBRDNEndTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setBRDNEndTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setBRDNEndTime(null);
      }
    }
    if(map.containsKey("bDriver")) {
      Object obj = map.get("bDriver");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBDriver((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("bPlateNo")) {
      Object obj = map.get("bPlateNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBPlateNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("bWarehouse")) {
      Object obj = map.get("bWarehouse");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBWarehouse((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("bSelfUnloading")) {
      Object obj = map.get("bSelfUnloading");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBSelfUnloading((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("bSellerCode")) {
      Object obj = map.get("bSellerCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBSellerCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("bSellerName")) {
      Object obj = map.get("bSellerName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBSellerName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("bCompanyCode")) {
      Object obj = map.get("bCompanyCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBCompanyCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("bCompanyName")) {
      Object obj = map.get("bCompanyName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBCompanyName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("bPurchaseBusinessTypeNo")) {
      Object obj = map.get("bPurchaseBusinessTypeNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBPurchaseBusinessTypeNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("bPurchaseBusinessTypeName")) {
      Object obj = map.get("bPurchaseBusinessTypeName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBPurchaseBusinessTypeName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("bRegionCode")) {
      Object obj = map.get("bRegionCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBRegionCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("bRegionName")) {
      Object obj = map.get("bRegionName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBRegionName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("bPurchaseStoreCode")) {
      Object obj = map.get("bPurchaseStoreCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBPurchaseStoreCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("bPurchaseStoreName")) {
      Object obj = map.get("bPurchaseStoreName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBPurchaseStoreName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("bPurchaseStoreGLN")) {
      Object obj = map.get("bPurchaseStoreGLN");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBPurchaseStoreGLN((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("bPurchaseCompanyName")) {
      Object obj = map.get("bPurchaseCompanyName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBPurchaseCompanyName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("bPurchaseCompanyCode")) {
      Object obj = map.get("bPurchaseCompanyCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBPurchaseCompanyCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("bPurchasePurOrgCode")) {
      Object obj = map.get("bPurchasePurOrgCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBPurchasePurOrgCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("bPurchasePurOrgName")) {
      Object obj = map.get("bPurchasePurOrgName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBPurchasePurOrgName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("bPurchaseReceiveOrgCode")) {
      Object obj = map.get("bPurchaseReceiveOrgCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBPurchaseReceiveOrgCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("bPurchaseReceiveOrgName")) {
      Object obj = map.get("bPurchaseReceiveOrgName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBPurchaseReceiveOrgName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("bPurchaseStoreAddress")) {
      Object obj = map.get("bPurchaseStoreAddress");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBPurchaseStoreAddress((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("bPurchaseStoreTel")) {
      Object obj = map.get("bPurchaseStoreTel");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBPurchaseStoreTel((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("barcode")) {
      Object obj = map.get("barcode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBarcode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sDNLineNo")) {
      Object obj = map.get("sDNLineNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSDNLineNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sSOLineNo")) {
      Object obj = map.get("sSOLineNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSSOLineNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sMaterialCode")) {
      Object obj = map.get("sMaterialCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSMaterialCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sMaterialName")) {
      Object obj = map.get("sMaterialName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSMaterialName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sCategoryCode")) {
      Object obj = map.get("sCategoryCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSCategoryCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sCategoryName")) {
      Object obj = map.get("sCategoryName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSCategoryName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sBrand")) {
      Object obj = map.get("sBrand");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSBrand((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sStandards")) {
      Object obj = map.get("sStandards");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSStandards((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sColor")) {
      Object obj = map.get("sColor");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSColor((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sSize")) {
      Object obj = map.get("sSize");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSSize((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sProduceArea")) {
      Object obj = map.get("sProduceArea");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSProduceArea((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sProductionDate")) {
      Object obj = map.get("sProductionDate");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setSProductionDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setSProductionDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSProductionDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setSProductionDate(null);
      }
    }
    if(map.containsKey("sGuaranteePeriod")) {
      Object obj = map.get("sGuaranteePeriod");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setSGuaranteePeriod(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setSGuaranteePeriod((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSGuaranteePeriod(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setSGuaranteePeriod(null);
      }
    }
    if(map.containsKey("sNetWeight")) {
      Object obj = map.get("sNetWeight");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setSNetWeight((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setSNetWeight(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setSNetWeight(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSNetWeight(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setSNetWeight(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("sTotalWeight")) {
      Object obj = map.get("sTotalWeight");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setSTotalWeight((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setSTotalWeight(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setSTotalWeight(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSTotalWeight(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setSTotalWeight(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("sPackageSize")) {
      Object obj = map.get("sPackageSize");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSPackageSize((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sUnitCode")) {
      Object obj = map.get("sUnitCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSUnitCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sUnitName")) {
      Object obj = map.get("sUnitName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSUnitName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sUnitQty")) {
      Object obj = map.get("sUnitQty");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setSUnitQty((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setSUnitQty(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setSUnitQty(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSUnitQty(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setSUnitQty(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("sUnitPriceWithoutTax")) {
      Object obj = map.get("sUnitPriceWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setSUnitPriceWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setSUnitPriceWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setSUnitPriceWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSUnitPriceWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setSUnitPriceWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("sUnitPriceWithTax")) {
      Object obj = map.get("sUnitPriceWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setSUnitPriceWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setSUnitPriceWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setSUnitPriceWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSUnitPriceWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setSUnitPriceWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("sAmountWithoutTax")) {
      Object obj = map.get("sAmountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setSAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setSAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setSAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setSAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("sAmountWithTax")) {
      Object obj = map.get("sAmountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setSAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setSAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setSAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setSAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("sTaxRate")) {
      Object obj = map.get("sTaxRate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setSTaxRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setSTaxRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setSTaxRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSTaxRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setSTaxRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("sTaxAmount")) {
      Object obj = map.get("sTaxAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setSTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setSTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setSTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setSTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("sFreeUnitCode")) {
      Object obj = map.get("sFreeUnitCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSFreeUnitCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sFreeUnitName")) {
      Object obj = map.get("sFreeUnitName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSFreeUnitName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sFreeQty")) {
      Object obj = map.get("sFreeQty");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setSFreeQty((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setSFreeQty(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setSFreeQty(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSFreeQty(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setSFreeQty(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("sDiscountRate")) {
      Object obj = map.get("sDiscountRate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setSDiscountRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setSDiscountRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setSDiscountRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSDiscountRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setSDiscountRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("sDiscountAmt")) {
      Object obj = map.get("sDiscountAmt");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setSDiscountAmt((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setSDiscountAmt(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setSDiscountAmt(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSDiscountAmt(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setSDiscountAmt(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("sDiscountAmtWithoutTax")) {
      Object obj = map.get("sDiscountAmtWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setSDiscountAmtWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setSDiscountAmtWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setSDiscountAmtWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSDiscountAmtWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setSDiscountAmtWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("sReceiveMethod")) {
      Object obj = map.get("sReceiveMethod");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSReceiveMethod((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sLineRDNState")) {
      Object obj = map.get("sLineRDNState");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSLineRDNState((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("poLineNo")) {
      Object obj = map.get("poLineNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPoLineNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("bRDNLineNo")) {
      Object obj = map.get("bRDNLineNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBRDNLineNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("bMaterialCode")) {
      Object obj = map.get("bMaterialCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBMaterialCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("bMaterialName")) {
      Object obj = map.get("bMaterialName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBMaterialName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("bCategoryCode")) {
      Object obj = map.get("bCategoryCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBCategoryCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("bCategoryName")) {
      Object obj = map.get("bCategoryName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBCategoryName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("bBrand")) {
      Object obj = map.get("bBrand");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBBrand((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("bStandards")) {
      Object obj = map.get("bStandards");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBStandards((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("bColor")) {
      Object obj = map.get("bColor");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBColor((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("bSize")) {
      Object obj = map.get("bSize");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBSize((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("bProduceArea")) {
      Object obj = map.get("bProduceArea");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBProduceArea((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("bProductionDate")) {
      Object obj = map.get("bProductionDate");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setBProductionDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setBProductionDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setBProductionDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setBProductionDate(null);
      }
    }
    if(map.containsKey("bGuaranteePeriod")) {
      Object obj = map.get("bGuaranteePeriod");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setBGuaranteePeriod(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setBGuaranteePeriod((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setBGuaranteePeriod(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setBGuaranteePeriod(null);
      }
    }
    if(map.containsKey("bNetWeight")) {
      Object obj = map.get("bNetWeight");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setBNetWeight((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setBNetWeight(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setBNetWeight(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setBNetWeight(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setBNetWeight(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("bTotalWeight")) {
      Object obj = map.get("bTotalWeight");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setBTotalWeight((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setBTotalWeight(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setBTotalWeight(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setBTotalWeight(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setBTotalWeight(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("bPackageSize")) {
      Object obj = map.get("bPackageSize");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBPackageSize((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("bUnitCode")) {
      Object obj = map.get("bUnitCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBUnitCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("bUnitName")) {
      Object obj = map.get("bUnitName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBUnitName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("bUnitQty")) {
      Object obj = map.get("bUnitQty");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setBUnitQty((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setBUnitQty(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setBUnitQty(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setBUnitQty(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setBUnitQty(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("bActualUnitQty")) {
      Object obj = map.get("bActualUnitQty");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setBActualUnitQty((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setBActualUnitQty(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setBActualUnitQty(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setBActualUnitQty(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setBActualUnitQty(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("bUnitPriceWithoutTax")) {
      Object obj = map.get("bUnitPriceWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setBUnitPriceWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setBUnitPriceWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setBUnitPriceWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setBUnitPriceWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setBUnitPriceWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("bUnitPriceWithTax")) {
      Object obj = map.get("bUnitPriceWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setBUnitPriceWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setBUnitPriceWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setBUnitPriceWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setBUnitPriceWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setBUnitPriceWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("bActualUnitPriceWithoutTax")) {
      Object obj = map.get("bActualUnitPriceWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setBActualUnitPriceWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setBActualUnitPriceWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setBActualUnitPriceWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setBActualUnitPriceWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setBActualUnitPriceWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("bActualUnitPriceWithTax")) {
      Object obj = map.get("bActualUnitPriceWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setBActualUnitPriceWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setBActualUnitPriceWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setBActualUnitPriceWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setBActualUnitPriceWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setBActualUnitPriceWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("bAmountWithoutTax")) {
      Object obj = map.get("bAmountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setBAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setBAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setBAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setBAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setBAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("bAmountWithTax")) {
      Object obj = map.get("bAmountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setBAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setBAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setBAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setBAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setBAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("bActualAmountWithoutTax")) {
      Object obj = map.get("bActualAmountWithoutTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setBActualAmountWithoutTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setBActualAmountWithoutTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setBActualAmountWithoutTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setBActualAmountWithoutTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setBActualAmountWithoutTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("bActualAmountWithTax")) {
      Object obj = map.get("bActualAmountWithTax");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setBActualAmountWithTax((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setBActualAmountWithTax(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setBActualAmountWithTax(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setBActualAmountWithTax(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setBActualAmountWithTax(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("bTaxRate")) {
      Object obj = map.get("bTaxRate");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setBTaxRate((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setBTaxRate(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setBTaxRate(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setBTaxRate(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setBTaxRate(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("bTaxAmount")) {
      Object obj = map.get("bTaxAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setBTaxAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setBTaxAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setBTaxAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setBTaxAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setBTaxAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("bFreeUnitCode")) {
      Object obj = map.get("bFreeUnitCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBFreeUnitCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("bFreeUnitName")) {
      Object obj = map.get("bFreeUnitName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBFreeUnitName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("bFreeQty")) {
      Object obj = map.get("bFreeQty");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setBFreeQty((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setBFreeQty(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setBFreeQty(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setBFreeQty(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setBFreeQty(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("bActualFreeQty")) {
      Object obj = map.get("bActualFreeQty");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setBActualFreeQty((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setBActualFreeQty(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setBActualFreeQty(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setBActualFreeQty(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setBActualFreeQty(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("bReceiveMethod")) {
      Object obj = map.get("bReceiveMethod");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBReceiveMethod((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("bInventory")) {
      Object obj = map.get("bInventory");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBInventory((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("bLocation")) {
      Object obj = map.get("bLocation");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBLocation((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("bRemark")) {
      Object obj = map.get("bRemark");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBRemark((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("bErrorInfo")) {
      Object obj = map.get("bErrorInfo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBErrorInfo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("traceId")) {
      Object obj = map.get("traceId");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTraceId((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sDeliveryTime")) {
      Object obj = map.get("sDeliveryTime");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setSDeliveryTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setSDeliveryTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSDeliveryTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setSDeliveryTime(null);
      }
    }
    if(map.containsKey("bPackageUnitCode")) {
      Object obj = map.get("bPackageUnitCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBPackageUnitCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("bPackageUnitName")) {
      Object obj = map.get("bPackageUnitName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBPackageUnitName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("bPackageUnitQty")) {
      Object obj = map.get("bPackageUnitQty");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setBPackageUnitQty((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setBPackageUnitQty(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setBPackageUnitQty(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setBPackageUnitQty(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setBPackageUnitQty(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("bPackageActualUnitQty")) {
      Object obj = map.get("bPackageActualUnitQty");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setBPackageActualUnitQty((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setBPackageActualUnitQty(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setBPackageActualUnitQty(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setBPackageActualUnitQty(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setBPackageActualUnitQty(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("poUnitQty")) {
      Object obj = map.get("poUnitQty");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setPoUnitQty((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setPoUnitQty(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setPoUnitQty(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPoUnitQty(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setPoUnitQty(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("sPlant")) {
      Object obj = map.get("sPlant");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSPlant((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sLastExecDeliveryTime")) {
      Object obj = map.get("sLastExecDeliveryTime");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setSLastExecDeliveryTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setSLastExecDeliveryTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSLastExecDeliveryTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setSLastExecDeliveryTime(null);
      }
    }
    if(map.containsKey("bPoItemQty")) {
      Object obj = map.get("bPoItemQty");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setBPoItemQty((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setBPoItemQty(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setBPoItemQty(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setBPoItemQty(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setBPoItemQty(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("sWarehouseLocation")) {
      Object obj = map.get("sWarehouseLocation");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSWarehouseLocation((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("bErrorFileUrl")) {
      Object obj = map.get("bErrorFileUrl");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBErrorFileUrl((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrgTree((String)obj);
        }
      } else {
      }
    }
  }
}
