package com.xforceplus.arterydocument.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * erp_transmit_status
 * </p>
 *
 * @author ultraman
 * @since 2025-05-14
 */
public enum ErpTransmitStatus {

    _0("0", "未传输"),
    _1("1", "成功"),
    _2("2", "失败"),
    _99("99", "无需传输");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    ErpTransmitStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ErpTransmitStatus fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "1":
                return _1;
            case "2":
                return _2;
            case "99":
                return _99;
            default:
                return null;
        }
    }
}
