package com.xforceplus.arterydocument.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * invoice_return_status
 * </p>
 *
 * @author ultraman
 * @since 2025-05-14
 */
public enum InvoiceReturnStatus {

    TO_BE_SELECTED("toBeSelected", "待勾选"),
    TO_BE_EXECUTED("toBeExecuted", "待执行"),
    FAIL("fail", "执行失败"),
    SUCCESS("success", "执行成功");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    InvoiceReturnStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static InvoiceReturnStatus fromCode(String code){
        switch(code) {
            case "toBeSelected":
                return TO_BE_SELECTED;
            case "toBeExecuted":
                return TO_BE_EXECUTED;
            case "fail":
                return FAIL;
            case "success":
                return SUCCESS;
            default:
                return null;
        }
    }
}
